/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.simplegame.single.list.data;

import android.graphics.Bitmap;
import android.graphics.Color;
import android.text.TextUtils;
import com.google.gson.annotations.Expose;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.DontProguardClass;
import com.yy.game.gamemodule.simplegame.single.list.data.AKC;
import com.yy.hiyo.game.base.SingleGameExtInfo;
import com.yy.hiyo.game.base.bean.SingleGameListItem;

@DontProguardClass
public class SingleGameMiddleInfo {
    private static final String TAG = "SingleGameMiddleInfo";
    public String gameId;
    public String gameName;
    public String gameIcon;
    public boolean havePlayed;
    public boolean todayPlayed;
    public int recentScore;
    public int rank;
    public int overPeople;
    public int historyBest;
    public int todayBest;
    public int totalRankCount;
    public String recentPlayDate;
    public String encouragementText;
    public String circleIconUrl;
    public SingleGameExtInfo extInfo;
    public String describeText;
    public String bgUrl;
    public boolean fixing;
    public int bgColor;
    public int bottomBarColor;
    public int biggerRank;
    public int ranklimit;
    public String scoreType;
    @Expose(serialize=false, deserialize=false)
    public String tempBgUrl;
    @Expose(serialize=false, deserialize=false)
    public Bitmap tempBitmap;
    public boolean isFull;
    public boolean isBetaTest;
    public boolean isWaitingOffline;
    public boolean isDisconnect = false;

    public static SingleGameMiddleInfo create(SingleGameListItem singleGameListItem) {
        SingleGameMiddleInfo singleGameMiddleInfo = new SingleGameMiddleInfo();
        if (singleGameListItem != null && singleGameListItem.dataItem != null) {
            singleGameMiddleInfo.gameId = singleGameListItem.dataItem.getId();
            singleGameMiddleInfo.gameName = singleGameListItem.dataItem.getTitle();
            singleGameMiddleInfo.describeText = singleGameListItem.dataItem.getDesc();
            singleGameMiddleInfo.circleIconUrl = singleGameListItem.dataItem.getIconUrl();
            singleGameMiddleInfo.scoreType = singleGameListItem.dataItem.getScoreType();
            if (singleGameListItem.dataItem.singleGameExt != null) {
                singleGameMiddleInfo.bgUrl = singleGameListItem.dataItem.singleGameExt.tmpBackGroundUrl;
            }
            singleGameMiddleInfo.fixing = singleGameListItem.dataItem.isFixing();
            singleGameMiddleInfo.isFull = singleGameListItem.dataItem.isFull();
            singleGameMiddleInfo.isBetaTest = singleGameListItem.dataItem.isBetaTest();
            singleGameMiddleInfo.isWaitingOffline = singleGameListItem.dataItem.isWaitingOffline();
            try {
                if (!TextUtils.isEmpty((CharSequence)singleGameListItem.dataItem.getBannerImgColor())) {
                    singleGameMiddleInfo.bgColor = singleGameListItem.dataItem.getBannerColor();
                }
            }
            catch (Exception exception) {
                MLog.error((Object)TAG, (String)"[create] bgColor %d", (Throwable)exception, (Object[])new Object[]{singleGameMiddleInfo.bgColor});
            }
            try {
                if (!TextUtils.isEmpty((CharSequence)singleGameListItem.dataItem.singleGameExt.viewColor)) {
                    singleGameMiddleInfo.bottomBarColor = Color.parseColor((String)singleGameListItem.dataItem.singleGameExt.viewColor);
                }
            }
            catch (Exception exception) {
                MLog.error((Object)TAG, (String)"[create] bottomBarColor", (Throwable)exception, (Object[])new Object[0]);
            }
            singleGameMiddleInfo.extInfo = singleGameListItem.dataItem.singleGameExt;
        }
        return singleGameMiddleInfo;
    }

    public void updateMiddleInfo(SingleGameMiddleInfo singleGameMiddleInfo) {
        if (singleGameMiddleInfo != null && TextUtils.equals((CharSequence)this.gameId, (CharSequence)singleGameMiddleInfo.gameId)) {
            this.havePlayed = singleGameMiddleInfo.havePlayed;
            this.todayPlayed = singleGameMiddleInfo.todayPlayed;
            this.recentScore = singleGameMiddleInfo.recentScore;
            this.recentPlayDate = singleGameMiddleInfo.recentPlayDate;
            this.rank = singleGameMiddleInfo.rank;
            this.overPeople = singleGameMiddleInfo.overPeople;
            this.historyBest = singleGameMiddleInfo.historyBest;
            this.todayBest = singleGameMiddleInfo.todayBest;
            this.totalRankCount = singleGameMiddleInfo.totalRankCount;
            this.encouragementText = singleGameMiddleInfo.encouragementText;
            this.biggerRank = singleGameMiddleInfo.biggerRank;
            this.ranklimit = singleGameMiddleInfo.ranklimit;
        }
    }

    public void recycleTempBitmap() {
        YYTaskExecutor.postToMainThread((Runnable)new AKC(this), (long)10000L);
    }

    public String toString() {
        return "SingleGameMiddleInfo{gameId='" + this.gameId + '\'' + ", gameName='" + this.gameName + '\'' + ", gameIcon='" + this.gameIcon + '\'' + ", havePlayed=" + this.havePlayed + ", todayPlayed=" + this.todayPlayed + ", recentScore=" + this.recentScore + ", rank=" + this.rank + ", overPeople=" + this.overPeople + ", historyBest=" + this.historyBest + ", todayBest=" + this.todayBest + ", totalRankCount=" + this.totalRankCount + ", recentPlayDate='" + this.recentPlayDate + '\'' + ", encouragementText='" + this.encouragementText + '\'' + '}';
    }
}

