/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.data;

import android.net.Uri;
import android.text.TextUtils;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.data.BaseDBBean;
import com.yy.appbase.data.GameHistoryBean;
import com.yy.appbase.data.GamePlayInfoDBBean;
import com.yy.appbase.data.GamePlayRecordBean;
import com.yy.appbase.data.MyBox;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.appbase.http.HttpUtil;
import com.yy.appbase.http.INetRespCallback;
import com.yy.appbase.kvomodule.BaseModuleData;
import com.yy.appbase.kvomodule.BizModule;
import com.yy.appbase.service.IDBService;
import com.yy.appbase.service.IServiceManager;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.callback.OnGameHistoryCallback;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.IConfigListener;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.Environment;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.game.data.AIC;
import com.yy.game.data.ALC;
import com.yy.game.data.a;
import com.yy.game.data.aCC;
import com.yy.game.data.aFC;
import com.yy.game.data.aNC;
import com.yy.game.data.aQC;
import com.yy.game.data.aTC;
import com.yy.game.data.adC;
import com.yy.game.data.agC;
import com.yy.game.data.ajC;
import com.yy.game.data.amC;
import com.yy.game.data.apC;
import com.yy.game.data.avC;
import com.yy.game.data.awC;
import com.yy.game.data.b;
import com.yy.game.data.c;
import com.yy.game.data.d;
import com.yy.game.data.e;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.base.bean.GameInfoSource;
import com.yy.hiyo.game.base.bean.GamePlayInfo;
import com.yy.hiyo.game.base.config.GameEmojiConfig;
import com.yy.hiyo.game.kvomodule.GameEmoji;
import com.yy.hiyo.game.kvomodule.GameInfoModule;
import com.yy.hiyo.game.kvomodule.GameInfoModuleData;
import com.yy.hiyo.game.kvomodule.IGamePlayLoadCallBack;
import com.yy.hiyo.game.kvomodule.SingleGameBestHistoryInfo;
import com.yy.hiyo.game.service.IGameInfoService;
import com.yy.hiyo.game.service.bean.GamePlayContext;
import com.yy.hiyo.game.service.callback.OnGameInfoChangedListener;
import com.yy.webservice.WebEnvSettings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public class GameModuleImpl
extends BizModule<GameInfoModuleData>
implements GameInfoModule,
OnGameInfoChangedListener {
    private static final String TAG = "GameModuleImpl";
    private final Object playGameInfoLock = new Object();
    private volatile List<GameHistoryBean> mPlayHistory;
    private volatile boolean isLoadDataFinish = false;
    private boolean mPlayHistoryPulling;
    private boolean mPlayHistoryWithUserPulling;
    private INotify mNotifyHandler;
    private boolean mPlayHistoryLoadedFromDB = false;
    private List<Runnable> cacheBizTask = new CopyOnWriteArrayList<Runnable>();
    private IConfigListener<GameEmojiConfig> mGameEmojiConfig = new adC(this);

    public GameModuleImpl(GameInfoModuleData gameInfoModuleData) {
        super((BaseModuleData)gameInfoModuleData);
        UnifyConfig.INSTANCE.registerListener(BssCode.GAME_EMOJIS, this.mGameEmojiConfig);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_WEB_VIEW_WINDOW_CLOSED, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.URI_WINDOW_STOP, (INotify)this);
    }

    public void notify(Notification notification) {
        super.notify(notification);
        if (notification != null) {
            Object object = notification.extObj;
            if (notification.id == NotificationDef.N_WEB_VIEW_WINDOW_CLOSED) {
                if (object instanceof WebEnvSettings) {
                    WebEnvSettings webEnvSettings = (WebEnvSettings)object;
                    this.stopPlayActivityGame(webEnvSettings.originUrl);
                }
            } else if (notification.id == NotificationDef.URI_WINDOW_STOP && object instanceof Uri) {
                Uri uri = (Uri)object;
                this.stopPlayActivityGame(uri.toString());
            }
        }
    }

    private void resetGameWithUidHistory() {
        this.mPlayHistoryWithUserPulling = false;
        SettingFlags.setBoolean((String)("pullgamehistory" + AccountUtil.getUid()), (boolean)false);
    }

    private void preloadPlayRecordBean() {
        MyBox myBox;
        IServiceManager iServiceManager = this.getService();
        if (iServiceManager == null) {
            iServiceManager = ServiceManagerProxy.getServiceManager();
        }
        if ((myBox = ((IDBService)ServiceManagerProxy.getService(IDBService.class)).boxForGlobal(GamePlayRecordBean.class)) != null) {
            myBox.getAll((MyBox.IGetItemsCallBack)new awC(this));
        }
        this.pullOldHistroyToFile();
        this.initGameHistoryFromFile(iServiceManager);
    }

    private void pullOldHistroyToFile() {
        if (this.mPlayHistoryPulling && this.mPlayHistoryWithUserPulling) {
            return;
        }
        boolean bl2 = SettingFlags.getBoolean((String)("pullgamehistory" + AccountUtil.getUid()), (boolean)false);
        boolean bl3 = SettingFlags.getBoolean((String)"pullgamehistory", (boolean)false);
        if (AccountUtil.getUid() > 0L && !bl3 || AccountUtil.getUid() > 0L && !bl2) {
            this.mPlayHistoryPulling = true;
            this.mPlayHistoryWithUserPulling = true;
            ((IUserInfoService)this.getService().getService(IUserInfoService.class)).getGameHistory(AccountUtil.getUid(), (OnGameHistoryCallback)new aCC(this, bl3, bl2));
        }
    }

    private void addGameHistoryGlobalToFile(ArrayList<GamePlayRecordBean> arrayList) {
        MyBox myBox = ((IDBService)this.getService().getService(IDBService.class)).boxForGlobal(GamePlayRecordBean.class);
        if (myBox != null && arrayList.size() > 0) {
            myBox.updateItems(arrayList, true);
            myBox.getAll((MyBox.IGetItemsCallBack)new agC(this));
        }
    }

    private void addGameHistoryWithUserToFile(ArrayList<GamePlayRecordBean> arrayList) {
        MyBox myBox = ((IDBService)this.getService().getService(IDBService.class)).boxForCurUser(GamePlayRecordBean.class);
        if (myBox != null && arrayList.size() > 0) {
            myBox.updateItems(arrayList, true);
            myBox.getAll((MyBox.IGetItemsCallBack)new a(this));
        }
    }

    public GameInfo getGame(String string2) {
        GamePlayInfo gamePlayInfo;
        GameInfo gameInfo = null;
        if (!StringUtils.isEmpty((String)string2) && (gamePlayInfo = (GamePlayInfo)((GameInfoModuleData)this.mData).getGameCacheInfo().get(string2)) != null) {
            gameInfo = gamePlayInfo.getGameInfo();
        }
        return gameInfo;
    }

    public void updateGameInfo(GameInfo gameInfo) {
        ((GameInfoModuleData)this.mData).updateGameInfo(gameInfo);
    }

    public void startPlayGame(GameInfo gameInfo) {
        if (!this.isReady) {
            this.cacheTask(new b(this, gameInfo));
            return;
        }
        if (gameInfo != null && gameInfo.getGameMode() == 10) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"hago show startPlayGame block!!!", (Object[])new Object[0]);
            }
            return;
        }
        MLog.debug((Object)TAG, (String)"startPlayGame gameInfo: %s", (Object[])new Object[]{gameInfo});
        this.startFavGame(gameInfo);
    }

    public void stopPlayGame(GameInfo gameInfo) {
        if (!this.isReady) {
            this.cacheTask(new c(this, gameInfo));
            return;
        }
        if (gameInfo != null && gameInfo.getGameMode() == 10) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"hago show stopPlayGame block!!!", (Object[])new Object[0]);
            }
            return;
        }
        MLog.debug((Object)TAG, (String)"stopPlayGame gameInfo: %s", (Object[])new Object[]{gameInfo});
        this.stopFavGame(gameInfo);
    }

    public void startPlayActivityGame(String string2, GameInfo gameInfo) {
        MLog.debug((Object)TAG, (String)"startPlayActivityGame gid: %s", (Object[])new Object[]{string2});
        GameInfo gameInfo2 = gameInfo;
        if (gameInfo2 != null) {
            MLog.debug((Object)TAG, (String)"startPlayActivityGame find gameInfo by GameInfoService", (Object[])new Object[0]);
        } else {
            gameInfo2 = ((IGameInfoService)this.getService().getService(IGameInfoService.class)).getGameInfoByGid(string2);
        }
        if (gameInfo2 != null) {
            String string3 = gameInfo2.getJumpUri();
            if (gameInfo2.getGameMode() == 0 && !StringUtils.isEmpty((String)string3) && (string3.startsWith("http") || string3.startsWith("hago"))) {
                MLog.debug((Object)TAG, (String)"startPlayActivityGame gid: %s, uri: %s", (Object[])new Object[]{gameInfo2.getGid(), gameInfo2.getJumpUri()});
                this.startFavGame(gameInfo2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopPlayActivityGame(String string2) {
        MLog.debug((Object)TAG, (String)"stopPlayActivityGame uri: %s", (Object[])new Object[]{string2});
        Object object = this.playGameInfoLock;
        synchronized (object) {
            GameInfo gameInfo;
            GamePlayInfoDBBean gamePlayInfoDBBean = ((GameInfoModuleData)this.mData).getPlayingGame();
            if (gamePlayInfoDBBean != null && gamePlayInfoDBBean.getGameMode() == 0 && StringUtils.equal((String)string2, (String)gamePlayInfoDBBean.getExt()) && (gameInfo = ((IGameInfoService)this.getService().getService(IGameInfoService.class)).getGameInfoByGid(gamePlayInfoDBBean.getGameId())) != null) {
                MLog.debug((Object)TAG, (String)"stopPlayActivityGame gid: %s, uri: %s", (Object[])new Object[]{gameInfo.getGid(), gameInfo.getJumpUri()});
                this.stopFavGame(gameInfo);
            }
        }
    }

    public void addToFavorGame(GameInfo gameInfo) {
        this.startFavGame(gameInfo);
        this.stopFavGame(gameInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startFavGame(GameInfo gameInfo) {
        Object object = this.playGameInfoLock;
        synchronized (object) {
            if (gameInfo == null || StringUtils.isEmpty((String)gameInfo.getGid())) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)"start play game err,game:%s", (Object[])new Object[]{gameInfo});
                }
                return;
            }
            GamePlayInfoDBBean gamePlayInfoDBBean = ((GameInfoModuleData)this.mData).getPlayingGame();
            if (gamePlayInfoDBBean != null && gamePlayInfoDBBean.getGameMode() == 0 && !TextUtils.isEmpty((CharSequence)gamePlayInfoDBBean.getExt()) && gamePlayInfoDBBean.getExt().startsWith("http")) {
                this.stopPlayActivityGame(gamePlayInfoDBBean.getExt());
            }
            GamePlayInfoDBBean gamePlayInfoDBBean2 = new GamePlayInfoDBBean();
            gamePlayInfoDBBean2.setStartTs(System.currentTimeMillis());
            gamePlayInfoDBBean2.setGameId(gameInfo.getGid());
            gamePlayInfoDBBean2.setGameMode(gameInfo.getGameMode());
            gamePlayInfoDBBean2.setUid(AccountUtil.getUid());
            gamePlayInfoDBBean2.setLastVersion(gameInfo.getModulerVer());
            if (gamePlayInfoDBBean2.getGameMode() == 0) {
                gamePlayInfoDBBean2.setExt(gameInfo.getJumpUri());
            }
            ((GameInfoModuleData)this.mData).setPlayingGame(gamePlayInfoDBBean2);
            ((GameInfoModuleData)this.mData).gameRunningContext.setGameRunning(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopFavGame(GameInfo gameInfo) {
        Object object = this.playGameInfoLock;
        synchronized (object) {
            MyBox myBox;
            IDBService iDBService;
            if (gameInfo == null || StringUtils.isEmpty((String)gameInfo.getGid())) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)"stop play game err,game:%s", (Object[])new Object[]{gameInfo});
                }
                return;
            }
            GamePlayInfoDBBean gamePlayInfoDBBean = ((GameInfoModuleData)this.mData).getPlayingGame();
            if (gamePlayInfoDBBean == null) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)"start play game is null,cur:%s", (Object[])new Object[]{gameInfo});
                }
                return;
            }
            if (!StringUtils.equal((String)gamePlayInfoDBBean.getGameId(), (String)gameInfo.getGid())) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)"game id not match, lastId:%s, curId:%s", (Object[])new Object[]{gamePlayInfoDBBean.getGameId(), gameInfo.getGid()});
                }
                return;
            }
            long l2 = System.currentTimeMillis();
            long l3 = l2 - gamePlayInfoDBBean.getStartTs();
            gamePlayInfoDBBean.setEndTs(l2);
            gamePlayInfoDBBean.setGamingTs(l3);
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"play game end, gameInfo: %s", (Object[])new Object[]{gamePlayInfoDBBean.getGameId()});
            }
            if ((iDBService = (IDBService)this.getService().getService(IDBService.class)) != null && (myBox = iDBService.boxForGlobal(GamePlayInfoDBBean.class)) != null) {
                myBox.updateItem((BaseDBBean)gamePlayInfoDBBean, true);
            }
            ((GameInfoModuleData)this.mData).updateGameInfo(gameInfo);
            ((GameInfoModuleData)this.mData).appendPlayGame(gamePlayInfoDBBean);
            ((GameInfoModuleData)this.mData).setPlayingGame(null);
            ((GameInfoModuleData)this.mData).gameRunningContext.setGameRunning(false);
            this.notifyPlayDataChange();
        }
    }

    public long getLastGamePlayDuration(String string2) {
        GamePlayInfo gamePlayInfo;
        long l2 = 0L;
        if (!StringUtils.isEmpty((String)string2) && (gamePlayInfo = (GamePlayInfo)((GameInfoModuleData)this.mData).getGameCacheInfo().get(string2)) != null) {
            l2 = gamePlayInfo.getLastTimePlayDuration();
        }
        return l2;
    }

    public List<GameEmoji> getGameEmojis() {
        return ((GameInfoModuleData)this.mData).getGameEmojis();
    }

    public void onGameJoinSuccess(GamePlayContext gamePlayContext) {
        String string2;
        GameInfo gameInfo = gamePlayContext.getGameInfo();
        if (gameInfo != null && gameInfo.getGameMode() != 10 && StringUtils.isNotEmpty((String)(string2 = gameInfo.getGid()))) {
            boolean bl2 = gamePlayContext.getExtendData().get("isGoldGame") != null && (Boolean)gamePlayContext.getExtendData().get("isGoldGame") != false;
            this.updateGlobalHistory(string2, bl2);
            this.updateWithUserGameHistoryWithCoins(string2, bl2);
        }
    }

    private void updateWithUserGameHistory(String string2) {
        MyBox myBox = ((IDBService)this.getService().getService(IDBService.class)).boxForCurUser(GamePlayRecordBean.class);
        this.updateGameHistory(string2, myBox, false);
    }

    private void updateWithUserGameHistoryWithCoins(String string2, boolean bl2) {
        MyBox myBox = ((IDBService)this.getService().getService(IDBService.class)).boxForCurUser(GamePlayRecordBean.class);
        this.updateGameHistory(string2, myBox, bl2);
    }

    private void updateGlobalHistory(String string2, boolean bl2) {
        MyBox myBox = ((IDBService)this.getService().getService(IDBService.class)).boxForGlobal(GamePlayRecordBean.class);
        this.updateGameHistory(string2, myBox, bl2);
    }

    private void updateGameHistory(String string2, MyBox myBox, boolean bl2) {
        if (myBox != null) {
            myBox.getItemByIndex((Object)string2, (MyBox.IGetItemsCallBack)new d(this, bl2, myBox, string2));
        }
    }

    public boolean hasGamePlayed(String string2) {
        GamePlayRecordBean gamePlayRecordBean;
        MyBox myBox = ((IDBService)this.getService().getService(IDBService.class)).boxForGlobal(GamePlayRecordBean.class);
        if (myBox == null) {
            return true;
        }
        ArrayList<String> arrayList = new ArrayList<String>(1);
        arrayList.add(string2);
        ArrayList arrayList2 = myBox.getItemsFromMem(arrayList);
        if (arrayList2 != null && arrayList2.size() > 0 && (gamePlayRecordBean = (GamePlayRecordBean)arrayList2.get(0)) != null) {
            return gamePlayRecordBean.hasPlayed();
        }
        gamePlayRecordBean = this.mPlayHistory;
        if (gamePlayRecordBean != null && gamePlayRecordBean.size() > 0) {
            for (GameHistoryBean gameHistoryBean : gamePlayRecordBean) {
                if (gameHistoryBean == null || !StringUtils.equal((String)gameHistoryBean.gameId, (String)string2)) continue;
                return gameHistoryBean.playerCount > 0;
            }
        }
        boolean bl2 = SettingFlags.getBoolean((String)"pullgamehistory", (boolean)false);
        return RuntimeContext.isNewInstalled() ? false : !bl2;
    }

    public boolean hasGamePlayedWithUser(String string2) {
        GamePlayRecordBean gamePlayRecordBean;
        MyBox myBox = ((IDBService)this.getService().getService(IDBService.class)).boxForCurUser(GamePlayRecordBean.class);
        if (myBox == null) {
            return true;
        }
        ArrayList<String> arrayList = new ArrayList<String>(1);
        arrayList.add(string2);
        ArrayList arrayList2 = myBox.getItemsFromMem(arrayList);
        if (arrayList2 != null && arrayList2.size() > 0 && (gamePlayRecordBean = (GamePlayRecordBean)arrayList2.get(0)) != null) {
            return gamePlayRecordBean.hasPlayed();
        }
        return false;
    }

    private void initGameHistoryFromFile(IServiceManager iServiceManager) {
        MyBox myBox = ((IDBService)iServiceManager.getService(IDBService.class)).boxForCurUser(GamePlayRecordBean.class);
        if (myBox == null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"initGameHistoryFromFile bos is null", (Object[])new Object[0]);
            }
            return;
        }
        myBox.getAll((MyBox.IGetItemsCallBack)new e(this));
    }

    public boolean isPlayingGame() {
        return ((GameInfoModuleData)this.mData).gameRunningContext.isGameRunning();
    }

    public List<GamePlayInfoDBBean> getAllPlayInfos() {
        return ((GameInfoModuleData)this.mData).getPlayInfoDBBeans();
    }

    public GamePlayInfoDBBean getPlayingInfo() {
        return ((GameInfoModuleData)this.mData).getPlayingGame();
    }

    public void getDurationPlayInfo(long l2, GameInfoModuleData.MatchCallback matchCallback) {
        if (!this.isLoadDataFinish) {
            this.cacheBizTask.add(new amC(this, l2, matchCallback));
            return;
        }
        ((GameInfoModuleData)this.mData).getMatchPlayInfoBean((GameInfoModuleData.Matcher)new ajC(this, l2), matchCallback);
    }

    public void getSelectGameModelData(int n2, GameInfoModuleData.MatchCallback matchCallback) {
        if (!this.isLoadDataFinish) {
            this.cacheBizTask.add(new aFC(this, n2, matchCallback));
            return;
        }
        ((GameInfoModuleData)this.mData).getMatchPlayInfoBean((GameInfoModuleData.Matcher)new aTC(this, n2), matchCallback);
    }

    public void getMatchGamePlayInfo(GameInfoModuleData.Matcher matcher, GameInfoModuleData.MatchCallback matchCallback) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)("\u5f00\u59cb\u83b7\u53d6\u6570\u636e\uff1a" + this.isLoadDataFinish), (Object[])new Object[0]);
        }
        if (!this.isLoadDataFinish) {
            this.cacheBizTask.add(new aQC(this, matcher, matchCallback));
            return;
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)("\u52a0\u8f7d\u6210\u529f\u4e86 \u53ef\u4ee5\u83b7\u53d6\u6570\u636e--" + this.isLoadDataFinish), (Object[])new Object[0]);
        }
        ((GameInfoModuleData)this.mData).getMatchPlayInfoBean(matcher, matchCallback);
    }

    public List<SingleGameBestHistoryInfo> requestSingleGameBestScore(List<String> list, boolean bl2, INetRespCallback<List<SingleGameBestHistoryInfo>> iNetRespCallback) {
        Object object;
        ArrayList<SingleGameBestHistoryInfo> arrayList = new ArrayList<SingleGameBestHistoryInfo>();
        if (list == null || list.isEmpty()) {
            return arrayList;
        }
        ArrayList<String> arrayList2 = new ArrayList<String>(list);
        StringBuilder stringBuilder = new StringBuilder("");
        for (int i2 = 0; i2 < arrayList2.size(); ++i2) {
            object = (String)arrayList2.get(i2);
            if (TextUtils.isEmpty((CharSequence)object)) continue;
            if (!TextUtils.isEmpty((CharSequence)stringBuilder) && i2 > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append((String)object);
            SingleGameBestHistoryInfo singleGameBestHistoryInfo = ((GameInfoModuleData)this.mData).getSingleGameBestScore((String)object);
            if (singleGameBestHistoryInfo == null) continue;
            arrayList.add(singleGameBestHistoryInfo);
        }
        if (arrayList2.size() == arrayList.size() && bl2) {
            return arrayList;
        }
        String string2 = stringBuilder.toString();
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"requestBestHistory, list: %s", (Object[])new Object[]{string2});
        }
        object = new HashMap();
        object.put("gidList", string2);
        HttpUtil.httpReq((String)(UriProvider.getIkxdApiHost() + "/single/bestHistory"), (Map)object, (int)2, (INetRespCallback)new apC(this, iNetRespCallback));
        return arrayList;
    }

    public void ensurePlayDataLoaded(IGamePlayLoadCallBack iGamePlayLoadCallBack) {
        if (this.mPlayHistoryLoadedFromDB) {
            if (iGamePlayLoadCallBack != null) {
                iGamePlayLoadCallBack.onLoadFinish();
            }
            return;
        }
        MyBox myBox = ((IDBService)this.getService().getService(IDBService.class)).boxForGlobal(GamePlayRecordBean.class);
        if (myBox != null) {
            myBox.getAll((MyBox.IGetItemsCallBack)new ALC(this, iGamePlayLoadCallBack));
        } else if (iGamePlayLoadCallBack != null) {
            iGamePlayLoadCallBack.onError();
        }
    }

    public long getPlayGoldTimes(String string2) {
        GamePlayRecordBean gamePlayRecordBean;
        MyBox myBox = ((IDBService)this.getService().getService(IDBService.class)).boxForCurUser(GamePlayRecordBean.class);
        if (myBox == null) {
            return 0L;
        }
        ArrayList<String> arrayList = new ArrayList<String>(1);
        arrayList.add(string2);
        ArrayList arrayList2 = myBox.getItemsFromMem(arrayList);
        if (arrayList2 != null && arrayList2.size() > 0 && (gamePlayRecordBean = (GamePlayRecordBean)arrayList2.get(0)) != null) {
            return gamePlayRecordBean.getGoldPlaytimes();
        }
        return 0L;
    }

    public long getPlayTimes(String string2) {
        GamePlayRecordBean gamePlayRecordBean;
        MyBox myBox = ((IDBService)this.getService().getService(IDBService.class)).boxForCurUser(GamePlayRecordBean.class);
        if (myBox == null) {
            return 0L;
        }
        ArrayList<String> arrayList = new ArrayList<String>(1);
        arrayList.add(string2);
        ArrayList arrayList2 = myBox.getItemsFromMem(arrayList);
        if (arrayList2 != null && arrayList2.size() > 0 && (gamePlayRecordBean = (GamePlayRecordBean)arrayList2.get(0)) != null) {
            return gamePlayRecordBean.getPlayTimes();
        }
        return 0L;
    }

    public void onCreate(IServiceManager iServiceManager, Environment environment) {
        super.onCreate(iServiceManager, environment);
        YYTaskExecutor.postToMainThread((Runnable)new AIC(this));
    }

    private void init() {
        AConfigData aConfigData;
        MyBox myBox = ((IDBService)this.getService().getService(IDBService.class)).boxForGlobal(GamePlayInfoDBBean.class);
        ((IGameInfoService)this.getService().getService(IGameInfoService.class)).addGameInfoListener((OnGameInfoChangedListener)this, true);
        if (myBox != null) {
            myBox.getAll((MyBox.IGetItemsCallBack)new avC(this, myBox));
        }
        if ((aConfigData = UnifyConfig.INSTANCE.getConfigData(BssCode.GAME_EMOJIS)) instanceof GameEmojiConfig) {
            ((GameInfoModuleData)this.mData).setGameEmojis(((GameEmojiConfig)aConfigData).getEmojis());
        }
    }

    private void executeCacheBizTask() {
        if (!this.cacheBizTask.isEmpty()) {
            ArrayList<Runnable> arrayList = new ArrayList<Runnable>(this.cacheBizTask);
            for (Runnable runnable : arrayList) {
                if (runnable == null) continue;
                runnable.run();
            }
            this.cacheBizTask.clear();
        }
    }

    private void notifyPlayDataChange() {
        ((GameInfoModuleData)this.mData).setPlayInfoChange(new Object());
    }

    public void onGameInfoChanged(GameInfoSource gameInfoSource, List<GameInfo> list) {
        YYTaskExecutor.execute((Runnable)new aNC(this, list));
    }

    protected void unbindDataWhenDestroy() {
        super.unbindDataWhenDestroy();
        IGameInfoService iGameInfoService = (IGameInfoService)ServiceManagerProxy.getInstance().getService(IGameInfoService.class);
        if (iGameInfoService != null) {
            iGameInfoService.removeGameInfoListener((OnGameInfoChangedListener)this);
        }
    }

    static /* synthetic */ BaseModuleData access$000(GameModuleImpl gameModuleImpl) {
        return gameModuleImpl.mData;
    }

    static /* synthetic */ boolean access$102(GameModuleImpl gameModuleImpl, boolean bl2) {
        gameModuleImpl.mPlayHistoryLoadedFromDB = bl2;
        return gameModuleImpl.mPlayHistoryLoadedFromDB;
    }

    static /* synthetic */ boolean access$202(GameModuleImpl gameModuleImpl, boolean bl2) {
        gameModuleImpl.mPlayHistoryPulling = bl2;
        return gameModuleImpl.mPlayHistoryPulling;
    }

    static /* synthetic */ boolean access$302(GameModuleImpl gameModuleImpl, boolean bl2) {
        gameModuleImpl.mPlayHistoryWithUserPulling = bl2;
        return gameModuleImpl.mPlayHistoryWithUserPulling;
    }

    static /* synthetic */ List access$402(GameModuleImpl gameModuleImpl, List list) {
        gameModuleImpl.mPlayHistory = list;
        return gameModuleImpl.mPlayHistory;
    }

    static /* synthetic */ void access$500(GameModuleImpl gameModuleImpl, ArrayList arrayList) {
        gameModuleImpl.addGameHistoryGlobalToFile(arrayList);
    }

    static /* synthetic */ void access$600(GameModuleImpl gameModuleImpl, ArrayList arrayList) {
        gameModuleImpl.addGameHistoryWithUserToFile(arrayList);
    }

    static /* synthetic */ BaseModuleData access$700(GameModuleImpl gameModuleImpl) {
        return gameModuleImpl.mData;
    }

    static /* synthetic */ INotify access$800(GameModuleImpl gameModuleImpl) {
        return gameModuleImpl.mNotifyHandler;
    }

    static /* synthetic */ INotify access$802(GameModuleImpl gameModuleImpl, INotify iNotify) {
        gameModuleImpl.mNotifyHandler = iNotify;
        return gameModuleImpl.mNotifyHandler;
    }

    static /* synthetic */ void access$900(GameModuleImpl gameModuleImpl) {
        gameModuleImpl.init();
    }

    static /* synthetic */ void access$1000(GameModuleImpl gameModuleImpl) {
        gameModuleImpl.resetGameWithUidHistory();
    }

    static /* synthetic */ void access$1100(GameModuleImpl gameModuleImpl) {
        gameModuleImpl.pullOldHistroyToFile();
    }

    static /* synthetic */ void access$1200(GameModuleImpl gameModuleImpl) {
        gameModuleImpl.preloadPlayRecordBean();
    }

    static /* synthetic */ BaseModuleData access$1300(GameModuleImpl gameModuleImpl) {
        return gameModuleImpl.mData;
    }

    static /* synthetic */ boolean access$1402(GameModuleImpl gameModuleImpl, boolean bl2) {
        gameModuleImpl.isLoadDataFinish = bl2;
        return gameModuleImpl.isLoadDataFinish;
    }

    static /* synthetic */ void access$1500(GameModuleImpl gameModuleImpl) {
        gameModuleImpl.executeCacheBizTask();
    }

    static /* synthetic */ void access$1600(GameModuleImpl gameModuleImpl) {
        gameModuleImpl.notifyPlayDataChange();
    }

    static /* synthetic */ BaseModuleData access$1700(GameModuleImpl gameModuleImpl) {
        return gameModuleImpl.mData;
    }

    static /* synthetic */ BaseModuleData access$1800(GameModuleImpl gameModuleImpl) {
        return gameModuleImpl.mData;
    }
}

