/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.http;

import android.os.Process;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.mobile.http.HttpLog;
import com.yy.mobile.http.Request;
import com.yy.mobile.http.RequestError;
import com.yy.mobile.http.RequestProcessor;
import com.yy.mobile.http.ResponseData;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;

public class NetworkDispatcher
extends Thread {
    private final BlockingQueue<Request> mQueue;
    private volatile boolean mQuit = false;
    private RequestProcessor mRequestProcessor;

    public NetworkDispatcher(BlockingQueue<Request> queue, String name, RequestProcessor requestProcessor) {
        super(name + "NetworkThread");
        this.mQueue = queue;
        this.mRequestProcessor = requestProcessor;
    }

    public void quit() {
        this.mQuit = true;
        this.interrupt();
    }

    @Override
    public void run() {
        Process.setThreadPriority((int)10);
        while (true) {
            Request request;
            try {
                request = this.mQueue.take();
            }
            catch (InterruptedException e) {
                if (HttpLog.isDebug()) {
                    HttpLog.d(this.getName() + " NetworkDispatcher interrupted.", new Object[0]);
                }
                if (!this.mQuit) continue;
                if (HttpLog.isDebug()) {
                    HttpLog.d(this.getName() + " NetworkDispatcher quit.", new Object[0]);
                }
                return;
            }
            catch (NullPointerException ex) {
                HttpLog.e(ex, this.getName() + " Unhandled exception " + ex.toString(), new Object[0]);
                continue;
            }
            YYTaskExecutor.execute((Runnable)new RequestMonitor(request), (long)0L, (int)5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitIfPaused() {
        AtomicBoolean pause;
        AtomicBoolean atomicBoolean = pause = this.mRequestProcessor.getPause();
        synchronized (atomicBoolean) {
            if (pause.get()) {
                HttpLog.v(this.getName() + " Network Wait for pause", new Object[0]);
                try {
                    pause.wait();
                }
                catch (InterruptedException e) {
                    HttpLog.e(e, this.getName() + " Network Wait for pause interrupted", new Object[0]);
                    return;
                }
                HttpLog.v(this.getName() + " Network Resume pause", new Object[0]);
            }
        }
    }

    private void parseAndDeliverNetworkError(Request<?> request, RequestError error) {
        request.postError(error);
    }

    class RequestMonitor
    implements Runnable {
        private Request request = null;
        int httpCode = 55;

        RequestMonitor(Request r) {
            this.request = r;
        }

        @Override
        public void run() {
            try {
                NetworkDispatcher.this.waitIfPaused();
                HttpLog.v(NetworkDispatcher.this.getName() + " Network queue take", this.request.getUrl());
                if (this.request.isCanceled()) {
                    this.request.postCancel(NetworkDispatcher.this.getName() + " Network discard cancelled");
                    return;
                }
                ResponseData responseData = this.request.getNetwork().performRequest(this.request);
                this.httpCode = responseData.statusCode;
                HttpLog.v(NetworkDispatcher.this.getName() + " Network com.yy.mobile.http complete response=" + responseData, new Object[0]);
                if (responseData.notModified && this.request.hasHadResponseDelivered()) {
                    this.request.finish(NetworkDispatcher.this.getName() + " Network not modified");
                    return;
                }
                this.request.parseDataToResponse(responseData);
                HttpLog.v(NetworkDispatcher.this.getName() + " Network parse complete", new Object[0]);
                this.request.markDelivered();
                this.request.postResponse();
                if (this.request.shouldCache() && this.request.getResponse().cacheEntry != null) {
                    this.request.getCache().put(this.request.getKey(), this.request.getResponse().cacheEntry);
                    HttpLog.v(NetworkDispatcher.this.getName() + " Network cache written", new Object[0]);
                }
            }
            catch (RequestError error) {
                NetworkDispatcher.this.parseAndDeliverNetworkError(this.request, error);
            }
            catch (Exception e) {
                HttpLog.e(e, NetworkDispatcher.this.getName() + " Unhandled exception " + e.toString(), new Object[0]);
                this.request.postError(new RequestError((Throwable)e){

                    @Override
                    public int code() {
                        return 111;
                    }

                    @Override
                    public int httpCode() {
                        return RequestMonitor.this.httpCode;
                    }
                });
            }
            catch (Error e) {
                HttpLog.e(e, NetworkDispatcher.this.getName() + " Unhandled error " + e.toString(), new Object[0]);
                this.request.postError(new RequestError((Throwable)e){

                    @Override
                    public int code() {
                        return 111;
                    }

                    @Override
                    public int httpCode() {
                        return RequestMonitor.this.httpCode;
                    }
                });
            }
        }
    }
}

