/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.backgroundprocess.Util.sharedpref;

import android.content.SharedPreferences;
import android.text.TextUtils;
import com.google.gson.Gson;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.SharedPreferencesUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class BackgroundProcessPref {
    private static final String DELIMITER = ",";
    private static final String COMMONREF_NAME = "BackGroundProcessPref";
    private static volatile SharedPreferences sInst;
    private static volatile BackgroundProcessPref sPref;

    private BackgroundProcessPref() {
        BackgroundProcessPref.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static synchronized void init() {
        if (sInst != null) return;
        Class<BackgroundProcessPref> clazz = BackgroundProcessPref.class;
        synchronized (BackgroundProcessPref.class) {
            if (sInst != null) return;
            sInst = SharedPreferencesUtils.INSTANCE.getSharedPreferences(RuntimeContext.sApplicationContext, COMMONREF_NAME, 4);
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BackgroundProcessPref instance() {
        if (sPref != null) return sPref;
        Class<BackgroundProcessPref> clazz = BackgroundProcessPref.class;
        synchronized (BackgroundProcessPref.class) {
            if (sPref != null) return sPref;
            sPref = new BackgroundProcessPref();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sPref;
        }
    }

    public void putString(String key, String value) {
        this.put(key, value);
    }

    public String getString(String key) {
        return this.get(key);
    }

    public String getString(String key, String defaultValue) {
        return sInst.getString(key, defaultValue);
    }

    public void putInt(String key, int value) {
        this.put(key, String.valueOf(value));
    }

    public void putBoolean(String key, boolean value) {
        this.put(key, String.valueOf(value));
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        String rawValue = this.get(key);
        if (TextUtils.isEmpty((CharSequence)rawValue)) {
            return defaultValue;
        }
        try {
            return Boolean.parseBoolean(rawValue);
        }
        catch (Exception e) {
            MLog.error((Object)"BgProcessPref", (String)"failed to parse boolean value for key %s, %s", (Object[])new Object[]{key, e});
            return defaultValue;
        }
    }

    public int getInt(String key, int defaultValue) {
        String rawValue = this.get(key);
        if (TextUtils.isEmpty((CharSequence)rawValue)) {
            return defaultValue;
        }
        return this.parseInt(rawValue, defaultValue);
    }

    private int parseInt(String value, int defaultValue) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            MLog.error((Object)"BgProcessPref", (String)"lcy failed to parse value for key %s, %s", (Object[])new Object[]{value, e});
            return defaultValue;
        }
    }

    public int getInt(String key) {
        return this.getInt(key, -1);
    }

    public void putLong(String key, long value) {
        this.put(key, String.valueOf(value));
    }

    public long getLong(String key, long defaultValue) {
        String rawValue = this.get(key);
        if (TextUtils.isEmpty((CharSequence)rawValue)) {
            return defaultValue;
        }
        try {
            return Long.parseLong(rawValue);
        }
        catch (NumberFormatException e) {
            MLog.error((Object)"BgProcessPref", (String)"lcy failed to parse %s as long, for key %s, ex : %s", (Object[])new Object[]{rawValue, key, e});
            return defaultValue;
        }
    }

    public long getLong(String key) {
        return this.getLong(key, -1L);
    }

    public void putIntArray(String key, Integer[] values) {
        this.putIntList(key, Arrays.asList(values));
    }

    public int[] getIntArray(String key) {
        return this.getIntArray(key, null);
    }

    public int[] getIntArray(String key, int[] outValues) {
        List<Integer> list = this.getIntList(key);
        if (list == null || list.size() == 0) {
            return null;
        }
        int[] ret = list.size() <= outValues.length ? outValues : new int[list.size()];
        int i = 0;
        for (Integer e : list) {
            ret[i++] = e;
        }
        return ret;
    }

    public void putIntList(String key, List<Integer> values) {
        if (values == null || values.size() == 0) {
            return;
        }
        String value = TextUtils.join((CharSequence)DELIMITER, values);
        this.put(key, value);
    }

    public List<Integer> getIntList(String key) {
        String val = this.get(key);
        if (TextUtils.isEmpty((CharSequence)val)) {
            return null;
        }
        String[] values = TextUtils.split((String)val, (String)DELIMITER);
        if (values == null || values.length == 0) {
            return null;
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (String e : values) {
            try {
                list.add(Integer.parseInt(e));
            }
            catch (NumberFormatException ex) {
                MLog.error((Object)"BgProcessPref", (String)"lcy failed to parse value for key: %s, value: %s, exception: %s", (Object[])new Object[]{key, e, ex});
            }
        }
        return list;
    }

    public final void put(String key, String value) {
        sInst.edit().putString(key, value).apply();
    }

    public final String get(String key) {
        return sInst.getString(key, null);
    }

    public void remove(String key) {
        sInst.edit().remove(key).apply();
    }

    public void clear() {
        sInst.edit().clear().apply();
    }

    public Map<String, ?> getAll() {
        return sInst.getAll();
    }

    public boolean contain(String key) {
        if (key == null || key.length() == 0) {
            return false;
        }
        return sInst.contains(key);
    }

    public void putObject(String key, Object obj) {
        Gson gson = new Gson();
        String json = gson.toJson(obj);
        this.put(key, json);
    }

    public Object getObj(String key, Class className) {
        Gson gson = new Gson();
        String json = this.getString(key, "");
        Object obj = gson.fromJson(json, className);
        return obj;
    }
}

