/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.voiceroom.plugin.game.load;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.event.kvo.Kvo;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.channel.base.bean.plugins.ChannelPluginData;
import com.yy.hiyo.channel.plugins.voiceroom.common.game.ILoadGameCallback;
import com.yy.hiyo.game.base.bean.GameDownloadInfo;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.base.bean.GameInfoSource;
import com.yy.hiyo.game.service.IGameInfoService;
import com.yy.hiyo.game.service.IGameService;
import com.yy.hiyo.game.service.callback.OnGameInfoChangedListener;
import java.util.List;

public class LoadRoomGame {
    private static final String TAG = "LoadRoomGame";
    private static final long TIMEOUT = 10000L;
    private ILoadGameCallback mLoadCallback;
    private GameInfo mLoadGameInfo;
    private ChannelPluginData mPendingGame;
    private OnGameInfoChangedListener mGameListener;
    private Runnable mTimeoutTask = new Runnable(){

        @Override
        public void run() {
            MLog.error((Object)LoadRoomGame.TAG, (String)"wait for game list, and timeout", (Object[])new Object[0]);
            LoadRoomGame.this.onFinished(null, 5, "timeout");
            LoadRoomGame.this.destroy();
        }
    };

    public synchronized void loadGame(ChannelPluginData info, ILoadGameCallback callback) {
        this.mLoadCallback = callback;
        boolean hasLoaded = this.hadLoadVoiceGameList();
        if (!hasLoaded) {
            this.mPendingGame = info;
            this.addVoiceGameListener();
            YYTaskExecutor.removeTask((Runnable)this.mTimeoutTask);
            YYTaskExecutor.execute((Runnable)this.mTimeoutTask, (long)10000L);
            return;
        }
        this.downloadInner(info);
    }

    private synchronized void downloadInner(ChannelPluginData info) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"downloadInner info == null: %b", (Object[])new Object[]{info == null});
        }
        this.unwatchDownloadGame();
        if (info == null || TextUtils.isEmpty((CharSequence)info.getPluginId())) {
            MLog.error((Object)TAG, (String)"loadGame illegal game info", (Object[])new Object[0]);
            this.onFinished(null, 100, "illegal game info");
            return;
        }
        String gid = info.getPluginId();
        this.mLoadGameInfo = ((IGameInfoService)ServiceManagerProxy.getServiceManager().getService(IGameInfoService.class)).getVoiceRoomGameInfoByGid(gid);
        if (this.mLoadGameInfo == null) {
            boolean hasLoaded = ((IGameInfoService)ServiceManagerProxy.getServiceManager().getService(IGameInfoService.class)).hasLoadRoomGameList();
            String msg = StringUtils.formatWitUSLocal((String)"can not found game info in list with gid: %s,loaded:%b", (Object[])new Object[]{info.getPluginId(), hasLoaded});
            MLog.error((Object)TAG, (String)msg, (Object[])new Object[0]);
            if (hasLoaded) {
                this.onFinished(null, 3, msg);
            } else {
                this.onFinished(null, 2, msg);
            }
            return;
        }
        if (!LoadRoomGame.checkCompatibility(info, this.mLoadGameInfo)) {
            String msg = StringUtils.formatWitUSLocal((String)"version(%s) and local version(%s) is not compatibility ", (Object[])new Object[]{info.getVersion(), this.mLoadGameInfo.getModulerVer()});
            MLog.error((Object)TAG, (String)msg, (Object[])new Object[0]);
            this.onFinished(this.mLoadGameInfo, 3, msg);
            return;
        }
        boolean valid = ((IGameService)ServiceManagerProxy.getServiceManager().getService(IGameService.class)).isGameValid(this.mLoadGameInfo);
        if (valid) {
            this.onFinished(this.mLoadGameInfo, 1, "");
            return;
        }
        this.downloadGame();
    }

    public synchronized void destroy() {
        this.unwatchDownloadGame();
        YYTaskExecutor.removeTask((Runnable)this.mTimeoutTask);
        this.onFinished(this.mLoadGameInfo, 6, "destroy");
        this.mLoadCallback = null;
        this.mLoadGameInfo = null;
        this.removeGameListener();
    }

    private void addVoiceGameListener() {
        ((IGameInfoService)ServiceManagerProxy.getServiceManager().getService(IGameInfoService.class)).addGameInfoListener(this.getGameListener(), true);
    }

    private void removeGameListener() {
        if (this.mGameListener != null) {
            ((IGameInfoService)ServiceManagerProxy.getServiceManager().getService(IGameInfoService.class)).removeGameInfoListener(this.mGameListener);
            this.mGameListener = null;
        }
    }

    private OnGameInfoChangedListener getGameListener() {
        if (this.mGameListener == null) {
            this.mGameListener = new OnGameInfoChangedListener(){

                public void onGameInfoChanged(GameInfoSource type, List<GameInfo> list) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)LoadRoomGame.TAG, (String)"onGameInfoChanged type: %s, list: %s", (Object[])new Object[]{type, FP.size(list)});
                    }
                    if (type == GameInfoSource.IN_VOICE_ROOM && !FP.empty(list)) {
                        YYTaskExecutor.removeTask((Runnable)LoadRoomGame.this.mTimeoutTask);
                        LoadRoomGame.this.removeGameListener();
                        LoadRoomGame.this.downloadInner(LoadRoomGame.this.mPendingGame);
                    }
                }
            };
        }
        return this.mGameListener;
    }

    private boolean hadLoadVoiceGameList() {
        if (ServiceManagerProxy.getServiceManager() == null || ServiceManagerProxy.getServiceManager().getService(IGameInfoService.class) == null) {
            return false;
        }
        return ((IGameInfoService)ServiceManagerProxy.getServiceManager().getService(IGameInfoService.class)).hasLoadRoomGameList();
    }

    public static boolean checkCompatibility(@NonNull ChannelPluginData info, @NonNull GameInfo gameInfo) {
        long localVersion;
        long version = info.getVersion();
        if (version == (localVersion = StringUtils.safeParseLong((String)gameInfo.getModulerVer()))) {
            return gameInfo.getGameMode() == 8;
        }
        long big = version / 10000L;
        long localBig = localVersion / 10000L;
        return big == localBig && gameInfo.getGameMode() == 8;
    }

    private void downloadGame() {
        ((IGameService)ServiceManagerProxy.getServiceManager().getService(IGameService.class)).downloadGame(this.mLoadGameInfo, GameDownloadInfo.DownloadType.no_pause);
        this.watchDownloadGame();
    }

    private void watchDownloadGame() {
        Kvo.autoBindingTo((KvoSource)this.mLoadGameInfo.downloadInfo, (Object)this);
    }

    private void unwatchDownloadGame() {
        if (this.mLoadGameInfo != null) {
            Kvo.autoUnbindingFrom((KvoSource)this.mLoadGameInfo.downloadInfo, (Object)this);
        }
    }

    @KvoMethodAnnotation(name="progress", sourceClass=GameDownloadInfo.class)
    public void onUpdateProgress(KvoEventIntent event) {
        GameDownloadInfo info = (GameDownloadInfo)event.source();
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"onUpdateProgress gid: %s, state: %s, cur: %s, total: %s", (Object[])new Object[]{info.gameId, info.getState(), info.getProgress(), info.getTotalBytes()});
        }
        if (info.getState() != GameDownloadInfo.DownloadState.downloading) {
            return;
        }
        this.onDownloadProgress(this.mLoadGameInfo, info.getTotalBytes(), info.getProgress());
    }

    @KvoMethodAnnotation(name="state", sourceClass=GameDownloadInfo.class)
    public void onState(KvoEventIntent event) {
        GameDownloadInfo info = (GameDownloadInfo)event.source();
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"onState gid: %s,  state: %s, type: %s", (Object[])new Object[]{info.gameId, info.getState(), info.downloadType});
        }
        if (info.getState() == GameDownloadInfo.DownloadState.download_start) {
            this.onDownloadGameStart(this.mLoadGameInfo);
        } else if (info.getState() == GameDownloadInfo.DownloadState.download_fail) {
            String msg = StringUtils.formatWitUSLocal((String)"download failed with error: %s", (Object[])new Object[]{info.downloadErrInfo});
            MLog.error((Object)TAG, (String)msg, (Object[])new Object[0]);
            this.onFinished(this.mLoadGameInfo, 4, msg);
            this.destroy();
        } else if (info.getState() == GameDownloadInfo.DownloadState.download_finish) {
            this.onFinished(this.mLoadGameInfo, 1, "");
            this.destroy();
        }
    }

    private void onDownloadGameStart(final GameInfo info) {
        final ILoadGameCallback callback = this.mLoadCallback;
        if (callback == null) {
            return;
        }
        if (YYTaskExecutor.isMainThread()) {
            callback.onDownloadGameStart(info);
        } else {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    callback.onDownloadGameStart(info);
                }
            });
        }
    }

    private void onDownloadProgress(final GameInfo info, final long total, final long current) {
        final ILoadGameCallback callback = this.mLoadCallback;
        if (callback == null) {
            return;
        }
        if (YYTaskExecutor.isMainThread()) {
            callback.onDownloadProgress(info, total, current);
        } else {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    callback.onDownloadProgress(info, total, current);
                }
            });
        }
    }

    private void onFinished(final GameInfo info, final int code, final String msg) {
        final ILoadGameCallback callback = this.mLoadCallback;
        if (callback == null) {
            return;
        }
        if (YYTaskExecutor.isMainThread()) {
            callback.onFinished(info, code, msg);
        } else {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    callback.onFinished(info, code, msg);
                }
            });
        }
    }
}

