/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.voiceroom.plugin.game.handler;

import androidx.annotation.Nullable;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.hiyo.game.base.CocoViewBean;
import com.yy.hiyo.game.base.GameComponentLocationBean;
import com.yy.hiyo.game.service.IGameCenterService;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.HashMap;
import java.util.Map;

public class GameComponentHandler {
    private static final String TAG = "GameComponentHandler";
    public static final String CHESS_GOLD = "chess_gold";
    Map<String, GameComponentLocationBean> mLocationMap = new HashMap<String, GameComponentLocationBean>();

    public void onConpomentLocationChange(String conpomentName, GameComponentLocationBean bean) {
        this.mLocationMap.put(conpomentName, bean);
    }

    @Nullable
    public CocoViewBean getComponentLocationByKey(String componentName) {
        GameComponentLocationBean gameConpomentLocationBean = this.mLocationMap.get(componentName);
        if (gameConpomentLocationBean == null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"don't have this component", (Object[])new Object[0]);
            }
            return null;
        }
        int[] location = new int[]{gameConpomentLocationBean.getPointx(), gameConpomentLocationBean.getPointy()};
        if (!MLog.isLogLevelAboveDebug() && !MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"location %s", (Object[])new Object[]{gameConpomentLocationBean.toString()});
        }
        CocoViewBean cocoViewBean = ((IGameCenterService)ServiceManagerProxy.getServiceManager().getService(IGameCenterService.class)).genGameViewDataInApp(location, gameConpomentLocationBean.getWidth(), gameConpomentLocationBean.getHeight());
        if (RuntimeContext.sIsDebuggable && !MLog.isLogLevelAboveDebug() && !MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"getComponentLocationByKey cocoViewBean=%s", (Object[])new Object[]{cocoViewBean.toString()});
        }
        return cocoViewBean;
    }

    public void clearLoaction() {
        this.mLocationMap.clear();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ComponentName {
    }
}

