/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.voiceroom.plugin.game.guide;

import android.content.Context;
import android.view.ViewGroup;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.yy.appbase.ui.widget.MoveSpotLayout;
import com.yy.appbase.ui.widget.viewpager.YYViewPager;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ColorUtils;
import com.yy.hiyo.channel.cbase.model.bean.RuleCardInfoBean;
import com.yy.hiyo.channel.cbase.widget.IGuidePageCallback;
import com.yy.hiyo.channel.plugins.game.R;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.game.guide.GameRuleCardPagerAdapter;
import java.util.List;

public class GameGuidePage
extends YYFrameLayout {
    private static final String TAG = "GameGuidePage";
    private YYViewPager mVpRuleCard;
    private YYTextView mTvNextBtn;
    private MoveSpotLayout mSpotRuleCard;
    private GameRuleCardPagerAdapter mRuleCardPagerAdapter;
    private YYImageView mIvClose;
    RecycleImageView mBg;
    YYRelativeLayout mPageBg;
    private IGuidePageCallback mCallback;

    public GameGuidePage(Context context) {
        super(context);
        this.createView();
        this.initListener();
    }

    private void createView() {
        GameGuidePage.inflate((Context)this.getContext(), (int)R.layout.layout_game_guide_page_channel, (ViewGroup)this);
        this.mVpRuleCard = (YYViewPager)this.findViewById(R.id.vp_rule);
        this.mSpotRuleCard = (MoveSpotLayout)this.findViewById(R.id.spot_rule);
        this.mTvNextBtn = (YYTextView)this.findViewById(R.id.tv_next);
        this.mIvClose = (YYImageView)this.findViewById(R.id.iv_close);
        this.mBg = (RecycleImageView)this.findViewById(R.id.img_bg);
        this.mPageBg = (YYRelativeLayout)this.findViewById(R.id.bg_pager);
        this.mRuleCardPagerAdapter = new GameRuleCardPagerAdapter();
    }

    public void initGuideBG(String bgUrl, String color) {
        try {
            this.mPageBg.setBackgroundColor(ColorUtils.parseColor((String)color));
        }
        catch (NumberFormatException e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
    }

    public void initRuleCardPager(List<RuleCardInfoBean> gameRuleData) {
        this.mVpRuleCard.setAdapter((PagerAdapter)this.mRuleCardPagerAdapter);
        this.mRuleCardPagerAdapter.setData(gameRuleData);
        this.mSpotRuleCard.setSpots(gameRuleData.size(), this.mVpRuleCard.getCurrentItem());
    }

    private void initListener() {
        this.mTvNextBtn.setOnClickListener(v -> {
            int itemCount;
            int currentPosition = this.mVpRuleCard.getCurrentItem();
            int nextPosition = currentPosition + 1;
            if (nextPosition < (itemCount = this.mRuleCardPagerAdapter.getCount())) {
                this.mVpRuleCard.setCurrentItem(nextPosition, true);
            } else if (this.mCallback != null) {
                this.mCallback.onClose();
            }
        });
        this.mIvClose.setOnClickListener(v -> {
            if (this.mCallback != null) {
                this.mCallback.onClose();
            }
        });
        this.mVpRuleCard.setOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
                if (GameGuidePage.this.mSpotRuleCard != null) {
                    GameGuidePage.this.mSpotRuleCard.setMoveSpotPosition(position, positionOffset);
                }
            }

            public void onPageSelected(int position) {
                if (position == GameGuidePage.this.mRuleCardPagerAdapter.getCount() - 1) {
                    GameGuidePage.this.mTvNextBtn.setText(R.string.btn_mic_up_rule_get);
                } else {
                    GameGuidePage.this.mTvNextBtn.setText(R.string.btn_mic_up_rule_next);
                }
            }

            public void onPageScrollStateChanged(int state) {
            }
        });
    }

    public void setCallback(IGuidePageCallback callback) {
        this.mCallback = callback;
    }
}

