/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.voiceroom.plugin.game.gold;

import android.content.Context;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import androidx.fragment.app.FragmentActivity;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.framework.core.Environment;
import com.yy.framework.core.ui.AbstractWindowManager;
import com.yy.hiyo.channel.cbase.model.bean.RoomData;
import com.yy.hiyo.channel.module.main.ChannelWindow;
import com.yy.hiyo.channel.plugins.voiceroom.RoomPageContext;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.game.GamePlayPresenter;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.game.RoomGamePresenter;
import com.yy.hiyo.game.base.CocoViewBean;
import com.yy.hiyo.game.base.GameGoldChangeBean;
import com.yy.hiyo.wallet.base.gold.GameGoldBusiness;
import com.yy.hiyo.wallet.base.gold.IGameGoldBehavior;
import com.yy.hiyo.wallet.base.gold.IGameGoldHandler;
import com.yy.hiyo.wallet.base.gold.IGameGoldService;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\bJ\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\b\u0010\u0011\u001a\u00020\fH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0006\u0010\u0017\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/yy/hiyo/channel/plugins/voiceroom/plugin/game/gold/RoomGameGold;", "Lcom/yy/hiyo/wallet/base/gold/IGameGoldBehavior;", "gamePresenter", "Lcom/yy/hiyo/channel/plugins/voiceroom/plugin/game/RoomGamePresenter;", "(Lcom/yy/hiyo/channel/plugins/voiceroom/plugin/game/RoomGamePresenter;)V", "goldHandler", "Lcom/yy/hiyo/wallet/base/gold/IGameGoldHandler;", "destroy", "", "getContext", "Landroid/content/Context;", "getGameId", "", "getGameViewLayer", "Landroid/view/ViewGroup;", "getGameViewLocation", "Lcom/yy/hiyo/game/base/CocoViewBean;", "getRoomId", "needShowGoldDialog", "", "notifyGoldChange", "bean", "Lcom/yy/hiyo/game/base/GameGoldChangeBean;", "queryJoinCoin", "channel-game_release"})
public final class RoomGameGold
implements IGameGoldBehavior {
    private final IGameGoldHandler goldHandler;
    private final RoomGamePresenter gamePresenter;

    public void notifyGoldChange(@NotNull GameGoldChangeBean bean) {
        Intrinsics.checkParameterIsNotNull((Object)bean, (String)"bean");
        ((GamePlayPresenter)this.gamePresenter.getPresenter(GamePlayPresenter.class)).notifyGoldChange(bean);
    }

    @NotNull
    public ViewGroup getGameViewLayer() {
        RelativeLayout relativeLayout = this.gamePresenter.getWindow().getExtLayer();
        Intrinsics.checkExpressionValueIsNotNull((Object)relativeLayout, (String)"gamePresenter.window.extLayer");
        return (ViewGroup)relativeLayout;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean needShowGoldDialog() {
        RoomPageContext roomPageContext = (RoomPageContext)this.gamePresenter.getMvpContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)roomPageContext, (String)"gamePresenter.mvpContext");
        Environment environment = roomPageContext.getEnv();
        Intrinsics.checkExpressionValueIsNotNull((Object)environment, (String)"gamePresenter.mvpContext.env");
        AbstractWindowManager abstractWindowManager = environment.getWindowManager();
        Intrinsics.checkExpressionValueIsNotNull((Object)abstractWindowManager, (String)"gamePresenter.mvpContext.env.windowManager");
        if (!(abstractWindowManager.getCurrentWindow() instanceof ChannelWindow)) return false;
        RoomData roomData = this.gamePresenter.getRoomData();
        Intrinsics.checkExpressionValueIsNotNull((Object)roomData, (String)"gamePresenter.roomData");
        if (!roomData.isInChessGame()) return false;
        return true;
    }

    @Nullable
    public CocoViewBean getGameViewLocation() {
        return ((GamePlayPresenter)this.gamePresenter.getPresenter(GamePlayPresenter.class)).getConpomentLocationByKey("chess_gold");
    }

    @NotNull
    public String getGameId() {
        return this.gamePresenter.getPluginId();
    }

    @NotNull
    public String getRoomId() {
        RoomData roomData = this.gamePresenter.getRoomData();
        Intrinsics.checkExpressionValueIsNotNull((Object)roomData, (String)"gamePresenter.roomData");
        String string2 = roomData.getRoomId();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"gamePresenter.roomData.roomId");
        return string2;
    }

    @NotNull
    public Context getContext() {
        FragmentActivity fragmentActivity = ((RoomPageContext)this.gamePresenter.getMvpContext()).getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)fragmentActivity, (String)"gamePresenter.mvpContext.context");
        return (Context)fragmentActivity;
    }

    public final void destroy() {
        ((IGameGoldService)ServiceManagerProxy.getService(IGameGoldService.class)).removeHandler(GameGoldBusiness.ROOM_GAME);
    }

    public final void queryJoinCoin() {
        this.goldHandler.queryJoinCoin();
    }

    public RoomGameGold(@NotNull RoomGamePresenter gamePresenter) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)gamePresenter), (String)"gamePresenter");
        this.gamePresenter = gamePresenter;
        this.goldHandler = ((IGameGoldService)ServiceManagerProxy.getService(IGameGoldService.class)).createHandler(GameGoldBusiness.ROOM_GAME, (IGameGoldBehavior)this);
    }
}

