/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.voiceroom.plugin.game;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.appbase.common.Callback;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.core.MsgDispatcher;
import com.yy.hiyo.channel.base.bean.ChannelNotify;
import com.yy.hiyo.channel.base.bean.plugins.ChannelPluginData;
import com.yy.hiyo.channel.base.service.plugin.IPluginService;
import com.yy.hiyo.channel.cbase.ChannelMsgDef;
import com.yy.hiyo.channel.cbase.model.bean.RoomData;
import com.yy.hiyo.channel.plugins.voiceroom.base.model.BaseRoomModel;
import com.yy.hiyo.channel.plugins.voiceroom.common.game.ILoadGameCallback;
import com.yy.hiyo.channel.plugins.voiceroom.common.game.IRoomGameService;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.game.load.LoadRoomGame;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.service.IGameInfoService;
import com.yy.hiyo.mvp.base.AbsNotifyDispatchService;
import java.util.HashMap;

public class RoomGameService
extends BaseRoomModel
implements IRoomGameService {
    private static final String TAG = "RoomGameService";
    private ChannelPluginData mRoomGameInfo;
    private HashMap<String, Boolean> mDownloadedGame = new HashMap();
    private LoadRoomGame mLoadRoomGame;
    private IPluginService pluginService;
    @Nullable
    private ILoadGameCallback loadGameCallback;

    public RoomGameService(@NonNull IPluginService pluginService) {
        this.pluginService = pluginService;
    }

    public void onInit(RoomData roomData, AbsNotifyDispatchService<ChannelNotify> notifyDispatchService) {
        super.onInit(roomData, notifyDispatchService);
        this.mRoomGameInfo = roomData.getGameInfo();
    }

    public ChannelPluginData getRoomGame() {
        return this.mRoomGameInfo;
    }

    public boolean isSupportGame() {
        String gid = this.mRoomGameInfo.getPluginId();
        if (FP.empty((CharSequence)gid)) {
            return false;
        }
        if (ServiceManagerProxy.getServiceManager() != null && ServiceManagerProxy.getServiceManager().getService(IGameInfoService.class) != null) {
            GameInfo gameInfo = ((IGameInfoService)ServiceManagerProxy.getServiceManager().getService(IGameInfoService.class)).getVoiceRoomGameInfoByGid(gid);
            return gameInfo != null;
        }
        return true;
    }

    public void loadGame(String gameId, @Nullable ILoadGameCallback callback) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"loadGame %s, gameInfo %s", (Object[])new Object[]{this.mLoadRoomGame, this.getRoomGame()});
        }
        this.loadGameCallback = callback;
        GameInfo gameInfo = ((IGameInfoService)ServiceManagerProxy.getServiceManager().getService(IGameInfoService.class)).getVoiceRoomGameInfoByGid(gameId);
        if (!NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
            if (callback != null) {
                callback.onFinished(gameInfo, 4, "");
            }
        } else if (!this.mDownloadedGame.containsKey(this.mRoomGameInfo.getPluginId()) || !this.mDownloadedGame.get(this.mRoomGameInfo.getPluginId()).booleanValue()) {
            MsgDispatcher.getInstance().sendMessage(ChannelMsgDef.REQUEST_ROOM_GAME_LIST);
            this.beginDownload(gameInfo);
        } else if (callback != null) {
            callback.onFinished(gameInfo, 1, "");
        }
    }

    private void beginDownload(final GameInfo gameInfo) {
        if (this.mLoadRoomGame == null) {
            this.mLoadRoomGame = new LoadRoomGame();
            this.mLoadRoomGame.loadGame(this.getRoomGame(), new ILoadGameCallback(){

                public void onDownloadGameStart(@NonNull GameInfo info) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)RoomGameService.TAG, (String)"onDownloadGameStart %s", (Object[])new Object[]{info});
                    }
                    if (!Boolean.TRUE.equals(RoomGameService.this.mDownloadedGame.get(info.gid))) {
                        RoomGameService.this.mDownloadedGame.put(info.gid, false);
                    }
                    if (RoomGameService.this.loadGameCallback != null) {
                        RoomGameService.this.loadGameCallback.onDownloadGameStart(info);
                    }
                }

                public void onDownloadProgress(@NonNull GameInfo info, long total, long current) {
                    MLog.debug((Object)RoomGameService.TAG, (String)"onDownloadProgress %s, total %d, current %s", (Object[])new Object[]{info.getGid(), total, current});
                    if (RoomGameService.this.loadGameCallback != null) {
                        RoomGameService.this.loadGameCallback.onDownloadProgress(gameInfo, total, current);
                    }
                }

                public void onFinished(@Nullable GameInfo info, int code, String msg) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)RoomGameService.TAG, (String)"loadGame onFinished code %s, msg %s\uff0cgameInfo %s", (Object[])new Object[]{code, msg, info});
                    }
                    if (info != null && !FP.empty((CharSequence)info.gid) && !Boolean.TRUE.equals(RoomGameService.this.mDownloadedGame.get(info.gid))) {
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)RoomGameService.TAG, (String)"oadGame onFinished setDownloaded %b", (Object[])new Object[]{code == 1});
                        }
                        RoomGameService.this.mDownloadedGame.put(info.gid, code == 1);
                    }
                    if (RoomGameService.this.loadGameCallback != null) {
                        RoomGameService.this.loadGameCallback.onFinished(info, code, msg);
                        RoomGameService.this.loadGameCallback = null;
                    }
                }
            });
        }
    }

    public boolean isDownloaded(String gameId) {
        return Boolean.TRUE.equals(this.mDownloadedGame.get(gameId));
    }

    public void stopLoadGame() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"stopLoadGame %s", (Object[])new Object[]{this.mLoadRoomGame});
        }
        if (this.mLoadRoomGame != null) {
            this.mLoadRoomGame.destroy();
            this.mLoadRoomGame = null;
        }
    }

    public void startPlay(Callback<Boolean> callback) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"startPlay", (Object[])new Object[0]);
        }
        this.pluginService.startGame(callback);
    }

    public void changeReady(boolean isReady, Callback<Boolean> callback) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"changeReady isReady %s", (Object[])new Object[]{isReady});
        }
        this.pluginService.ready(isReady, callback);
    }

    public void onDestroy() {
        super.onDestroy();
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"onDestroy", (Object[])new Object[0]);
        }
        this.stopLoadGame();
        this.loadGameCallback = null;
    }
}

