/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.voiceroom.plugin.chessgame.seat;

import android.content.Context;
import android.graphics.Point;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import com.yy.appbase.ui.widget.image.CircleImageView;
import com.yy.appbase.util.ScreenWrapperUtils;
import com.yy.base.env.RuntimeContext;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResolutionUtils;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.component.seat.ISeatViewWrapper;
import com.yy.hiyo.channel.component.seat.SeatMvp;
import com.yy.hiyo.channel.component.seat.bean.SeatItem;
import com.yy.hiyo.channel.component.seat.holder.SeatItemHolder;
import com.yy.hiyo.channel.plugins.game.R;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.chessgame.ChessSeatItemHolder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ChessSeatViewWrapper
implements ISeatViewWrapper {
    private View mRealSeatView;
    private ArrayList<SeatItemHolder<SeatItem>> mItemHolders = new ArrayList(8);
    private int mSmallAvatarSize;
    private int mBigAvatarSize;
    private int mHorizontalMargin;
    private int mBigItemWidth;
    private int mSmallItemWidth;
    private IChannelPageContext mRoomPageContext;

    public ChessSeatViewWrapper(IChannelPageContext pageContext) {
        this.mRoomPageContext = pageContext;
    }

    public void createView(Context context, ViewGroup parent) {
        if (null == context || null == parent) {
            return;
        }
        if (this.mRealSeatView != null) {
            return;
        }
        int screenWidth = ResolutionUtils.getScreenWidth((Context)context);
        this.mSmallAvatarSize = screenWidth / 9;
        this.mBigAvatarSize = this.mSmallAvatarSize * 2;
        this.mHorizontalMargin = (screenWidth - this.mSmallAvatarSize * 6) / 12;
        this.mBigItemWidth = this.mBigAvatarSize + this.mHorizontalMargin * 2;
        this.mSmallItemWidth = screenWidth / 6;
        int firstRowMargin = this.mSmallItemWidth / 2;
        View.inflate((Context)context, (int)R.layout.voice_room_chess_stage_channel, (ViewGroup)parent);
        this.mRealSeatView = parent.findViewById(R.id.chess_stage);
        ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)this.mRealSeatView.getLayoutParams();
        layoutParams.leftMargin = this.mHorizontalMargin;
        layoutParams.rightMargin = this.mHorizontalMargin;
        View row1 = this.mRealSeatView.findViewById(R.id.row1);
        ViewGroup.MarginLayoutParams romLayoutParams = (ViewGroup.MarginLayoutParams)row1.getLayoutParams();
        romLayoutParams.leftMargin = firstRowMargin;
        romLayoutParams.rightMargin = firstRowMargin;
        this.mItemHolders.add(this.getSeatItemHolder(0));
        this.mItemHolders.add(this.getSeatItemHolder(1));
        this.mItemHolders.add(this.getSeatItemHolder(2));
        this.mItemHolders.add(this.getSeatItemHolder(3));
        this.mItemHolders.add(this.getSeatItemHolder(4));
        this.mItemHolders.add(this.getSeatItemHolder(5));
        this.mItemHolders.add(this.getSeatItemHolder(6));
        this.mItemHolders.add(this.getSeatItemHolder(7));
        this.mRealSeatView.addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(){

            public void onViewAttachedToWindow(View v) {
            }

            public void onViewDetachedFromWindow(View v) {
                for (SeatItemHolder holder : ChessSeatViewWrapper.this.mItemHolders) {
                    holder.onViewDetach();
                }
            }
        });
    }

    private ChessSeatItemHolder getSeatItemHolder(int seatIndex) {
        View itemView = null;
        switch (seatIndex) {
            case 0: {
                itemView = this.mRealSeatView.findViewById(R.id.item0);
                break;
            }
            case 1: {
                itemView = this.mRealSeatView.findViewById(R.id.item1);
                break;
            }
            case 2: {
                itemView = this.mRealSeatView.findViewById(R.id.item2);
                break;
            }
            case 3: {
                itemView = this.mRealSeatView.findViewById(R.id.item3);
                break;
            }
            case 4: {
                itemView = this.mRealSeatView.findViewById(R.id.item4);
                break;
            }
            case 5: {
                itemView = this.mRealSeatView.findViewById(R.id.item5);
                break;
            }
            case 6: {
                itemView = this.mRealSeatView.findViewById(R.id.item6);
                break;
            }
            case 7: {
                itemView = this.mRealSeatView.findViewById(R.id.item7);
                break;
            }
            default: {
                if (!RuntimeContext.sIsDebuggable) break;
                throw new IllegalArgumentException("illegal seat index" + seatIndex);
            }
        }
        ChessSeatItemHolder holder = null;
        if (itemView != null) {
            int avatarSize = 0 == seatIndex ? this.mBigAvatarSize : this.mSmallAvatarSize;
            int itemWidth = 0 == seatIndex ? this.mBigItemWidth : this.mSmallItemWidth;
            int avatarTopMargin = 0;
            avatarTopMargin = seatIndex < 4 ? ResolutionUtils.dip2Px((float)4.0f) : ResolutionUtils.dip2Px((float)9.0f);
            ViewGroup.LayoutParams layoutParams = itemView.getLayoutParams();
            layoutParams.width = itemWidth;
            holder = new ChessSeatItemHolder(itemView, seatIndex, this.mRoomPageContext);
            holder.adjustDimen(avatarSize, avatarTopMargin);
        }
        return holder;
    }

    public void setOnLayoutChangeListener(View.OnLayoutChangeListener listener) {
        if (this.mRealSeatView != null) {
            this.mRealSeatView.addOnLayoutChangeListener(listener);
        }
    }

    public void setPresenter(SeatMvp.IPresenter presenter) {
        if (null == presenter) {
            return;
        }
        for (SeatItemHolder<SeatItem> holder : this.mItemHolders) {
            holder.setRoomId(presenter.getRoomId());
            holder.setOnSeatItemListener((SeatMvp.IView.OnSeatItemListener)presenter);
        }
    }

    public void stopSpeakingAnimation(int position) {
        SeatItemHolder<SeatItem> holder = this.mItemHolders.get(position);
        if (holder != null) {
            holder.stopSpeakAnim();
        }
    }

    public void startSpeakingAnimation(int position) {
        SeatItemHolder<SeatItem> holder = this.mItemHolders.get(position);
        if (holder != null) {
            holder.startSpeakAnim();
        }
    }

    public void setVisibility(int visibility) {
        if (this.mRealSeatView != null) {
            this.mRealSeatView.setVisibility(visibility);
        }
    }

    public int getVisibility() {
        if (this.mRealSeatView != null) {
            return this.mRealSeatView.getVisibility();
        }
        return 8;
    }

    public View getRealSeatView() {
        return this.mRealSeatView;
    }

    public void destroy() {
        if (this.mItemHolders == null || this.mItemHolders.size() <= 0) {
            return;
        }
        ArrayList<SeatItemHolder<SeatItem>> itemHolders = new ArrayList<SeatItemHolder<SeatItem>>(this.mItemHolders);
        for (SeatItemHolder<SeatItem> item : itemHolders) {
            if (item == null) continue;
            item.destroy();
        }
    }

    public int getSeatFaceSize() {
        return this.mSmallAvatarSize;
    }

    public int[] getSeatViewPosition() {
        if (this.mRealSeatView != null) {
            return new int[]{(int)this.mRealSeatView.getX(), (int)this.mRealSeatView.getY()};
        }
        return new int[]{-1, -1};
    }

    public void updateSeats(List<SeatItem> seatItems) {
        if (!FP.empty(seatItems)) {
            int size = Math.min(seatItems.size(), this.mItemHolders.size());
            for (int i = 0; i < size; ++i) {
                this.mItemHolders.get(i).setData(seatItems.get(i));
            }
        }
    }

    public void updateSeat(int position, SeatItem data) {
        if (position >= 0 && position < this.mItemHolders.size()) {
            SeatItemHolder<SeatItem> holder = this.mItemHolders.get(position);
            holder.setData(data);
        }
    }

    public Map<Long, Point> getSeatViewLoaction(boolean isAbsolute) {
        HashMap<Long, Point> realLoctionMap = new HashMap<Long, Point>();
        int[] loction = new int[2];
        for (int i = 0; i < this.mItemHolders.size(); ++i) {
            SeatItemHolder<SeatItem> holder = this.mItemHolders.get(i);
            CircleImageView avator = holder.getAvatar();
            ScreenWrapperUtils.INSTANCE.getViewPoint((View)avator, isAbsolute, loction);
            SeatItem item = (SeatItem)holder.getData();
            if (item == null) continue;
            realLoctionMap.put(item.uid, new Point(loction[0], loction[1]));
        }
        return realLoctionMap;
    }

    @Nullable
    public View getItemView(int index) {
        if (index >= 0 && index < this.mItemHolders.size()) {
            return this.mItemHolders.get((int)index).itemView;
        }
        return null;
    }
}

