/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.voiceroom.plugin.chessgame;

import android.view.View;
import android.view.ViewGroup;
import com.yy.base.utils.ResolutionUtils;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.component.seat.bean.SeatItem;
import com.yy.hiyo.channel.component.seat.holder.SeatItemHolder;

public class ChessSeatItemHolder
extends SeatItemHolder<SeatItem> {
    private int mIndex;
    private static final int ownerSeatHeight = ResolutionUtils.dip2Px((float)120.0f);
    private static final int ownerLargeSeatHeight = ResolutionUtils.dip2Px((float)130.0f);
    private static final int normalSeatHeight = ResolutionUtils.dip2Px((float)70.0f);
    private static final int normalLargeSeatHeight = ResolutionUtils.dip2Px((float)78.0f);

    public ChessSeatItemHolder(View itemView, int seatIndex, IChannelPageContext pageContext) {
        super(itemView, pageContext);
        this.mIndex = seatIndex;
    }

    protected int getSeatHeight(SeatItem data) {
        if (data != null) {
            if (1 == data.index) {
                return data.mCalculatorData.isNeedLarge() ? ownerLargeSeatHeight : ownerSeatHeight;
            }
            if (data.index >= 5) {
                return data.mCalculatorData.isNeedLarge() ? ResolutionUtils.dip2Px((float)85.0f) : ResolutionUtils.dip2Px((float)85.0f);
            }
            return data.mCalculatorData.isNeedLarge() ? normalLargeSeatHeight : normalSeatHeight;
        }
        return normalSeatHeight;
    }

    public void adjustDimen(int avatarSize, int avatarTopMargin) {
        if (this.mSpeakAnimView != null) {
            this.mSpeakAnimView.setInitialRadius((float)(avatarSize / 2));
        }
        if (this.mAvatar != null) {
            this.mAvatar.setFrameWidthAndHeight(avatarSize);
            ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)this.mAvatar.getLayoutParams();
            layoutParams.topMargin = avatarTopMargin;
        }
        if (this.mSeatIndexView != null) {
            this.mSeatIndexView.getLayoutParams().width = ResolutionUtils.dip2Px((float)12.0f);
            this.mSeatIndexView.getLayoutParams().height = ResolutionUtils.dip2Px((float)12.0f);
            this.mSeatIndexView.setTextSize(2, 10.0f);
        }
        if (this.mIndex != 0) {
            if (this.mNickName != null) {
                this.mNickName.setTextSize(2, 10.0f);
                this.mNickName.setMaxWidth(avatarSize * 9 / 10);
            }
        } else {
            ViewGroup.MarginLayoutParams layoutParams;
            int margin = ResolutionUtils.dip2Px((float)12.0f);
            if (this.mMicIcon != null) {
                layoutParams = (ViewGroup.MarginLayoutParams)this.mMicIcon.getLayoutParams();
                layoutParams.rightMargin = margin;
                layoutParams.bottomMargin = margin;
            }
            if (this.mReadyIcon != null) {
                layoutParams = (ViewGroup.MarginLayoutParams)this.mReadyIcon.getLayoutParams();
                layoutParams.rightMargin = margin;
                layoutParams.bottomMargin = margin;
            }
        }
        if (this.mCalculatorView != null) {
            this.mCalculatorView.adjustSmallMode();
        }
    }
}

