/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.voiceroom.plugin.assistgame.seat;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.common.Callback;
import com.yy.appbase.ui.adapter.BaseItemBinder;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ScreenUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.component.seat.ISeatViewWrapper;
import com.yy.hiyo.channel.component.seat.SeatMvp;
import com.yy.hiyo.channel.component.seat.bean.SeatItem;
import com.yy.hiyo.channel.plugins.game.R;
import com.yy.hiyo.channel.plugins.voiceroom.base.AbsRoomSeatPresenter;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.assistgame.AssistGamePresenter;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.assistgame.seat.AssistGameSeatItemHolder;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.assistgame.seat.AssistSeatUtils;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.assistgame.seat.AssistSeatViewWrapper;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.assistgame.toppanel.AssistGameTopPanelPresenter;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.assistgame.toppresenter.AssistGameTopPresenter;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.game.GamePlayPresenter;
import com.yy.hiyo.game.service.bean.GamePlayContext;
import com.yy.hiyo.game.service.protocol.GameLifeWrapper;
import com.yy.hiyo.game.service.protocol.IGameLifecycle;
import me.drakeet.multitype.ItemViewBinder;

public class AssistGameSeatPresenter
extends AbsRoomSeatPresenter<ISeatViewWrapper> {
    private static final String TAG = "AssistGameSeatPresenter";
    private GameLifeWrapper gameLifecycle = new GameLifeWrapper(){

        public void onLoadGameFinish(GamePlayContext context, int finishType, @Nullable DefaultWindow window) {
            super.onLoadGameFinish(context, finishType, window);
            if (null != AssistGameSeatPresenter.this.getSeatViewContainer()) {
                AssistGameSeatPresenter.this.getSeatViewContainer().updateSeatViewLocation();
            }
        }
    };

    public void onInit(IChannelPageContext mvpContext) {
        super.onInit(mvpContext);
        ((GamePlayPresenter)this.getPresenter(GamePlayPresenter.class)).registerGameLifecycle((IGameLifecycle)this.gameLifecycle);
        AssistSeatUtils.setAvatarSize((ScreenUtils.getInstance().getWidthPixels() - ResolutionUtils.dip2Px((float)39.0f) - AssistSeatUtils.getItemSpace() * 8) / 9);
        ((AssistGameTopPresenter)this.getPresenter(AssistGameTopPresenter.class)).showAssistGameStyle();
        ((AssistGameTopPanelPresenter)this.getPresenter(AssistGameTopPanelPresenter.class)).resetIconSize();
    }

    public void onStandUp() {
        boolean canOP = ((AssistGamePresenter)this.getPresenter(AssistGamePresenter.class)).canOperateUser(AccountUtil.getUid());
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"onStandUp canOP: %s", (Object[])new Object[]{canOP});
        }
        if (canOP) {
            super.onStandUp();
        } else {
            ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.tips_assist_gameing);
        }
    }

    public boolean onSitDown(int index, Callback<Integer> callback) {
        int mSeatIndex = this.getChannel().getSeatService().getSeatIndex(AccountUtil.getUid());
        if (mSeatIndex == -1) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"mSeatIndex is -1 can onSitDown", (Object[])new Object[0]);
            }
            return super.onSitDown(index, callback);
        }
        boolean inFirstSeat = this.getChannel().getSeatService().isInFirstSeat(AccountUtil.getUid());
        int mGameState = ((AssistGamePresenter)this.getPresenter(AssistGamePresenter.class)).getGameState();
        if (inFirstSeat && (mGameState == 2 || mGameState == 3)) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"onSitDown first and in game can not OP: %s", (Object[])new Object[]{mGameState});
            }
            ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.tips_assist_gameing);
            return false;
        }
        return super.onSitDown(index, callback);
    }

    protected ISeatViewWrapper createSeatViewWrapper() {
        return this.createAssistGameSeatViewWrapper();
    }

    private ISeatViewWrapper createAssistGameSeatViewWrapper() {
        AssistSeatViewWrapper seatViewWrapper = new AssistSeatViewWrapper();
        seatViewWrapper.getAdapter().register(SeatItem.class, (ItemViewBinder)new BaseItemBinder<SeatItem, AssistGameSeatItemHolder>(){

            @NonNull
            protected AssistGameSeatItemHolder onCreateViewHolder(@NonNull LayoutInflater inflater, @NonNull ViewGroup parent) {
                return new AssistGameSeatItemHolder(this.createItemView(inflater, parent, R.layout.assistgame_seat_style1_item), (IChannelPageContext)AssistGameSeatPresenter.this.getMvpContext());
            }

            protected void onBindViewHolder(@NonNull AssistGameSeatItemHolder holder, @NonNull SeatItem item) {
                super.onBindViewHolder((BaseItemBinder.ViewHolder)holder, (Object)item);
                holder.setRoomId(AssistGameSeatPresenter.this.getRoomId());
                holder.setOnSeatItemListener((SeatMvp.IView.OnSeatItemListener)AssistGameSeatPresenter.this);
            }

            protected long getItemId(@NonNull SeatItem item) {
                return item.index;
            }
        });
        return seatViewWrapper;
    }

    public void changeSeatStyle(int style) {
    }

    public void onDestroy() {
        super.onDestroy();
        ((GamePlayPresenter)this.getPresenter(GamePlayPresenter.class)).unRegisterGameLifecycle((IGameLifecycle)this.gameLifecycle);
    }
}

