/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.voiceroom.plugin.assistgame.seat;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Paint;
import android.view.View;
import android.view.animation.Interpolator;
import androidx.annotation.ColorInt;
import androidx.interpolator.view.animation.LinearOutSlowInInterpolator;
import com.bumptech.glide.load.DataSource;
import com.yy.appbase.common.Callback;
import com.yy.appbase.ui.adapter.BaseItemBinder;
import com.yy.appbase.ui.press.PressAlpha;
import com.yy.appbase.ui.widget.image.CircleImageView;
import com.yy.appbase.ui.widget.waveview.WaveView;
import com.yy.base.env.RuntimeContext;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.component.seat.SeatMvp;
import com.yy.hiyo.channel.component.seat.SeatPresenter;
import com.yy.hiyo.channel.component.seat.SeatTrack;
import com.yy.hiyo.channel.component.seat.bean.SeatItem;
import com.yy.hiyo.channel.component.seat.holder.SeatMenuContainer;
import com.yy.hiyo.channel.component.seat.holder.SeatMenuPresenter;
import com.yy.hiyo.channel.plugins.game.R;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.assistgame.seat.AssistSeatUtils;
import com.yy.hiyo.mvp.base.callback.IDestroyable;
import com.yy.hiyo.mvp.base.callback.WeakCallback;

public class AssistGameSeatItemHolder
extends BaseItemBinder.ViewHolder<SeatItem> {
    private static final String IMAGE_POSTFIX = YYImageUtils.getThumbnailPostfix((int)75);
    private IChannelPageContext mRoomPageContext;
    private static final String TAG = "FTVoiceRoomSeat_AssistGameSeatItemHolder";
    @ColorInt
    private static final int SPEAK_COLOR = Color.parseColor((String)"#31ffdb");
    @ColorInt
    private static final int HOST_SPEAK_COLOR = Color.parseColor((String)"#ffc102");
    private static final int INDEX_SIZE = ResolutionUtils.dip2Px((float)8.0f);
    protected RecycleImageView mMicIcon;
    protected YYTextView mSeatIndexView;
    protected CircleImageView mAvatar;
    private SeatMvp.IView.OnSeatItemListener mOnSeatItemListener;
    private String mRoomId;
    protected WaveView mSpeakAnimView;
    private String mAvatarUrl = null;
    private SeatMenuContainer menuContainer;

    public AssistGameSeatItemHolder(View itemView, IChannelPageContext context) {
        super(itemView);
        this.initView();
        this.mRoomPageContext = context;
    }

    private void initView() {
        int itemSize;
        this.itemView.getLayoutParams().width = itemSize = AssistSeatUtils.getAvatarSize() + ResolutionUtils.dip2Px((float)6.0f);
        this.itemView.getLayoutParams().height = itemSize;
        this.mSpeakAnimView = (WaveView)this.itemView.findViewById(R.id.speak_anim);
        this.mSpeakAnimView.setDuration(2000L);
        this.mSpeakAnimView.setStyle(Paint.Style.FILL);
        this.mSpeakAnimView.setMaxRadiusRate(1.15f);
        this.mSpeakAnimView.setInterpolator((Interpolator)new LinearOutSlowInInterpolator());
        this.mSpeakAnimView.setInitialRadius((float)(AssistSeatUtils.getAvatarSize() / 2));
        this.mSpeakAnimView.getLayoutParams().width = itemSize;
        this.mSpeakAnimView.getLayoutParams().height = itemSize;
        this.mAvatar = (CircleImageView)this.itemView.findViewById(R.id.avatar);
        this.mSeatIndexView = (YYTextView)this.itemView.findViewById(R.id.seat_index);
        this.mMicIcon = (RecycleImageView)this.itemView.findViewById(R.id.micIcon);
        this.mAvatar.setOnClickListener(v -> {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"item on click %s", (Object[])new Object[]{this.getData()});
            }
            if (((SeatItem)this.getData()).hasUser()) {
                this.mOnSeatItemListener.onAvatarClick((SeatItem)this.getData());
            } else {
                ((SeatPresenter)this.mRoomPageContext.getPresenter(SeatPresenter.class)).checkManagerPermission((Callback)WeakCallback.of((IDestroyable)this.mRoomPageContext, hasPermission -> {
                    if (Boolean.TRUE.equals(hasPermission)) {
                        this.showMenu();
                        SeatTrack.INSTANCE.hostBlankClick(this.mRoomId);
                    } else if (!((SeatItem)this.getData()).isLocked()) {
                        this.mOnSeatItemListener.onSitDown(((SeatItem)this.getData()).index, null);
                    } else {
                        ToastUtils.showToast((Context)this.itemView.getContext(), (int)(((SeatItem)this.getData()).index == 1 ? R.string.tips_seat_locked_sub_group : R.string.tips_room_bean_locked));
                    }
                }));
            }
        });
        this.mAvatar.getLayoutParams().width = AssistSeatUtils.getAvatarSize();
        this.mAvatar.getLayoutParams().height = AssistSeatUtils.getAvatarSize();
    }

    private void showMenu() {
        SeatMenuPresenter presenter = (SeatMenuPresenter)this.mRoomPageContext.getPresenter(SeatMenuPresenter.class);
        SeatMenuContainer menuContainer = new SeatMenuContainer(this.mSeatIndexView.getContext());
        menuContainer.setPresenter((View)this.mAvatar, presenter);
        presenter.show((SeatItem)this.getData());
        this.menuContainer = menuContainer;
    }

    public void setRoomId(String roomId) {
        this.mRoomId = roomId;
    }

    public void setData(SeatItem data) {
        super.setData((Object)data);
        if (RuntimeContext.sIsDebuggable && !MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"setData holder hasUser %b, %s, item view %s, %s", (Object[])new Object[]{data.hasUser(), this, this.itemView, data});
        }
        boolean isAvatarChanged = FP.empty((CharSequence)this.mAvatarUrl) || !StringUtils.equals((String)this.mAvatarUrl, (String)data.userInfo.avatar);
        MLog.debug((Object)TAG, (String)"hashCode %s, mAvatarUrl %s, data.userInfo.avatar %s", (Object[])new Object[]{((Object)((Object)this)).hashCode(), this.mAvatarUrl, data.userInfo.avatar});
        this.mAvatarUrl = data.userInfo.avatar;
        if (RuntimeContext.sIsDebuggable && data.uid > 0L && !data.hasUser()) {
            throw new RuntimeException("SeatItemHolder user data error data:" + data.toString());
        }
        if (data.hasUser()) {
            if (isAvatarChanged || !StringUtils.equal((String)String.valueOf(this.mAvatar.getTag(R.id.avatar)), (String)this.mAvatarUrl)) {
                int defaultAvatar = data.userInfo.isFemale() ? R.drawable.icon_avatar_default_female_medium : R.drawable.icon_avatar_default_male_medium;
                ImageLoader.Builder.obtain((RecycleImageView)this.mAvatar, (String)(data.userInfo.avatar + IMAGE_POSTFIX)).placeholder(ResourceUtils.getDrawable((int)defaultAvatar)).error(defaultAvatar).setListener(new ImageLoader.ImageLoadListener(){

                    public void onLoadFailed(Exception e) {
                        AssistGameSeatItemHolder.this.mAvatar.setTag(R.id.avatar, (Object)"");
                    }

                    public void onResourceReady(Object resource, boolean isFromMemoryCache, DataSource dataSource) {
                        AssistGameSeatItemHolder.this.mAvatar.setTag(R.id.avatar, (Object)AssistGameSeatItemHolder.this.mAvatarUrl);
                    }
                }).load();
            }
            PressAlpha.of((View)this.mAvatar, (float)1.0f);
            this.mSeatIndexView.getLayoutParams().width = INDEX_SIZE;
            this.mSeatIndexView.getLayoutParams().height = INDEX_SIZE;
            if (data.index == 1) {
                this.updateHost(data);
            } else {
                this.updateIndex();
            }
            this.updateMic(data);
        } else {
            this.updateLock(data);
            PressAlpha.of((View)this.mAvatar, (float)0.2f);
            this.mMicIcon.setVisibility(8);
            this.updateIndex();
        }
        if (data.isSpeaking) {
            this.startSpeakAnim();
        } else {
            this.stopSpeakAnim();
        }
    }

    private void updateLock(SeatItem data) {
        int lockDrawable = R.drawable.bg_seat_lock;
        ImageLoader.Builder.obtain((RecycleImageView)this.mAvatar, (String)"", (int)(data.isLocked() ? lockDrawable : R.drawable.room_seat_add)).load();
    }

    private void updateMic(SeatItem data) {
        if (data.isMicForbidden()) {
            this.mMicIcon.setVisibility(0);
            this.mMicIcon.setImageResource(R.drawable.icon_voiceforbid);
        } else if (!data.isMicOpen()) {
            this.mMicIcon.setImageResource(R.drawable.icon_voiceoff);
            this.mMicIcon.setVisibility(0);
        } else {
            this.mMicIcon.setVisibility(8);
        }
    }

    private void updateHost(SeatItem data) {
        if (data.roleType == 15) {
            this.mSeatIndexView.setVisibility(this.getData() != null && ((SeatItem)this.getData()).hasUser() ? 0 : 4);
            this.mSeatIndexView.setBackgroundResource(R.drawable.icon_seat_host);
        } else if (data.roleType == 10) {
            this.mSeatIndexView.setVisibility(0);
            this.mSeatIndexView.setBackgroundResource(R.drawable.icon_seat_administorter);
        } else {
            this.mSeatIndexView.setVisibility(this.getData() != null && ((SeatItem)this.getData()).hasUser() ? 0 : 4);
            this.mSeatIndexView.setBackgroundResource(R.drawable.icon_room_host);
        }
        if (this.mSeatIndexView.getVisibility() == 4) {
            this.mSeatIndexView.getLayoutParams().width = -2;
            this.mSeatIndexView.getLayoutParams().height = -2;
            this.mSeatIndexView.setBackgroundResource(0);
        } else {
            this.mSeatIndexView.getLayoutParams().width = INDEX_SIZE;
            this.mSeatIndexView.getLayoutParams().height = INDEX_SIZE;
        }
        this.mSeatIndexView.setText(null);
    }

    public void setOnSeatItemListener(SeatMvp.IView.OnSeatItemListener onSeatItemListener) {
        this.mOnSeatItemListener = onSeatItemListener;
    }

    public void startSpeakAnim() {
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"startSpeakAnim %d", (Object[])new Object[]{((SeatItem)this.getData()).index});
        }
        this.mSpeakAnimView.setColor(((SeatItem)this.getData()).index == 1 ? HOST_SPEAK_COLOR : SPEAK_COLOR);
        this.mSpeakAnimView.start();
    }

    public void stopSpeakAnim() {
        if (!MLog.isLogLevelAboveDebug() && this.getData() != null) {
            MLog.debug((Object)TAG, (String)"stopSpeakAnim %d", (Object[])new Object[]{((SeatItem)this.getData()).index});
        }
        this.mSpeakAnimView.stop();
    }

    private void updateIndex() {
        SeatItem data = (SeatItem)this.getData();
        if (((SeatItem)this.getData()).index == 1) {
            this.updateHost((SeatItem)this.getData());
        } else {
            this.mSeatIndexView.setVisibility(0);
            this.mSeatIndexView.setBackgroundResource(R.drawable.room_seat_index);
            this.mSeatIndexView.getBackground().setLevel(data.userInfo.isFemale() ? 0 : 1);
            this.mSeatIndexView.setText((CharSequence)String.valueOf(data.index));
        }
    }

    public void onViewDetach() {
        super.onViewDetach();
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"onPageDetach %s", (Object[])new Object[]{this});
        }
        this.mSpeakAnimView.stopImmediately();
    }

    public CircleImageView getAvatar() {
        return this.mAvatar;
    }

    public void destroy() {
        if (this.menuContainer != null) {
            this.menuContainer.destroy();
        }
    }
}

