/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.voiceroom.plugin.assistgame.profile;

import android.content.Context;
import com.yy.appbase.R;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.common.Callback;
import com.yy.appbase.ui.dialog.OkCancelDialog;
import com.yy.appbase.ui.dialog.OkCancelDialogListener;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.component.profile.profilecard.voiceroom.VoiceRoomProfileCardPresenter;
import com.yy.hiyo.channel.plugins.game.R;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.assistgame.AssistGamePresenter;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.game.GamePlayPresenter;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import net.ihago.game.srv.result.GameInnerStatus;

public class AssistGameProfilePresenter
extends VoiceRoomProfileCardPresenter {
    private static final String TAG = "AssistGameProfilePresen";

    public void onKickOut(long uid) {
        boolean canOP = ((AssistGamePresenter)this.getPresenter(AssistGamePresenter.class)).canOperateUser(uid);
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"onKickOut uid: %s  canOP: %s", (Object[])new Object[]{uid, canOP});
        }
        this.checkCanOperateInGaming(uid, (Callback<Boolean>)((Callback)data -> {
            if (data.booleanValue()) {
                if (canOP) {
                    super.onKickOut(uid);
                } else {
                    ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.tips_assist_gameing);
                }
            } else {
                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.tips_assist_game_ing_cannot_kickout);
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", "partygame_cant_kick_news_show"));
            }
        }));
    }

    public void onChangeMic(long uid, boolean open) {
        if (uid == AccountUtil.getUid()) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"onChangeMic by self", (Object[])new Object[0]);
            }
            super.onChangeMic(uid, open);
            return;
        }
        boolean canOP = ((AssistGamePresenter)this.getPresenter(AssistGamePresenter.class)).canOperateUser(uid);
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"onKickOut uid: %s  open: %s canOP: %s", (Object[])new Object[]{uid, open, canOP});
        }
        if (canOP) {
            super.onChangeMic(uid, open);
        } else {
            ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.tips_assist_gameing);
        }
    }

    public void onMakeLeaveSeat(long uid) {
        boolean canOP = ((AssistGamePresenter)this.getPresenter(AssistGamePresenter.class)).canOperateUser(uid);
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"onMakeLeaveSeat uid: %s  canOP: %s", (Object[])new Object[]{uid, canOP});
        }
        this.checkCanOperateInGaming(uid, (Callback<Boolean>)((Callback)data -> {
            if (data.booleanValue()) {
                if (canOP) {
                    super.onMakeLeaveSeat(uid);
                } else {
                    ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.tips_assist_gameing);
                }
            } else {
                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.tips_assist_game_ing_cannot_kickout);
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", "partygame_cant_kick_news_show"));
            }
        }));
    }

    public void onLeaveSeatSelf(final long uid) {
        if (this.getChannel().getPluginService().getCurPluginData().getPluginId().equals("ludoyuyinfang") && ((GamePlayPresenter)this.getPresenter(GamePlayPresenter.class)).getGameInnerStatus().isMeInGameSeat) {
            OkCancelDialog dialog2 = new OkCancelDialog((CharSequence)ResourceUtils.getString((int)R.string.tips_ludoyuyinfang_standup_dialog), (CharSequence)ResourceUtils.getString((int)R.string.contact_dialog_ok), (CharSequence)ResourceUtils.getString((int)R.string.contact_dialog_cancel), new OkCancelDialogListener(){

                public void onCancel() {
                }

                public void onOk() {
                    AssistGameProfilePresenter.super.onLeaveSeatSelf(uid);
                }
            });
            DialogLinkManager dialogLinkManager = new DialogLinkManager((Context)((IChannelPageContext)this.getMvpContext()).getContext());
            dialogLinkManager.showDialog((BaseDialog)dialog2);
            return;
        }
        boolean canOP = ((AssistGamePresenter)this.getPresenter(AssistGamePresenter.class)).canOperateUser(uid);
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"onLeaveSeatSelf uid: %s  canOP: %s", (Object[])new Object[]{uid, canOP});
        }
        if (canOP) {
            super.onLeaveSeatSelf(uid);
        } else {
            ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.tips_assist_gameing);
        }
    }

    public void onMakeLeaveAndLockSeat(long uid) {
        boolean canOP = ((AssistGamePresenter)this.getPresenter(AssistGamePresenter.class)).canOperateUser(uid);
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"onMakeLeaveAndLockSeat uid: %s  canOP: %s", (Object[])new Object[]{uid, canOP});
        }
        this.checkCanOperateInGaming(uid, (Callback<Boolean>)((Callback)data -> {
            if (data.booleanValue()) {
                if (canOP) {
                    super.onMakeLeaveAndLockSeat(uid);
                } else {
                    ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.tips_assist_gameing);
                }
            } else {
                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.tips_assist_game_ing_cannot_kickout);
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", "partygame_cant_kick_news_show"));
            }
        }));
    }

    public void onRemoveMember(long uid) {
        boolean canOP = ((AssistGamePresenter)this.getPresenter(AssistGamePresenter.class)).canOperateUser(uid);
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"onRemoveMember uid: %s  canOP: %s", (Object[])new Object[]{uid, canOP});
        }
        if (canOP) {
            super.onRemoveMember(uid);
        } else {
            ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.tips_assist_gameing);
        }
    }

    private void checkCanOperateInGaming(long uid, Callback<Boolean> callback) {
        if (null != this.getChannel() && null != this.getChannel().getPluginService()) {
            this.getChannel().getPluginService().getGameInnerData(data -> {
                if ((data.getGameInnerStatus() == (long)GameInnerStatus.StatusStart.getValue() || data.getGameInnerStatus() == (long)GameInnerStatus.StatusGameingPing.getValue()) && data.getPlayerList().contains(uid)) {
                    callback.onResponse((Object)false);
                } else {
                    callback.onResponse((Object)true);
                }
            });
        } else {
            callback.onResponse((Object)false);
        }
    }
}

