/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.voiceroom.plugin.assistgame.game;

import android.content.Context;
import android.view.ViewGroup;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.constraintlayout.widget.ConstraintSet;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.channel.plugins.game.R;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.game.RoomGameContainer;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.game.RoomGamePresenter;
import org.json.JSONException;
import org.json.JSONObject;

public class AssistGameRoomPresenter
extends RoomGamePresenter {
    private static final String TAG = "AssistGameRoomPresenter";

    public void changeGameContainerViewSize(boolean fullSize, boolean isAssistMember, int mGameState) {
        if (fullSize) {
            ConstraintSet set = new ConstraintSet();
            RoomGameContainer parent = this.getGameContainer();
            set.clone((ConstraintLayout)parent);
            int top = this.getGameContainer().getTop();
            int height = this.getGameParentHeight() - top;
            int width = ResolutionUtils.getScreenWidth((Context)RuntimeContext.sApplicationContext);
            set.constrainWidth(R.id.gaming_container, width);
            set.constrainHeight(R.id.gaming_container, height);
            set.applyTo((ConstraintLayout)parent);
        } else {
            ConstraintSet set = new ConstraintSet();
            RoomGameContainer parent = this.getGameContainer();
            set.clone((ConstraintLayout)parent);
            int width = ResolutionUtils.getScreenWidth((Context)RuntimeContext.sApplicationContext);
            set.constrainHeight(R.id.gaming_container, this.getHalfScreenHeight(mGameState, isAssistMember, width));
            set.constrainWidth(R.id.gaming_container, width);
            set.applyTo((ConstraintLayout)parent);
        }
    }

    private int getGameParentHeight() {
        ViewGroup viewGroup;
        RoomGameContainer gameContainer = this.getGameContainer();
        if (gameContainer.getParent() != null && (viewGroup = (ViewGroup)gameContainer.getParent()).getHeight() > 0) {
            return viewGroup.getHeight();
        }
        return ResolutionUtils.getScreenHeight((Context)RuntimeContext.sApplicationContext);
    }

    private int getHalfScreenHeight(int mGameState, boolean isAssistMember, int width) {
        int margin = ResolutionUtils.dip2Px((float)10.0f);
        int height = width - 2 * margin;
        if (isAssistMember && mGameState == 3) {
            return (int)((float)height * 0.6f);
        }
        return height;
    }

    public JSONObject getRoomViewParams() {
        JSONObject jsonObject = JsonParser.obtainJSONObject();
        try {
            jsonObject.put("totalHeight", this.getGameParentHeight());
            jsonObject.put("totalWidth", ResolutionUtils.getScreenWidth((Context)RuntimeContext.sApplicationContext));
            jsonObject.put("topBarHeight", this.getGameContainer().getTop());
            jsonObject.put("gameViewHeight", this.getGameContainer().getHeight());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"getCurViewParams str: %s", (Object[])new Object[]{jsonObject.toString()});
        }
        return jsonObject;
    }
}

