/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.voiceroom.plugin.assistgame.bottom;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import com.yy.appbase.ui.widget.YYPlaceHolderView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.utils.ResolutionUtils;
import com.yy.hiyo.channel.cbase.AbsPage;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.component.act.rightbanner.RightBannerActivityPresenter;
import com.yy.hiyo.channel.plugins.game.R;

public class AssistGameRightBannerPresenter
extends RightBannerActivityPresenter {
    private static final String TAG = "AssistGameRightBannerPresenter";
    private YYImageView mImageView;

    public void setClickListener(View.OnClickListener clickListener) {
        if (clickListener != null && this.mImageView != null) {
            this.mImageView.setOnClickListener(clickListener);
        }
    }

    public void setContainer(@NonNull YYPlaceHolderView container) {
        super.setContainer(container);
        this.mParentContainer.setVisibility(8);
        this.mParentContainer.removeAllViews();
    }

    public void updateAssistGameView(boolean show) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"updateAssistGameView show: %s", (Object[])new Object[]{show});
        }
        if (this.mParentContainer == null) {
            return;
        }
        if (show) {
            this.mParentContainer.setVisibility(0);
            this.showAssistImageView();
        } else {
            this.mParentContainer.setVisibility(8);
            this.mParentContainer.removeAllViews();
        }
    }

    private void showAssistImageView() {
        if (this.mParentContainer == null) {
            return;
        }
        if (this.mImageView == null) {
            this.mImageView = new YYImageView((Context)((IChannelPageContext)this.getMvpContext()).getContext());
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -2);
            layoutParams.gravity = 0x800055;
            layoutParams.bottomMargin = ResolutionUtils.dip2Px((float)8.0f);
            this.mImageView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.mImageView.setScaleType(ImageView.ScaleType.CENTER_CROP);
        }
        if (this.mImageView.getParent() != null) {
            ((ViewGroup)this.mImageView.getParent()).removeView((View)this.mImageView);
        }
        this.mParentContainer.addView((View)this.mImageView);
        this.mImageView.setBackgroundResource(R.drawable.btn_assist_game_expland);
    }

    public void onPageAttach(AbsPage page, boolean isReAttach) {
        super.onPageAttach(page, isReAttach);
        if (this.mParentContainer != null) {
            this.mParentContainer.removeAllViews();
        }
    }

    public void onPageDetach(AbsPage page) {
        super.onPageDetach(page);
        this.mImageView = null;
    }

    protected void requestRoomActivities(boolean isInit) {
        MLog.debug((Object)TAG, (String)"assistGame don't need show Right Activity", (Object[])new Object[0]);
    }
}

