/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.service.rolepermission;

import androidx.annotation.NonNull;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.common.Callback;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.RoomRolePermissionConfig;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.hiyo.channel.base.bean.ChannelDetailInfo;
import com.yy.hiyo.channel.base.bean.ChannelInfo;
import com.yy.hiyo.channel.base.bean.ChannelUser;
import com.yy.hiyo.channel.base.rolepermission.IRolePermissionService;
import com.yy.hiyo.channel.base.rolepermission.RolePermission;
import com.yy.hiyo.channel.base.rolepermission.RoleSession;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.base.service.IDataService;
import com.yy.hiyo.channel.base.service.IRoleService;
import com.yy.hiyo.channel.service.BaseService;
import com.yy.hiyo.channel.service.role.RoleService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.CopyOnWriteArrayList;

public class RolePermissionServiceImpl
extends BaseService
implements IRolePermissionService {
    private static final String TAG = "RolePermissionService";
    private final CopyOnWriteArrayList<IRolePermissionService.OnRoleSessionUpdateListener> mSessionUpdateListeners;
    private final IChannel mGroup;
    private final IRoleService.IMemberOrMasterChangeListener mMemberOrMasterChangeListener;
    private IDataService.IDataUpdateListener mDataUpdateListener;
    private long mOwnerId;

    public RolePermissionServiceImpl(final IChannel channel) {
        super(channel);
        this.mGroup = channel;
        this.mSessionUpdateListeners = new CopyOnWriteArrayList();
        this.mMemberOrMasterChangeListener = new IRoleService.IMemberOrMasterChangeListener(){

            public void onRoleChanged(String channelId, long uid, int roleType) {
                RolePermissionServiceImpl.this.onRoleUpdate(channel, uid, roleType);
            }

            public void onMyRoleChanged(String channelId, int newRoleType) {
                RolePermissionServiceImpl.this.onRoleUpdate(channel, AccountUtil.getUid(), newRoleType);
            }

            public void onMemberListChanged(String channelId, ArrayList<ChannelUser> members) {
            }
        };
        this.mDataUpdateListener = new IDataService.IDataUpdateListener(){

            public void onDataUpdate(String channelId, ChannelDetailInfo info) {
                if (info != null && info.baseInfo.ownerUid != RolePermissionServiceImpl.this.mOwnerId) {
                    RolePermissionServiceImpl.this.mOwnerId = info.baseInfo.ownerUid;
                }
            }
        };
        channel.getRoleService().addDataListener(this.mMemberOrMasterChangeListener);
        channel.getDataService().addDataListener(this.mDataUpdateListener);
        channel.getDataService().getChannelBaseInfo(new IDataService.IGetGroupBaseInfoCallBack(){

            public void onSuccess(String channelId, ChannelInfo info) {
                if (info != null && info.ownerUid > 0L) {
                    RolePermissionServiceImpl.this.mOwnerId = info.ownerUid;
                }
            }

            public void onError(String channelId, int errorCode, String errorTips, Exception e) {
            }
        });
    }

    private void onRoleUpdate(IChannel group, long uid, int role) {
        MLog.debug((Object)TAG, (String)"onRoleUpdate uid %d, role %d", (Object[])new Object[]{uid, role});
        YYTaskExecutor.postToMainThread(() -> {
            RoleSession session = RoleSession.getSession((int)role, (boolean)this.isAnchor(uid));
            for (IRolePermissionService.OnRoleSessionUpdateListener item : this.mSessionUpdateListeners) {
                item.onRoleSessionUpdate(uid, session);
            }
        });
    }

    public void fetchRolePermission(final long uid, final @NonNull Callback<RoleSession> callback2) {
        int role = this.getRole(uid);
        if (role != -1) {
            YYTaskExecutor.postToMainThread(() -> callback2.onResponse((Object)RoleSession.getSession((int)role, (boolean)this.isAnchor(uid))));
        } else {
            this.mGroup.getRoleService().getRole(uid, new IRoleService.IGetRoleCallBack(){

                public void onSuccess(String channelId, int roleType) {
                    RoleSession session = RoleSession.getSession((int)roleType, (boolean)RolePermissionServiceImpl.this.isAnchor(uid));
                    callback2.onResponse((Object)session);
                }

                public void onError(String channelId, int errorCode, String errorTips, Exception e) {
                    callback2.onResponse((Object)RoleSession.NONE);
                }
            });
        }
    }

    public RoleSession getRoleSession(long uid) {
        return this.checkRoleSession(uid);
    }

    public boolean hasPermission(long uid, RolePermission ... permission) {
        if (FP.empty((Object[])permission)) {
            return false;
        }
        RoleSession roleSession = this.checkRoleSession(uid);
        return roleSession.getPermissions().containsAll(Arrays.asList(permission));
    }

    public void addOnRoleSessionUpdateListener(IRolePermissionService.OnRoleSessionUpdateListener listener) {
        this.mSessionUpdateListeners.add(listener);
    }

    public void removeOnRoleSessionUpdateListener(IRolePermissionService.OnRoleSessionUpdateListener listener) {
        this.mSessionUpdateListeners.remove(listener);
    }

    private RoleSession checkRoleSession(long uid) {
        if (this.isPermissionDisable()) {
            MLog.warn((Object)TAG, (String)"checkRoleSession uid %d, owner %d, \u7981\u7528\u6743\u9650", (Object[])new Object[]{uid, this.mOwnerId});
            if (uid == this.mOwnerId && this.mOwnerId > 0L) {
                return RoleSession.OWNER;
            }
            return RoleSession.GUEST;
        }
        int role = this.getRole(uid);
        MLog.debug((Object)TAG, (String)"checkRoleSession uid %d, role %d", (Object[])new Object[]{uid, role});
        return RoleSession.getSession((int)role, (boolean)this.isAnchor(uid));
    }

    private int getRole(long uid) {
        if (uid == this.mOwnerId && this.mOwnerId > 0L) {
            return 15;
        }
        RoleService roleService = (RoleService)this.mGroup.getRoleService();
        int role = roleService.getRoleModel().getRoleCache(uid);
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"getPermission cache %d", (Object[])new Object[]{role});
        }
        return role;
    }

    private boolean isPermissionDisable() {
        RoomRolePermissionConfig config = (RoomRolePermissionConfig)UnifyConfig.INSTANCE.getConfigData(BssCode.ROOM_ROLE_PERMISSION);
        return config != null && config.getData().isDisablePermission;
    }

    private boolean isAnchor(long uid) {
        if (null != this.mGroup && null != this.mGroup.getRoleService()) {
            return this.mGroup.getRoleService().isAnchor(uid);
        }
        return false;
    }

    public void setOwnerId(long ownerId) {
        this.mOwnerId = ownerId;
    }
}

