/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.service.role;

import android.content.Context;
import android.text.TextUtils;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.dialog.ConfirmDialog;
import com.yy.appbase.ui.dialog.OkDialog;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.TimeUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiyo.channel.ChannelNotifyDef;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.BaseRequestManager;
import com.yy.hiyo.channel.base.ChannelDefine;
import com.yy.hiyo.channel.base.IRoomService;
import com.yy.hiyo.channel.base.bean.ChannelDetailInfo;
import com.yy.hiyo.channel.base.bean.ChannelInfo;
import com.yy.hiyo.channel.base.bean.ChannelListData;
import com.yy.hiyo.channel.base.bean.ChannelNotify;
import com.yy.hiyo.channel.base.bean.ChannelUser;
import com.yy.hiyo.channel.base.bean.EnterChannelData;
import com.yy.hiyo.channel.base.bean.JoinApproveData;
import com.yy.hiyo.channel.base.bean.NotifyDataDefine;
import com.yy.hiyo.channel.base.bean.OnlineInfo;
import com.yy.hiyo.channel.base.bean.OnlineWithStatusInfo;
import com.yy.hiyo.channel.base.bean.SeatUser;
import com.yy.hiyo.channel.base.bean.ThemeItemBean;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.base.service.IDataService;
import com.yy.hiyo.channel.base.service.IGetJoinApplyStatusCallback;
import com.yy.hiyo.channel.base.service.IRoleService;
import com.yy.hiyo.channel.service.BaseService;
import com.yy.hiyo.channel.service.data.ILocalDataModel;
import com.yy.hiyo.channel.service.request.ChannelRequestManager;
import com.yy.hiyo.channel.service.request.role.RoleRequestManager;
import com.yy.hiyo.channel.service.role.ChannelRoleModel;
import com.yy.hiyo.channel.service.role.ui.FamilyApplyDialog;
import com.yy.hiyo.linkmic.base.bean.UserLinkMicInfo;
import com.yy.hiyo.proto.ProtoManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class RoleService
extends BaseService
implements IRoleService,
ChannelRoleModel.IGroupRoleModelCallBack {
    private static final String TAG = "RoleService";
    private ChannelRoleModel roleModel;
    private HashMap<Long, Long> bannedUids = new HashMap();
    private ChannelRequestManager requestManager;
    private IDataService.IDataUpdateListener baseDataListener;
    private UserLinkMicInfo mUserLinkMicInfo;

    public RoleService(final IChannel group, ILocalDataModel localGroupDataManager) {
        super(group, localGroupDataManager);
        this.roleModel = new ChannelRoleModel(this.getGroupId(), localGroupDataManager, this);
        this.requestManager = new ChannelRequestManager();
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (RoleService.this.baseDataListener == null) {
                    RoleService.this.baseDataListener = new IDataService.IDataUpdateListener(){

                        public void onTopAndSubGroupListChange(String channelId, ChannelListData data, List<Integer> totalNumList, List<Integer> limitNumList, ThemeItemBean themeItemBean) {
                            if (RoleService.this.roleModel != null) {
                                RoleService.this.roleModel.onTopAndSubGroupListChange(channelId, data);
                            }
                        }
                    };
                }
                group.getDataService().addDataListener(RoleService.this.baseDataListener);
            }
        });
    }

    public ChannelRoleModel getRoleModel() {
        return this.roleModel;
    }

    public void getChannelOnlineUserList(ProtoManager.Page page, final IRoleService.IGetOnlineUserListCallBack callBack) {
        this.requestManager.getChannelOnlineUserList(this.getGroupId(), page, new BaseRequestManager.IGetUserListWithTotalCallBack(){

            public void onSuccess(OnlineInfo data, ProtoManager.Page requestPage, ProtoManager.Page pageFromServer) {
                if (callBack != null) {
                    callBack.onSuccess(RoleService.this.getGroupId(), pageFromServer, data);
                }
            }

            public void onError(int errorCode, String errorTips, Exception e) {
                if (callBack != null) {
                    callBack.onError(RoleService.this.getGroupId(), errorCode, errorTips, e);
                }
                if (!ChannelDefine.sUnEnableLog && MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)"FTRoomGroupRoleService", (String)(RoleService.this.getGroupId() + ",getOnlineUserList errorCode:%d, errorTips:%s"), (Object[])new Object[]{errorCode, errorTips});
                }
            }
        });
    }

    public void getChannelOnlineWithStatusUserList(ProtoManager.Page page, final IRoleService.IGetOnlineUserWithStatusListCallBack callBack) {
        this.requestManager.getChannelOnlineUserWithStatusList(this.getGroupId(), page, new BaseRequestManager.IGetUserListWithWithStatusCallBack(){

            public void onSuccess(OnlineWithStatusInfo info, ProtoManager.Page requestPage, ProtoManager.Page pageFromServer) {
                if (callBack != null) {
                    callBack.onSuccess(RoleService.this.getGroupId(), pageFromServer, info);
                }
            }

            public void onError(int errorCode, String errorTips, Exception e) {
                if (callBack != null) {
                    callBack.onError(RoleService.this.getGroupId(), errorCode, errorTips, e);
                }
                if (!ChannelDefine.sUnEnableLog && MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)"FTRoomGroupRoleService", (String)(RoleService.this.getGroupId() + ",getChannelOnlineWithStatusUserList errorCode:%d, errorTips:%s"), (Object[])new Object[]{errorCode, errorTips});
                }
            }
        });
    }

    public void getOnlineUserList(ProtoManager.Page page, final IRoleService.IGetOnlineUserListCallBack callBack) {
        this.requestManager.getOnlineUserList(this.getGroupId(), page, new BaseRequestManager.IGetUserListWithTotalCallBack(){

            public void onSuccess(OnlineInfo data, ProtoManager.Page requestPage, ProtoManager.Page pageFromServer) {
                if (callBack != null) {
                    callBack.onSuccess(RoleService.this.getGroupId(), pageFromServer, data);
                }
            }

            public void onError(int errorCode, String errorTips, Exception e) {
                if (callBack != null) {
                    callBack.onError(RoleService.this.getGroupId(), errorCode, errorTips, e);
                }
                if (!ChannelDefine.sUnEnableLog && MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)"FTRoomGroupRoleService", (String)(RoleService.this.getGroupId() + ",getOnlineUserList errorCode:%d, errorTips:%s"), (Object[])new Object[]{errorCode, errorTips});
                }
            }
        });
    }

    public void getPotentialOnlineUserList(ProtoManager.Page page, final IRoleService.IGetOnlineUserListCallBack callBack) {
        this.requestManager.getPotentialOnlineUserList(this.getGroupId(), page, new BaseRequestManager.IGetUserListWithTotalCallBack(){

            public void onSuccess(OnlineInfo data, ProtoManager.Page requestPage, ProtoManager.Page pageFromServer) {
                if (callBack != null) {
                    callBack.onSuccess(RoleService.this.getGroupId(), pageFromServer, data);
                }
            }

            public void onError(int errorCode, String errorTips, Exception e) {
                if (callBack != null) {
                    callBack.onError(RoleService.this.getGroupId(), errorCode, errorTips, e);
                }
                if (!ChannelDefine.sUnEnableLog && MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)"FTRoomGroupRoleService", (String)(RoleService.this.getGroupId() + ",getPotentialOnlineUserList errorCode:%d, errorTips:%s"), (Object[])new Object[]{errorCode, errorTips});
                }
            }
        });
    }

    public void getMemberAndMasterList(int num, int offset, IRoleService.IGetUserListCallBack callBack) {
        this.getMemberAndMasterList(num, offset, callBack, true);
    }

    public void getMemberAndMasterList(final int num, final int offset, final IRoleService.IGetUserListCallBack callBack, boolean useCache) {
        IRoleService.IGetAllMemberListCallBack innerCallback = new IRoleService.IGetAllMemberListCallBack(){

            public void onSuccess(String channelId, ArrayList<ChannelUser> members) {
                if (members == null) {
                    members = new ArrayList(0);
                }
                if (!ChannelDefine.sUnEnableLog && MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)"FTRoomGroupRoleService", (String)(RoleService.this.getGroupId() + ",getMemberAndMaster success num:%d, offset:%d, list:%s, total:%d"), (Object[])new Object[]{num, offset, members != null ? members.toString() : "", members.size()});
                }
                if (offset >= members.size()) {
                    if (callBack != null) {
                        callBack.onSuccess(RoleService.this.channel, (long)members.size(), new ArrayList());
                    }
                } else if (num >= 0 && members.size() > 0) {
                    int toIndex;
                    int n = toIndex = num + offset >= members.size() ? members.size() : num + offset;
                    if (callBack != null) {
                        callBack.onSuccess(RoleService.this.channel, (long)members.size(), new ArrayList<Object>(members.subList(offset, toIndex)));
                    }
                } else if (callBack != null) {
                    callBack.onSuccess(RoleService.this.channel, (long)members.size(), new ArrayList());
                }
            }

            public void onError(String channelId, int errorCode, String errorTips, Exception e) {
                if (callBack != null) {
                    callBack.onError(RoleService.this.channel, errorCode, errorTips, e);
                }
                if (!ChannelDefine.sUnEnableLog && MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)"FTRoomGroupRoleService", (String)(RoleService.this.getGroupId() + ",getMemberAndMasterList errorCode:%d, errorTips:%s"), (Object[])new Object[]{errorCode, errorTips});
                }
            }
        };
        if (useCache) {
            this.roleModel.getAllMemberList(this.getGroupId(), innerCallback);
        } else {
            this.roleModel.getAllMemberListFromServer(this.getGroupId(), innerCallback);
        }
    }

    public void getRoleList(final int roleType, final int num, final int offset, final IRoleService.IGetUserListCallBack callBack) {
        this.roleModel.getRoleList(this.channel, this.getGroupId(), roleType, num, offset, new IRoleService.IGetUserListCallBack(){

            public void onSuccess(IChannel channel, long total, List<ChannelUser> members) {
                if (callBack != null) {
                    callBack.onSuccess(channel, total, members);
                }
                if (!ChannelDefine.sUnEnableLog && MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)"FTRoomGroupRoleService", (String)(RoleService.this.getGroupId() + ",getRoleList roleType:%d, num:%d, offset:%d, list:%s, total:%d"), (Object[])new Object[]{roleType, num, offset, members != null ? members.toString() : "", total});
                }
            }

            public void onError(IChannel channel, int errorCode, String errorTips, Exception e) {
                if (callBack != null) {
                    callBack.onError(channel, errorCode, errorTips, e);
                }
                if (!ChannelDefine.sUnEnableLog && MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)"FTRoomGroupRoleService", (String)(RoleService.this.getGroupId() + ",getRoleList errorCode:%d, errorTips:%s"), (Object[])new Object[]{errorCode, errorTips});
                }
            }
        });
    }

    public void isInChannel(final List<Long> uids, final IRoleService.IQueryUsersInThisChannelCallBack callBack) {
        RoleRequestManager.getCurrentChannels(true, false, uids, new IRoleService.IQueryUsersInChannelCallBack(){

            public void onSuccess(HashMap<Long, String> inChannelMap) {
                HashMap<Long, Boolean> inThisChannelMap = new HashMap<Long, Boolean>(uids.size());
                boolean in = false;
                for (Long uid : uids) {
                    in = StringUtils.equal((String)inChannelMap.get(uid), (String)RoleService.this.getGroupId());
                    inThisChannelMap.put(uid, in);
                }
                if (callBack != null) {
                    callBack.onSuccess(RoleService.this.getGroupId(), inThisChannelMap);
                }
            }

            public void onError(int errorCode, String errorTips, Exception e) {
                if (callBack != null) {
                    callBack.onError(RoleService.this.getGroupId(), errorCode, errorTips, e);
                }
            }
        });
    }

    public void updateMemberCacheFromServer(String channelId) {
        if (FP.empty((CharSequence)channelId)) {
            return;
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"updateMemberCacheFromServer cid:%s", (Object[])new Object[]{channelId});
        }
        this.roleModel.getAllMemberListFromServer(channelId, null);
    }

    public int getRole(long uid, IRoleService.IGetRoleCallBack callBack) {
        return this.roleModel.getRole(uid, this.getGroupId(), callBack);
    }

    public HashMap<Long, Integer> getRoles(List<Long> uids, final IRoleService.IGetRolesCallBack callBack) {
        if (uids == null || uids.size() <= 0) {
            if (YYTaskExecutor.isMainThread()) {
                if (callBack != null) {
                    callBack.onError(this.getGroupId(), -1, "", null);
                }
            } else {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callBack != null) {
                            callBack.onError(RoleService.this.getGroupId(), -1, "", null);
                        }
                    }
                });
            }
            return new HashMap<Long, Integer>();
        }
        return this.roleModel.getRoles(this.getGroupId(), uids, callBack);
    }

    public HashMap<Long, ChannelUser> getRoles(List<Long> uids, final IRoleService.IGetRoleUsersCallBack callBack) {
        if (uids == null || uids.size() <= 0) {
            if (YYTaskExecutor.isMainThread()) {
                if (callBack != null) {
                    callBack.onError(this.getGroupId(), -1, "", null);
                }
            } else {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callBack != null) {
                            callBack.onError(RoleService.this.getGroupId(), -1, "", null);
                        }
                    }
                });
            }
            return new HashMap<Long, ChannelUser>();
        }
        return this.roleModel.getUsers(this.getGroupId(), uids, callBack);
    }

    public void getMyRole(IRoleService.IGetRoleCallBack callBack) {
        this.roleModel.getRole(AccountUtil.getUid(), this.getGroupId(), callBack);
    }

    public int getMyRoleCache() {
        return this.roleModel.getRoleCache(AccountUtil.getUid());
    }

    public int getRoleCache(long uid) {
        return this.roleModel.getRoleCache(uid);
    }

    public void setRole(final HashMap<Long, Integer> uidAndRoles, String joinFrom, final IRoleService.ISetRolesCallBack callBack) {
        this.requestManager.setRole(this.getGroupId(), uidAndRoles, joinFrom, new IRoleService.ISetRolesCallBack(){

            public void onSuccess(String channelId, HashMap<Long, IRoleService.SetRoleRes> results) {
                if (results != null && results.size() > 0) {
                    Set<Long> keys = results.keySet();
                    for (Long key : keys) {
                        IRoleService.SetRoleRes item = results.get(key);
                        if (item == null || !item.success || item.waitForAccept) continue;
                        RoleService.this.roleModel.onRoleSeted(RoleService.this.getGroupId(), key, -1L, System.currentTimeMillis(), (Integer)uidAndRoles.get(key));
                    }
                }
                if (callBack != null) {
                    callBack.onSuccess(channelId, results);
                }
            }

            public void onHaveJoinedFamily(String channelId) {
                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.tips_already_in_other_famill_short);
                if (callBack != null) {
                    callBack.onHaveJoinedFamily(channelId);
                }
            }

            public void onFailByJoinedLvLimit(String applyCId) {
                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.family_lv_not_enough_short);
                if (callBack != null) {
                    callBack.onFailByJoinedLvLimit(applyCId);
                }
            }

            public void onError(String channelId, int errorCode, String errorTips, Exception e) {
                if (callBack != null) {
                    callBack.onError(channelId, errorCode, errorTips, e);
                }
            }
        });
    }

    public void applyJoin(String joinFrom, final IRoleService.IJoinApplyCallBack callback2) {
        this.requestManager.applyJoin(this.getGroupId(), joinFrom, new IRoleService.IJoinApplyCallBack(){

            public void onSuccess(String cId, String applyId, ChannelUser user) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)RoleService.TAG, (String)"applyJoin onSuccess cid:%s, applyId:%s, user:%s", (Object[])new Object[]{cId, applyId, user});
                }
                if (StringUtils.isEmpty((String)applyId) && user != null) {
                    RoleService.this.roleModel.onRoleSeted(cId, user.uid, -1L, user.time, user.roleType);
                }
                if (TextUtils.isEmpty((CharSequence)applyId) && user != null) {
                    ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.tips_channel_has_join);
                } else {
                    DialogLinkManager dialogLinkManager = new DialogLinkManager((Context)RoleService.this.channel.getContext());
                    OkDialog dialog2 = new OkDialog((CharSequence)ResourceUtils.getString((int)R.string.tips_channel_send_apply_join), true, null);
                    dialog2.setShowCancel(false);
                    dialogLinkManager.showDialog((BaseDialog)dialog2);
                }
                if (callback2 != null) {
                    callback2.onSuccess(cId, applyId, user);
                }
                RoleService.this.sendJoinChannelNotification(cId);
            }

            public void onFailByMemberReachLimit(String cId) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)RoleService.TAG, (String)"applyJoin onFailByMemberReachLimit cid:%s", (Object[])new Object[]{cId});
                }
                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.tips_channel_join_failed_by_counts_limit);
                if (callback2 != null) {
                    callback2.onFailByMemberReachLimit(cId);
                }
            }

            public void onFailByJoinedChannelLimit(String cId) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)RoleService.TAG, (String)"applyJoin onFailByJoinedChannelLimit cid:%s, errorCode:%d, tips:%s, e:%s", (Object[])new Object[]{cId});
                }
                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.tips_join_failed_channel_counts_limit);
                if (callback2 != null) {
                    callback2.onFailByJoinedChannelLimit(cId);
                }
            }

            public void onJoinBanForever(String cId) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)RoleService.TAG, (String)"applyJoin onJoinBanForever cid:%s", (Object[])new Object[]{cId});
                }
                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.tips_ban_join_channel);
                if (callback2 != null) {
                    callback2.onJoinBanForever(cId);
                }
            }

            public void onAlreadyJoined(String cId) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)RoleService.TAG, (String)"applyJoin onAlreadyJoined cid:%s", (Object[])new Object[]{cId});
                }
                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.tips_channel_has_join);
                if (callback2 != null) {
                    callback2.onAlreadyJoined(cId);
                }
            }

            public void onHaveJoinedFamily(String applyCId) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)RoleService.TAG, (String)"onHaveJoinedFamily applycid:%s", (Object[])new Object[]{applyCId});
                }
                RoleService.this.channel.getFamilyService().getJoinApplyStatus(new IGetJoinApplyStatusCallback(){

                    public void onJoinedChannel(@NotNull ChannelInfo cinfo) {
                        RoleService.this.showApplyFamilyDialog(cinfo);
                    }

                    public void nonJoinedChannel(@NotNull List<String> applyList) {
                    }

                    public void onFail(long errCode, @NotNull String msg) {
                        ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.tips_join_channel_failed);
                    }
                });
                if (callback2 != null) {
                    callback2.onHaveJoinedFamily(applyCId);
                }
            }

            public void onFailByJoinedLvLimit(String applyCId) {
                RoleService.this.channel.getDataService().getChannelBaseInfo(new IDataService.IGetGroupBaseInfoCallBack(){

                    public void onSuccess(String channelId, ChannelInfo info) {
                        ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)StringUtils.format((String)ResourceUtils.getString((int)R.string.family_lv_not_enough), (Object[])new Object[]{info.joinPayLevel, info.joinActiveTime}), (int)0);
                    }

                    public void onError(String channelId, int errorCode, String errorTips, Exception e) {
                        ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.tips_join_channel_failed);
                    }
                });
                if (callback2 != null) {
                    callback2.onFailByJoinedLvLimit(applyCId);
                }
            }

            public void onFailByJoinedFrozeLimit(String applyCId, int leftFrozeTime) {
                int hour;
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)RoleService.TAG, (String)"onFailByJoinedFrozeLimit applycid:%s, leftFrozeTime=%d", (Object[])new Object[]{applyCId, leftFrozeTime});
                }
                if ((hour = (int)TimeUtils.MINUTES.toCeilHours((long)leftFrozeTime)) <= 0) {
                    hour = 1;
                }
                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)ResourceUtils.getString((int)R.string.tips_join_family_froze, (Object[])new Object[]{hour}), (int)0);
                if (callback2 != null) {
                    callback2.onFailByJoinedFrozeLimit(applyCId, leftFrozeTime);
                }
            }

            public void onFailByInOwnerBlackList(String applyCId, String msgTips) {
                String msg;
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)RoleService.TAG, (String)"onFailByInOwnerBlackList applycid:%s", (Object[])new Object[]{applyCId});
                }
                if (TextUtils.isEmpty((CharSequence)(msg = msgTips))) {
                    msg = ResourceUtils.getString((int)R.string.tips_enter_channel_fail_by_black, (Object[])new Object[]{""});
                }
                DialogLinkManager dialogLinkManager = new DialogLinkManager((Context)RoleService.this.channel.getContext());
                ConfirmDialog dialog2 = ConfirmDialog.newBuilder().canceledOnClickOutside(true).withCloseBtn(true).confirmLabel((CharSequence)ResourceUtils.getString((int)R.string.tips_black_enter_ok)).message((CharSequence)msg).build();
                dialogLinkManager.showDialog((BaseDialog)dialog2);
                if (callback2 != null) {
                    callback2.onFailByInOwnerBlackList(applyCId, msgTips);
                }
            }

            public void onError(String cId, int errorCode, String errorTips, Exception e) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)RoleService.TAG, (String)"applyJoin onError cid:%s, errorCode:%d, tips:%s, e:%s", (Object[])new Object[]{cId, errorCode, errorTips, e});
                }
                if (!FP.empty((CharSequence)errorTips)) {
                    ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)errorTips, (int)0);
                } else {
                    ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.tips_join_channel_failed);
                }
                if (callback2 != null) {
                    callback2.onError(cId, errorCode, errorTips, e);
                }
            }
        });
    }

    private void sendJoinChannelNotification(String cId) {
        Notification notification = Notification.obtain((int)ChannelNotifyDef.JOIN_CHANNEL_SUCCESS);
        notification.extObj = cId;
        NotificationCenter.getGlobalInstance().notify(notification);
    }

    public void joinApprove(JoinApproveData data, final IRoleService.IJoinApproveCallBack callback2) {
        this.requestManager.joinApprove(this.getGroupId(), data, new IRoleService.IJoinApproveCallBack(){

            public void onSuccess(String cId, String applyId, ChannelUser user) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)RoleService.TAG, (String)"joinApprove onSuccess, cid:%s, applyId:%s, user:%s", (Object[])new Object[]{cId, applyId, user});
                }
                if (user != null) {
                    RoleService.this.roleModel.onRoleSeted(cId, user.uid, -1L, user.time, user.roleType);
                }
                if (callback2 != null) {
                    callback2.onSuccess(cId, applyId, user);
                }
            }

            public void onNoPermissionError(String cId, String applyId) {
                MLog.error((Object)RoleService.TAG, (String)"joinApprove onNoPermissionError cid:%s, id:%s", (Object[])new Object[]{cId, applyId});
                if (callback2 != null) {
                    callback2.onNoPermissionError(cId, applyId);
                }
            }

            public void onFailByMemberReachLimit(String cId, String applyId) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)RoleService.TAG, (String)"joinApprove onFailByMemberReachLimit cid:%s", (Object[])new Object[]{cId});
                }
                if (callback2 != null) {
                    callback2.onFailByMemberReachLimit(cId, applyId);
                }
            }

            public void onApplyAlreadyInvalidError(String cId, String applyId) {
                MLog.error((Object)RoleService.TAG, (String)"joinApprove onApplyAlreadyInvalidError, cid:%s, id:%s", (Object[])new Object[]{cId, applyId});
                if (callback2 != null) {
                    callback2.onApplyAlreadyInvalidError(cId, applyId);
                }
            }

            public void onFailByJoinedChannelLimit(String cId, String applyId) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)RoleService.TAG, (String)"joinApprove onFailByJoinedChannelLimit cid:%s, applyId:%s", (Object[])new Object[]{cId, applyId});
                }
                if (callback2 != null) {
                    callback2.onFailByJoinedChannelLimit(cId, applyId);
                }
            }

            public void onAlreadyJoined(String cId, String applyId) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)RoleService.TAG, (String)"joinApprove onAlreadyJoined cid:%s, applyId:%s", (Object[])new Object[]{cId, applyId});
                }
                if (callback2 != null) {
                    callback2.onAlreadyJoined(cId, applyId);
                }
            }

            public void onError(String cId, int errorCode, String errorTips, Exception e) {
                MLog.error((Object)RoleService.TAG, (String)"joinApprove onError cid:%s, code:%d, tips:%s, e:%s", (Object[])new Object[]{cId, errorCode, errorTips, e});
                if (callback2 != null) {
                    callback2.onError(cId, errorCode, errorTips, e);
                }
            }

            public void onChannelNoExit(String cid, long errorCode) {
                if (callback2 != null) {
                    callback2.onChannelNoExit(cid, errorCode);
                }
            }

            public void onChannelBanned(String cid, long code) {
                if (callback2 != null) {
                    callback2.onChannelBanned(cid, code);
                }
            }

            public void onChannelJoinBanForever(String cid, long code) {
                if (callback2 != null) {
                    callback2.onChannelJoinBanForever(cid, code);
                }
            }

            public void onNotInChannel(String cid, long code) {
                if (callback2 != null) {
                    callback2.onNotInChannel(cid, code);
                }
            }

            public void onOtherRejected(String cid, long code) {
                if (callback2 != null) {
                    callback2.onOtherRejected(cid, code);
                }
            }

            public void onNoArrow(String cid, long code) {
                if (callback2 != null) {
                    callback2.onNoArrow(cid, code);
                }
            }

            public void onFailAlreadHaveFamily(String cid, long code) {
                if (callback2 != null) {
                    callback2.onFailAlreadHaveFamily(cid, code);
                }
            }
        });
    }

    public void setRole(long uid, final int roleType, String joinFrom, final IRoleService.ISetRoleCallBack callBack) {
        this.requestManager.setRole(this.getGroupId(), uid, roleType, joinFrom, new IRoleService.ISetRoleCallBack(){

            public void onSuccess(String channelId, long uid, boolean waitForAccept) {
                if (!waitForAccept) {
                    RoleService.this.roleModel.onRoleSeted(RoleService.this.getGroupId(), uid, -1L, System.currentTimeMillis(), roleType);
                    if (!ChannelDefine.sUnEnableLog && MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)"FTRoomGroupRoleService", (String)(RoleService.this.getGroupId() + ",setRole roleType:%d, uid:%s, role:%s"), (Object[])new Object[]{roleType, String.valueOf(uid), String.valueOf(roleType)});
                    }
                }
                if (callBack != null) {
                    callBack.onSuccess(RoleService.this.getGroupId(), uid, waitForAccept);
                }
            }

            public void onNoPermissionError(String cId) {
                if (callBack != null) {
                    callBack.onNoPermissionError(cId);
                }
            }

            public void onFailByAlreadyIsThisRole(String cId) {
                if (callBack != null) {
                    callBack.onFailByAlreadyIsThisRole(cId);
                }
            }

            public void onFailByMemberReachLimit() {
                if (callBack != null) {
                    callBack.onFailByMemberReachLimit();
                }
            }

            public void onFailByJoinedChannelLimit() {
                if (callBack != null) {
                    callBack.onFailByJoinedChannelLimit();
                }
            }

            public void onHaveJoinedFamily(String channelId) {
                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.tips_already_in_other_famill_short);
                if (callBack != null) {
                    callBack.onHaveJoinedFamily(channelId);
                }
            }

            public void onFailByJoinedLvLimit(String applyCId) {
                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.family_lv_not_enough_short);
                if (callBack != null) {
                    callBack.onFailByJoinedLvLimit(applyCId);
                }
            }

            public void onError(String channelId, int errorCode, String errorTips, Exception e) {
                if (callBack != null) {
                    callBack.onError(channelId, errorCode, errorTips, e);
                }
                if (!ChannelDefine.sUnEnableLog && MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)"FTRoomGroupRoleService", (String)(RoleService.this.getGroupId() + ",setRole errorCode:%d, errorTips:%s"), (Object[])new Object[]{errorCode, errorTips});
                }
            }
        });
    }

    public void acceptRole(String inviteId, boolean accept, final IRoleService.IAcceptRoleInviteCallBack callBack) {
        this.requestManager.acceptRole(this.getGroupId(), inviteId, accept, new IRoleService.IAcceptRoleInviteCallBack(){

            public void onSuccess(String cId, ChannelUser user) {
                RoleService.this.roleModel.onRoleSeted(RoleService.this.getGroupId(), user.uid, -1L, user.time, user.roleType);
                if (callBack != null) {
                    callBack.onSuccess(cId, user);
                }
                if (RoleService.this.callBack != null) {
                    RoleService.this.callBack.getMyJoinedChannels().handleMyRoleChange(RoleService.this.getGroupId(), user.roleType);
                }
            }

            public void onInviteAlreadyInvalidError(String cId, String inviteId) {
                if (callBack != null) {
                    callBack.onInviteAlreadyInvalidError(cId, inviteId);
                }
            }

            public void onError(String cId, int errorCode, String errorTips, Exception e) {
                if (callBack != null) {
                    callBack.onError(cId, errorCode, errorTips, e);
                }
            }

            public void onFailByMemberReachLimit(String cid, String inviteId) {
                if (callBack != null) {
                    callBack.onFailByMemberReachLimit(cid, inviteId);
                }
            }

            public void onFailByJoinedChannelLimit(String cid, String inviteId) {
                if (callBack != null) {
                    callBack.onFailByJoinedChannelLimit(cid, inviteId);
                }
            }

            public void onAlreadyJoined(String cid, String inviteId) {
                if (callBack != null) {
                    callBack.onAlreadyJoined(cid, inviteId);
                }
            }

            public void onFailByJoinedFrozeLimit(String applyCId, int leftFrozeTime) {
                if (callBack != null) {
                    callBack.onFailByJoinedFrozeLimit(applyCId, leftFrozeTime);
                }
            }

            public void onChannelNoExit(String cid, long errorCode) {
                if (callBack != null) {
                    callBack.onChannelNoExit(cid, errorCode);
                }
            }

            public void onChannelBanned(String cid, long code) {
                if (callBack != null) {
                    callBack.onChannelBanned(cid, code);
                }
            }

            public void onChannelJoinBanForever(String cid, long code) {
                if (callBack != null) {
                    callBack.onChannelJoinBanForever(cid, code);
                }
            }

            public void onNotInChannel(String cid, long code) {
                if (callBack != null) {
                    callBack.onNotInChannel(cid, code);
                }
            }

            public void onOtherRejected(String cid, long code) {
                if (callBack != null) {
                    callBack.onOtherRejected(cid, code);
                }
            }

            public void onNoArrow(String cid, long code) {
                if (callBack != null) {
                    callBack.onNoArrow(cid, code);
                }
            }
        });
    }

    public boolean isBanned(final long uid, final IRoleService.IIsBannedCallBack callBack) {
        this.requestManager.getBanned(this.getGroupId(), uid, new BaseRequestManager.IIsBannedCallBack(){

            public void banned(String groupId, long uid2, long banTime, long banLeftTime) {
                if (callBack != null) {
                    RoleService.this.bannedUids.put(uid2, banTime);
                    callBack.banned(groupId, uid2, banLeftTime);
                }
                if (!ChannelDefine.sUnEnableLog && MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)"FTRoomGroupRoleService", (String)(RoleService.this.getGroupId() + ",banned:%d, uid:%s, banTime:%d"), (Object[])new Object[]{String.valueOf(uid2), banTime});
                }
            }

            public void onError(String gid, int errorCode, String errorTips, Exception e) {
                if (RoleService.this.bannedUids.containsKey(uid)) {
                    if (callBack != null) {
                        long banLeftTime = (Long)RoleService.this.bannedUids.get(uid) - System.currentTimeMillis() / 1000L;
                        callBack.banned(gid, uid, banLeftTime);
                    }
                } else if (callBack != null) {
                    callBack.banned(gid, uid, -1L);
                }
                if (!ChannelDefine.sUnEnableLog && MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)"FTRoomGroupRoleService", (String)(RoleService.this.getGroupId() + ",banned errorCode:%d, errorTips:%s"), (Object[])new Object[]{errorCode, errorTips});
                }
            }
        });
        return false;
    }

    public void banned(final long uid, final long banTime, final IRoleService.IBannedCallBack callBack) {
        this.requestManager.setBanned(this.getGroupId(), uid, banTime, new BaseRequestManager.IRequestCallBack(){

            public void onSuccess() {
                if (callBack != null) {
                    RoleService.this.bannedUids.put(uid, banTime);
                    callBack.onSuccess(RoleService.this.channel, uid, banTime);
                }
            }

            public void onFailUnauthorized() {
                if (callBack != null) {
                    callBack.onFailUnauthorized();
                }
            }

            public void onError(int errorCode, String errorTips, Exception e) {
                if (callBack != null) {
                    callBack.onError(RoleService.this.channel, errorCode, errorTips, e);
                }
            }
        });
    }

    @Override
    public void onNotify(ChannelNotify notify2) {
        NotifyDataDefine.AcceptRole acceptRole;
        if (notify2.uri == ChannelNotify.Uri.UriUserRoleChangeNotify) {
            NotifyDataDefine.UserRoleChange userRoleChange = notify2.notify.userRoleChange;
            if (userRoleChange != null) {
                this.roleModel.onRoleSeted(this.getGroupId(), userRoleChange.uid, userRoleChange.getSignalVer(), 1L, userRoleChange.roleType);
            }
        } else if (notify2.uri != ChannelNotify.Uri.UriSetRoleNotify && notify2.uri == ChannelNotify.Uri.UriAcceptRoleNotify && (acceptRole = notify2.notify.acceptRole) != null && acceptRole.accept) {
            this.roleModel.onRoleSeted(this.getGroupId(), acceptRole.uid, -1L, acceptRole.getTime(), acceptRole.roleType);
        }
    }

    @Override
    public void handleNotifyBanned(long operUid, boolean banned, long time) {
        this.bannedUids.put(AccountUtil.getUid(), time);
        this.roleModel.notifySpeakBanned(AccountUtil.getUid(), banned, time);
    }

    @Override
    public void onDoNotDisturbChanged(long uid, int mode) {
        this.roleModel.onDoNotDisturbChanged(uid, mode);
    }

    public void addDataListener(IRoleService.IMemberOrMasterChangeListener listener) {
        this.roleModel.addDataListener(this.channel.getChannelId(), listener);
    }

    public void removeDataListener(IRoleService.IMemberOrMasterChangeListener listener) {
        this.roleModel.removeDataListener(this.channel.getChannelId(), listener);
    }

    public boolean isLinkMicAudience(long uid) {
        if (null == this.mUserLinkMicInfo || null == this.mUserLinkMicInfo.getJoinUid()) {
            return false;
        }
        return uid == this.mUserLinkMicInfo.getJoinUid();
    }

    public void setLinkMicUserInfo(UserLinkMicInfo userLinkMicInfo) {
        this.mUserLinkMicInfo = userLinkMicInfo;
    }

    public UserLinkMicInfo getLinkMicUserInfo() {
        return this.mUserLinkMicInfo;
    }

    public boolean isAnchor(long uid) {
        if (null != this.channel.getDataService() && null != this.channel.getDataService().getCacheDetail()) {
            if (this.channel.getDataService().getCacheDetail().baseInfo.isLoopMicRoom()) {
                SeatUser data = this.channel.getSeatService().getSeatData().getSeatByIndex(1);
                return data != null && data.uid == uid;
            }
            ChannelDetailInfo detailInfo = this.channel.getDataService().getCacheDetail();
            if (detailInfo.baseInfo.isGroupParty() && detailInfo.baseInfo.showUid == uid) {
                return true;
            }
        }
        return false;
    }

    public long getAnchorUid() {
        if (null != this.channel.getDataService() && null != this.channel.getDataService().getCacheDetail()) {
            if (this.channel.getDataService().getCacheDetail().baseInfo.isLoopMicRoom()) {
                SeatUser data = this.channel.getSeatService().getSeatData().getSeatByIndex(1);
                if (data != null) {
                    return data.uid;
                }
                return 0L;
            }
            ChannelDetailInfo detailInfo = this.channel.getDataService().getCacheDetail();
            if (detailInfo.baseInfo.isGroupParty()) {
                return detailInfo.baseInfo.showUid;
            }
            if (ChannelDefine.isRadioMode((int)this.channel.getPluginService().getCurPluginData().mode)) {
                return detailInfo.baseInfo.ownerUid;
            }
        }
        return 0L;
    }

    @Override
    public void onWsConnect(boolean flag) {
        this.roleModel.onWsConnect(flag);
    }

    @Override
    public void onLeaved() {
        this.roleModel.onLeaveGroup();
        super.onLeaved();
    }

    @Override
    public boolean hasGroupJoined(String topGroupId) {
        String joinedGroup = this.callBack.getJoinedChannel();
        if (StringUtils.isEmpty((String)joinedGroup)) {
            return false;
        }
        return this.callBack.isInSameTopRoom(topGroupId, joinedGroup);
    }

    @Override
    public void onJoined(boolean rejoin2, ChannelDetailInfo info, EnterChannelData data) {
        super.onJoined(rejoin2, info, data);
        this.roleModel.onJoined(rejoin2, info, data);
    }

    @Override
    public IDataService getDataService() {
        return this.channel.getDataService();
    }

    private void showApplyFamilyDialog(ChannelInfo channelInfo) {
        DialogLinkManager dialogLinkManager = new DialogLinkManager((Context)this.channel.getContext());
        FamilyApplyDialog dialog2 = new FamilyApplyDialog(channelInfo, () -> ((IRoomService)ServiceManagerProxy.getServiceManager().getService(IRoomService.class)).enterRoom(0, channelInfo.getChannelId()));
        dialogLinkManager.showDialog((BaseDialog)dialog2);
    }
}

