/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.service.request.config;

import android.os.Build;
import android.os.SystemClock;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import biz.ClientHardware;
import biz.UserInfo;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.callback.ICommonCallback;
import com.yy.appbase.http.CommonHttpHeader;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.HardwareUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.VersionUtil;
import com.yy.base.utils.xml.CommonUtils;
import com.yy.hiyo.channel.base.BaseRequestManager;
import com.yy.hiyo.channel.base.IChannelCenterService;
import com.yy.hiyo.channel.base.bean.MyChannelControlConfig;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.ihago.abtest.srv.info.GetGroupInfoByUIDReq;
import net.ihago.abtest.srv.info.GetGroupInfoByUIDResp;
import net.ihago.abtest.srv.info.GroupInfo;
import net.ihago.channel.srv.mgr.GetConfigReq;
import net.ihago.channel.srv.mgr.GetConfigRes;
import net.ihago.channel.srv.mgr.GetCreateFamilyPermitReq;
import net.ihago.channel.srv.mgr.GetCreateFamilyPermitRes;

public class ConfigRequestManager
extends BaseRequestManager {
    private static final String TAG = "ChannelRequest_Config";

    public void getControlConfig(final IChannelCenterService.IGetControlConfigCallBack callBack) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"getControlConfig!", (Object[])new Object[0]);
        }
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                ClientHardware.CpuInfo cpuInfo = new ClientHardware.CpuInfo(HardwareUtils.getCpuRealName(), Integer.valueOf(HardwareUtils.getCpuCoreCount()), HardwareUtils.getCpuArch(), Long.valueOf(HardwareUtils.getMinCpuFreq()), Long.valueOf(HardwareUtils.getMaxCpuFreq()));
                int memory = CommonUtils.getTotalMemory();
                ClientHardware hardware = new ClientHardware(cpuInfo, Integer.valueOf(memory), Build.MODEL, Build.MANUFACTURER);
                GetConfigReq req = new GetConfigReq.Builder().hardware(hardware).ret_video_permit(Boolean.valueOf(true)).ret_diy_push(Boolean.valueOf(true)).build();
                final long startTime = SystemClock.uptimeMillis();
                ProtoManager.getInstance().sendRpc((AndroidMessage)req, (IProtoCallback)new IProtoCallback<GetConfigRes>(){

                    @Deprecated
                    @UiThread
                    public void onResponse(@Nullable GetConfigRes message) {
                        if (RuntimeContext.sIsDebuggable) {
                            throw new RuntimeException("ChannelRequest_Config error, use old result!");
                        }
                    }

                    @UiThread
                    public void onResponse(@NonNull GetConfigRes message, long code, String msg) {
                        if (ProtoManager.isSuccessCode((long)code)) {
                            List banTimeSelectsList;
                            List colorsList;
                            MyChannelControlConfig controlConfig = new MyChannelControlConfig();
                            controlConfig.channelMaxNum = message.max_channel;
                            controlConfig.guestMsgSendLimitInBasePlugin = message.guest_limit;
                            controlConfig.memberMsgSendLimitInBasePlugin = message.send_limit;
                            controlConfig.onlineLimit = message.online_limit;
                            controlConfig.canOpenVoiceChat = message.voice_chat;
                            controlConfig.canCreateChannel = message.gray_channel;
                            controlConfig.channelId = message.cid;
                            if (StringUtils.isEmpty((String)controlConfig.channelId)) {
                                controlConfig.channelId = message.roomid;
                            }
                            controlConfig.canSwitchVoiceRoomToBasePlugin = message.change_base;
                            controlConfig.guestMsgSendLimitInVoicePlugin = message.voice_guest_limit;
                            controlConfig.memberMsgSendLimitInVoicePlugin = message.voice_send_limit;
                            controlConfig.canSwitchBasePluginToVoiceRoom = message.change_voice_room;
                            controlConfig.showAlbumInVoicePlugin = message.show_album;
                            controlConfig.showCameraInVoicePlugin = message.show_camera;
                            controlConfig.showRecordInVoicePlugin = message.show_video;
                            controlConfig.resultConditionMin = message.result_condition_min;
                            controlConfig.showBasicGradeMedal = message.show_basic_grade_medal;
                            controlConfig.showBasicActivityMedal = message.show_basic_activity_medal;
                            controlConfig.canGuestBasicInput = message.can_guest_input;
                            controlConfig.canGuestSendGif = message.forbid_base_guest_gif == false;
                            controlConfig.canGuestSendBigFace = message.forbid_base_guest_emoji == false;
                            controlConfig.canGuestSendPhoto = message.forbid_base_guest_image == false;
                            controlConfig.canGuestSendPK = message.forbid_base_guest_pkgame == false;
                            controlConfig.canGuestJoinVoiceChat = message.forbid_base_guest_join_voice == false;
                            controlConfig.canUnseatGuestShowBigFace = message.forbid_voice_guest_emoji == false;
                            controlConfig.upgrade = message.upgrade;
                            controlConfig.maxChannelInput = message.base_msg_max_length;
                            controlConfig.maxRoomInput = message.chat_msg_max_length;
                            controlConfig.canCreateMultiVideoRoom = message.create_multi_video;
                            controlConfig.lowEndDevice = message.video_low_end;
                            controlConfig.canUseShowVideo = message.video_permit;
                            controlConfig.canUseGroupBg = message.is_bgi_setting;
                            controlConfig.enableDiyPush = message.can_diy_push;
                            Map items = message.role_limit;
                            if (items != null && items.size() > 0) {
                                controlConfig.roleLimit = new HashMap(items);
                            }
                            if ((colorsList = message.room_bg_colors) != null && colorsList.size() > 0) {
                                controlConfig.bgcolors.addAll(colorsList);
                            }
                            if ((banTimeSelectsList = message.ban_time_selects) != null && banTimeSelectsList.size() > 0) {
                                controlConfig.banTimeSelects = new ArrayList();
                                controlConfig.banTimeSelects.addAll(banTimeSelectsList);
                            }
                            if (callBack != null) {
                                callBack.onSuccess(controlConfig);
                            }
                            if (MLog.isLogLevelBlowInfo()) {
                                MLog.info((Object)ConfigRequestManager.TAG, (String)"getControlConfig success:%s!", (Object[])new Object[]{controlConfig.toString()});
                            }
                            BaseRequestManager.statMetric((String)"channel/config", (long)(SystemClock.uptimeMillis() - startTime), (boolean)true, (long)code);
                        } else {
                            if (callBack != null) {
                                callBack.onError(100, "", new Exception("code:" + code + " msg:" + (msg != null ? msg : "")));
                            }
                            MLog.error((Object)ConfigRequestManager.TAG, (String)"getControlConfig error code:%d,errortips:%s", (Object[])new Object[]{code, message.result != null ? message.result.errmsg : ""});
                            BaseRequestManager.statMetric((String)"channel/config", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)code);
                        }
                    }

                    public boolean retryWhenTimeout(boolean canRetry) {
                        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                if (callBack != null) {
                                    callBack.onError(100, "", new Exception("Time out!"));
                                }
                                MLog.error((Object)ConfigRequestManager.TAG, (String)"getControlConfig error Timeout!", (Object[])new Object[0]);
                                BaseRequestManager.statMetric((String)"channel/config", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)99L);
                            }
                        });
                        return false;
                    }

                    public boolean retryWhenError(boolean canRetry, final String reason, final int code) {
                        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                if (callBack != null) {
                                    callBack.onError(100, "", new Exception((reason != null ? reason : "") + " code:" + code));
                                }
                                MLog.error((Object)ConfigRequestManager.TAG, (String)"getControlConfig netError code:%d, reason:%s!", (Object[])new Object[]{code, reason});
                                BaseRequestManager.statMetric((String)"channel/config", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)code);
                            }
                        });
                        return false;
                    }
                });
            }
        });
    }

    public void getFamilyPermit(final @Nullable ICommonCallback<Boolean> callback2) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"getFamilyPermit", (Object[])new Object[0]);
        }
        GetCreateFamilyPermitReq getFamilyConfigReq = new GetCreateFamilyPermitReq();
        ProtoManager.getInstance().sendRpc((AndroidMessage)getFamilyConfigReq, (IProtoCallback)new IProtoCallback<GetCreateFamilyPermitRes>(){

            public void onResponse(@NonNull GetCreateFamilyPermitRes message, long code, String msg) {
                super.onResponse((AndroidMessage)message, code, msg);
                if (callback2 == null) {
                    return;
                }
                YYTaskExecutor.postToMainThread(() -> {
                    if (ProtoManager.isSuccessCode((long)code)) {
                        callback2.onSuccess((Object)true, new Object[0]);
                    } else {
                        callback2.onSuccess((Object)false, new Object[0]);
                    }
                });
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                YYTaskExecutor.postToMainThread(() -> {
                    if (callback2 != null) {
                        callback2.onFail(100, "getFamilyPermit timeout", new Object[0]);
                    }
                    MLog.error((Object)ConfigRequestManager.TAG, (String)"getFamilyPermit timeout", (Object[])new Object[0]);
                });
                return false;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                YYTaskExecutor.postToMainThread(() -> {
                    if (callback2 != null) {
                        callback2.onFail(100, "getFamilyPermit error", new Object[0]);
                    }
                });
                MLog.error((Object)ConfigRequestManager.TAG, (String)"getFamilyPermit error. code:%d reason:%s", (Object[])new Object[]{code, reason});
                return false;
            }
        });
    }

    public void getChannelAB(String channelId, String key, long ownerId, final IChannelCenterService.IGetChannelABCallback callback2) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"getChannelAB cid=%s, key=%s, ownerId=%s", (Object[])new Object[]{channelId, key, ownerId});
        }
        UserInfo user = new UserInfo.Builder().uid(Long.valueOf(ownerId)).device(channelId).os_type(CommonHttpHeader.getOsType()).app_ver(String.valueOf(VersionUtil.getAppVersion())).build();
        GetGroupInfoByUIDReq req = new GetGroupInfoByUIDReq.Builder().appid(RuntimeContext.sAppid).layerid(key).user(user).build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)req, (IProtoCallback)new IProtoCallback<GetGroupInfoByUIDResp>(){

            public void onResponse(@NonNull GetGroupInfoByUIDResp message, long code, String msg) {
                super.onResponse((AndroidMessage)message, code, msg);
                if (ProtoManager.isSuccessCode((long)code)) {
                    GroupInfo groupInfo = message.groupinfo;
                    if (null != groupInfo) {
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)ConfigRequestManager.TAG, (String)"getChannelAB layerid=%s, testid=%s, groupid=%s", (Object[])new Object[]{groupInfo.layerid, groupInfo.testid, groupInfo.groupid});
                        }
                        if (null != callback2) {
                            callback2.onSuccess(groupInfo.layerid, groupInfo.testid, groupInfo.groupid);
                        }
                    } else {
                        MLog.error((Object)ConfigRequestManager.TAG, (String)"getChannelAB error grounInfo=null", (Object[])new Object[0]);
                        if (null != callback2) {
                            callback2.onFail(code, msg);
                        }
                    }
                } else {
                    MLog.error((Object)ConfigRequestManager.TAG, (String)"getChannelAB fail, code:%s, msg:%s", (Object[])new Object[]{code, msg});
                    if (null != callback2) {
                        callback2.onFail(code, msg);
                    }
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                MLog.error((Object)ConfigRequestManager.TAG, (String)"getChannelAB timeout", (Object[])new Object[0]);
                YYTaskExecutor.postToMainThread(() -> {
                    if (null != callback2) {
                        callback2.onFail(-1L, "");
                    }
                });
                return false;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                MLog.error((Object)ConfigRequestManager.TAG, (String)"getChannelAB error, code:%s, msg:%s", (Object[])new Object[]{code, reason});
                YYTaskExecutor.postToMainThread(() -> {
                    if (null != callback2) {
                        callback2.onFail((long)code, reason);
                    }
                });
                return false;
            }
        });
    }
}

