/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.service.plugin;

import com.yy.hiyo.channel.base.bean.ChannelDetailInfo;
import com.yy.hiyo.channel.base.bean.ChannelInfo;
import com.yy.hiyo.channel.base.bean.NotifyDataDefine;
import com.yy.hiyo.channel.base.bean.plugins.ChannelPluginData;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.cbase.model.bean.LockInfo;
import com.yy.hiyo.channel.cbase.model.bean.RoomData;
import com.yy.hiyo.channel.cbase.model.bean.RoomInfo;
import com.yy.hiyo.channel.service.plugin.IPluginDataFilter;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u0013"}, d2={"Lcom/yy/hiyo/channel/service/plugin/AbsRoomFilter;", "Lcom/yy/hiyo/channel/service/plugin/IPluginDataFilter;", "channel", "Lcom/yy/hiyo/channel/base/service/IChannel;", "(Lcom/yy/hiyo/channel/base/service/IChannel;)V", "getChannel", "()Lcom/yy/hiyo/channel/base/service/IChannel;", "roomData", "Lcom/yy/hiyo/channel/cbase/model/bean/RoomData;", "getRoomData", "()Lcom/yy/hiyo/channel/cbase/model/bean/RoomData;", "setRoomData", "(Lcom/yy/hiyo/channel/cbase/model/bean/RoomData;)V", "clear", "", "initData", "data", "Lcom/yy/hiyo/channel/base/bean/plugins/ChannelPluginData;", "process", "channel-components_release"})
public abstract class AbsRoomFilter
implements IPluginDataFilter {
    @Nullable
    private RoomData roomData;
    @NotNull
    private final IChannel channel;

    @Nullable
    public final RoomData getRoomData() {
        return this.roomData;
    }

    public final void setRoomData(@Nullable RoomData roomData) {
        this.roomData = roomData;
    }

    @NotNull
    public final RoomData initData(@NotNull ChannelPluginData data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        ChannelDetailInfo detail = this.channel.getDataService().getChannelDetailInfo(null);
        RoomInfo roomInfo = new RoomInfo();
        roomInfo.setId(this.channel.getChannelId());
        roomInfo.setOwner(detail.baseInfo.ownerUid);
        roomInfo.setName(detail.baseInfo.name);
        roomInfo.setVid(detail.baseInfo.cvid);
        roomInfo.setRoomShowType(detail.baseInfo.roomShowType);
        roomInfo.setShowUid(detail.baseInfo.showUid);
        roomInfo.setTags((List)detail.baseInfo.tag.getTags());
        LockInfo lockInfo = new LockInfo();
        ChannelInfo channelInfo = detail.baseInfo;
        Intrinsics.checkExpressionValueIsNotNull((Object)channelInfo, (String)"detail.baseInfo");
        lockInfo.setLocked(channelInfo.isLock());
        lockInfo.setPassword(detail.baseInfo.password);
        lockInfo.setPwdToken("");
        RoomData roomData = RoomData.newBuilder().topGroupId(this.channel.getChannelId()).roomInfo(roomInfo).enterParam(this.channel.getEnterParam()).lockInfo(lockInfo).roomGameInfo(new ChannelPluginData(data.mode, data.getId())).mediaData(this.channel.getMediaService().getMediaData()).seatData(this.channel.getSeatService().getSeatData()).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)roomData, (String)"RoomData.newBuilder()\n  \u2026a())\n            .build()");
        return roomData;
    }

    @Override
    @NotNull
    public ChannelPluginData process(@NotNull ChannelPluginData data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        if (this.roomData == null) {
            this.roomData = this.initData(data);
            data.putExt("voiceroom", (Object)this.roomData);
        } else {
            data.putExt("voiceroom", (Object)this.roomData);
        }
        RoomData roomData = this.roomData;
        if (roomData == null) {
            Intrinsics.throwNpe();
        }
        roomData.getGameInfo().update(data);
        RoomData roomData2 = this.roomData;
        if (roomData2 == null) {
            Intrinsics.throwNpe();
        }
        ChannelPluginData channelPluginData = roomData2.getGameInfo();
        Intrinsics.checkExpressionValueIsNotNull((Object)channelPluginData, (String)"roomData!!.gameInfo");
        return channelPluginData;
    }

    @Override
    public void clear() {
        this.roomData = null;
    }

    @NotNull
    public final IChannel getChannel() {
        return this.channel;
    }

    public AbsRoomFilter(@NotNull IChannel channel) {
        Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
        this.channel = channel;
    }

    @Override
    public boolean isStartNotifyValid(@NotNull NotifyDataDefine.PluginStatusStartNotify start) {
        Intrinsics.checkParameterIsNotNull((Object)start, (String)"start");
        return IPluginDataFilter.DefaultImpls.isStartNotifyValid(this, start);
    }
}

