/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.service.myjoin;

import androidx.annotation.Nullable;
import biz.IMMsgItem;
import com.yy.appbase.R;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.constant.WindowNameDef;
import com.yy.appbase.data.NotifySourceBean;
import com.yy.appbase.service.ICIMService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.IFrequencyLimitExecutor;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.filestorage.FileStorageUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.hiyo.channel.base.ChannelDefine;
import com.yy.hiyo.channel.base.IChannelCenterService;
import com.yy.hiyo.channel.base.bean.ChannelNotify;
import com.yy.hiyo.channel.base.bean.ChannelPushContent;
import com.yy.hiyo.channel.base.bean.LastMsgAndUnreadData;
import com.yy.hiyo.channel.base.bean.MsgSection;
import com.yy.hiyo.channel.base.bean.MyJoinChannelItem;
import com.yy.hiyo.channel.base.bean.NotifyDataDefine;
import com.yy.hiyo.channel.base.bean.unreadmsg.IChannelUnreadMsgNotifyCallbak;
import com.yy.hiyo.channel.base.bean.unreadmsg.IChannelUnreadMsgPuller;
import com.yy.hiyo.channel.base.bean.unreadmsg.IUnreadMsgRequestCallBack;
import com.yy.hiyo.channel.base.callback.IMyJoinChannelHandler;
import com.yy.hiyo.channel.cbase.publicscreen.IPublicScreenService;
import com.yy.hiyo.channel.module.main.ChannelWindow;
import com.yy.hiyo.channel.module.myjoined.ui.JoinedChannelsWindow;
import com.yy.hiyo.channel.publicscreen.BaseImMsg;
import com.yy.hiyo.channel.service.myjoin.MyJoinedChannelData;
import com.yy.hiyo.channel.service.notify.IChannelNotifyHandler;
import com.yy.hiyo.channel.service.request.ChannelRequestManager;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.service.IGameInfoService;
import com.yy.hiyo.im.ImService;
import com.yy.hiyo.proto.ProtoManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class MyJoinedChannelModel
implements IChannelNotifyHandler,
IMyJoinChannelHandler,
IChannelUnreadMsgNotifyCallbak {
    private static final String FILE_NAME = "MyJoinedChannels_";
    private static final String TAG = "MyJoinedChannelModel";
    private IGameInfoService gameInfoService;
    private ChannelRequestManager requestManager;
    private MyJoinedChannelData myJoinedGroups;
    private String dataStr;
    private boolean hasSynced;
    private boolean hasLoadFromFile;
    private boolean startRefresh = false;
    private boolean curWinNeedRefresh = true;
    private DefaultWindow.IGlobalWindowMonitor mWindowMonitor;
    private boolean refreshSwitchOn = false;
    private List<MyJoinChannelItem> lastSources;
    private IChannelUnreadMsgPuller mChannelUnreadMsgPuller;
    private IChannelCenterService.IControlConfigOrJoinedChannelsListener callback;
    private long uid;
    private IFrequencyLimitExecutor saveFileLimitExecutor;
    private boolean notifyListChanging = false;

    public MyJoinedChannelModel(ChannelRequestManager requestManager, long uid, IChannelCenterService.IControlConfigOrJoinedChannelsListener callback2) {
        this.callback = callback2;
        this.uid = uid;
        this.requestManager = requestManager;
        this.refreshSwitchOn = SettingFlags.getBoolean((String)"cunreadrefresh", (boolean)true);
    }

    public void updateUid(long uid) {
        if (this.uid == uid) {
            return;
        }
        this.uid = uid;
        this.myJoinedGroups = new MyJoinedChannelData();
        this.dataStr = "";
        this.hasSynced = false;
        this.hasLoadFromFile = false;
        if (this.startRefresh) {
            this.startRefreshUnreadNum(-1, 0L);
        }
    }

    public ArrayList<MyJoinChannelItem> getMyJoinedGroups(final IChannelCenterService.IGetMyJoinedChannelsCallBack callBack, final boolean foreFromServer) {
        return this.getMyJoinedGroupsInner(new IChannelCenterService.IGetMyJoinedChannelsCallBack(){

            public void onSuccess(ArrayList<MyJoinChannelItem> groupSummays) {
                if (groupSummays == null || groupSummays.size() <= 0) {
                    if (callBack != null) {
                        callBack.onSuccess(groupSummays);
                    }
                    return;
                }
                if (callBack != null) {
                    callBack.onSuccess(groupSummays);
                }
                if (foreFromServer || !MyJoinedChannelModel.this.hasSynced) {
                    MyJoinedChannelModel.this.doChangeChatInfo(null, MyJoinedChannelModel.this.getUnreadMsgRequestCallBack());
                }
            }

            public void onError(int errorCode, Exception e) {
                if (callBack != null) {
                    callBack.onError(errorCode, e);
                }
            }
        }, foreFromServer);
    }

    private ArrayList<MyJoinChannelItem> getMyJoinedGroupsInner(IChannelCenterService.IGetMyJoinedChannelsCallBack callBack, boolean forceUpdateFromServer) {
        if (this.hasSynced && (!forceUpdateFromServer || this.notifyListChanging)) {
            if (callBack != null) {
                callBack.onSuccess(this.myJoinedGroups == null ? new ArrayList(0) : new ArrayList<MyJoinChannelItem>(this.myJoinedGroups.groups));
            }
            return this.myJoinedGroups != null ? this.myJoinedGroups.groups : new ArrayList<MyJoinChannelItem>();
        }
        YYTaskExecutor.execute(() -> {
            if (!this.hasLoadFromFile) {
                String fileData2 = FileStorageUtils.getInstance().getStrFromFile(true, FILE_NAME + this.uid);
                if (StringUtils.isNotEmpty((String)fileData2)) {
                    this.dataStr = fileData2;
                    this.myJoinedGroups = (MyJoinedChannelData)JsonParser.parseJsonObject((String)fileData2, MyJoinedChannelData.class);
                    if (!ChannelDefine.sUnEnableLog && MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)"FTRoomGroupMyJoin", (String)"myJoinedGroups fromFile:%s", (Object[])new Object[]{this.myJoinedGroups});
                    }
                }
                this.hasLoadFromFile = true;
                if (this.myJoinedGroups != null) {
                    YYTaskExecutor.postToMainThread(() -> callBack.onSuccess(this.myJoinedGroups.groups));
                    this.getControlConfigFromServer(null);
                    return;
                }
            } else if (!forceUpdateFromServer && this.myJoinedGroups != null) {
                YYTaskExecutor.postToMainThread(() -> callBack.onSuccess(this.myJoinedGroups.groups));
                this.getControlConfigFromServer(null);
                return;
            }
            this.getControlConfigFromServer(callBack);
        });
        return this.myJoinedGroups != null ? this.myJoinedGroups.groups : new ArrayList<MyJoinChannelItem>();
    }

    @Nullable
    private GameInfo getGameInfo(String gid) {
        if (this.gameInfoService == null) {
            this.gameInfoService = (IGameInfoService)ServiceManagerProxy.getService(IGameInfoService.class);
        }
        if (this.gameInfoService != null) {
            return this.gameInfoService.getGameInfoByGid(gid);
        }
        return null;
    }

    private void getControlConfigFromServer(final IChannelCenterService.IGetMyJoinedChannelsCallBack callBack) {
        this.requestManager.getMyJoinedGroups(new IChannelCenterService.IGetMyJoinedChannelsCallBack(){

            public void onSuccess(ArrayList<MyJoinChannelItem> groupSummays) {
                MyJoinedChannelModel.this.hasSynced = true;
                MyJoinedChannelData data = new MyJoinedChannelData();
                data.groups = groupSummays;
                if (groupSummays != null && MyJoinedChannelModel.this.myJoinedGroups != null && ((MyJoinedChannelModel)MyJoinedChannelModel.this).myJoinedGroups.groups != null) {
                    for (MyJoinChannelItem item : groupSummays) {
                        GameInfo gameInfo;
                        for (MyJoinChannelItem itemFind : ((MyJoinedChannelModel)MyJoinedChannelModel.this).myJoinedGroups.groups) {
                            if (null == item || null == itemFind || !StringUtils.equal((String)item.cid, (String)itemFind.cid)) continue;
                            item.unreadMsgNum = itemFind.mPluginData == null || itemFind.mPluginData.mode != 1 ? 0L : itemFind.unreadMsgNum;
                            item.lastReadMsgTime = itemFind.lastReadMsgTime;
                            item.lastestUnReadMsgTs = itemFind.lastestUnReadMsgTs;
                            item.setLastMsgTips(itemFind.getLastMsgTips(), true);
                        }
                        if (item == null || !item.source.equals("hago.game") || (gameInfo = MyJoinedChannelModel.this.getGameInfo(item.indieGameId)) == null) continue;
                        item.indieGameName = gameInfo.getGname();
                    }
                }
                MyJoinedChannelModel.this.myJoinedGroups = data;
                MyJoinedChannelModel.this.refreshUnreadNum();
                if (!ChannelDefine.sUnEnableLog && MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)"FTRoomGroupMyJoin", (String)"myJoinedGroups fromServer:%s", (Object[])new Object[]{MyJoinedChannelModel.this.myJoinedGroups});
                }
                if (callBack != null) {
                    callBack.onSuccess(data.groups);
                }
                YYTaskExecutor.execute(() -> {
                    String newData = JsonParser.toJson((Object)data);
                    if (!StringUtils.equal((String)MyJoinedChannelModel.this.dataStr, (String)newData)) {
                        YYTaskExecutor.postToMainThread(() -> MyJoinedChannelModel.this.notifyListChanged());
                        MyJoinedChannelModel.this.dataStr = newData;
                        FileStorageUtils.getInstance().saveToFile(true, newData, MyJoinedChannelModel.FILE_NAME + MyJoinedChannelModel.this.uid);
                    } else if (!ChannelDefine.sUnEnableLog && MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)"FTRoomGroupMyJoin", (String)"myJoinedGroups fromServer no change!", (Object[])new Object[0]);
                    }
                });
            }

            public void onError(int errorCode, Exception e) {
                if (MyJoinedChannelModel.this.myJoinedGroups != null && ((MyJoinedChannelModel)MyJoinedChannelModel.this).myJoinedGroups.groups != null && ((MyJoinedChannelModel)MyJoinedChannelModel.this).myJoinedGroups.groups.size() > 0) {
                    if (callBack != null) {
                        callBack.onSuccess(((MyJoinedChannelModel)MyJoinedChannelModel.this).myJoinedGroups.groups);
                    }
                } else if (callBack != null) {
                    callBack.onError(errorCode, e);
                }
                if (!ChannelDefine.sUnEnableLog) {
                    MLog.error((Object)"FTRoomGroupMyJoin", (String)"myJoinedGroups error:%s", (Throwable)e, (Object[])new Object[0]);
                }
            }
        });
    }

    private void notifyListChanged() {
        this.notifyListChanging = true;
        if (this.callback != null) {
            this.callback.onMyJoinedChannelsListChange();
        }
        if (this.startRefresh && this.myJoinedGroups != null) {
            this.addSource(this.myJoinedGroups.groups);
        }
        this.notifyListChanging = false;
    }

    @Override
    public void handleNotifySetName(final String channelId, final NotifyDataDefine.SetName data) {
        this.getMyJoinedGroups(new IChannelCenterService.IGetMyJoinedChannelsCallBack(){

            public void onSuccess(ArrayList<MyJoinChannelItem> groupSummays) {
                if (MyJoinedChannelModel.this.myJoinedGroups != null && ((MyJoinedChannelModel)MyJoinedChannelModel.this).myJoinedGroups.groups != null && ((MyJoinedChannelModel)MyJoinedChannelModel.this).myJoinedGroups.groups.size() > 0) {
                    MyJoinChannelItem itemFind = null;
                    for (MyJoinChannelItem summary : ((MyJoinedChannelModel)MyJoinedChannelModel.this).myJoinedGroups.groups) {
                        if (null == summary || !StringUtils.equal((String)summary.cid, (String)channelId)) continue;
                        itemFind = summary;
                        break;
                    }
                    if (!ChannelDefine.sUnEnableLog && MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)"FTRoomGroupMyJoin", (String)"handleNotifySetName find:%s, role:%s", (Object[])new Object[]{itemFind != null ? itemFind.toString() : "", data});
                    }
                    if (itemFind != null && !StringUtils.equal((String)itemFind.name, (String)data.name)) {
                        itemFind.name = data.name;
                        MyJoinedChannelModel.this.saveToFile();
                        MyJoinedChannelModel.this.notifyListChanged();
                    }
                }
            }

            public void onError(int errorCode, Exception e) {
            }
        }, false);
    }

    @Override
    public void handleNotifyDisbandChannel(String channelId, NotifyDataDefine.DisbandGroup data) {
        if (this.myJoinedGroups != null && this.myJoinedGroups.groups != null && this.myJoinedGroups.groups.size() > 0) {
            ArrayList<MyJoinChannelItem> items = this.myJoinedGroups.groups;
            boolean changed = false;
            for (MyJoinChannelItem item : items) {
                if (null == item || !StringUtils.equal((String)item.cid, (String)channelId)) continue;
                items.remove(item);
                changed = true;
                break;
            }
            if (changed) {
                this.saveToFile();
                this.notifyListChanged();
            }
        }
    }

    public void onChannelAdd(String channel) {
        if (StringUtils.isNotEmpty((String)channel)) {
            this.hasSynced = false;
            this.getMyJoinedGroups(new IChannelCenterService.IGetMyJoinedChannelsCallBack(){

                public void onSuccess(ArrayList<MyJoinChannelItem> groupSummays) {
                }

                public void onError(int errorCode, Exception e) {
                }
            }, true);
        }
    }

    public void onMsgDoNotDisturbSwitchChanged(String channel, int mode) {
        if (this.myJoinedGroups != null && this.myJoinedGroups.groups != null && this.myJoinedGroups.groups.size() > 0) {
            ArrayList<MyJoinChannelItem> items = this.myJoinedGroups.groups;
            MyJoinChannelItem itemFind = null;
            for (MyJoinChannelItem item : items) {
                if (null == item || !StringUtils.equal((String)item.cid, (String)channel)) continue;
                itemFind = item;
                break;
            }
            if (itemFind != null && itemFind.myRoleData != null && itemFind.myRoleData.msgReceiveMode != mode) {
                itemFind.myRoleData.msgReceiveMode = mode;
                this.saveToFile();
                if (this.callback != null) {
                    this.callback.onChannelMsgReceiveModeChange(channel, mode);
                }
            }
        }
    }

    public void updateChannelMsgData(String channel, long unreadNum, long lastReadTime, BaseImMsg lastMsg) {
        if (this.myJoinedGroups != null && this.myJoinedGroups.groups != null && this.myJoinedGroups.groups.size() > 0) {
            ArrayList<MyJoinChannelItem> items = this.myJoinedGroups.groups;
            MyJoinChannelItem itemFind = null;
            for (MyJoinChannelItem item : items) {
                if (null == item || !StringUtils.equal((String)item.cid, (String)channel)) continue;
                itemFind = item;
                break;
            }
            if (itemFind == null || itemFind.mPluginData == null || itemFind.mPluginData.mode != 1) {
                if (RuntimeContext.isInGray() && MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)"not update by not baseMode, unread cid:%s,unreadNum:%d,time:%s", (Object[])new Object[]{itemFind != null ? itemFind.cid : "", unreadNum, String.valueOf(lastReadTime)});
                }
                return;
            }
            if (itemFind != null && (itemFind.unreadMsgNum != unreadNum || itemFind.lastReadMsgTime != lastReadTime)) {
                itemFind.unreadMsgNum = unreadNum;
                itemFind.lastReadMsgTime = lastReadTime;
                boolean hasMsg = lastMsg != null;
                itemFind.setLastMsgTips(hasMsg ? lastMsg.getSessionTips() : null, hasMsg);
                this.saveToFile();
                LastMsgAndUnreadData data = new LastMsgAndUnreadData();
                data.unreadMsgNum = unreadNum;
                data.lastestUnReadMsgTs = itemFind.lastestUnReadMsgTs;
                data.lastMsg = lastMsg;
                if (RuntimeContext.isInGray() && MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)"update unread cid:%s,unreadNum:%d,time:%s", (Object[])new Object[]{itemFind.cid, unreadNum, String.valueOf(lastReadTime)});
                }
                if (this.callback != null) {
                    this.callback.onMyJoinedChannelsUnreadNumChange(channel, data);
                }
            }
        }
    }

    private String toLastMsgTip(BaseImMsg lastMsg) {
        if (lastMsg == null || FP.empty((Collection)lastMsg.getSections())) {
            return "";
        }
        MsgSection section = (MsgSection)lastMsg.getSections().get(0);
        int type = section.getType();
        if (type == 1) {
            // empty if block
        }
        return "";
    }

    @Override
    public void handleNotify(String channelId, ChannelNotify notify2) {
        NotifyDataDefine.UserRoleChange userRoleChange;
        if (notify2.uri == ChannelNotify.Uri.UriUserRoleChangeNotify && (userRoleChange = notify2.notify.userRoleChange) != null) {
            if (userRoleChange.uid != AccountUtil.getUid()) {
                return;
            }
            this.handleMyRoleChange(channelId, userRoleChange.roleType);
        }
    }

    public void handleMyRoleChange(String channelId, int roleType) {
        boolean needUpdate;
        MyJoinChannelItem itemFind = null;
        if (this.myJoinedGroups != null && this.myJoinedGroups.groups != null && this.myJoinedGroups.groups.size() > 0) {
            ArrayList<MyJoinChannelItem> items = this.myJoinedGroups.groups;
            for (MyJoinChannelItem summary : items) {
                if (null == summary || !StringUtils.equal((String)summary.cid, (String)channelId)) continue;
                itemFind = summary;
                break;
            }
        }
        if (!ChannelDefine.sUnEnableLog && MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)"FTRoomGroupMyJoin", (String)"handleNotifySetRole find:%s, role:%d", (Object[])new Object[]{itemFind != null ? itemFind.toString() : "", roleType});
        }
        boolean bl = needUpdate = itemFind == null;
        if (!needUpdate) {
            boolean bl2 = needUpdate = itemFind.myRoleData != null && roleType != itemFind.myRoleData.roleType;
        }
        if (needUpdate) {
            this.hasSynced = false;
            this.getMyJoinedGroups(new IChannelCenterService.IGetMyJoinedChannelsCallBack(){

                public void onSuccess(ArrayList<MyJoinChannelItem> groupSummays) {
                }

                public void onError(int errorCode, Exception e) {
                }
            }, true);
        }
    }

    private void saveToFile() {
        YYTaskExecutor.execute(() -> {
            if (this.saveFileLimitExecutor == null) {
                this.saveFileLimitExecutor = YYTaskExecutor.createAFrequencyLimitExecut((long)8000L, (boolean)false);
            }
            this.saveFileLimitExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    String newData = JsonParser.toJson((Object)MyJoinedChannelModel.this.myJoinedGroups);
                    if (!StringUtils.equal((String)MyJoinedChannelModel.this.dataStr, (String)newData)) {
                        MyJoinedChannelModel.this.dataStr = newData;
                        FileStorageUtils.getInstance().saveToFile(true, newData, MyJoinedChannelModel.FILE_NAME + MyJoinedChannelModel.this.uid);
                    }
                }
            });
        });
    }

    public void onWsConnect(boolean flag) {
        if (flag) {
            this.hasSynced = false;
            this.refreshUnreadNum();
        }
    }

    public void handleForeGround(boolean fore) {
        if (fore) {
            this.refreshUnreadNum();
        }
    }

    private void ensureCimOpen(final ICIMService.IOpenCallBack callBack) {
        ICIMService icimService = (ICIMService)ServiceManagerProxy.getServiceManager().getService(ICIMService.class);
        if (!icimService.isOpened()) {
            icimService.initCIM();
            icimService.open(new ICIMService.IOpenCallBack(){

                public void onsuccess() {
                    if (callBack != null) {
                        callBack.onsuccess();
                    }
                }

                public void onError(final int errorCode, String tips) {
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (callBack != null) {
                                callBack.onError(errorCode, "");
                            }
                        }
                    });
                }
            });
        } else if (callBack != null) {
            callBack.onsuccess();
        }
    }

    private void startRefreshUnreadNumInner(int from, long delay) {
        MLog.error((Object)TAG, (String)"startRefreshUnreadNumInner!", (Object[])new Object[0]);
        if (AccountUtil.getUid() <= 0L || !this.startRefresh) {
            MLog.error((Object)TAG, (String)"not startRefreshUnreadNumInner!", (Object[])new Object[0]);
            return;
        }
        if (this.myJoinedGroups != null && this.myJoinedGroups.groups != null && this.myJoinedGroups.groups.size() > 0) {
            this.addSource(this.myJoinedGroups.groups);
            this.refreshUnreadNum();
        } else {
            this.getMyJoinedGroups(new IChannelCenterService.IGetMyJoinedChannelsCallBack(){

                public void onSuccess(ArrayList<MyJoinChannelItem> groupSummays) {
                    MyJoinedChannelModel.this.addSource(groupSummays);
                    MyJoinedChannelModel.this.refreshUnreadNum();
                }

                public void onError(int errorCode, Exception e) {
                    MLog.error((Object)MyJoinedChannelModel.TAG, (String)"startRefreshUnreadNumInner error:%d!", (Object[])new Object[]{errorCode});
                }
            }, false);
        }
        if (this.mWindowMonitor == null) {
            this.addWindowMonitor();
        }
    }

    public void startRefreshUnreadNum(int from, long delay) {
        this.startRefresh = true;
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"startRefreshUnreadNum from:%d!", (Object[])new Object[]{from});
        }
        if (AccountUtil.getUid() <= 0L) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"not startRefreshUnreadNum from:%d!", (Object[])new Object[]{from});
            }
            return;
        }
        this.startRefreshUnreadNumInner(from, delay);
    }

    private void addSource(List<MyJoinChannelItem> myJoinChannelItems) {
        Object region;
        ICIMService service = (ICIMService)ServiceManagerProxy.getServiceManager().getService(ICIMService.class);
        if (service == null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"cimSource add error service null!", (Object[])new Object[0]);
            }
            return;
        }
        this.removeRoamingCahtListener();
        this.addRoamingCahtListener();
        ArrayList<MyJoinChannelItem> sourcesShouldAdd = null;
        if (myJoinChannelItems != null && myJoinChannelItems.size() > 0) {
            for (MyJoinChannelItem item : myJoinChannelItems) {
                if (item == null || item.mPluginData == null || item.mPluginData.mode != 1) continue;
                if (sourcesShouldAdd == null) {
                    sourcesShouldAdd = new ArrayList<MyJoinChannelItem>(8);
                }
                sourcesShouldAdd.add(item);
            }
        }
        if (this.lastSources != null && this.lastSources.size() > 0) {
            ArrayList<NotifySourceBean> sourcesToDelete = null;
            for (MyJoinChannelItem item : this.lastSources) {
                if (null == item) continue;
                boolean find = false;
                if (sourcesShouldAdd != null && sourcesShouldAdd.size() > 0) {
                    for (MyJoinChannelItem itemToFind : sourcesShouldAdd) {
                        if (null == itemToFind || !StringUtils.equals((String)item.cid, (String)itemToFind.cid)) continue;
                        find = true;
                        break;
                    }
                }
                if (find) continue;
                if (sourcesToDelete == null) {
                    sourcesToDelete = new ArrayList<NotifySourceBean>(3);
                }
                region = null;
                if (item.region != null && item.region.region != null) {
                    region = item.region.region.toLowerCase();
                }
                sourcesToDelete.add(new NotifySourceBean(item.cid, region));
            }
            if (sourcesToDelete != null) {
                service.deleteNotifySources(sourcesToDelete);
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)"cimSource delete:%d!", (Object[])new Object[]{sourcesToDelete.size()});
                }
            } else if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"cimSource delete:0!", (Object[])new Object[0]);
            }
        }
        if (sourcesShouldAdd != null && sourcesShouldAdd.size() > 0) {
            ArrayList<NotifySourceBean> sourcesToAdd = null;
            for (MyJoinChannelItem item : sourcesShouldAdd) {
                if (null == item) continue;
                boolean find = false;
                if (this.lastSources != null && this.lastSources.size() > 0) {
                    for (MyJoinChannelItem itemToFind : this.lastSources) {
                        if (null == itemToFind || item.cid != itemToFind.cid) continue;
                        find = true;
                        break;
                    }
                }
                if (find) continue;
                if (sourcesToAdd == null) {
                    sourcesToAdd = new ArrayList<NotifySourceBean>(8);
                }
                region = null;
                if (item.region != null && item.region.region != null) {
                    region = item.region.region.toLowerCase();
                }
                sourcesToAdd.add(new NotifySourceBean(item.cid, region));
            }
            if (sourcesToAdd != null) {
                service.addNotifySources(sourcesToAdd);
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)"cimSource add:%d!", (Object[])new Object[]{sourcesToAdd.size()});
                }
            } else if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"cimSource add:%d!", (Object[])new Object[]{0});
            }
        } else if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"cimSource add:%d!", (Object[])new Object[]{0});
        }
        this.lastSources = sourcesShouldAdd;
    }

    public void stopRefreshUnreadNum(int from) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"stopRefreshUnreadNum from:%d!", (Object[])new Object[]{from});
        }
        ICIMService service = (ICIMService)ServiceManagerProxy.getServiceManager().getService(ICIMService.class);
        this.removeRoamingCahtListener();
        if (this.lastSources != null && this.lastSources.size() > 0) {
            ArrayList<NotifySourceBean> sourcesToDelete = new ArrayList<NotifySourceBean>();
            for (MyJoinChannelItem item : this.lastSources) {
                if (null == item) continue;
                String region = null;
                if (item.region != null && item.region.region != null) {
                    region = item.region.region.toLowerCase();
                }
                sourcesToDelete.add(new NotifySourceBean(item.cid, region));
            }
            service.deleteNotifySources(sourcesToDelete);
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"cimSource delete:%d!", (Object[])new Object[]{this.lastSources.size()});
            }
            this.lastSources.clear();
        }
        this.startRefresh = false;
    }

    public void updateChannelMsgUnreadData(String channel, long unreadNum, long lastReadTime) {
        if (this.myJoinedGroups != null && this.myJoinedGroups.groups != null && this.myJoinedGroups.groups.size() > 0) {
            ArrayList<MyJoinChannelItem> items = this.myJoinedGroups.groups;
            MyJoinChannelItem itemFind = null;
            for (MyJoinChannelItem item : items) {
                if (null == item || !StringUtils.equal((String)item.cid, (String)channel)) continue;
                itemFind = item;
                break;
            }
            if (itemFind != null && (itemFind.unreadMsgNum != unreadNum || itemFind.lastReadMsgTime != lastReadTime)) {
                itemFind.unreadMsgNum = unreadNum;
                itemFind.lastReadMsgTime = lastReadTime;
                this.saveToFile();
                LastMsgAndUnreadData data = new LastMsgAndUnreadData();
                data.unreadMsgNum = unreadNum;
                data.lastestUnReadMsgTs = itemFind.lastestUnReadMsgTs;
                if (this.callback != null) {
                    this.callback.onMyJoinedChannelsUnreadNumChange(channel, data);
                }
            }
        }
    }

    private void addWindowMonitor() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"addWindowMonitor", (Object[])new Object[0]);
        }
        this.mWindowMonitor = new DefaultWindow.IGlobalWindowMonitor(){

            public void onWindowCreate(DefaultWindow window) {
            }

            public void onShown(DefaultWindow window) {
                if (window == null) {
                    return;
                }
                if (WindowNameDef.isHomePage((String)window.getName())) {
                    MyJoinedChannelModel.this.curWinNeedRefresh = true;
                    MyJoinedChannelModel.this.refreshUnreadNum();
                } else if (window instanceof ChannelWindow) {
                    MyJoinedChannelModel.this.curWinNeedRefresh = true;
                    MyJoinedChannelModel.this.refreshUnreadNum();
                } else if (window instanceof JoinedChannelsWindow) {
                    MyJoinedChannelModel.this.curWinNeedRefresh = true;
                    MyJoinedChannelModel.this.refreshUnreadNum();
                } else if (WindowNameDef.isShareSelectorPage((String)window.getName())) {
                    MyJoinedChannelModel.this.curWinNeedRefresh = true;
                    MyJoinedChannelModel.this.refreshUnreadNum();
                } else {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)MyJoinedChannelModel.TAG, (String)"Window not need Refresh!", (Object[])new Object[0]);
                    }
                    MyJoinedChannelModel.this.curWinNeedRefresh = false;
                }
            }

            public void onHidden(DefaultWindow window) {
            }

            public void onLayout(boolean changed, int left, int top, int right, int bottom) {
            }
        };
        DefaultWindow.addGlobalMonitor((DefaultWindow.IGlobalWindowMonitor)this.mWindowMonitor);
    }

    private void refreshUnreadNum() {
        if (!this.refreshSwitchOn) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"stop refresh, switch off!", (Object[])new Object[0]);
            }
            return;
        }
        if (!this.curWinNeedRefresh) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"curWinNeedRefresh false!", (Object[])new Object[0]);
            }
            return;
        }
        if (!this.startRefresh || !RuntimeContext.sIsForeground || AccountUtil.getUid() <= 0L) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"stop refresh,startRefresh:%d,fore:%d,destoryed:%d", (Object[])new Object[]{this.startRefresh ? 1 : 0, RuntimeContext.sIsForeground ? 1 : 0, AccountUtil.getUid() <= 0L ? 1 : 0});
            }
            return;
        }
        MyJoinedChannelData myJoinedGroups = this.myJoinedGroups;
        if (myJoinedGroups == null || myJoinedGroups.groups == null || myJoinedGroups.groups.size() <= 0) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"stop refresh,groupsize:0!", (Object[])new Object[0]);
            }
            return;
        }
        if (!ProtoManager.getInstance().isWSConnected()) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"stop refresh,ws not connect!", (Object[])new Object[0]);
            }
            return;
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"refresh,unreadnums!", (Object[])new Object[0]);
        }
        this.doChangeChatInfo(null, this.getUnreadMsgRequestCallBack());
    }

    private void doChangeChatInfo(List targets, IUnreadMsgRequestCallBack callBack) {
        IChannelUnreadMsgPuller channelUnreadMsgPuller = this.getChannelUnreadMsgPuller();
        if (channelUnreadMsgPuller == null && !SystemUtils.isShowEnvSetting()) {
            throw new RuntimeException("Why is null!");
        }
        if (channelUnreadMsgPuller == null) {
            return;
        }
        channelUnreadMsgPuller.getUnreadChatInfo(targets, this.myJoinedGroups.groups, callBack);
    }

    private void onRoamingChatResponse(HashMap<String, LastMsgAndUnreadData> unreadItemDatas) {
        if (this.myJoinedGroups == null || this.myJoinedGroups.groups == null) {
            MLog.error((Object)TAG, (String)"onRoamingChatResponse myJoinedGroups:%s", (Object[])new Object[]{this.myJoinedGroups});
            return;
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"onRoamingChatResponse hasData:%b", (Object[])new Object[]{unreadItemDatas != null && !unreadItemDatas.isEmpty()});
        }
        for (MyJoinChannelItem item : this.myJoinedGroups.groups) {
            LastMsgAndUnreadData unreadItemData;
            if (null == item || (unreadItemData = unreadItemDatas.get(item.cid)) == null) continue;
            item.unreadMsgNum = unreadItemData.unreadMsgNum;
            item.lastestUnReadMsgTs = unreadItemData.lastestUnReadMsgTs;
            CharSequence tips = null;
            if (unreadItemData.lastMsg != null && (tips = unreadItemData.lastMsg.getSessionTips()) == null) {
                tips = ResourceUtils.getString((int)R.string.tips_new_unread_channel_msg);
                MLog.error((Object)TAG, (String)"unreadItemData without session tips!!!:%s", (Object[])new Object[]{unreadItemData.lastMsg});
            }
            item.setLastMsgTips(tips, unreadItemData.lastMsg != null);
            MLog.debug((Object)TAG, (String)"lastestUnReadMsgTs cid:%s, ts:%d, tips: %s", (Object[])new Object[]{item.cid, item.lastestUnReadMsgTs, tips});
        }
        YYTaskExecutor.postToMainThread(() -> {
            if (this.callback != null) {
                this.callback.onMyJoinedChannelsUnreadNumChange(unreadItemDatas);
            }
        });
        YYTaskExecutor.execute(() -> {
            String newData = JsonParser.toJson((Object)this.myJoinedGroups);
            if (!StringUtils.equal((String)this.dataStr, (String)newData)) {
                this.dataStr = newData;
                FileStorageUtils.getInstance().saveToFile(true, newData, FILE_NAME + this.uid);
            }
        });
    }

    private IUnreadMsgRequestCallBack getUnreadMsgRequestCallBack() {
        return new IUnreadMsgRequestCallBack(){

            public void onSuccess(HashMap<String, LastMsgAndUnreadData> dataHashMap) {
                MyJoinedChannelModel.this.onRoamingChatResponse(dataHashMap);
            }

            public void needRefresh(List refreshTargets) {
                if (MyJoinedChannelModel.this.myJoinedGroups == null || ((MyJoinedChannelModel)MyJoinedChannelModel.this).myJoinedGroups.groups == null) {
                    return;
                }
                if (MyJoinedChannelModel.this.startRefresh) {
                    MyJoinedChannelModel.this.doChangeChatInfo(refreshTargets, MyJoinedChannelModel.this.getUnreadMsgRequestCallBack());
                }
            }

            public BaseImMsg transformMsgItem(String msgId, IMMsgItem msg, ChannelPushContent pushContent, boolean isRevoked) {
                IPublicScreenService service = (IPublicScreenService)ServiceManagerProxy.getService(IPublicScreenService.class);
                return service == null ? null : service.getMsgItemFactory().transformMsgItem(msgId, msg, pushContent, false, isRevoked);
            }

            public void onError(int errorcode, String errorTips) {
                MLog.error((Object)MyJoinedChannelModel.TAG, (String)"doChangeChatInfoInner refreshing err:%s", (Object[])new Object[]{errorTips});
            }
        };
    }

    public void destroy() {
        if (this.mWindowMonitor != null) {
            DefaultWindow.removeGlobalMonitor((DefaultWindow.IGlobalWindowMonitor)this.mWindowMonitor);
        }
    }

    private IChannelUnreadMsgPuller getChannelUnreadMsgPuller() {
        if (this.mChannelUnreadMsgPuller == null) {
            this.mChannelUnreadMsgPuller = ((ImService)ServiceManagerProxy.getService(ImService.class)).createUnreadMsgPuller();
            if (this.mChannelUnreadMsgPuller == null && !SystemUtils.isShowEnvSetting()) {
                throw new RuntimeException("Why is null!");
            }
        }
        return this.mChannelUnreadMsgPuller;
    }

    private void addRoamingCahtListener() {
        IChannelUnreadMsgPuller channelUnreadMsgPuller = this.getChannelUnreadMsgPuller();
        if (channelUnreadMsgPuller == null) {
            return;
        }
        channelUnreadMsgPuller.addRoamingCahtListener((IChannelUnreadMsgNotifyCallbak)this);
    }

    private void removeRoamingCahtListener() {
        IChannelUnreadMsgPuller channelUnreadMsgPuller = this.getChannelUnreadMsgPuller();
        if (channelUnreadMsgPuller == null) {
            return;
        }
        channelUnreadMsgPuller.removeRoamingCahtListener((IChannelUnreadMsgNotifyCallbak)this);
    }

    public void onMsgCome(List targets) {
        if (this.myJoinedGroups == null) {
            return;
        }
        if (this.myJoinedGroups.groups == null || this.myJoinedGroups.groups.size() < 1) {
            return;
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"onChangeChatInfo!", (Object[])new Object[0]);
        }
        this.doChangeChatInfo(targets, this.getUnreadMsgRequestCallBack());
    }
}

