/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.service.family;

import android.content.Context;
import android.text.TextUtils;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import biz.CInfo;
import biz.IMMsgSection;
import biz.PluginInfo;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.account.AccountRelatedSetting;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.callback.ICommonCallback;
import com.yy.appbase.common.DataCallback;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.TimeUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.BaseRequestManager;
import com.yy.hiyo.channel.base.bean.ChannelInfo;
import com.yy.hiyo.channel.base.bean.FamilyCommonConfigData;
import com.yy.hiyo.channel.base.bean.FamilyGateInfo;
import com.yy.hiyo.channel.base.bean.FamilyInfoBean;
import com.yy.hiyo.channel.base.bean.FamilyMemberLvInfo;
import com.yy.hiyo.channel.base.bean.FamilyProfileData;
import com.yy.hiyo.channel.base.bean.NotifyDataDefine;
import com.yy.hiyo.channel.base.bean.PartyRoomBean;
import com.yy.hiyo.channel.base.bean.family.FamilyCallInfo;
import com.yy.hiyo.channel.base.bean.plugins.ChannelPluginData;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.base.service.IDataService;
import com.yy.hiyo.channel.base.service.IFamilyService;
import com.yy.hiyo.channel.base.service.IFetchFamilyConfigCallback;
import com.yy.hiyo.channel.base.service.IFetchFamilyProfileCallback;
import com.yy.hiyo.channel.base.service.IGetJoinApplyStatusCallback;
import com.yy.hiyo.channel.base.service.OnFamilyMemberShowListener;
import com.yy.hiyo.channel.service.BaseService;
import com.yy.hiyo.channel.service.family.FamilyConfigFetcher;
import com.yy.hiyo.channel.service.family.FamilyService;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.proto.callback.SimpleProtoCallback;
import common.ERet;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.ihago.channel.srv.mgr.ECode;
import net.ihago.channel.srv.mgr.GetFamilyConditionReq;
import net.ihago.channel.srv.mgr.GetFamilyConditionRes;
import net.ihago.channel.srv.mgr.GetFamilyConfigReq;
import net.ihago.channel.srv.mgr.GetFamilyConfigRes;
import net.ihago.channel.srv.mgr.GetFamilyModifyLimitReq;
import net.ihago.channel.srv.mgr.GetFamilyModifyLimitRes;
import net.ihago.channel.srv.mgr.GetFamilyRoomListReq;
import net.ihago.channel.srv.mgr.GetFamilyRoomListRes;
import net.ihago.channel.srv.mgr.GetJoinApplyStatusReq;
import net.ihago.channel.srv.mgr.GetJoinApplyStatusRes;
import net.ihago.channel.srv.mgr.PartyInfoChannel;
import net.ihago.channel.srv.mgr.SendFamilyCallMsgReq;
import net.ihago.channel.srv.mgr.SendFamilyCallMsgRes;
import net.ihago.money.api.family.CallJoinAlreadyRoomReq;
import net.ihago.money.api.family.CallJoinAlreadyRoomRes;
import net.ihago.money.api.family.FamilyLvConf;
import net.ihago.money.api.family.FamilyLvInfo;
import net.ihago.money.api.family.GetFamilyBaseInfoReq;
import net.ihago.money.api.family.GetFamilyBaseInfoRes;
import net.ihago.money.api.family.GetFamilyProfile4AppReq;
import net.ihago.money.api.family.GetFamilyProfile4AppRes;
import net.ihago.money.api.family.GetMemberLvInfoReq;
import net.ihago.money.api.family.GetMemberLvInfoRes;
import net.ihago.money.api.family.IsAlmostDisbandReq;
import net.ihago.money.api.family.IsAlmostDisbandRes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00d4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 J2\u00020\u00012\u00020\u0002:\u0001JB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\n\u0010\u0011\u001a\u0004\u0018\u00010\fH\u0016J(\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u000e\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u0018H\u0016J\u0018\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u0010\u001f\u001a\u00020\u00132\u000e\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010 H\u0016J\u0012\u0010!\u001a\u00020\u00132\b\u0010\u0017\u001a\u0004\u0018\u00010\"H\u0016J&\u0010#\u001a\u00020\u00132\u0006\u0010$\u001a\u00020\u00152\u0014\u0010\u0017\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020&0%\u0018\u00010 H\u0016J\u001a\u0010'\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00152\b\u0010\u0017\u001a\u0004\u0018\u00010(H\u0016J \u0010)\u001a\u00020\u00132\u0006\u0010*\u001a\u00020\b2\u000e\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010 H\u0016J\n\u0010+\u001a\u0004\u0018\u00010,H\u0016J(\u0010-\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010*\u001a\u00020\b2\u000e\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020.\u0018\u00010\u0018H\u0016J\u0016\u0010/\u001a\b\u0012\u0004\u0012\u0002000\t2\u0006\u00101\u001a\u000202H\u0016J\u0018\u00103\u001a\u0012\u0012\u0004\u0012\u00020\b04j\b\u0012\u0004\u0012\u00020\b`5H\u0016J\u0018\u00106\u001a\u0012\u0012\u0004\u0012\u00020\b04j\b\u0012\u0004\u0012\u00020\b`5H\u0016J\u0018\u00107\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n082\u0006\u0010*\u001a\u00020\bH\u0016J \u00107\u001a\u00020\u00132\u0006\u0010*\u001a\u00020\b2\u000e\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010 H\u0016J\"\u00109\u001a\u00020\u00132\u0006\u0010:\u001a\u00020\u00152\u0010\u0010\u0017\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010;\u0018\u00010\u0018H\u0016J\u0010\u0010<\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020=H\u0016J \u0010>\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u000e\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020?\u0018\u00010\u0018H\u0016J\u001c\u0010@\u001a\u00020\u00132\b\u0010A\u001a\u0004\u0018\u00010\u00152\b\u0010B\u001a\u0004\u0018\u00010CH\u0016J\u0012\u0010D\u001a\u00020\u00132\b\u0010E\u001a\u0004\u0018\u00010\u0010H\u0016J\u001e\u0010F\u001a\u00020\u00132\u0006\u0010G\u001a\u00020H2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\b0\u0018H\u0016J\u0012\u0010I\u001a\u00020\u00132\b\u0010E\u001a\u0004\u0018\u00010\u0010H\u0016R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006K"}, d2={"Lcom/yy/hiyo/channel/service/family/FamilyService;", "Lcom/yy/hiyo/channel/service/BaseService;", "Lcom/yy/hiyo/channel/base/service/IFamilyService;", "channel", "Lcom/yy/hiyo/channel/base/service/IChannel;", "(Lcom/yy/hiyo/channel/base/service/IChannel;)V", "familyMemberLvInfoMap", "", "", "Landroidx/lifecycle/MutableLiveData;", "Lcom/yy/hiyo/channel/base/bean/FamilyMemberLvInfo;", "mMyFamilyInfo", "Lcom/yy/hiyo/channel/base/bean/FamilyInfoBean;", "mOnMemberShowListeners", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Ljava/lang/ref/WeakReference;", "Lcom/yy/hiyo/channel/base/service/OnFamilyMemberShowListener;", "cacheMyFamilyInfo", "callJoinInFamily", "", "fid", "", "cid", "callback", "Lcom/yy/appbase/common/DataCallback;", "", "changeFamilyGate", "gateInfo", "Lcom/yy/hiyo/channel/base/bean/FamilyGateInfo;", "iUpdateFamilyGateCallBack", "Lcom/yy/hiyo/channel/base/service/IDataService$IUpdateFamilyGateCallBack;", "fetchFamilyCommonConfig", "Lcom/yy/appbase/callback/ICommonCallback;", "fetchFamilyConfig", "Lcom/yy/hiyo/channel/base/service/IFetchFamilyConfigCallback;", "fetchFamilyMemberLivingChannels", "fcid", "", "Lcom/yy/hiyo/channel/base/bean/PartyRoomBean;", "fetchFamilyProfileInfo", "Lcom/yy/hiyo/channel/base/service/IFetchFamilyProfileCallback;", "getFamilyByUid", "uid", "getFamilyCommonConfig", "Lcom/yy/hiyo/channel/base/bean/FamilyCommonConfigData;", "getFamilyCondition", "Lnet/ihago/channel/srv/mgr/GetFamilyConditionRes;", "getFamilyConfigById", "Lnet/ihago/money/api/family/FamilyLvConf;", "lv", "", "getFamilyGataActiveTimeConfig", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "getFamilyGataWeathLvConfig", "getFamilyMemberLvInfo", "Landroidx/lifecycle/LiveData;", "getFamilyModifyLimit", "channelId", "Lnet/ihago/channel/srv/mgr/GetFamilyModifyLimitRes;", "getJoinApplyStatus", "Lcom/yy/hiyo/channel/base/service/IGetJoinApplyStatusCallback;", "isAlmostDisband", "Lnet/ihago/money/api/family/IsAlmostDisbandRes;", "onFamilyMemberShow", "gid", "data", "Lcom/yy/hiyo/channel/base/bean/NotifyDataDefine$FamilyShowNotify;", "registerFamilyMemberShowListener", "listener", "sendFamilyCall", "familyCallInfo", "Lcom/yy/hiyo/channel/base/bean/family/FamilyCallInfo;", "unregisterFamilyMemberShowListener", "Companion", "channel-components_release"})
public final class FamilyService
extends BaseService
implements IFamilyService {
    private CopyOnWriteArrayList<WeakReference<OnFamilyMemberShowListener>> mOnMemberShowListeners;
    private final Map<Long, MutableLiveData<FamilyMemberLvInfo>> familyMemberLvInfoMap;
    private FamilyInfoBean mMyFamilyInfo;
    @NotNull
    public static final String TAG = "FamilyService";
    @NotNull
    private static final Map<Integer, MutableLiveData<FamilyLvConf>> localFamilyConfig;
    private static boolean mHasRequestConfig;
    @NotNull
    private static final ArrayList<Long> gateDurationList;
    @NotNull
    private static final ArrayList<Long> gateLvList;
    @Nullable
    private static FamilyCommonConfigData mFamilyCommonConfig;
    public static final Companion Companion;

    @NotNull
    public MutableLiveData<FamilyLvConf> getFamilyConfigById(int lv) {
        MutableLiveData conf = localFamilyConfig.get(lv);
        if (conf == null) {
            conf = new MutableLiveData();
            localFamilyConfig.put(lv, (MutableLiveData<FamilyLvConf>)conf);
        }
        return conf;
    }

    @Nullable
    public FamilyInfoBean cacheMyFamilyInfo() {
        this.getFamilyByUid(AccountUtil.getUid(), null);
        return this.mMyFamilyInfo;
    }

    public void getFamilyByUid(long uid, @Nullable ICommonCallback<FamilyInfoBean> callback2) {
        GetFamilyBaseInfoReq req = new GetFamilyBaseInfoReq.Builder().uid(Long.valueOf(uid)).build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<GetFamilyBaseInfoRes>(this, uid, callback2){
            final /* synthetic */ FamilyService this$0;
            final /* synthetic */ long $uid;
            final /* synthetic */ ICommonCallback $callback;

            public void onResponse(@NotNull GetFamilyBaseInfoRes message, long code, @Nullable String msg) {
                block3: {
                    block2: {
                        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                        super.onResponse((AndroidMessage)message, code, msg);
                        if (!ProtoManager.isSuccessCode((long)code)) break block2;
                        Integer n = message.lv;
                        Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"message.lv");
                        int n2 = n;
                        String string2 = message.fid;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"message.fid");
                        String string3 = message.name;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"message.name");
                        String string4 = message.avatar;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"message.avatar");
                        Long l = message.score;
                        Intrinsics.checkExpressionValueIsNotNull((Object)l, (String)"message.score");
                        long l2 = l;
                        Integer n3 = message.lv;
                        Intrinsics.checkExpressionValueIsNotNull((Object)n3, (String)"message.lv");
                        MutableLiveData<FamilyLvConf> mutableLiveData = this.this$0.getFamilyConfigById(n3);
                        Integer n4 = message.member_count;
                        Intrinsics.checkExpressionValueIsNotNull((Object)n4, (String)"message.member_count");
                        int n5 = n4;
                        Integer n6 = message.member_limit;
                        Intrinsics.checkExpressionValueIsNotNull((Object)n6, (String)"message.member_limit");
                        FamilyInfoBean info = new FamilyInfoBean(n2, string2, string3, string4, l2, mutableLiveData, n5, n6.intValue());
                        if (this.$uid == AccountUtil.getUid()) {
                            FamilyService.access$setMMyFamilyInfo$p(this.this$0, info);
                        }
                        ICommonCallback iCommonCallback = this.$callback;
                        if (iCommonCallback == null) break block3;
                        iCommonCallback.onSuccess((Object)info, new Object[0]);
                        break block3;
                    }
                    ICommonCallback iCommonCallback = this.$callback;
                    if (iCommonCallback == null) break block3;
                    int n = (int)code;
                    String string5 = msg;
                    if (string5 == null) {
                        string5 = "";
                    }
                    iCommonCallback.onFail(n, string5, new Object[0]);
                }
            }

            public void onError(@Nullable String reason, int code) {
                block1: {
                    super.onError(reason, code);
                    ICommonCallback iCommonCallback = this.$callback;
                    if (iCommonCallback == null) break block1;
                    String string2 = reason;
                    if (string2 == null) {
                        string2 = "";
                    }
                    iCommonCallback.onFail(code, string2, new Object[0]);
                }
            }
            {
                this.this$0 = $outer;
                this.$uid = $captured_local_variable$1;
                this.$callback = $captured_local_variable$2;
            }
        });
    }

    public void fetchFamilyConfig(@Nullable IFetchFamilyConfigCallback callback2) {
        FamilyConfigFetcher.INSTANCE.requestConfig(new IFetchFamilyConfigCallback(this, callback2){
            final /* synthetic */ FamilyService this$0;
            final /* synthetic */ IFetchFamilyConfigCallback $callback;

            public void fetchSuccess(@NotNull List<FamilyLvConf> configList) {
                block1: {
                    Intrinsics.checkParameterIsNotNull(configList, (String)"configList");
                    Iterable $this$forEach$iv = configList;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        FamilyLvConf it = (FamilyLvConf)element$iv;
                        boolean bl = false;
                        Integer n = it.lv;
                        Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"it.lv");
                        MutableLiveData<FamilyLvConf> configLiveData = this.this$0.getFamilyConfigById(n);
                        if (!(Intrinsics.areEqual((Object)((FamilyLvConf)configLiveData.getValue()), (Object)it) ^ true)) continue;
                        configLiveData.setValue((Object)it);
                    }
                    IFetchFamilyConfigCallback iFetchFamilyConfigCallback = this.$callback;
                    if (iFetchFamilyConfigCallback == null) break block1;
                    iFetchFamilyConfigCallback.fetchSuccess(configList);
                }
            }

            public void fetchError(int errorCode, @NotNull String errorMsg) {
                block0: {
                    Intrinsics.checkParameterIsNotNull((Object)errorMsg, (String)"errorMsg");
                    IFetchFamilyConfigCallback iFetchFamilyConfigCallback = this.$callback;
                    if (iFetchFamilyConfigCallback == null) break block0;
                    iFetchFamilyConfigCallback.fetchError(errorCode, errorMsg);
                }
            }
            {
                this.this$0 = $outer;
                this.$callback = $captured_local_variable$1;
            }
        });
    }

    public void fetchFamilyProfileInfo(@NotNull String cid, @Nullable IFetchFamilyProfileCallback callback2) {
        Intrinsics.checkParameterIsNotNull((Object)cid, (String)"cid");
        GetFamilyProfile4AppReq req = new GetFamilyProfile4AppReq.Builder().fid(cid).build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<GetFamilyProfile4AppRes>(callback2){
            final /* synthetic */ IFetchFamilyProfileCallback $callback;

            public void onResponse(@NotNull GetFamilyProfile4AppRes message, long code, @Nullable String msg) {
                block0: {
                    Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                    super.onResponse((AndroidMessage)message, code, msg);
                    FamilyLvInfo familyLvInfo = message.lv_info;
                    Intrinsics.checkExpressionValueIsNotNull((Object)familyLvInfo, (String)"message.lv_info");
                    List list2 = message.top_members;
                    Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"message.top_members");
                    Boolean bl = message.will_disband;
                    Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"message.will_disband");
                    FamilyProfileData familyProfileData = new FamilyProfileData(familyLvInfo, list2, bl.booleanValue());
                    IFetchFamilyProfileCallback iFetchFamilyProfileCallback = this.$callback;
                    if (iFetchFamilyProfileCallback == null) break block0;
                    iFetchFamilyProfileCallback.fetchSuccess(familyProfileData);
                }
            }

            public void onError(@Nullable String reason, int code) {
                block1: {
                    super.onError(reason, code);
                    String string2 = reason;
                    if (string2 == null) {
                        string2 = "UnKnown";
                    }
                    String errorMsg = string2;
                    IFetchFamilyProfileCallback iFetchFamilyProfileCallback = this.$callback;
                    if (iFetchFamilyProfileCallback == null) break block1;
                    iFetchFamilyProfileCallback.fetchError(code, errorMsg);
                }
            }
            {
                this.$callback = $captured_local_variable$0;
            }
        });
    }

    public void fetchFamilyCommonConfig(@Nullable ICommonCallback<Boolean> callback2) {
        GetFamilyConfigReq req = new GetFamilyConfigReq.Builder().build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<GetFamilyConfigRes>(callback2){
            final /* synthetic */ ICommonCallback $callback;

            public void onResponse(@NotNull GetFamilyConfigRes message, long code, @Nullable String msg) {
                block1: {
                    Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                    super.onResponse((AndroidMessage)message, code, msg);
                    String infoLog = "fetchFamilyCommonConfig " + message.show_entry + ", " + message.leave_family_froze + ", code:" + code + ", msg:" + msg;
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)"FamilyService", (String)infoLog, (Object[])new Object[0]);
                    }
                    Boolean bl = message.show_entry;
                    Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"message.show_entry");
                    boolean bl2 = bl;
                    Integer n = message.leave_family_froze;
                    Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"message.leave_family_froze");
                    FamilyService.Companion.setMFamilyCommonConfig(new FamilyCommonConfigData(bl2, n.intValue()));
                    ICommonCallback iCommonCallback = this.$callback;
                    if (iCommonCallback == null) break block1;
                    iCommonCallback.onSuccess((Object)Intrinsics.areEqual((Object)message.show_entry, (Object)true), new Object[0]);
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(this, canRetry){
                    final /* synthetic */ fetchFamilyCommonConfig.1 this$0;
                    final /* synthetic */ boolean $canRetry;

                    public final void run() {
                        block0: {
                            String string2 = "fetchFamilyCommonConfig retryWhenTimeout canRetry:" + this.$canRetry;
                            boolean bl = false;
                            boolean bl2 = false;
                            String it = string2;
                            boolean bl3 = false;
                            MLog.error((Object)"FamilyService", (String)it, (Object[])new Object[0]);
                            ICommonCallback iCommonCallback = this.this$0.$callback;
                            if (iCommonCallback == null) break block0;
                            iCommonCallback.onFail(-1, it, new Object[0]);
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        this.$canRetry = bl;
                    }
                });
                return false;
            }

            public boolean retryWhenError(boolean canRetry, @Nullable String reason, int code) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(this, canRetry, reason, code){
                    final /* synthetic */ fetchFamilyCommonConfig.1 this$0;
                    final /* synthetic */ boolean $canRetry;
                    final /* synthetic */ String $reason;
                    final /* synthetic */ int $code;

                    public final void run() {
                        block0: {
                            String string2 = "fetchFamilyCommonConfig retryWhenError canRetry:" + this.$canRetry + ", reason:" + this.$reason + ", code:" + this.$code;
                            boolean bl = false;
                            boolean bl2 = false;
                            String it = string2;
                            boolean bl3 = false;
                            MLog.error((Object)"FamilyService", (String)it, (Object[])new Object[0]);
                            ICommonCallback iCommonCallback = this.this$0.$callback;
                            if (iCommonCallback == null) break block0;
                            iCommonCallback.onFail(-2, it, new Object[0]);
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        this.$canRetry = bl;
                        this.$reason = string2;
                        this.$code = n;
                    }
                });
                return false;
            }
            {
                this.$callback = $captured_local_variable$0;
            }
        });
    }

    @NotNull
    public ArrayList<Long> getFamilyGataActiveTimeConfig() {
        return gateDurationList;
    }

    @NotNull
    public ArrayList<Long> getFamilyGataWeathLvConfig() {
        return gateLvList;
    }

    public void fetchFamilyMemberLivingChannels(@NotNull String fcid, @Nullable ICommonCallback<List<PartyRoomBean>> callback2) {
        Intrinsics.checkParameterIsNotNull((Object)fcid, (String)"fcid");
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)("fetchFamilyMemberLivingChannels fcid:" + fcid), (Object[])new Object[0]);
        }
        GetFamilyRoomListReq req = new GetFamilyRoomListReq.Builder().cid(fcid).build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<GetFamilyRoomListRes>(fcid, callback2){
            final /* synthetic */ String $fcid;
            final /* synthetic */ ICommonCallback $callback;

            public void onResponse(@NotNull GetFamilyRoomListRes message, long code, @Nullable String msg) {
                block6: {
                    String infoLog;
                    block5: {
                        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                        super.onResponse((AndroidMessage)message, code, msg);
                        List list2 = message.channels;
                        infoLog = "fetchFamilyMemberLivingChannels cid:" + this.$fcid + ", message:" + (list2 != null ? Integer.valueOf(list2.size()) : null) + ", code:" + code + ", " + "msg:" + msg;
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)"FamilyService", (String)infoLog, (Object[])new Object[0]);
                        }
                        if (!ProtoManager.isSuccessCode((long)code)) break block5;
                        boolean bl = false;
                        List result = new ArrayList<E>();
                        List list3 = message.channels;
                        if (list3 != null) {
                            Iterable $this$forEach$iv = list3;
                            boolean $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                List list4;
                                PartyInfoChannel it = (PartyInfoChannel)element$iv;
                                boolean bl2 = false;
                                List list5 = result;
                                ChannelInfo channelInfo = BaseRequestManager.obtianChannelInfo((CInfo)it.cinfo);
                                ChannelInfo channelInfo2 = channelInfo;
                                Intrinsics.checkExpressionValueIsNotNull((Object)channelInfo, (String)"BaseRequestManager.obtianChannelInfo(it.cinfo)");
                                ChannelPluginData channelPluginData = BaseRequestManager.obtainPluginData((PluginInfo)it.plugin_info, (String)"", (String)"");
                                ChannelPluginData channelPluginData2 = channelPluginData;
                                Intrinsics.checkExpressionValueIsNotNull((Object)channelPluginData, (String)"BaseRequestManager.obtai\u2026a(it.plugin_info, \"\", \"\")");
                                long l = it.onlines != null ? (long)it.onlines.intValue() : 0L;
                                if (it.show_uids != null) {
                                    list4 = it.show_uids;
                                } else {
                                    long l2 = l;
                                    ChannelPluginData channelPluginData3 = channelPluginData2;
                                    ChannelInfo channelInfo3 = channelInfo2;
                                    List list6 = list5;
                                    boolean bl3 = false;
                                    List list7 = new ArrayList<E>();
                                    list5 = list6;
                                    channelInfo2 = channelInfo3;
                                    channelPluginData2 = channelPluginData3;
                                    l = l2;
                                    list4 = list7;
                                }
                                Intrinsics.checkExpressionValueIsNotNull((Object)list4, (String)"if (it.show_uids != null\u2026uids else mutableListOf()");
                                List list8 = list4;
                                long l3 = l;
                                ChannelPluginData channelPluginData4 = channelPluginData2;
                                ChannelInfo channelInfo4 = channelInfo2;
                                list5.add(new PartyRoomBean(channelInfo4, channelPluginData4, l3, list8));
                            }
                        }
                        ICommonCallback iCommonCallback = this.$callback;
                        if (iCommonCallback == null) break block6;
                        iCommonCallback.onSuccess((Object)result, new Object[0]);
                        break block6;
                    }
                    ICommonCallback iCommonCallback = this.$callback;
                    if (iCommonCallback == null) break block6;
                    iCommonCallback.onFail(-1, infoLog, new Object[0]);
                }
            }

            public void onError(@Nullable String reason, int code) {
                block0: {
                    super.onError(reason, code);
                    ICommonCallback iCommonCallback = this.$callback;
                    if (iCommonCallback == null) break block0;
                    iCommonCallback.onFail(-2, "fetchFamilyMemberLivingChannels cid:" + this.$fcid + ", code:" + code + ", reasson:" + reason, new Object[0]);
                }
            }
            {
                this.$fcid = $captured_local_variable$0;
                this.$callback = $captured_local_variable$1;
            }
        });
    }

    public void registerFamilyMemberShowListener(@Nullable OnFamilyMemberShowListener listener) {
        if (listener != null) {
            boolean bl;
            block5: {
                Iterable $this$none$iv = this.mOnMemberShowListeners;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        WeakReference it = (WeakReference)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)((OnFamilyMemberShowListener)it.get()), (Object)listener)) continue;
                        bl = false;
                        break block5;
                    }
                    bl = true;
                }
            }
            if (bl) {
                this.mOnMemberShowListeners.add(new WeakReference<OnFamilyMemberShowListener>(listener));
            }
        }
    }

    public void unregisterFamilyMemberShowListener(@Nullable OnFamilyMemberShowListener listener) {
        OnFamilyMemberShowListener onFamilyMemberShowListener = listener;
        if (onFamilyMemberShowListener != null) {
            OnFamilyMemberShowListener onFamilyMemberShowListener2 = onFamilyMemberShowListener;
            boolean bl = false;
            boolean bl2 = false;
            OnFamilyMemberShowListener $this$apply = onFamilyMemberShowListener2;
            boolean bl3 = false;
            Iterable $this$forEach$iv = this.mOnMemberShowListeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                WeakReference it = (WeakReference)element$iv;
                boolean bl4 = false;
                if (!Intrinsics.areEqual((Object)((OnFamilyMemberShowListener)it.get()), (Object)listener)) continue;
                this.mOnMemberShowListeners.remove(it);
                break;
            }
        }
    }

    @Override
    public void onFamilyMemberShow(@Nullable String gid, @Nullable NotifyDataDefine.FamilyShowNotify data) {
        super.onFamilyMemberShow(gid, data);
        if (StringUtils.isNotEmpty((String)gid) && data != null) {
            Iterable $this$forEach$iv = this.mOnMemberShowListeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                WeakReference it = (WeakReference)element$iv;
                boolean bl = false;
                OnFamilyMemberShowListener onFamilyMemberShowListener = (OnFamilyMemberShowListener)it.get();
                if (onFamilyMemberShowListener != null) {
                    String string2 = gid;
                    if (string2 == null) {
                        Intrinsics.throwNpe();
                    }
                    onFamilyMemberShowListener.onFamilyMemberShow(string2, data);
                }
            }
        }
    }

    public void changeFamilyGate(@NotNull FamilyGateInfo gateInfo, @NotNull IDataService.IUpdateFamilyGateCallBack iUpdateFamilyGateCallBack) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)gateInfo, (String)"gateInfo");
            Intrinsics.checkParameterIsNotNull((Object)iUpdateFamilyGateCallBack, (String)"iUpdateFamilyGateCallBack");
            IChannel iChannel = this.channel;
            Intrinsics.checkExpressionValueIsNotNull((Object)iChannel, (String)"channel");
            IDataService iDataService = iChannel.getDataService();
            if (iDataService == null) break block0;
            iDataService.changeFamilyGate(gateInfo, new IDataService.IUpdateFamilyGateCallBack(iUpdateFamilyGateCallBack){
                final /* synthetic */ IDataService.IUpdateFamilyGateCallBack $iUpdateFamilyGateCallBack;

                public void onSuccess(@Nullable IChannel group) {
                    this.$iUpdateFamilyGateCallBack.onSuccess(group);
                }

                public void onError(@Nullable String channelId, int errorCode, @Nullable String errorTips, @Nullable Exception e) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)"GroupSettingViewModel", (String)("updateRoleJoinMode failed, channelId: " + channelId + " errorCode: " + errorCode + " tips: " + errorTips), (Object[])new Object[0]);
                    }
                    ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.tips_channel_join_net_error);
                }
                {
                    this.$iUpdateFamilyGateCallBack = $captured_local_variable$0;
                }
            });
        }
    }

    public void getJoinApplyStatus(@NotNull IGetJoinApplyStatusCallback callback2) {
        Intrinsics.checkParameterIsNotNull((Object)callback2, (String)"callback");
        GetJoinApplyStatusReq req = new GetJoinApplyStatusReq.Builder().build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<GetJoinApplyStatusRes>(callback2){
            final /* synthetic */ IGetJoinApplyStatusCallback $callback;

            public void onResponse(@NotNull GetJoinApplyStatusRes message, long code, @Nullable String msg) {
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                super.onResponse((AndroidMessage)message, code, msg);
                if (ProtoManager.isSuccessCode((long)code)) {
                    List list2 = message.apply_cids;
                    Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"message.apply_cids");
                    this.$callback.nonJoinedChannel(list2);
                } else if (code == (long)ECode.ALREADY_HAS_FAMILY.getValue()) {
                    ChannelInfo channelInfo;
                    ChannelInfo channelInfo2 = channelInfo = BaseRequestManager.obtianChannelInfo((CInfo)message.cinfo);
                    Intrinsics.checkExpressionValueIsNotNull((Object)channelInfo2, (String)"channelInfo");
                    this.$callback.onJoinedChannel(channelInfo2);
                } else {
                    this.$callback.onFail(code, "");
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(this, canRetry){
                    final /* synthetic */ getJoinApplyStatus.1 this$0;
                    final /* synthetic */ boolean $canRetry;

                    public final void run() {
                        String string2 = "getJoinApplyStatus retryWhenTimeout canRetry:" + this.$canRetry;
                        boolean bl = false;
                        boolean bl2 = false;
                        String it = string2;
                        boolean bl3 = false;
                        MLog.error((Object)"FamilyService", (String)it, (Object[])new Object[0]);
                        this.this$0.$callback.onFail(-1L, it);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$canRetry = bl;
                    }
                });
                return false;
            }

            public boolean retryWhenError(boolean canRetry, @Nullable String reason, int code) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(this, canRetry, reason, code){
                    final /* synthetic */ getJoinApplyStatus.1 this$0;
                    final /* synthetic */ boolean $canRetry;
                    final /* synthetic */ String $reason;
                    final /* synthetic */ int $code;

                    public final void run() {
                        String string2 = "getJoinApplyStatus retryWhenError canRetry:" + this.$canRetry + ", reason:" + this.$reason + ", code:" + this.$code;
                        boolean bl = false;
                        boolean bl2 = false;
                        String it = string2;
                        boolean bl3 = false;
                        MLog.error((Object)"FamilyService", (String)it, (Object[])new Object[0]);
                        this.this$0.$callback.onFail(-2L, it);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$canRetry = bl;
                        this.$reason = string2;
                        this.$code = n;
                    }
                });
                return false;
            }
            {
                this.$callback = $captured_local_variable$0;
            }
        });
    }

    @Nullable
    public FamilyCommonConfigData getFamilyCommonConfig() {
        return mFamilyCommonConfig;
    }

    @NotNull
    public LiveData<FamilyMemberLvInfo> getFamilyMemberLvInfo(long uid) {
        Map<Long, MutableLiveData<FamilyMemberLvInfo>> map = this.familyMemberLvInfoMap;
        Long l = uid;
        boolean bl = false;
        MutableLiveData mutableLiveData = map.get(l);
        if (mutableLiveData == null) {
            boolean bl2 = false;
            mutableLiveData = new MutableLiveData();
        }
        return (LiveData)mutableLiveData;
    }

    public void getFamilyMemberLvInfo(long uid, @Nullable ICommonCallback<FamilyMemberLvInfo> callback2) {
        GetMemberLvInfoReq req = new GetMemberLvInfoReq.Builder().sequence(Long.valueOf(System.currentTimeMillis())).uid(Long.valueOf(uid)).build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<GetMemberLvInfoRes>(this, uid, callback2, "getFamilyMemberLvInfo"){
            final /* synthetic */ FamilyService this$0;
            final /* synthetic */ long $uid;
            final /* synthetic */ ICommonCallback $callback;

            /*
             * WARNING - void declaration
             */
            public void onResponse(@NotNull GetMemberLvInfoRes res, long code, @Nullable String msgTip) {
                block4: {
                    block3: {
                        Object object;
                        void $this$getOrPut$iv;
                        Intrinsics.checkParameterIsNotNull((Object)res, (String)"res");
                        super.onResponse((AndroidMessage)res, code, msgTip);
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)"FamilyService", (String)("getFamilyMemberLvInfo code: " + code), (Object[])new Object[0]);
                        }
                        if (!ProtoManager.isSuccessCode((long)code)) break block3;
                        Integer n = res.lv;
                        Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"res.lv");
                        int n2 = n;
                        Long l = res.score;
                        Intrinsics.checkExpressionValueIsNotNull((Object)l, (String)"res.score");
                        long l2 = l;
                        Long l3 = res.contribution;
                        Intrinsics.checkExpressionValueIsNotNull((Object)l3, (String)"res.contribution");
                        long l4 = l3;
                        Long l5 = res.channel_activity;
                        Intrinsics.checkExpressionValueIsNotNull((Object)l5, (String)"res.channel_activity");
                        long l6 = l5;
                        Long l7 = res.mic_activity;
                        Intrinsics.checkExpressionValueIsNotNull((Object)l7, (String)"res.mic_activity");
                        FamilyMemberLvInfo familyMemberLvInfo = new FamilyMemberLvInfo(n2, l2, l4, l6, l7.longValue());
                        MLog.debug((Object)"FamilyService", (String)("getFamilyMemberLvInfo: " + familyMemberLvInfo), (Object[])new Object[0]);
                        Map map = FamilyService.access$getFamilyMemberLvInfoMap$p(this.this$0);
                        Long key$iv = this.$uid;
                        boolean $i$f$getOrPut = false;
                        V value$iv = $this$getOrPut$iv.get(key$iv);
                        if (value$iv == null) {
                            boolean bl = false;
                            MutableLiveData answer$iv = new MutableLiveData();
                            $this$getOrPut$iv.put(key$iv, answer$iv);
                            object = answer$iv;
                        } else {
                            object = value$iv;
                        }
                        ((MutableLiveData)object).setValue((Object)familyMemberLvInfo);
                        ICommonCallback iCommonCallback = this.$callback;
                        if (iCommonCallback == null) break block4;
                        iCommonCallback.onSuccess((Object)familyMemberLvInfo, new Object[0]);
                        break block4;
                    }
                    ICommonCallback iCommonCallback = this.$callback;
                    if (iCommonCallback == null) break block4;
                    iCommonCallback.onFail((int)code, msgTip, new Object[0]);
                }
            }

            public void onError(@Nullable String reason, int code) {
                block0: {
                    super.onError(reason, code);
                    MLog.error((Object)"FamilyService", (String)("getFamilyMemberLvInfo error: " + reason + " , code: " + code), (Object[])new Object[0]);
                    ICommonCallback iCommonCallback = this.$callback;
                    if (iCommonCallback == null) break block0;
                    iCommonCallback.onFail(code, reason, new Object[0]);
                }
            }
            {
                this.this$0 = $outer;
                this.$uid = $captured_local_variable$1;
                this.$callback = $captured_local_variable$2;
                super($super_call_param$3);
            }
        });
    }

    public void sendFamilyCall(@NotNull FamilyCallInfo familyCallInfo, @NotNull DataCallback<Long> callback2) {
        Intrinsics.checkParameterIsNotNull((Object)familyCallInfo, (String)"familyCallInfo");
        Intrinsics.checkParameterIsNotNull(callback2, (String)"callback");
        String desc = !TextUtils.isEmpty((CharSequence)familyCallInfo.getDesc()) ? familyCallInfo.getDesc() : ResourceUtils.getString((int)R.string.tips_family_call_panel_enter_room);
        JSONObject jSONObject = JsonParser.obtainJSONObject();
        boolean bl = false;
        boolean bl2 = false;
        JSONObject $this$apply = jSONObject;
        boolean bl3 = false;
        $this$apply.putOpt("roomId", (Object)familyCallInfo.getRoomId());
        $this$apply.putOpt("owner_avatar", (Object)familyCallInfo.getOwnerAvatar());
        $this$apply.putOpt("owner_nick", (Object)familyCallInfo.getOwnerNick());
        $this$apply.putOpt("desc", (Object)desc);
        $this$apply.putOpt("start_time", (Object)TimeUtils.getServiceRealTime());
        $this$apply.putOpt("fid", (Object)familyCallInfo.getFid());
        JSONObject contentJson = jSONObject;
        IMMsgSection section = new IMMsgSection.Builder().content(contentJson.toString()).type(Integer.valueOf(3755)).build();
        SendFamilyCallMsgReq req = new SendFamilyCallMsgReq.Builder().to_fid(familyCallInfo.getFid()).cseq(String.valueOf(System.currentTimeMillis())).section(section).nick(familyCallInfo.getSenderNick()).avatar(familyCallInfo.getSenderAvatar()).build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<SendFamilyCallMsgRes>(callback2, "sendFamilyCall"){
            final /* synthetic */ DataCallback $callback;

            public void onResponse(@NotNull SendFamilyCallMsgRes res, long code, @Nullable String msgTip) {
                Intrinsics.checkParameterIsNotNull((Object)res, (String)"res");
                super.onResponse((AndroidMessage)res, code, msgTip);
                int n = (int)code;
                if (n == ERet.kRetSuccess.getValue()) {
                    this.$callback.onResult((Object)0L);
                } else if (n == ECode.FAMILY_CALL_TOATL_LIMIT.getValue()) {
                    this.$callback.onResult((Object)1939L);
                } else if (n == ECode.FAMILY_CALL_INTERVAL_LIMIT.getValue()) {
                    this.$callback.onResult((Object)1940L);
                } else if (n == ECode.SENSITIVE.getValue()) {
                    this.$callback.onResult((Object)1200L);
                }
            }

            public void onError(@Nullable String reason, int code) {
                super.onError(reason, code);
                this.$callback.onResult((Object)-10000L);
            }
            {
                this.$callback = $captured_local_variable$0;
                super($super_call_param$1);
            }
        });
    }

    public void callJoinInFamily(@NotNull String fid, @NotNull String cid, @Nullable DataCallback<Boolean> callback2) {
        Intrinsics.checkParameterIsNotNull((Object)fid, (String)"fid");
        Intrinsics.checkParameterIsNotNull((Object)cid, (String)"cid");
        CallJoinAlreadyRoomReq req = new CallJoinAlreadyRoomReq.Builder().fid(fid).rid(cid).build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<CallJoinAlreadyRoomRes>(callback2, "callJoinInFamily"){
            final /* synthetic */ DataCallback $callback;

            public void onResponse(@NotNull CallJoinAlreadyRoomRes res, long code, @Nullable String msgTip) {
                Intrinsics.checkParameterIsNotNull((Object)res, (String)"res");
                super.onResponse((AndroidMessage)res, code, msgTip);
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)"FamilyService", (String)("callJoinInFamily response: " + code), (Object[])new Object[0]);
                }
            }

            public void onError(@Nullable String reason, int code) {
                block0: {
                    super.onError(reason, code);
                    MLog.error((Object)"FamilyService", (String)("callJoinInFamily error: " + code), (Object[])new Object[0]);
                    DataCallback dataCallback = this.$callback;
                    if (dataCallback == null) break block0;
                    dataCallback.onResult((Object)false);
                }
            }
            {
                this.$callback = $captured_local_variable$0;
                super($super_call_param$1);
            }
        });
    }

    public void getFamilyCondition(@NotNull String cid, long uid, @Nullable DataCallback<GetFamilyConditionRes> callback2) {
        Intrinsics.checkParameterIsNotNull((Object)cid, (String)"cid");
        GetFamilyConditionReq req = new GetFamilyConditionReq.Builder().cid(cid).uid(Long.valueOf(uid)).build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<GetFamilyConditionRes>(callback2, "getFamilyCondition"){
            final /* synthetic */ DataCallback $callback;

            public void onResponse(@NotNull GetFamilyConditionRes res, long code, @Nullable String msgTip) {
                block1: {
                    Intrinsics.checkParameterIsNotNull((Object)res, (String)"res");
                    super.onResponse((AndroidMessage)res, code, msgTip);
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)"FamilyService", (String)("getFamilyCondition response: " + code), (Object[])new Object[0]);
                    }
                    DataCallback dataCallback = this.$callback;
                    if (dataCallback == null) break block1;
                    dataCallback.onResult((Object)res);
                }
            }

            public void onError(@Nullable String reason, int code) {
                block0: {
                    super.onError(reason, code);
                    MLog.error((Object)"FamilyService", (String)("getFamilyCondition error: " + code), (Object[])new Object[0]);
                    DataCallback dataCallback = this.$callback;
                    if (dataCallback == null) break block0;
                    dataCallback.onResult(null);
                }
            }
            {
                this.$callback = $captured_local_variable$0;
                super($super_call_param$1);
            }
        });
    }

    public void getFamilyModifyLimit(@NotNull String channelId, @Nullable DataCallback<GetFamilyModifyLimitRes> callback2) {
        Intrinsics.checkParameterIsNotNull((Object)channelId, (String)"channelId");
        GetFamilyModifyLimitReq req = new GetFamilyModifyLimitReq.Builder().cid(channelId).build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<GetFamilyModifyLimitRes>(callback2, "GetFamilyModifyLimit"){
            final /* synthetic */ DataCallback $callback;

            public void onResponse(@NotNull GetFamilyModifyLimitRes res, long code, @Nullable String msgTip) {
                block1: {
                    Intrinsics.checkParameterIsNotNull((Object)res, (String)"res");
                    super.onResponse((AndroidMessage)res, code, msgTip);
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)"FamilyService", (String)("GetFamilyModifyLimit response: " + code + ',' + " name=" + res.name_toast + ", avatar=" + res.avatar_toast), (Object[])new Object[0]);
                    }
                    DataCallback dataCallback = this.$callback;
                    if (dataCallback == null) break block1;
                    dataCallback.onResult((Object)res);
                }
            }

            public void onError(@Nullable String reason, int code) {
                block0: {
                    super.onError(reason, code);
                    MLog.error((Object)"FamilyService", (String)("GetFamilyModifyLimit error: " + code), (Object[])new Object[0]);
                    DataCallback dataCallback = this.$callback;
                    if (dataCallback == null) break block0;
                    dataCallback.onResult(null);
                }
            }
            {
                this.$callback = $captured_local_variable$0;
                super($super_call_param$1);
            }
        });
    }

    public void isAlmostDisband(@NotNull String fid, @Nullable DataCallback<IsAlmostDisbandRes> callback2) {
        Intrinsics.checkParameterIsNotNull((Object)fid, (String)"fid");
        IsAlmostDisbandReq req = new IsAlmostDisbandReq.Builder().fid(fid).build();
        AccountRelatedSetting.getInstance().getLong("key_last_req_family_disband_data", System.currentTimeMillis());
        ProtoManager.getInstance().sendRpc((AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<IsAlmostDisbandRes>(callback2, "GetFamilyModifyLimit"){
            final /* synthetic */ DataCallback $callback;

            public void onResponse(@NotNull IsAlmostDisbandRes res, long code, @Nullable String msgTip) {
                block1: {
                    Intrinsics.checkParameterIsNotNull((Object)res, (String)"res");
                    super.onResponse((AndroidMessage)res, code, msgTip);
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)"FamilyService", (String)("getIsAlmostDisband response: " + code + ',' + " name=" + res.url), (Object[])new Object[0]);
                    }
                    DataCallback dataCallback = this.$callback;
                    if (dataCallback == null) break block1;
                    dataCallback.onResult((Object)res);
                }
            }

            public void onError(@Nullable String reason, int code) {
                block0: {
                    super.onError(reason, code);
                    MLog.error((Object)"FamilyService", (String)("getIsAlmostDisband error: " + code), (Object[])new Object[0]);
                    DataCallback dataCallback = this.$callback;
                    if (dataCallback == null) break block0;
                    dataCallback.onResult(null);
                }
            }
            {
                this.$callback = $captured_local_variable$0;
                super($super_call_param$1);
            }
        });
    }

    public FamilyService(@NotNull IChannel channel) {
        Map map;
        Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
        super(channel);
        this.mOnMemberShowListeners = new CopyOnWriteArrayList();
        FamilyService familyService = this;
        boolean bl = false;
        familyService.familyMemberLvInfoMap = map = (Map)new LinkedHashMap();
        this.fetchFamilyConfig(null);
        this.fetchFamilyCommonConfig(null);
        this.getFamilyByUid(AccountUtil.getUid(), null);
    }

    static {
        long i;
        Companion = new Companion(null);
        boolean bl = false;
        localFamilyConfig = new LinkedHashMap();
        gateDurationList = new ArrayList();
        gateLvList = new ArrayList();
        long l = 0L;
        long l2 = 100L;
        while (l <= l2) {
            gateDurationList.add(i);
            ++i;
        }
        i = 0L;
        l2 = 40L;
        while (i <= l2) {
            gateLvList.add(i);
            l = i + 1L;
        }
    }

    public static final /* synthetic */ FamilyInfoBean access$getMMyFamilyInfo$p(FamilyService $this) {
        return $this.mMyFamilyInfo;
    }

    public static final /* synthetic */ void access$setMMyFamilyInfo$p(FamilyService $this, FamilyInfoBean familyInfoBean) {
        $this.mMyFamilyInfo = familyInfoBean;
    }

    public static final /* synthetic */ Map access$getFamilyMemberLvInfoMap$p(FamilyService $this) {
        return $this.familyMemberLvInfoMap;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R!\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR!\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR#\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001f\u00a8\u0006 "}, d2={"Lcom/yy/hiyo/channel/service/family/FamilyService$Companion;", "", "()V", "TAG", "", "gateDurationList", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "getGateDurationList", "()Ljava/util/ArrayList;", "gateLvList", "getGateLvList", "localFamilyConfig", "", "", "Landroidx/lifecycle/MutableLiveData;", "Lnet/ihago/money/api/family/FamilyLvConf;", "getLocalFamilyConfig", "()Ljava/util/Map;", "mFamilyCommonConfig", "Lcom/yy/hiyo/channel/base/bean/FamilyCommonConfigData;", "getMFamilyCommonConfig", "()Lcom/yy/hiyo/channel/base/bean/FamilyCommonConfigData;", "setMFamilyCommonConfig", "(Lcom/yy/hiyo/channel/base/bean/FamilyCommonConfigData;)V", "mHasRequestConfig", "", "getMHasRequestConfig", "()Z", "setMHasRequestConfig", "(Z)V", "channel-components_release"})
    public static final class Companion {
        @NotNull
        public final Map<Integer, MutableLiveData<FamilyLvConf>> getLocalFamilyConfig() {
            return localFamilyConfig;
        }

        public final boolean getMHasRequestConfig() {
            return mHasRequestConfig;
        }

        public final void setMHasRequestConfig(boolean bl) {
            mHasRequestConfig = bl;
        }

        @NotNull
        public final ArrayList<Long> getGateDurationList() {
            return gateDurationList;
        }

        @NotNull
        public final ArrayList<Long> getGateLvList() {
            return gateLvList;
        }

        @Nullable
        public final FamilyCommonConfigData getMFamilyCommonConfig() {
            return mFamilyCommonConfig;
        }

        public final void setMFamilyCommonConfig(@Nullable FamilyCommonConfigData familyCommonConfigData) {
            mFamilyCommonConfig = familyCommonConfigData;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

