/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.service.data.local;

import com.yy.base.taskexecutor.IFrequencyLimitExecutor;
import com.yy.base.taskexecutor.IQueueTaskExecutor;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.hiyo.channel.base.bean.ChannelInfo;
import com.yy.hiyo.channel.base.bean.ChannelUser;
import com.yy.hiyo.channel.service.data.ILocalDataModel;
import com.yy.hiyo.channel.service.data.local.ChannelData;
import com.yy.hiyo.channel.service.data.local.ChannelDataList;
import com.yy.hiyo.channel.service.data.local.ChannelMembers;
import com.yy.hiyo.channel.service.data.local.ChannelMembersList;
import com.yy.hiyo.channel.service.data.local.ChannelMembersListNew;
import java.util.ArrayList;

public class ChannelLocalDataManager
implements ILocalDataModel {
    private ChannelDataList groupDataList;
    private ChannelMembersListNew groupMembersList;
    private boolean destroyed;
    private IQueueTaskExecutor taskExecutor = YYTaskExecutor.createAQueueExcuter();
    private IFrequencyLimitExecutor memberFrequencyLimitExecutor;
    private IFrequencyLimitExecutor channelDataFrequencyLimitExecutor;
    private long uid;

    public ChannelLocalDataManager(long uid) {
        this.uid = uid;
    }

    private synchronized void ensureGroupDataFromFile() {
        if (this.groupDataList == null) {
            this.groupDataList = ChannelDataList.loadFromFile(this.uid);
        }
    }

    private synchronized void ensureGroupMembersFromFile() {
        if (this.groupMembersList == null) {
            this.groupMembersList = ChannelMembersListNew.loadFromFile(this.uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChannelInfo getChannelInfoFromMem(String cid) {
        if (this.destroyed || this.uid <= 0L) {
            return null;
        }
        Class<ChannelDataList> clazz = ChannelDataList.class;
        synchronized (ChannelDataList.class) {
            if (this.groupDataList != null && this.groupDataList.groupDataList != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return this.groupDataList.getChannelInfo(cid);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChannelData getGroupData(String groupId) {
        if (this.destroyed || this.uid <= 0L) {
            return null;
        }
        this.ensureGroupDataFromFile();
        Class<ChannelDataList> clazz = ChannelDataList.class;
        synchronized (ChannelDataList.class) {
            if (this.groupDataList != null && this.groupDataList.groupDataList != null) {
                ChannelData data = this.groupDataList.groupDataList.get(groupId);
                if (data != null) {
                    data.index = this.groupDataList.generateIndex();
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return data;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChannelMembers getGroupMembers(String groupId) {
        if (this.destroyed || this.uid <= 0L) {
            return null;
        }
        this.ensureGroupMembersFromFile();
        Class<ChannelMembersList> clazz = ChannelMembersList.class;
        synchronized (ChannelMembersList.class) {
            if (this.groupMembersList != null && this.groupMembersList.membersList != null) {
                ChannelMembers data = this.groupMembersList.membersList.get(groupId);
                if (data != null) {
                    data.index = this.groupMembersList.generateIndex();
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return data;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return null;
        }
    }

    @Override
    public void updateGroupData(final String groupId, final ChannelData data) {
        if (this.destroyed || this.uid <= 0L) {
            return;
        }
        this.taskExecutor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ChannelLocalDataManager.this.ensureGroupDataFromFile();
                Class<ChannelDataList> clazz = ChannelDataList.class;
                synchronized (ChannelDataList.class) {
                    if (ChannelLocalDataManager.this.groupDataList != null && ((ChannelLocalDataManager)ChannelLocalDataManager.this).groupDataList.groupDataList != null) {
                        ChannelData oldData = ((ChannelLocalDataManager)ChannelLocalDataManager.this).groupDataList.groupDataList.get(groupId);
                        data.index = oldData != null ? oldData.index : ChannelLocalDataManager.this.groupDataList.generateIndex();
                        ((ChannelLocalDataManager)ChannelLocalDataManager.this).groupDataList.groupDataList.put(groupId, data);
                        YYTaskExecutor.execute((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                if (ChannelLocalDataManager.this.channelDataFrequencyLimitExecutor == null) {
                                    ChannelLocalDataManager.this.channelDataFrequencyLimitExecutor = YYTaskExecutor.createAFrequencyLimitExecut((long)10000L, (boolean)false);
                                }
                                ChannelLocalDataManager.this.channelDataFrequencyLimitExecutor.execute(new Runnable(){

                                    @Override
                                    public void run() {
                                        ChannelDataList.saveFile(ChannelLocalDataManager.this.uid, ChannelLocalDataManager.this.groupDataList);
                                    }
                                });
                            }
                        }, (long)3000L);
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        }, 0L);
    }

    @Override
    public void updateMembers(final String groupId, final long ver, final ArrayList<ChannelUser> users) {
        if (this.destroyed || this.uid <= 0L) {
            return;
        }
        this.taskExecutor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ChannelLocalDataManager.this.ensureGroupMembersFromFile();
                Class<ChannelMembersList> clazz = ChannelMembersList.class;
                synchronized (ChannelMembersList.class) {
                    if (ChannelLocalDataManager.this.groupMembersList != null && ((ChannelLocalDataManager)ChannelLocalDataManager.this).groupMembersList.membersList != null) {
                        ChannelMembers oldData = ((ChannelLocalDataManager)ChannelLocalDataManager.this).groupMembersList.membersList.get(groupId);
                        ((ChannelLocalDataManager)ChannelLocalDataManager.this).groupMembersList.membersList.put(groupId, new ChannelMembers(ver, users, oldData != null ? oldData.index : ChannelLocalDataManager.this.groupMembersList.generateIndex()));
                        YYTaskExecutor.execute((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                if (ChannelLocalDataManager.this.memberFrequencyLimitExecutor == null) {
                                    ChannelLocalDataManager.this.memberFrequencyLimitExecutor = YYTaskExecutor.createAFrequencyLimitExecut((long)15000L, (boolean)false);
                                }
                                ChannelLocalDataManager.this.memberFrequencyLimitExecutor.execute(new Runnable(){

                                    @Override
                                    public void run() {
                                        ChannelLocalDataManager.this.taskExecutor.execute(new Runnable(){

                                            @Override
                                            public void run() {
                                                ChannelMembersListNew.saveFile(ChannelLocalDataManager.this.uid, ChannelLocalDataManager.this.groupMembersList);
                                            }
                                        }, 0L);
                                    }
                                });
                            }
                        }, (long)5000L);
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        }, 0L);
    }

    @Override
    public String getUsededRoomPassWord() {
        if (this.destroyed || this.uid <= 0L) {
            return null;
        }
        return null;
    }

    @Override
    public void destroy() {
        this.destroyed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTrimMemory() {
        Class clazz = ChannelDataList.class;
        synchronized (ChannelDataList.class) {
            if (this.groupDataList != null) {
                this.groupDataList.clearData();
            }
            // ** MonitorExit[var1_1 /* !! */ ] (shouldn't be in output)
            clazz = ChannelMembersList.class;
            synchronized (ChannelMembersList.class) {
                if (this.groupMembersList != null) {
                    this.groupMembersList.clearData();
                }
                // ** MonitorExit[var1_1 /* !! */ ] (shouldn't be in output)
                return;
            }
        }
    }
}

