/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.service.data;

import biz.CDynamic;
import biz.CInfo;
import biz.PluginInfo;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.channel.base.BaseRequestManager;
import com.yy.hiyo.channel.base.ChannelDefine;
import com.yy.hiyo.channel.base.bean.ChannelDetailInfo;
import com.yy.hiyo.channel.base.bean.ChannelInfo;
import com.yy.hiyo.channel.base.bean.ChannelListData;
import com.yy.hiyo.channel.base.bean.ThemeItemBean;
import com.yy.hiyo.channel.base.bean.plugins.ChannelPluginData;
import com.yy.hiyo.channel.base.service.IDataService;
import com.yy.hiyo.channel.service.data.ILocalDataModel;
import com.yy.hiyo.channel.service.data.local.ChannelData;
import com.yy.hiyo.channel.service.request.ChannelRequestManager;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ChannelListModel {
    private final ChannelData groupData = new ChannelData();
    private ILocalDataModel localDataManager;
    private ChannelRequestManager requestManager = null;
    private ArrayList<WeakReference<IDataService.IDataUpdateListener>> dataListeners;
    private String channelId;

    public ChannelListModel(String channelId, ChannelRequestManager requestManager, ILocalDataModel localGroupDataManager) {
        this.channelId = channelId;
        this.localDataManager = localGroupDataManager;
        this.requestManager = requestManager;
    }

    public ArrayList<ChannelDetailInfo> getTopAndSubGroupInfosFromCache() {
        return this.groupData.subGroupDatas;
    }

    public void getTopAndSubGroupInfos(final IDataService.IGetTopAndSubInfosCallBack callBack) {
        if (this.groupData.hasSyncTime > 0L) {
            Runnable command = new Runnable(){

                @Override
                public void run() {
                    if (callBack != null) {
                        ChannelListData data = new ChannelListData();
                        data.channels = new ArrayList<ChannelDetailInfo>(((ChannelListModel)ChannelListModel.this).groupData.subGroupDatas);
                        data.curPluginInfos = new HashMap<String, ChannelPluginData>(((ChannelListModel)ChannelListModel.this).groupData.curPluginInfos);
                        callBack.onSuccess(ChannelListModel.this.channelId, data, ((ChannelListModel)ChannelListModel.this).groupData.totalNumList, ((ChannelListModel)ChannelListModel.this).groupData.limitNumList, null);
                    }
                }
            };
            if (YYTaskExecutor.isMainThread()) {
                command.run();
            } else {
                YYTaskExecutor.postToMainThread((Runnable)command);
            }
        }
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!((ChannelListModel)ChannelListModel.this).groupData.hasLoaded) {
                    ChannelData data = null;
                    if (ChannelListModel.this.localDataManager != null) {
                        data = ChannelListModel.this.localDataManager.getGroupData(ChannelListModel.this.channelId);
                    }
                    ((ChannelListModel)ChannelListModel.this).groupData.hasLoaded = true;
                    if (data != null && data.subGroupDatas != null && data.subGroupDatas.size() > 0) {
                        ((ChannelListModel)ChannelListModel.this).groupData.ver = data.ver;
                        ((ChannelListModel)ChannelListModel.this).groupData.subGroupDatas = data.subGroupDatas;
                    }
                }
                if (((ChannelListModel)ChannelListModel.this).groupData.hasSyncTime > 0L) {
                    long lastTime = System.currentTimeMillis();
                    if (lastTime < 0L || lastTime < ((ChannelListModel)ChannelListModel.this).groupData.hasSyncTime || lastTime - ((ChannelListModel)ChannelListModel.this).groupData.hasSyncTime > 3000L) {
                        ChannelListModel.this.getTopAndSubGroupInfosFromServer(null);
                    }
                } else {
                    ChannelListModel.this.getTopAndSubGroupInfosFromServer(callBack);
                }
            }
        });
    }

    public void getTopAndSubGroupInfosFromServer(final IDataService.IGetTopAndSubInfosCallBack callBack) {
        if (!ChannelDefine.sUnEnableLog && MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)"FTRoomGroupDataService", (String)(this.channelId + ",getTopAndSubChannelInfos FromServer Ver:%s"), (Object[])new Object[]{this.groupData.ver});
        }
        this.requestManager.getTopAndSubGroupInfos(this.channelId, this.groupData.ver, new BaseRequestManager.IGetTopAndSubGroupInfosCallBack(){

            public void onSuccess(List<CInfo> staticInfos, List<CDynamic> dynamicInfos, List<Integer> totalCounts, List<Integer> limitCounts, ThemeItemBean themeItemBean) {
                if (!ChannelDefine.sUnEnableLog && MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)"FTRoomGroupDataService", (String)(ChannelListModel.this.channelId + ",getTopAndSubChannelInfos success"), (Object[])new Object[0]);
                }
                ArrayList<ChannelDetailInfo> subGroupDatas = null;
                if (staticInfos == null || staticInfos.size() <= 0) {
                    return;
                }
                HashMap<String, ChannelPluginData> curPluginInfos = new HashMap<String, ChannelPluginData>();
                subGroupDatas = new ArrayList<ChannelDetailInfo>(staticInfos.size());
                for (int i = 0; i < staticInfos.size(); ++i) {
                    CInfo staticInfoItem = staticInfos.get(i);
                    if (staticInfoItem == null || StringUtils.isEmpty((String)staticInfoItem.cid)) continue;
                    CDynamic dynamicInfoItem = null;
                    if (dynamicInfos != null && dynamicInfos.size() > 0) {
                        for (CDynamic dynamicInfo : dynamicInfos) {
                            if (dynamicInfo == null || !StringUtils.equal((String)dynamicInfo.cid, (String)staticInfoItem.cid)) continue;
                            dynamicInfoItem = dynamicInfo;
                            break;
                        }
                    }
                    ChannelListModel.this.requestManager;
                    subGroupDatas.add(ChannelRequestManager.obtianChannelInfo((CInfo)staticInfoItem, dynamicInfoItem));
                }
                for (CDynamic dynamicInfo : dynamicInfos) {
                    if (dynamicInfo.current_plugin_info.__isDefaultInstance()) continue;
                    String string2 = dynamicInfo.cid;
                    ChannelListModel.this.requestManager;
                    curPluginInfos.put(string2, ChannelRequestManager.obtainPluginData((PluginInfo)dynamicInfo.current_plugin_info, (String)"", (String)""));
                }
                if (subGroupDatas != null) {
                    ((ChannelListModel)ChannelListModel.this).groupData.subGroupDatas = subGroupDatas;
                    ((ChannelListModel)ChannelListModel.this).groupData.curPluginInfos = curPluginInfos;
                }
                ((ChannelListModel)ChannelListModel.this).groupData.limitNumList = limitCounts;
                ((ChannelListModel)ChannelListModel.this).groupData.totalNumList = totalCounts;
                if (callBack != null) {
                    ChannelListData data = new ChannelListData();
                    data.channels = new ArrayList<ChannelDetailInfo>(((ChannelListModel)ChannelListModel.this).groupData.subGroupDatas);
                    data.curPluginInfos = new HashMap<String, ChannelPluginData>(((ChannelListModel)ChannelListModel.this).groupData.curPluginInfos);
                    callBack.onSuccess(ChannelListModel.this.channelId, data, totalCounts, limitCounts, themeItemBean);
                }
                ChannelListModel.this.notifySubGroupsListChanged();
                if (!ChannelDefine.sUnEnableLog && MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)"FTRoomGroupDataService", (String)(ChannelListModel.this.channelId + ",groupData:%s"), (Object[])new Object[]{ChannelListModel.this.groupData != null ? ChannelListModel.this.groupData.toString() : ""});
                }
            }

            public void onError(String gid, int errorCode, String errorTips, Exception e) {
                if (((ChannelListModel)ChannelListModel.this).groupData.subGroupDatas != null && ((ChannelListModel)ChannelListModel.this).groupData.subGroupDatas.size() > 0) {
                    if (callBack != null) {
                        ChannelListData data = new ChannelListData();
                        data.channels = new ArrayList<ChannelDetailInfo>(((ChannelListModel)ChannelListModel.this).groupData.subGroupDatas);
                        data.curPluginInfos = new HashMap<String, ChannelPluginData>(((ChannelListModel)ChannelListModel.this).groupData.curPluginInfos);
                        callBack.onSuccess(ChannelListModel.this.channelId, data, null, null, null);
                    }
                } else if (callBack != null) {
                    callBack.onError(ChannelListModel.this.channelId, errorCode, errorTips, e);
                }
                if (!ChannelDefine.sUnEnableLog) {
                    MLog.error((Object)"FTRoomGroupDataService", (Throwable)e);
                }
            }
        }, false);
    }

    public void onSubGroupAdded() {
        this.getTopAndSubGroupInfosFromServer(new IDataService.IGetTopAndSubInfosCallBack(){

            public void onSuccess(String channelId, ChannelListData data, List<Integer> totalCounts, List<Integer> limitCounts, ThemeItemBean themeItemBean) {
            }

            public void onError(String channelId, int errorCode, String errorTips, Exception e) {
            }
        });
    }

    public void onSubGroupDisbanded(String groupId, long ver) {
        ChannelDetailInfo groupDetailInfo = null;
        if (this.groupData.subGroupDatas != null && this.groupData.subGroupDatas.size() > 0) {
            for (ChannelDetailInfo item : this.groupData.subGroupDatas) {
                if (item == null || !StringUtils.equal((String)groupId, (String)item.baseInfo.gid)) continue;
                groupDetailInfo = item;
                break;
            }
        }
        if (groupDetailInfo != null) {
            this.groupData.subGroupDatas.remove(groupDetailInfo);
            this.notifySubGroupsListChanged();
        }
        if (!ChannelDefine.sUnEnableLog && MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)"FTRoomGroupDataService", (String)"onSubGroupDisbanded:%s", (Object[])new Object[]{groupId});
        }
    }

    private void notifySubGroupsListChanged() {
        if (this.dataListeners == null || this.dataListeners.size() == 0) {
            return;
        }
        if (this.localDataManager != null) {
            this.localDataManager.updateGroupData(this.channelId, this.groupData);
        }
        ChannelListData data = new ChannelListData();
        data.channels = new ArrayList<ChannelDetailInfo>(this.groupData.subGroupDatas);
        data.curPluginInfos = new HashMap<String, ChannelPluginData>(this.groupData.curPluginInfos);
        ChannelInfo channelInfo = this.groupData.getChannelInfo(this.channelId);
        ThemeItemBean themeItemBean = new ThemeItemBean();
        if (channelInfo != null) {
            themeItemBean = channelInfo.partyTheme;
        }
        IDataService.IDataUpdateListener listener = null;
        for (WeakReference<IDataService.IDataUpdateListener> item : this.dataListeners) {
            if (item == null || item.get() == null || (listener = (IDataService.IDataUpdateListener)item.get()) == null) continue;
            listener.onTopAndSubGroupListChange(this.channelId, data, this.groupData.totalNumList, this.groupData.limitNumList, themeItemBean);
        }
    }

    public void addDataListener(IDataService.IDataUpdateListener listener) {
        if (listener == null) {
            return;
        }
        if (this.dataListeners == null) {
            this.dataListeners = new ArrayList(2);
        } else {
            IDataService.IDataUpdateListener listenerReal = null;
            for (WeakReference<IDataService.IDataUpdateListener> item : this.dataListeners) {
                if (item == null || item.get() == null || (listenerReal = (IDataService.IDataUpdateListener)item.get()) != listener) continue;
                return;
            }
        }
        this.dataListeners.add(new WeakReference<IDataService.IDataUpdateListener>(listener));
    }

    public void removeDataListener(IDataService.IDataUpdateListener listener) {
        if (listener == null || this.dataListeners == null || this.dataListeners.size() <= 0) {
            return;
        }
        IDataService.IDataUpdateListener listenerReal = null;
        for (WeakReference<IDataService.IDataUpdateListener> item : this.dataListeners) {
            if (item == null || item.get() == null || (listenerReal = (IDataService.IDataUpdateListener)item.get()) != listener) continue;
            this.dataListeners.remove(item);
            return;
        }
    }

    public void onWsConnect(boolean flag) {
        if (!flag) {
            this.groupData.hasSyncTime = -1L;
        }
    }

    public void onLeaveGroup() {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ((ChannelListModel)ChannelListModel.this).groupData.hasSyncTime = -1L;
            }
        }, (long)1000L);
    }
}

