/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.service.config;

import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.filestorage.FileStorageUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.channel.base.ChannelDefine;
import com.yy.hiyo.channel.base.IChannelCenterService;
import com.yy.hiyo.channel.base.bean.ChannelInfo;
import com.yy.hiyo.channel.base.bean.MyChannelControlConfig;
import com.yy.hiyo.channel.service.request.ChannelRequestManager;
import com.yy.hiyo.channel.service.request.cinfo.CInfoRequestManager;

public class MyChannelConfigModel
implements CInfoRequestManager.IRequestManagerCallBack {
    private static final String FILE_NAME = "MyChannelConfig_";
    private ChannelRequestManager requestManager;
    private MyChannelControlConfig myGroupControlConfig;
    private String configDataStr;
    private boolean hasUpdateFromServer;
    private boolean hasLoadFromFile;
    private IChannelCenterService.IControlConfigOrJoinedChannelsListener callback;
    private long uid;

    public MyChannelConfigModel(ChannelRequestManager requestManager, long uid, IChannelCenterService.IControlConfigOrJoinedChannelsListener callback2) {
        this.callback = callback2;
        this.uid = uid;
        this.requestManager = requestManager;
        CInfoRequestManager.addGlobalCallBack(this);
    }

    public void updateCallBack(IChannelCenterService.IControlConfigOrJoinedChannelsListener callback2) {
        this.callback = callback2;
    }

    public MyChannelControlConfig getControlConfigCache() {
        return this.myGroupControlConfig;
    }

    public void getControlConfig(IChannelCenterService.IGetControlConfigCallBack callBack) {
        if (callBack == null) {
            return;
        }
        if (this.hasUpdateFromServer) {
            callBack.onSuccess(this.myGroupControlConfig != null ? this.myGroupControlConfig : new MyChannelControlConfig());
            return;
        }
        if (this.hasLoadFromFile && this.myGroupControlConfig != null) {
            callBack.onSuccess(this.myGroupControlConfig);
            return;
        }
        YYTaskExecutor.execute(() -> {
            if (!this.hasLoadFromFile) {
                String fileData2 = FileStorageUtils.getInstance().getStrFromFile(true, FILE_NAME + this.uid);
                if (StringUtils.isNotEmpty((String)fileData2)) {
                    this.configDataStr = fileData2;
                    this.myGroupControlConfig = (MyChannelControlConfig)JsonParser.parseJsonObject((String)fileData2, MyChannelControlConfig.class);
                    if (!ChannelDefine.sUnEnableLog && MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)"FTRoomGroupCongfig", (String)"GroupControlConfig:%s", (Object[])new Object[]{this.myGroupControlConfig != null ? this.myGroupControlConfig.toString() : ""});
                    }
                }
                this.hasLoadFromFile = true;
                if (this.myGroupControlConfig != null) {
                    YYTaskExecutor.postToMainThread(() -> callBack.onSuccess(this.myGroupControlConfig));
                    this.getControlConfigFromServer(null);
                    return;
                }
            }
            this.getControlConfigFromServer(callBack);
        });
    }

    public void updateControlConfigFromServer(IChannelCenterService.IGetControlConfigCallBack callBack) {
        this.getControlConfigFromServer(callBack);
    }

    private void getControlConfigFromServer(final IChannelCenterService.IGetControlConfigCallBack callBack) {
        this.requestManager.getControlConfig(new IChannelCenterService.IGetControlConfigCallBack(){

            public void onSuccess(MyChannelControlConfig controlConfig) {
                MyChannelConfigModel.this.myGroupControlConfig = controlConfig;
                if (!ChannelDefine.sUnEnableLog && MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)"FTRoomGroupCongfig", (String)"GroupControlConfig fromServer:%s", (Object[])new Object[]{MyChannelConfigModel.this.myGroupControlConfig != null ? MyChannelConfigModel.this.myGroupControlConfig.toString() : ""});
                }
                MyChannelConfigModel.this.hasUpdateFromServer = true;
                if (callBack != null) {
                    callBack.onSuccess(MyChannelConfigModel.this.myGroupControlConfig);
                }
                YYTaskExecutor.execute(() -> {
                    String newData = JsonParser.toJson((Object)controlConfig);
                    if (!StringUtils.equal((String)MyChannelConfigModel.this.configDataStr, (String)newData)) {
                        YYTaskExecutor.postToMainThread(() -> {
                            if (MyChannelConfigModel.this.callback != null) {
                                MyChannelConfigModel.this.callback.onControlConfigChange();
                            }
                        });
                        MyChannelConfigModel.this.configDataStr = newData;
                        FileStorageUtils.getInstance().saveToFile(true, newData, MyChannelConfigModel.FILE_NAME + MyChannelConfigModel.this.uid);
                    }
                });
            }

            public void onError(int errorCode, String errorTips, Exception e) {
                if (callBack != null) {
                    callBack.onError(errorCode, errorTips, e);
                }
                if (!ChannelDefine.sUnEnableLog) {
                    MLog.error((Object)"FTRoomGroupCongfig", (String)"GroupControlConfig fromServer error:", (Throwable)e, (Object[])new Object[0]);
                }
            }
        });
    }

    @Override
    public void onCreateChannelSuccess(ChannelInfo channelInfo) {
        if (this.myGroupControlConfig == null || StringUtils.isNotEmpty((String)this.myGroupControlConfig.channelId)) {
            return;
        }
        this.hasUpdateFromServer = false;
        this.getControlConfigFromServer(new IChannelCenterService.IGetControlConfigCallBack(){

            public void onSuccess(MyChannelControlConfig controlConfig) {
            }

            public void onError(int errorCode, String errorTips, Exception e) {
            }
        });
    }
}

