/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.voiceroom.plugin.game;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.Observer;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYConstraintLayout;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ScreenUtils;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.plugins.voiceroom.RoomPageContext;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.AbsPluginPresenter;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.game.prepare.GamePreparePresenter;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.game.prepare.GamePrepareView;
import com.yy.hiyo.mvp.base.ICustomView;

public class RoomGameContainer
extends YYConstraintLayout
implements ICustomView {
    private static final String TAG = "FTVoiceRoomRoomGameContainer";
    private YYFrameLayout mGamingContainer;
    private YYFrameLayout mPrepareContainer;
    private GamePrepareView prepareView;
    private boolean destroyed;

    public RoomGameContainer(Context context) {
        super(context);
        this.createView(null);
    }

    public RoomGameContainer(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.createView(attrs);
    }

    public RoomGameContainer(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.createView(attrs);
    }

    public void createView(@Nullable AttributeSet attrs) {
        RoomGameContainer.inflate((Context)this.getContext(), (int)R.layout.room_game_container_channel, (ViewGroup)this);
        this.mGamingContainer = (YYFrameLayout)this.findViewById(R.id.gaming_container);
        this.mPrepareContainer = (YYFrameLayout)this.findViewById(R.id.prepare_container);
    }

    public void setPresenter(AbsPluginPresenter presenter) {
        presenter.getGamingUiData().observe((LifecycleOwner)((RoomPageContext)presenter.getMvpContext()).getLifecycleOwner(), (Observer)new Observer<Boolean>(){

            public void onChanged(@Nullable Boolean isStarted) {
                boolean isGamingVisible = Boolean.TRUE.equals(isStarted);
                RoomGameContainer.this.mGamingContainer.setVisibility(isGamingVisible ? 0 : 8);
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)RoomGameContainer.TAG, (String)"GamingUiData changed isStarted %s", (Object[])new Object[]{isStarted});
                }
                if (!isGamingVisible) {
                    RoomGameContainer.this.mGamingContainer.removeAllViews();
                }
            }
        });
    }

    public void setPreparePresenter(final GamePreparePresenter presenter) {
        presenter.getPrepareUiData().observe((LifecycleOwner)((RoomPageContext)presenter.getMvpContext()).getLifecycleOwner(), (Observer)new Observer<Boolean>(){

            public void onChanged(@Nullable Boolean isVisible) {
                if (RoomGameContainer.this.destroyed) {
                    return;
                }
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)RoomGameContainer.TAG, (String)"PrepareUiData onChanged %s", (Object[])new Object[]{isVisible});
                }
                boolean isPrepare = Boolean.TRUE.equals(isVisible);
                RoomGameContainer.this.mPrepareContainer.setVisibility(isPrepare ? 0 : 8);
                if (isPrepare) {
                    RoomGameContainer.this.initPrepareMode(presenter);
                    if (!(RoomGameContainer.this.mPrepareContainer.getChildAt(0) instanceof GamePrepareView)) {
                        if (RoomGameContainer.this.prepareView != null) {
                            RoomGameContainer.this.prepareView.destroy();
                        }
                        RoomGameContainer.this.mPrepareContainer.removeAllViews();
                        RoomGameContainer.this.prepareView = new GamePrepareView(RoomGameContainer.this.getContext());
                        if (presenter.isChessGameMode()) {
                            RoomGameContainer.this.prepareView.adjustLayoutForChess();
                        } else if (presenter.isAssistGameMode()) {
                            RoomGameContainer.this.prepareView.adjustLayoutForAssistGame();
                        }
                        RoomGameContainer.this.mPrepareContainer.addView((View)RoomGameContainer.this.prepareView);
                        RoomGameContainer.this.prepareView.setPresenter(presenter);
                    }
                } else {
                    RoomGameContainer.this.mPrepareContainer.removeAllViews();
                }
            }
        });
    }

    public YYFrameLayout getGamingContainer() {
        return this.mGamingContainer;
    }

    private void initPrepareMode(GamePreparePresenter preparePresenter) {
        ConstraintLayout.LayoutParams params = (ConstraintLayout.LayoutParams)this.mPrepareContainer.getLayoutParams();
        if (preparePresenter.isChessGameMode()) {
            params.leftMargin = 0;
            params.rightMargin = 0;
            params.height = ScreenUtils.getInstance().getWidthPixels() * 5 / 8;
        } else {
            params.leftMargin = ResolutionUtils.dip2Px((float)10.0f);
            params.rightMargin = ResolutionUtils.dip2Px((float)10.0f);
            params.height = ResolutionUtils.dip2Px((float)150.0f);
        }
        this.mPrepareContainer.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    public void destroy() {
        this.destroyed = true;
        if (this.prepareView != null) {
            this.prepareView.destroy();
        }
    }
}

