/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.voiceroom.plugin;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.OnLifecycleEvent;
import biz.SourceEntry;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.callback.ICommonCallback;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.UserInfoModule;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.widget.YYPlaceHolderView;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.AutoInviteMicUpConfig;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.DateUtils;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.TimeUtils;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.service.IRoleService;
import com.yy.hiyo.channel.cbase.AbsPage;
import com.yy.hiyo.channel.cbase.context.IHolderPresenter;
import com.yy.hiyo.channel.cbase.publicscreen.IPublicScreenService;
import com.yy.hiyo.channel.cbase.publicscreen.callback.IPublicScreenModulePresenter;
import com.yy.hiyo.channel.cbase.publicscreen.msg.PureTextMsg;
import com.yy.hiyo.channel.component.seat.SafeLiveData;
import com.yy.hiyo.channel.component.seat.SeatPresenter;
import com.yy.hiyo.channel.component.seat.bean.SeatItem;
import com.yy.hiyo.channel.component.seat.seattip.SeatTipsPresenter;
import com.yy.hiyo.channel.plugins.voiceroom.AbsRoomPage;
import com.yy.hiyo.channel.plugins.voiceroom.BaseRoomPresenter;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.IPlugin;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.PluginKvoDelegate;
import com.yy.hiyo.channel.publicscreen.BaseImMsg;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.mvp.base.callback.IDestroyable;
import com.yy.hiyo.mvp.base.callback.WeakRunnable;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class AbsPluginPresenter
extends BaseRoomPresenter
implements IPlugin,
IHolderPresenter {
    private static final String TAG = "AbsPluginPresenter";
    private PluginKvoDelegate kvoDelegate;
    protected final MutableLiveData<Boolean> isRunning = new MutableLiveData();
    private MutableLiveData<Boolean> mGamingUiData = new SafeLiveData();
    private int mInviteMicCount;
    private Runnable autoInviteOnSitDownTask = WeakRunnable.of((IDestroyable)this, () -> {
        if (this.getRoomData() == null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"roomdata is null", (Object[])new Object[0]);
            }
            return;
        }
        String gid = this.getRoomData().getGameInfo().getId();
        if (TextUtils.isEmpty((CharSequence)gid)) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"autoInviteOnSitDownTask gid is null", (Object[])new Object[0]);
            }
            return;
        }
        if (this.getChannelDetailInfo().baseInfo.notAutoInviteMicro) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"autoInviteOnSitDownTask gid notAutoInviteMicro switch close", (Object[])new Object[0]);
            }
            return;
        }
        if (SettingFlags.getIntValue((String)"key_refuse_auto_invite_mic") >= 3) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"autoInviteOnSitDownTask user refuse times is 3", (Object[])new Object[0]);
            }
            return;
        }
        try {
            ((SeatPresenter)this.getPresenter(SeatPresenter.class)).autoInviteOnSitDown(gid);
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (String)"autoInviteOnSitDownTask failed", (Throwable)e, (Object[])new Object[0]);
        }
    });
    private Runnable enterWelcomePublicScreenTask = WeakRunnable.of((IDestroyable)this, () -> {
        if (this.getChannel() == null || this.getChannel().getRoleService() == null || this.getRoomData() == null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"addEnterWelcomePublicScreen  null", (Object[])new Object[0]);
            }
            return;
        }
        if (this.getChannelDetailInfo().baseInfo.isAmongUsUser()) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"amongUs not need show", (Object[])new Object[0]);
            }
            return;
        }
        LiveData<List<SeatItem>> seatsLiveData = null;
        try {
            seatsLiveData = ((SeatPresenter)this.getPresenter(SeatPresenter.class)).seats();
        }
        catch (Exception ex) {
            if (RuntimeContext.sIsDebuggable) {
                throw ex;
            }
            MLog.error((Object)TAG, (String)"enterWelcomePublicScreenTask failed getPresenter(SeatPresenter)", (Throwable)ex, (Object[])new Object[0]);
            return;
        }
        List seats = (List)seatsLiveData.getValue();
        UserInfoKS myUserInfo = ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getUserInfo(AccountUtil.getUid(), null);
        if (this.checkIsFromBroadcast(seats, myUserInfo)) {
            return;
        }
        if (FP.empty((Collection)seats) || ((SeatItem)seats.get((int)0)).uid == 0L) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"seat index 0 is empty", (Object[])new Object[0]);
            }
            return;
        }
        long uid = ((SeatItem)seats.get((int)0)).uid;
        if (uid == AccountUtil.getUid()) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"seat index 0 is mySelf", (Object[])new Object[0]);
            }
            return;
        }
        String gid = this.getRoomData().getGameInfo().getId();
        if (TextUtils.isEmpty((CharSequence)gid)) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"addEnterWelcomePublicScreen gid is null", (Object[])new Object[0]);
            }
            return;
        }
        String msg = "";
        if ("chat".equals(gid)) {
            msg = ResourceUtils.getString((int)R.string.channel_enter_welcome_chat);
        } else if ("ktv".equals(gid)) {
            msg = ResourceUtils.getString((int)R.string.channel_enter_welcome_sing);
        } else if (GameInfo.ROOM_GAME_LIST.contains(gid)) {
            msg = ResourceUtils.getString((int)R.string.channel_enter_welcome_play_game);
        } else {
            return;
        }
        int mode = this.getChannel().getPluginService().getCurPluginData().getMode();
        if (mode == 100) {
            msg = ResourceUtils.getString((int)R.string.channel_enter_welcome_play_game);
        }
        this.publicScreenWelcome(myUserInfo, uid, msg);
    });

    public void onPageAttach(AbsRoomPage page, boolean isReAttach) {
        super.onPageAttach((AbsPage)page, isReAttach);
        if (!isReAttach) {
            this.handleModeChange(this.getRoomData().getGameInfo().mode);
            this.kvoDelegate = new PluginKvoDelegate(this);
            this.kvoDelegate.onInit(this.getRoomData().getGameInfo());
            this.addEnterWelcomePublicScreen();
        }
    }

    @Override
    public boolean interceptModeChange() {
        return false;
    }

    @Override
    public void handleModeChange(long mode) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"handleModeChange mode: %s, this %s", (Object[])new Object[]{mode, this});
        }
        if (!this.interceptRunningState()) {
            this.isRunning.setValue((Object)true);
        }
    }

    @Override
    public void handleGameStateChange(boolean started) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"handleGameStateChange started %b, this %s", (Object[])new Object[]{started, this});
        }
    }

    @Override
    public void exit(ICommonCallback<Boolean> callback2) {
    }

    @Override
    public void resumeStateAfterExit() {
        this.handleGameStateChange(false);
    }

    @Override
    public void reLoadGame() {
    }

    @Override
    public void resumePlugin() {
    }

    protected void setGameContainerVisibility(boolean show) {
        this.mGamingUiData.setValue((Object)show);
    }

    protected void setSeatViewVisibility(boolean show) {
        ((SeatPresenter)this.getPresenter(SeatPresenter.class)).setSeatVisibility(show);
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.kvoDelegate != null) {
            this.kvoDelegate.onDestroy();
        }
    }

    @Override
    @NonNull
    public LiveData<Boolean> isRunning() {
        return this.isRunning;
    }

    public LiveData<Boolean> getGamingUiData() {
        return this.mGamingUiData;
    }

    public boolean isCompatible() {
        return true;
    }

    public void setContainer(@NotNull YYPlaceHolderView container) {
    }

    private void addEnterWelcomePublicScreen() {
        YYTaskExecutor.postToMainThread((Runnable)this.enterWelcomePublicScreenTask, (long)1000L);
        this.handleAutoInvitemic();
    }

    private void handleAutoInvitemic() {
        boolean isNewUser;
        AConfigData config = UnifyConfig.INSTANCE.getConfigData(BssCode.AUTO_INVITE_TRIGGER_TIME);
        String startDay = SettingFlags.getStringValue((String)"key_first_enter_channel_day", (String)"");
        this.mInviteMicCount = SettingFlags.getIntValue((String)"key_auto_invite_mic_count", (int)0);
        long lastInviteTime = SettingFlags.getLongValue((String)"key_last_day_auto_invite_mic", (long)0L);
        if (!TimeUtils.isSameDay((long)lastInviteTime, (long)System.currentTimeMillis())) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"autoInviteOnSitDownTask not same day", (Object[])new Object[0]);
            }
            this.mInviteMicCount = 0;
            SettingFlags.setIntValue((String)"key_auto_invite_mic_count", (int)0);
        }
        if (TextUtils.isEmpty((CharSequence)startDay)) {
            String today = DateUtils.dateToString((Date)new Date(), (String)"yyyy-MM-dd");
            SettingFlags.setStringValue((String)"key_first_enter_channel_day", (String)today);
            isNewUser = true;
        } else {
            isNewUser = DateUtils.getIntervalDays((String)startDay) < 3;
        }
        int delayTriggerTime = 30000;
        if (config instanceof AutoInviteMicUpConfig) {
            int count;
            AutoInviteMicUpConfig autoInviteConfig = (AutoInviteMicUpConfig)config;
            int n = count = isNewUser ? autoInviteConfig.getNewUserTriggerMaxCount() : autoInviteConfig.getOldUserTriggerMaxCount();
            if (this.mInviteMicCount >= count) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)("autoInviteOnSitDownTask break already invite count = " + this.mInviteMicCount + ",maxCount = " + count), (Object[])new Object[0]);
                }
                return;
            }
            delayTriggerTime = isNewUser ? autoInviteConfig.getNewUserTriggerTime() : autoInviteConfig.getOldUserTriggerTime();
        }
        YYTaskExecutor.postToMainThread((Runnable)this.autoInviteOnSitDownTask, (long)delayTriggerTime);
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_STOP)
    public void onPageHide() {
        YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.autoInviteOnSitDownTask);
        YYTaskExecutor.removeTask((Runnable)this.enterWelcomePublicScreenTask);
    }

    private void publicScreenWelcome(UserInfoKS myUserInfo, long uid, String msg) {
        IRoleService roleService = this.getChannel().getRoleService();
        IPublicScreenService publicScreenService = (IPublicScreenService)ServiceManagerProxy.getService(IPublicScreenService.class);
        if (publicScreenService == null) {
            return;
        }
        PureTextMsg generateLocalPureTextMsg = publicScreenService.getMsgItemFactory().generateLocalPureTextWelcomeMsg(this.getChannelId(), msg, roleService.getMyRoleCache(), uid, myUserInfo.getNick(), myUserInfo.uid);
        generateLocalPureTextMsg.setMsgState(1);
        try {
            SettingFlags.setBoolean((String)"key_has_sent_welcome_msg", (boolean)true);
            ((IPublicScreenModulePresenter)this.getPresenter(IPublicScreenModulePresenter.class)).getPublicScreenPresenter().appendLocalMsg((BaseImMsg)generateLocalPureTextMsg);
        }
        catch (Exception e) {
            if (RuntimeContext.sIsDebuggable) {
                throw e;
            }
            MLog.error((Object)TAG, (String)"enterWelcomePublicScreenTask appendLocalMsg", (Throwable)e, (Object[])new Object[0]);
        }
    }

    private boolean checkIsFromBroadcast(List<SeatItem> seats, UserInfoKS myUserInfo) {
        if (this.getRoomData().getEnterParam().entry == SourceEntry.SE_FRIEND_BROADCAST.getValue()) {
            HiidoStatis.reportEventNow((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", "audience_screen_welcome_show"));
            String msg = ResourceUtils.getString((int)R.string.channel_enter_welcome);
            if (FP.empty(seats)) {
                this.publicScreenWelcome(myUserInfo, this.getChannelDetailInfo().baseInfo.ownerUid, msg);
                return true;
            }
            long uid = -1L;
            for (SeatItem seat : seats) {
                if (seat.roleType != 15) continue;
                uid = seat.uid;
                break;
            }
            if (uid == AccountUtil.getUid()) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)"FromBroadcast enter room uid is self", (Object[])new Object[0]);
                }
                return false;
            }
            if (uid != -1L) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)("FromBroadcast enter room uid is = " + uid), (Object[])new Object[0]);
                }
                ((SeatTipsPresenter)this.getPresenter(SeatTipsPresenter.class)).showTipsByUidNow(uid, ResourceUtils.getString((int)R.string.short_tips_location_seat, (Object[])new Object[]{myUserInfo.getNick()}));
                return true;
            }
            this.publicScreenWelcome(myUserInfo, this.getChannelDetailInfo().baseInfo.ownerUid, msg);
            return true;
        }
        return false;
    }
}

