/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.module.notice;

import android.content.Context;
import android.graphics.Color;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.scwang.smartrefresh.layout.SmartRefreshLayout;
import com.scwang.smartrefresh.layout.api.RefreshLayout;
import com.scwang.smartrefresh.layout.listener.OnLoadMoreListener;
import com.yy.appbase.ui.widget.bar.SimpleTitleBar;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.utils.ResourceUtils;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.module.notice.ChannelNoticeAdapter;
import com.yy.hiyo.im.base.ChannelNoticeMessage;
import com.yy.hiyo.im.base.ITitleBarListener;
import java.util.ArrayList;
import java.util.List;

public class ChannelNoticeWindow
extends DefaultWindow {
    private SimpleTitleBar mTitleBar;
    private ITitleBarListener mListener;
    private RecyclerView mRvChannelNotice;
    private ChannelNoticeAdapter mAdapter;
    private TextView mTvNoData;
    private SmartRefreshLayout mRefreshLayout;
    private IChannelNoticeListener mChannelNoticeListener;
    private List<ChannelNoticeMessage> mChannelNoticeItemList = new ArrayList<ChannelNoticeMessage>();

    public ChannelNoticeWindow(Context context, UICallBacks callBacks, ITitleBarListener listener, IChannelNoticeListener channelNoticeListener) {
        super(context, callBacks, "ChannelNotice");
        this.mListener = listener;
        this.mChannelNoticeListener = channelNoticeListener;
        this.createView();
    }

    private void createView() {
        View root = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.im_channel_notice_page, this.getBaseLayer(), true);
        this.mRvChannelNotice = (RecyclerView)root.findViewById(R.id.rv_channel_notice);
        this.mAdapter = new ChannelNoticeAdapter(this.mChannelNoticeListener);
        this.mTvNoData = (TextView)root.findViewById(R.id.tv_channel_notice_null);
        this.mRefreshLayout = (SmartRefreshLayout)root.findViewById(R.id.srl_channel_notice_refresh);
        this.mRefreshLayout.setEnableRefresh(false);
        LinearLayoutManager layoutManager = new LinearLayoutManager(this.getContext());
        layoutManager.setOrientation(1);
        this.mRvChannelNotice.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        this.mRvChannelNotice.setAdapter((RecyclerView.Adapter)this.mAdapter);
        this.mAdapter.setData(this.mChannelNoticeItemList);
        this.mTitleBar = (SimpleTitleBar)root.findViewById(R.id.stb);
        this.mTitleBar.setLeftTitle(ResourceUtils.getString((int)R.string.title_channle_notice));
        this.mTitleBar.setLeftBtn(R.drawable.icon_nav_back, new View.OnClickListener(){

            public void onClick(View view) {
                if (ChannelNoticeWindow.this.mListener != null) {
                    ChannelNoticeWindow.this.mListener.onLeftBtnClick(view);
                }
            }
        });
        this.mTitleBar.setRightBtn((CharSequence)ResourceUtils.getString((int)R.string.title_channel_notice_clean), new View.OnClickListener(){

            public void onClick(View v) {
                if (ChannelNoticeWindow.this.mListener != null) {
                    ChannelNoticeWindow.this.mListener.onRightBtnClick(v);
                }
            }
        });
        this.mRefreshLayout.setOnLoadMoreListener(new OnLoadMoreListener(){

            public void onLoadMore(@NonNull RefreshLayout refreshLayout) {
                if (ChannelNoticeWindow.this.mChannelNoticeListener != null) {
                    ChannelNoticeWindow.this.mChannelNoticeListener.onLoad();
                }
                ChannelNoticeWindow.this.mRefreshLayout.finishLoadMore();
            }
        });
    }

    @Nullable
    public View getNeedOffsetView() {
        return this.mTitleBar;
    }

    public boolean isTranslucentBar() {
        return true;
    }

    public boolean isDarkMode() {
        return true;
    }

    public void setData(List<ChannelNoticeMessage> list2) {
        this.mChannelNoticeItemList.clear();
        this.mChannelNoticeItemList.addAll(list2);
        this.mAdapter.setData(this.mChannelNoticeItemList);
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTChannelNotice", (String)"setData:%s", (Object[])new Object[]{list2});
        }
        this.showNoData();
    }

    public void clearData() {
        this.mChannelNoticeItemList.clear();
        this.mAdapter.setData(this.mChannelNoticeItemList);
        this.showNoData();
    }

    public void updateStatus(int index, int status) {
        ChannelNoticeMessage channelNoticeItem = this.mChannelNoticeItemList.get(index);
        channelNoticeItem.setStatus(status);
        this.mChannelNoticeItemList.set(index, channelNoticeItem);
        if (this.mAdapter != null) {
            this.mAdapter.notifyItemChanged(index);
        }
    }

    private void showNoData() {
        if (this.mChannelNoticeItemList != null && this.mChannelNoticeItemList.size() > 0) {
            this.mRefreshLayout.setVisibility(0);
            this.mTvNoData.setVisibility(8);
            this.mRvChannelNotice.setVisibility(0);
        } else {
            this.mRefreshLayout.setVisibility(8);
            this.mTvNoData.setVisibility(0);
            this.mRvChannelNotice.setVisibility(8);
        }
    }

    public void finishLoad() {
        if (this.mRefreshLayout != null) {
            this.mRefreshLayout.finishLoadMore();
        }
    }

    public void stopLoadMore() {
        if (this.mRefreshLayout != null) {
            this.mRefreshLayout.setEnableLoadMore(false);
        }
    }

    public void setClearStatus(boolean canClick) {
        if (this.mTitleBar != null) {
            this.mTitleBar.setRightBtnClickable(canClick);
            int textColor = canClick ? Color.parseColor((String)"#000000") : Color.parseColor((String)"#BBBBBB");
            this.mTitleBar.setRightBtnColor(textColor);
        }
    }

    public static interface IChannelNoticeListener {
        public void onRefuse(int var1);

        public void onAgree(int var1);

        public void onJumpToChannel(String var1, String var2);

        public void onJumpToProfile(long var1, String var3);

        public void onLoad();
    }
}

