/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.module.notice;

import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.ImModule;
import com.yy.appbase.notify.NotificationIdDef;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.utils.FP;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.hiyo.channel.base.IChannelCenterService;
import com.yy.hiyo.channel.base.bean.ChannelNotify;
import com.yy.hiyo.channel.base.bean.NotifyDataDefine;
import com.yy.hiyo.channel.base.callback.IChannelNotifyListener;
import com.yy.hiyo.channel.module.notice.ChannelMessageCreator;
import com.yy.hiyo.im.base.ChannelNoticeMessage;
import java.util.ArrayList;
import java.util.List;

public class ChannelNoticeReceiver {
    private List<String> mMsgIdList = new ArrayList<String>();
    private IChannelNotifyListener mNotifyListener = new IChannelNotifyListener(){

        public void handleNotify(String channelId, ChannelNotify notify2) {
            if (notify2.uri == ChannelNotify.Uri.UriJoinApplyNotify) {
                NotifyDataDefine.JoinApply joinApply;
                ChannelNoticeMessage channelNoticeMessage;
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTChannelNotice", (String)"handleNotify:joinApply, time:%s, msgId:%s, cname:%s", (Object[])new Object[]{notify2.notify.joinApply.getTime(), notify2.notify.joinApply.getMsgId(), notify2.notify.joinApply.getCname()});
                }
                if ((channelNoticeMessage = ChannelMessageCreator.createJoinApplyMsg(joinApply = notify2.notify.joinApply)) == null || !ChannelNoticeReceiver.this.canMsgShow(channelNoticeMessage)) {
                    return;
                }
                channelNoticeMessage.setExtObj((Object)joinApply);
                NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationIdDef.CHANNEL_NOTICE_NEW_MSG, (Object)channelNoticeMessage));
            } else if (notify2.uri == ChannelNotify.Uri.UriJoinApproveNotify) {
                NotifyDataDefine.JoinApprove joinApprove;
                ChannelNoticeMessage channelNoticeMessage;
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTChannelNotice", (String)"handleNotify:joinApprove", (Object[])new Object[0]);
                }
                if ((channelNoticeMessage = ChannelMessageCreator.createJoinApproveMsg(joinApprove = notify2.notify.joinApprove)) == null || !ChannelNoticeReceiver.this.canMsgShow(channelNoticeMessage)) {
                    return;
                }
                ChannelNoticeReceiver.this.checkMsgValid(channelNoticeMessage);
                channelNoticeMessage.setExtObj((Object)joinApprove);
                NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationIdDef.CHANNEL_NOTICE_NEW_MSG, (Object)channelNoticeMessage));
            } else if (notify2.uri == ChannelNotify.Uri.UriSetRoleNotify) {
                NotifyDataDefine.SetRole setRole2;
                ChannelNoticeMessage channelNoticeMessage;
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTChannelNotice", (String)"handleNotify:setRole:%s\uff0c %s", (Object[])new Object[]{notify2.notify.setRole.toString(), notify2.notify.toString()});
                }
                if ((channelNoticeMessage = ChannelMessageCreator.createSetRoleMsg(setRole2 = notify2.notify.setRole)) == null || !ChannelNoticeReceiver.this.canMsgShow(channelNoticeMessage)) {
                    return;
                }
                ChannelNoticeReceiver.this.checkMsgValid(channelNoticeMessage);
                NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationIdDef.CHANNEL_NOTICE_NEW_MSG, (Object)channelNoticeMessage));
            } else if (notify2.uri == ChannelNotify.Uri.UriUserRoleChangeNotify) {
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTChannelNotice", (String)"handleNotify:userRoleChange:%s\uff0c %s", (Object[])new Object[]{notify2.notify.userRoleChange.toString(), notify2.notify.toString()});
                }
                NotifyDataDefine.UserRoleChange userRoleChange = notify2.notify.userRoleChange;
                ChannelNoticeMessage channelNoticeMessage = ChannelMessageCreator.createUserRoleChangeMsg(userRoleChange);
                if (userRoleChange.roleType == 1 && userRoleChange.uid == AccountUtil.getUid()) {
                    ((ImModule)KvoModuleManager.getModule(ImModule.class)).deleteSession(notify2.cid);
                }
                if (channelNoticeMessage == null || !ChannelNoticeReceiver.this.canMsgShow(channelNoticeMessage)) {
                    return;
                }
                ChannelNoticeReceiver.this.checkMsgValid(channelNoticeMessage);
                NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationIdDef.CHANNEL_NOTICE_NEW_MSG, (Object)channelNoticeMessage));
            } else if (notify2.uri == ChannelNotify.Uri.UriAcceptRoleNotify) {
                NotifyDataDefine.AcceptRole acceptRole;
                ChannelNoticeMessage channelNoticeMessage;
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTChannelNotice", (String)"handleNotify:acceptRole:%s\uff0c %s", (Object[])new Object[]{notify2.notify.acceptRole.toString(), notify2.notify.toString()});
                }
                if ((channelNoticeMessage = ChannelMessageCreator.createAcceptRoleMsg(acceptRole = notify2.notify.acceptRole)) == null || !ChannelNoticeReceiver.this.canMsgShow(channelNoticeMessage)) {
                    return;
                }
                ChannelNoticeReceiver.this.checkMsgValid(channelNoticeMessage);
                NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationIdDef.CHANNEL_NOTICE_NEW_MSG, (Object)channelNoticeMessage));
            } else if (notify2.uri == ChannelNotify.Uri.UriDisbandChannel) {
                NotifyDataDefine.DisbandGroup disbandGroup;
                ChannelNoticeMessage channelNoticeMessage;
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTChannelNotice", (String)"handleNotify:disband:%s\uff0c %s", (Object[])new Object[]{notify2.notify.disbandGroup.toString(), notify2.notify.toString()});
                }
                if ((channelNoticeMessage = ChannelMessageCreator.createDisbandChannelMsg(disbandGroup = notify2.notify.disbandGroup)) == null || !ChannelNoticeReceiver.this.canMsgShow(channelNoticeMessage)) {
                    return;
                }
                ChannelNoticeReceiver.this.checkMsgValid(channelNoticeMessage);
                NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationIdDef.CHANNEL_NOTICE_NEW_MSG, (Object)channelNoticeMessage));
                NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationIdDef.CHANNEL_DISBAND_MSG, (Object)notify2.cid));
            } else if (notify2.uri == ChannelNotify.Uri.UriChannelInviteApprove) {
                NotifyDataDefine.InviteApprove inviteApprove;
                ChannelNoticeMessage channelNoticeMessage;
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTChannelNotice", (String)"handleNotify:inviteApprove:%s,  %s", (Object[])new Object[]{notify2.notify.inviteApprove.toString(), notify2.notify.toString()});
                }
                if ((channelNoticeMessage = ChannelMessageCreator.createInviteApproveMsg(inviteApprove = notify2.notify.inviteApprove)) == null || !ChannelNoticeReceiver.this.canMsgShow(channelNoticeMessage)) {
                    return;
                }
                ChannelNoticeReceiver.this.checkMsgValid(channelNoticeMessage);
                NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationIdDef.CHANNEL_NOTICE_NEW_MSG, (Object)channelNoticeMessage));
            } else if (notify2.uri == ChannelNotify.Uri.UriChannelInviteApproveStatus) {
                NotifyDataDefine.InviteApproveStatus inviteApproveStatus;
                ChannelNoticeMessage channelNoticeMessage;
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTChannelNotice", (String)"handleNotify:inviteApproveStatus:%s,  %s", (Object[])new Object[]{notify2.notify.inviteApproveStatus.toString(), notify2.notify.toString()});
                }
                if ((channelNoticeMessage = ChannelMessageCreator.createInviteApproveStatusMsg(inviteApproveStatus = notify2.notify.inviteApproveStatus)) == null || !ChannelNoticeReceiver.this.canMsgShow(channelNoticeMessage)) {
                    return;
                }
                ChannelNoticeReceiver.this.checkMsgValid(channelNoticeMessage);
                NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationIdDef.CHANNEL_NOTICE_NEW_MSG, (Object)channelNoticeMessage));
            }
        }
    };

    public void register() {
        ((IChannelCenterService)ServiceManagerProxy.getServiceManager().getService(IChannelCenterService.class)).addNotifyListener(this.mNotifyListener);
    }

    public void unRegister() {
        ((IChannelCenterService)ServiceManagerProxy.getServiceManager().getService(IChannelCenterService.class)).removeNotifyListener(this.mNotifyListener);
    }

    private boolean canMsgShow(ChannelNoticeMessage msg) {
        return !FP.eq((Object)"hago.game", (Object)msg.getChannelSource());
    }

    private void checkMsgValid(ChannelNoticeMessage channelNoticeMessage) {
        if (channelNoticeMessage == null) {
            return;
        }
        if (this.mMsgIdList.contains(channelNoticeMessage.getMsgId())) {
            FeatureLog.d((String)"FTChannelNotice", (String)"checkMsgValid:%s", (Object[])new Object[]{channelNoticeMessage.getMsgId()});
            channelNoticeMessage.setExtCounts(-1);
        } else {
            channelNoticeMessage.setExtCounts(0);
            this.mMsgIdList.add(channelNoticeMessage.getMsgId());
        }
    }
}

