/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.module.notice;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.appbase.ui.widget.image.CircleImageView;
import com.yy.appbase.ui.widget.image.RoundImageView;
import com.yy.appbase.util.ShortNameUtils;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.TimeUtils;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.module.notice.ChannelNoticeWindow;
import com.yy.hiyo.im.base.ChannelNoticeMessage;
import java.util.ArrayList;
import java.util.List;

public class ChannelNoticeAdapter
extends RecyclerView.Adapter<ChannelNoticeViewHolder> {
    private List<ChannelNoticeMessage> mChannelNoticeItemList = new ArrayList<ChannelNoticeMessage>();
    private ChannelNoticeWindow.IChannelNoticeListener mListener;

    public ChannelNoticeAdapter(ChannelNoticeWindow.IChannelNoticeListener listener) {
        this.mListener = listener;
    }

    public void setData(List<ChannelNoticeMessage> list2) {
        this.mChannelNoticeItemList.clear();
        this.mChannelNoticeItemList.addAll(list2);
        this.notifyDataSetChanged();
    }

    @NonNull
    public ChannelNoticeViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.layout_channel_notice_item, parent, false);
        return new ChannelNoticeViewHolder(view);
    }

    public void onBindViewHolder(@NonNull ChannelNoticeViewHolder holder, final int position) {
        final ChannelNoticeMessage channelNoticeItem = this.mChannelNoticeItemList.get(position);
        LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)holder.channelNoticeLayout.getLayoutParams();
        holder.ivArrow.setVisibility(8);
        holder.channelNoticeLayout.setOnClickListener(null);
        if (channelNoticeItem == null) {
            return;
        }
        if (channelNoticeItem.getStatus() != 0) {
            holder.tvRefuse.setVisibility(8);
            holder.tvAgree.setVisibility(8);
            holder.tvStatus.setVisibility(0);
            holder.tvStatus.setText((CharSequence)this.getStatus(channelNoticeItem));
            if (channelNoticeItem.getStatus() == 2) {
                holder.tvStatus.setText((CharSequence)this.getStatus(channelNoticeItem));
            }
        } else {
            if (channelNoticeItem.getType() == 5 || channelNoticeItem.getType() == 6) {
                holder.tvRefuse.setVisibility(8);
                holder.tvAgree.setVisibility(8);
            } else if ((channelNoticeItem.getType() == 4 || channelNoticeItem.getType() == 1) && channelNoticeItem.getChannelType() == 2) {
                holder.tvRefuse.setVisibility(8);
                holder.tvAgree.setVisibility(8);
            } else {
                holder.tvRefuse.setVisibility(0);
                holder.tvAgree.setVisibility(0);
            }
            holder.tvStatus.setVisibility(8);
            holder.tvAgree.setText((CharSequence)this.getAcceptTips(channelNoticeItem.getType()));
        }
        layoutParams.height = channelNoticeItem.isNeedLarge() ? ResolutionUtils.dip2Px((float)120.0f) : ResolutionUtils.dip2Px((float)80.0f);
        if (channelNoticeItem.isShowChannelHeader()) {
            holder.tvTitle.setText((CharSequence)channelNoticeItem.getChannelName());
            if (channelNoticeItem.getChannelType() == 2) {
                holder.multiAvatar.setVisibility(8);
                holder.rivAvatar.setVisibility(8);
                holder.rvHeader.setVisibility(0);
                if (FP.empty((CharSequence)channelNoticeItem.getChannelAvatar())) {
                    if (channelNoticeItem.getVersion() == 1) {
                        ImageLoader.loadImage((RecycleImageView)holder.rvHeader, (int)R.drawable.ico_default_channel_cover);
                    } else if (channelNoticeItem.getVersion() == 0) {
                        ImageLoader.loadImage((RecycleImageView)holder.rvHeader, (String)channelNoticeItem.getChannelOwnerAvatar());
                    } else {
                        ImageLoader.loadImage((RecycleImageView)holder.rvHeader, (String)channelNoticeItem.getChannelOwnerAvatar());
                    }
                } else {
                    ImageLoader.loadImage((RecycleImageView)holder.rvHeader, (String)channelNoticeItem.getChannelAvatar());
                }
            } else if (channelNoticeItem.getChannelType() == 1) {
                holder.rivAvatar.setVisibility(0);
                holder.multiAvatar.setVisibility(8);
                holder.rvHeader.setVisibility(8);
                ImageLoader.loadImage((RecycleImageView)holder.rivAvatar, (String)channelNoticeItem.getChannelOwnerAvatar());
            }
        } else {
            holder.tvTitle.setText((CharSequence)channelNoticeItem.getFromNick());
            holder.multiAvatar.setVisibility(8);
            holder.rvHeader.setVisibility(0);
            ImageLoader.loadImage((RecycleImageView)holder.rvHeader, (String)channelNoticeItem.getFromAvatar(), (int)R.drawable.icon_avatar_default_male);
            holder.rvHeader.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (ChannelNoticeAdapter.this.mListener != null) {
                        ChannelNoticeAdapter.this.mListener.onJumpToProfile(channelNoticeItem.getFromUid(), channelNoticeItem.getChannelId());
                    }
                }
            });
        }
        holder.tvContent.setText((CharSequence)channelNoticeItem.getContent());
        holder.tvTime.setText((CharSequence)this.getTimeStr(channelNoticeItem.getTs() * 1000L));
        if (channelNoticeItem.getType() != 1 && channelNoticeItem.getType() != 5 && channelNoticeItem.getType() != 4) {
            holder.tvContent.setMaxLines(1);
        } else {
            holder.tvContent.setMaxLines(2);
            if (channelNoticeItem.isNeedJump()) {
                holder.ivArrow.setVisibility(0);
                holder.channelNoticeLayout.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (ChannelNoticeAdapter.this.mListener != null) {
                            ChannelNoticeAdapter.this.mListener.onJumpToChannel(channelNoticeItem.getChannelId(), channelNoticeItem.getChannelPwd());
                        }
                    }
                });
            }
        }
        holder.tvAgree.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ChannelNoticeAdapter.this.mListener != null) {
                    ChannelNoticeAdapter.this.mListener.onAgree(position);
                }
            }
        });
        holder.tvRefuse.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ChannelNoticeAdapter.this.mListener != null) {
                    ChannelNoticeAdapter.this.mListener.onRefuse(position);
                }
            }
        });
    }

    private boolean isShowOperation(int type) {
        return type == 5 || type == 6;
    }

    private String getTimeStr(long time) {
        boolean isSameYear = TimeUtils.isSameYear((long)time, (long)TimeUtils.getServiceRealTime());
        return isSameYear ? TimeUtils.getFormatTimeString((long)time, (String)"mon/day hour:min") : TimeUtils.getFormatTimeString((long)time, (String)"year/mon/day hour:min");
    }

    private String getAcceptTips(int type) {
        if (type == 2 || type == 7) {
            return ResourceUtils.getString((int)R.string.tips_channel_notice_status_agree);
        }
        if (type == 1) {
            return ResourceUtils.getString((int)R.string.tips_channel_notice_status_join);
        }
        return "";
    }

    private String getStatus(ChannelNoticeMessage item) {
        int status = item.getStatus();
        if (status == 2) {
            if (item.getType() == 2 || item.getType() == 4 || item.getType() == 8) {
                return ResourceUtils.getString((int)R.string.tips_channel_notice_status_agreeed);
            }
            if (item.getType() == 3) {
                return ResourceUtils.getString((int)R.string.tips_channel_notice_accept, (Object[])new Object[]{ShortNameUtils.getShortNameWithoutColon((String)item.getOperatorName(), (int)15)});
            }
            return "";
        }
        if (status == 3) {
            return ResourceUtils.getString((int)R.string.tips_channel_notice_status_expired);
        }
        if (status == 1) {
            if (item.getType() == 2 || item.getType() == 4 || item.getType() == 8) {
                return ResourceUtils.getString((int)R.string.tips_channel_notice_status_rejected);
            }
            if (item.getType() == 3) {
                return ResourceUtils.getString((int)R.string.tips_channel_notice_refuse_by, (Object[])new Object[]{ShortNameUtils.getShortNameWithoutColon((String)item.getOperatorName(), (int)15)});
            }
            return "";
        }
        return "";
    }

    public int getItemCount() {
        return this.mChannelNoticeItemList.size();
    }

    static class ChannelNoticeViewHolder
    extends RecyclerView.ViewHolder {
        TextView tvTitle;
        RecycleImageView rvHeader;
        TextView tvContent;
        TextView tvTime;
        TextView tvRefuse;
        TextView tvAgree;
        TextView tvStatus;
        ConstraintLayout channelNoticeLayout;
        RecycleImageView ivArrow;
        View bottomView;
        ConstraintLayout multiAvatar;
        CircleImageView ivAvatar;
        RoundImageView rivAvatar;

        public ChannelNoticeViewHolder(View itemView) {
            super(itemView);
            this.tvTitle = (TextView)itemView.findViewById(R.id.tv_channel_notice_title);
            this.tvContent = (TextView)itemView.findViewById(R.id.tv_channel_notice_content);
            this.tvTime = (TextView)itemView.findViewById(R.id.tv_channel_notice_time);
            this.tvRefuse = (TextView)itemView.findViewById(R.id.tv_channel_notice_refuse);
            this.tvAgree = (TextView)itemView.findViewById(R.id.tv_channel_notice_agree);
            this.rvHeader = (RecycleImageView)itemView.findViewById(R.id.iv_channel_notice_header);
            this.tvStatus = (TextView)itemView.findViewById(R.id.tv_channel_notice_status);
            this.channelNoticeLayout = (ConstraintLayout)itemView.findViewById(R.id.layout_channel_notice);
            this.ivArrow = (RecycleImageView)itemView.findViewById(R.id.iv_channel_notice_arrow);
            this.bottomView = itemView.findViewById(R.id.view_channel_notice_divider);
            this.multiAvatar = (ConstraintLayout)itemView.findViewById(R.id.layout_multi_avatar);
            this.ivAvatar = (CircleImageView)itemView.findViewById(R.id.ivAvatar);
            this.rivAvatar = (RoundImageView)itemView.findViewById(R.id.iv_avatar);
        }
    }
}

