/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.module.myjoined;

import android.content.Context;
import android.os.Message;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.appbase.core.DefaultWindowController;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.ImModule;
import com.yy.appbase.kvomodule.module.UserInfoModule;
import com.yy.appbase.service.callback.OnProfileCallback;
import com.yy.base.logger.MLog;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.Environment;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.hiyo.channel.base.EnterParam;
import com.yy.hiyo.channel.base.IChannelCenterService;
import com.yy.hiyo.channel.base.bean.JoinedChannelInfo;
import com.yy.hiyo.channel.base.bean.MyJoinChannelItem;
import com.yy.hiyo.channel.module.myjoined.ui.JoinedChannelsUiCallback;
import com.yy.hiyo.channel.module.myjoined.ui.JoinedChannelsWindow;
import java.util.ArrayList;
import java.util.List;

public class JoinedChannelsWindowController
extends DefaultWindowController
implements JoinedChannelsUiCallback,
IChannelCenterService.IControlConfigOrJoinedChannelsListener {
    private static final String TAG = "JoinedChannelsWindowController";
    private JoinedChannelsWindow mWindow;

    public JoinedChannelsWindowController(Environment env) {
        super(env);
    }

    public void handleMessage(Message msg) {
        if (msg.what == BaseMsgDef.OPEN_JOINED_CHANNEL) {
            if (this.mWindow != null) {
                this.closeCurrWindow();
            }
            this.openWindow();
        } else {
            super.handleMessage(msg);
        }
    }

    private void openWindow() {
        ((ImModule)KvoModuleManager.getModule(ImModule.class)).updateChannelMsgKeep(true);
        this.mWindow = new JoinedChannelsWindow((Context)this.mContext, this);
        this.mWindowMgr.pushWindow((AbstractWindow)this.mWindow, true);
        this.requestDataForWindow(this.mWindow);
        ((IChannelCenterService)this.getServiceManager().getService(IChannelCenterService.class)).addConfigOrMyJoinedChannelsListener((IChannelCenterService.IControlConfigOrJoinedChannelsListener)this);
    }

    private void requestDataForWindow(JoinedChannelsWindow window) {
        final JoinedChannelsWindow forWindow = window;
        ((IChannelCenterService)this.getServiceManager().getService(IChannelCenterService.class)).getMyJoinedChannels(new IChannelCenterService.IGetMyJoinedChannelsCallBack(){

            public void onSuccess(ArrayList<MyJoinChannelItem> channelSummaries) {
                if (forWindow != JoinedChannelsWindowController.this.mWindow) {
                    return;
                }
                JoinedChannelsWindowController.this.requestChannelOwnerInfo(channelSummaries, forWindow);
            }

            public void onError(int errorCode, Exception e) {
                MLog.error((Object)JoinedChannelsWindowController.TAG, (String)"getMyJoinedChannels error, code=%d, msg=%s", (Object[])new Object[]{errorCode, e.getMessage()});
            }
        }, false);
    }

    private void requestChannelOwnerInfo(final List<MyJoinChannelItem> channelSummaries, JoinedChannelsWindow window) {
        final JoinedChannelsWindow forWindow = window;
        if (channelSummaries == null || channelSummaries.size() == 0) {
            forWindow.updateData(null);
            return;
        }
        ArrayList<Long> uids = new ArrayList<Long>();
        for (MyJoinChannelItem groupSummary : channelSummaries) {
            uids.add(groupSummary.ownerUid);
        }
        ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getUserInfos(uids, new OnProfileCallback(){

            public void onSuccess(int id2, List<UserInfoKS> userInfoKSList) {
                if (forWindow != JoinedChannelsWindowController.this.mWindow) {
                    return;
                }
                if (userInfoKSList == null) {
                    MLog.error((Object)JoinedChannelsWindowController.TAG, (String)"requestChannelOwnerInfo error, response data is null", (Object[])new Object[0]);
                    return;
                }
                ArrayList<JoinedChannelInfo> joinedGroupInfoList = new ArrayList<JoinedChannelInfo>();
                for (MyJoinChannelItem groupSummary : channelSummaries) {
                    JoinedChannelInfo joinedGroupInfo = new JoinedChannelInfo(groupSummary);
                    UserInfoKS ownerInfo = null;
                    for (UserInfoKS userInfoKS : userInfoKSList) {
                        if (userInfoKS.uid != groupSummary.ownerUid) continue;
                        ownerInfo = userInfoKS;
                        break;
                    }
                    if (ownerInfo == null) {
                        MLog.error((Object)JoinedChannelsWindowController.TAG, (String)("requestChannelOwnerInfo error, owner user info not found, " + groupSummary), (Object[])new Object[0]);
                    } else {
                        joinedGroupInfo.avatar = ownerInfo.avatar;
                        joinedGroupInfo.gender = ownerInfo.sex;
                    }
                    joinedGroupInfoList.add(joinedGroupInfo);
                }
                forWindow.updateData(joinedGroupInfoList);
            }

            public void onFail(int id2, String msg, String response) {
                MLog.error((Object)JoinedChannelsWindowController.TAG, (String)"requestChannelOwnerInfo error, msg=%s", (Object[])new Object[]{msg});
            }

            public int id() {
                return 0;
            }
        });
    }

    private void closeCurrWindow() {
        if (this.mWindow != null) {
            this.mWindowMgr.popWindow(true, (AbstractWindow)this.mWindow);
            this.mWindow = null;
        }
    }

    @Override
    public void closeWindow(DefaultWindow window) {
        if (window == this.mWindow) {
            this.closeCurrWindow();
        } else {
            this.mWindowMgr.popWindow(false, (AbstractWindow)window);
        }
    }

    @Override
    public void onGroupClick(JoinedChannelInfo channelInfo) {
        if (channelInfo == null) {
            return;
        }
        EnterParam enterChannelParams = EnterParam.of((String)channelInfo.cid).entry(69).build();
        Message message = Message.obtain();
        message.what = AppbaseMsgDef.ChannelMsgDef.ENTRY_CHANNEL;
        message.obj = enterChannelParams;
        this.sendMessage(message);
    }

    public void onWindowDetach(AbstractWindow abstractWindow) {
        super.onWindowDetach(abstractWindow);
        ((ImModule)KvoModuleManager.getModule(ImModule.class)).updateChannelMsgKeep(false);
        if (abstractWindow == this.mWindow) {
            this.mWindow = null;
        }
    }

    public void onMyJoinedChannelsListChange() {
        if (this.mWindow != null) {
            this.requestDataForWindow(this.mWindow);
        }
    }
}

