/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.module.mini;

import android.content.Context;
import android.os.Build;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.RotateAnimation;
import android.widget.FrameLayout;
import androidx.annotation.Nullable;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.appbase.DpToPxDef;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.UserInfoModule;
import com.yy.appbase.service.callback.OnProfileCallback;
import com.yy.appbase.util.KeyboardHelper;
import com.yy.base.env.RuntimeContext;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.base.utils.LanguageUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.utils.ChannelCoverUtils;
import com.yy.hiyo.channel.cbase.channelhiido.RoomTrack;
import com.yy.hiyo.channel.module.mini.AspectRatioFrameLayout;
import com.yy.hiyo.channel.module.mini.MiniMvp;
import com.yy.hiyo.channel.module.mini.MultiVideoAudioAdapter;
import com.yy.hiyo.channel.module.mini.SizeLocation;
import com.yy.hiyo.mvp.base.ICustomView;
import com.yy.hiyo.voice.base.bean.VideoPositionWrapper;
import com.yy.hiyo.voice.base.channelvoice.CdnPlayerABManager;
import java.util.ArrayList;
import java.util.List;

public class MiniView
extends YYRelativeLayout
implements MiniMvp.IView,
ICustomView,
View.OnTouchListener {
    public static final String TAG = "FTVoice RoomMiniView";
    private MiniMvp.IPresenter mRoomMiniPresenter;
    private YYRelativeLayout mRootLayout;
    private RecycleImageView mRoomAvatarIv;
    private RecycleImageView mRoomCloseIv;
    private RecycleImageView mChannelAvatarIv;
    private RecycleImageView mChannelCloseIv;
    private YYFrameLayout mVideoContainer;
    private YYFrameLayout mMultiVideoContainer;
    private RecycleImageView mVideoCloseIv;
    private RecycleImageView mMultiVideoCloseIv;
    private YYRelativeLayout mVideoLayout;
    private YYRelativeLayout mRoomLayout;
    private YYRelativeLayout mChannelLayout;
    private ConstraintLayout mMultiVideoLayout;
    private RecyclerView mMultiVideoAudioRv;
    private YYLinearLayout mMultiVideoCover1;
    private YYLinearLayout mMultiVideoCover2;
    private MultiVideoAudioAdapter mMultiVideoAudioAdapter;
    private List<VideoPositionWrapper> mMultiVideoAudioList;
    private int mViewType = 0;
    private static final int BORDER_MARGIN = 0;
    private int mLastX;
    private int mLastY;
    private boolean mIsMotionMove = false;
    private KeyboardHelper.OnKeyboardShowListener mOnKeyboardShowListener;
    private int mKeyboardHeight = 0;
    private RotateAnimation mRotateAnimation;
    private String mRoomId = "";

    public MiniView(Context context) {
        super(context);
        this.createView(null);
    }

    public MiniView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.createView(attrs);
    }

    public MiniView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.createView(attrs);
    }

    public void createView(@Nullable AttributeSet attrs) {
        if (CdnPlayerABManager.INSTANCE.shouldRenderDirectToSurface()) {
            MiniView.inflate((Context)this.getContext(), (int)R.layout.layout_min_room_channel_v2, (ViewGroup)this);
        } else {
            MiniView.inflate((Context)this.getContext(), (int)R.layout.layout_min_room_channel, (ViewGroup)this);
        }
        this.setTag(TAG);
        this.mRootLayout = this;
        this.mVideoLayout = (YYRelativeLayout)this.findViewById(R.id.layout_video);
        this.mChannelLayout = (YYRelativeLayout)this.findViewById(R.id.layout_channel);
        this.mRoomLayout = (YYRelativeLayout)this.findViewById(R.id.layout_room);
        this.mMultiVideoLayout = (ConstraintLayout)this.findViewById(R.id.layout_multi_video);
        this.mRoomAvatarIv = (RecycleImageView)this.findViewById(R.id.iv_avatar_room);
        this.mChannelAvatarIv = (RecycleImageView)this.findViewById(R.id.iv_avatar_channel);
        this.mVideoContainer = (YYFrameLayout)this.findViewById(R.id.videoContainer);
        this.mRootLayout.setOnTouchListener((View.OnTouchListener)this);
        this.mRoomCloseIv = (RecycleImageView)this.findViewById(R.id.roomCloseIv);
        this.mChannelCloseIv = (RecycleImageView)this.findViewById(R.id.channelCloseIv);
        this.mVideoCloseIv = (RecycleImageView)this.findViewById(R.id.videoCloseIv);
        this.mMultiVideoContainer = (YYFrameLayout)this.findViewById(R.id.multiVideoContainer);
        this.mMultiVideoCloseIv = (RecycleImageView)this.findViewById(R.id.multiVideoCloseIv);
        this.mMultiVideoAudioRv = (RecyclerView)this.findViewById(R.id.multiVideoAudioRv);
        this.mMultiVideoCover1 = (YYLinearLayout)this.findViewById(R.id.multiVideoCover1);
        this.mMultiVideoCover2 = (YYLinearLayout)this.findViewById(R.id.multiVideoCover2);
        this.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
        this.setKeyboardWatch();
    }

    public void setLocation(int left, int top) {
        if (this.mRootLayout.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
            ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)this.mRootLayout.getLayoutParams();
            layoutParams.leftMargin = left;
            if (Build.VERSION.SDK_INT >= 17) {
                layoutParams.setMarginStart(left);
            }
            layoutParams.topMargin = top;
            this.mRootLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
    }

    public void setMiniViewType(int type) {
        int lastType = this.mViewType;
        this.mViewType = type;
        switch (type) {
            case 1: {
                this.mRoomLayout.setVisibility(8);
                this.mChannelLayout.setVisibility(0);
                this.mVideoLayout.setVisibility(8);
                break;
            }
            case 2: 
            case 3: {
                if (lastType == type) break;
                this.videoType(type == 3);
                break;
            }
            case 4: {
                this.mRoomLayout.setVisibility(8);
                this.mChannelLayout.setVisibility(8);
                this.mVideoLayout.setVisibility(8);
                this.mMultiVideoLayout.setVisibility(0);
                break;
            }
            default: {
                this.mRoomLayout.setVisibility(0);
                this.mChannelLayout.setVisibility(8);
                this.mVideoLayout.setVisibility(8);
            }
        }
    }

    public void setPresenter(MiniMvp.IPresenter presenter) {
        this.mRoomMiniPresenter = presenter;
    }

    public void setAvatar(String url, final long uid) {
        if (!StringUtils.isEmpty((String)url)) {
            ImageLoader.loadImage((RecycleImageView)this.mRoomAvatarIv, (String)(url + YYImageUtils.getThumbnailPostfix((int)75)));
        } else {
            ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getUserInfo(uid, new OnProfileCallback(){

                public void onSuccess(int id2, List<UserInfoKS> userInfoKSList) {
                    UserInfoKS userInfo;
                    if (userInfoKSList != null && userInfoKSList.size() > 0 && (userInfo = userInfoKSList.get(0)) != null && !StringUtils.isEmpty((String)userInfo.avatar)) {
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)MiniView.TAG, (String)"setAvatar userInfo.uid=%d", (Object[])new Object[]{userInfo.uid});
                        }
                        ImageLoader.loadImage((RecycleImageView)MiniView.this.mRoomAvatarIv, (String)(userInfo.avatar + YYImageUtils.getThumbnailPostfix((int)75)));
                    }
                }

                public void onFail(int id2, String msg, String response) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)MiniView.TAG, (String)"setAvatar onFail userInfo.uid=%d, msg=%s, response=%s", (Object[])new Object[]{uid, msg, response});
                    }
                }

                public int id() {
                    return 0;
                }
            });
        }
    }

    public void setAvatarLocal(int res) {
        ImageLoader.loadImage((RecycleImageView)this.mRoomAvatarIv, (int)res);
    }

    public void setChannelCover(String url, int channelVersion, long ownerId) {
        ChannelCoverUtils.INSTANCE.showChannelCover(channelVersion, url, ownerId, this.mChannelAvatarIv);
    }

    private void videoType(boolean isLandscape) {
        this.mRoomLayout.setVisibility(8);
        this.mChannelLayout.setVisibility(8);
        this.mVideoLayout.setVisibility(0);
        SizeLocation pair = this.mRoomMiniPresenter.getLocation();
        int x = pair.x;
        int y = pair.y;
        int right = x + pair.width;
        ViewGroup.LayoutParams lp = this.mVideoLayout.getLayoutParams();
        if (isLandscape) {
            lp.width = ResourceUtils.getDimen((int)R.dimen.channel_mini_video_double_width) * 2;
            lp.height = ResourceUtils.getDimen((int)R.dimen.channel_mini_video_double_height);
        } else {
            lp.width = ResourceUtils.getDimen((int)R.dimen.channel_mini_video_width);
            lp.height = ResourceUtils.getDimen((int)R.dimen.channel_mini_video_height);
        }
        int left = right - lp.width;
        if (left < 0) {
            left = 0;
        }
        this.mRoomMiniPresenter.setLocation(left, y, lp.width, lp.height);
        this.setLocation(left, y);
        this.mVideoLayout.setLayoutParams(lp);
        if (this.mVideoContainer instanceof AspectRatioFrameLayout) {
            AspectRatioFrameLayout aspectRatioFrameLayout = (AspectRatioFrameLayout)this.mVideoContainer;
            if (isLandscape) {
                aspectRatioFrameLayout.setResizeMode(3);
            } else {
                aspectRatioFrameLayout.setResizeMode(1);
            }
        }
        this.requestLayout();
    }

    private void initAnim() {
        this.mRotateAnimation = new RotateAnimation(0.0f, 359.0f, 1, 0.5f, 1, 0.5f);
        this.mRotateAnimation.setRepeatCount(-1);
        this.mRotateAnimation.setRepeatMode(1);
        this.mRotateAnimation.setInterpolator((Interpolator)new LinearInterpolator());
        this.mRotateAnimation.setDuration(8000L);
    }

    public void startAnim() {
        if (this.mRotateAnimation == null) {
            this.initAnim();
        }
        this.mRoomAvatarIv.startAnimation((Animation)this.mRotateAnimation);
    }

    public void stopAnim() {
        if (this.mRoomAvatarIv != null) {
            this.mRoomAvatarIv.clearAnimation();
        }
    }

    public boolean onTouch(View view, MotionEvent event) {
        switch (event.getAction() & 0xFF) {
            case 0: {
                if (RuntimeContext.sIsDebuggable && MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)"ACTION_DOWN", (Object[])new Object[0]);
                }
                this.mLastX = (int)event.getRawX();
                this.mLastY = (int)event.getRawY();
                this.mIsMotionMove = false;
                break;
            }
            case 2: {
                int dx = (int)event.getRawX() - this.mLastX;
                int dy = (int)event.getRawY() - this.mLastY;
                int left = view.getLeft() + dx;
                int top = view.getTop() + dy;
                if (RuntimeContext.sIsDebuggable && MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)"ACTION_MOVE dx=%d, dy=%d", (Object[])new Object[]{dx, dy});
                }
                if (Math.abs(dx) > ViewConfiguration.getTouchSlop() || Math.abs(dy) > ViewConfiguration.getTouchSlop()) {
                    this.mIsMotionMove = true;
                }
                int maxLeft = ResolutionUtils.getScreenWidth((Context)this.getContext()) - this.getWidth() - 0;
                int minLeft = 0;
                int maxTop = ResolutionUtils.getScreenHeight((Context)this.getContext()) - this.mKeyboardHeight - this.getHeight() - ResolutionUtils.dip2Px((float)56.0f);
                if (LanguageUtils.isRtl()) {
                    left = ResolutionUtils.getScreenWidth((Context)this.getContext()) - this.getWidth() - left;
                    if (left >= minLeft && left <= maxLeft && top >= 0 && top <= maxTop) {
                        this.setLocation(left, top);
                        this.mRoomMiniPresenter.setLocation(left, top);
                    }
                } else if (left >= 0 || top >= 0) {
                    if (left > maxLeft) {
                        left = maxLeft;
                    }
                    if (top > maxTop) {
                        top = maxTop;
                    }
                    if (left < minLeft) {
                        left = minLeft;
                    }
                    if (top < 0) {
                        top = 0;
                    }
                    this.setLocation(left, top);
                    this.mRoomMiniPresenter.setLocation(left, top);
                }
                this.mLastX = (int)event.getRawX();
                this.mLastY = (int)event.getRawY();
                break;
            }
            case 1: {
                if (RuntimeContext.sIsDebuggable && MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)"ACTION_UP", (Object[])new Object[0]);
                }
                if (this.mIsMotionMove) break;
                if (this.mViewType == 2 || this.mViewType == 3) {
                    if (LanguageUtils.isRtl()) {
                        if (event.getX() < (float)this.mVideoCloseIv.getWidth() && event.getY() < (float)this.mVideoCloseIv.getHeight()) {
                            this.clickClose();
                            break;
                        }
                        this.clickAvatar();
                        break;
                    }
                    if (event.getX() > (float)(this.getWidth() - this.mVideoCloseIv.getWidth()) && event.getY() < (float)this.mVideoCloseIv.getHeight()) {
                        this.clickClose();
                        break;
                    }
                    this.clickAvatar();
                    break;
                }
                if (this.mViewType == 0) {
                    if (LanguageUtils.isRtl()) {
                        if (event.getX() <= (float)this.mRoomCloseIv.getWidth()) {
                            this.clickClose();
                            break;
                        }
                        this.clickAvatar();
                        break;
                    }
                    if (event.getX() <= (float)this.mRoomAvatarIv.getWidth()) {
                        this.clickAvatar();
                        break;
                    }
                    this.clickClose();
                    break;
                }
                if (this.mViewType == 1) {
                    if (LanguageUtils.isRtl()) {
                        if (event.getX() <= (float)this.mChannelCloseIv.getWidth()) {
                            this.clickClose();
                            break;
                        }
                        this.clickAvatar();
                        break;
                    }
                    if (event.getX() <= (float)this.mChannelAvatarIv.getWidth()) {
                        this.clickAvatar();
                        break;
                    }
                    this.clickClose();
                    break;
                }
                if (this.mViewType != 4) break;
                if (LanguageUtils.isRtl()) {
                    if (event.getX() < (float)(this.mMultiVideoCloseIv.getWidth() + DpToPxDef.RESOLUTION_10_DP) && event.getX() > (float)DpToPxDef.RESOLUTION_10_DP && event.getY() < (float)(this.mMultiVideoCloseIv.getHeight() + DpToPxDef.RESOLUTION_15_DP)) {
                        this.clickClose();
                        break;
                    }
                    this.clickAvatar();
                    break;
                }
                if (event.getX() > (float)(this.getWidth() - this.mMultiVideoCloseIv.getWidth() - DpToPxDef.RESOLUTION_10_DP) && event.getX() < (float)(this.getWidth() - DpToPxDef.RESOLUTION_10_DP) && event.getY() < (float)(this.mMultiVideoCloseIv.getHeight() + DpToPxDef.RESOLUTION_15_DP)) {
                    this.clickClose();
                    break;
                }
                this.clickAvatar();
                break;
            }
        }
        return true;
    }

    public YYFrameLayout getVideoContainer() {
        return this.mVideoContainer;
    }

    public void setVideoRatio(float widthHeightRation) {
        if (this.mVideoContainer instanceof AspectRatioFrameLayout) {
            AspectRatioFrameLayout aspectRatioFrameLayout = (AspectRatioFrameLayout)this.mVideoContainer;
            aspectRatioFrameLayout.setAspectRatio(widthHeightRation);
        }
    }

    public YYFrameLayout getMultiVideoContainer() {
        return this.mMultiVideoContainer;
    }

    public void clickAvatar() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"clickAvatar", (Object[])new Object[0]);
        }
        if (Build.VERSION.SDK_INT >= 30) {
            this.mVideoContainer.removeAllViews();
        }
        this.setVisibility(8);
        if (this.mRoomMiniPresenter != null) {
            this.mRoomMiniPresenter.enterRoom();
        }
        RoomTrack.INSTANCE.smallIconClick(this.mRoomId);
    }

    private void clickClose() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"close click", (Object[])new Object[0]);
        }
        if (this.mRoomMiniPresenter != null) {
            this.mRoomMiniPresenter.exitRoom();
        }
        RoomTrack.INSTANCE.smallIconCloseClick(this.mRoomId);
    }

    private void setKeyboardWatch() {
        this.mOnKeyboardShowListener = new KeyboardHelper.OnKeyboardShowListener((View)this){

            public void onShow(boolean isShowing, int keyboardHeight) {
                if (isShowing) {
                    MiniView.this.mKeyboardHeight = keyboardHeight;
                    if (MiniView.this.mRootLayout.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
                        View parentView;
                        int bottomMargin;
                        ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)MiniView.this.mRootLayout.getLayoutParams();
                        if (MiniView.this.mRootLayout.getParent() != null && (bottomMargin = (parentView = (View)MiniView.this.mRootLayout.getParent()).getHeight() - MiniView.this.mRootLayout.getBottom()) < ResolutionUtils.dip2Px((float)90.0f)) {
                            if (LanguageUtils.isRtl()) {
                                if (Build.VERSION.SDK_INT >= 17) {
                                    MiniView.this.setLocation(layoutParams.getMarginStart(), layoutParams.topMargin - (ResolutionUtils.dip2Px((float)90.0f) - bottomMargin));
                                }
                            } else {
                                MiniView.this.setLocation(layoutParams.leftMargin, layoutParams.topMargin - (ResolutionUtils.dip2Px((float)90.0f) - bottomMargin));
                            }
                        }
                    }
                } else {
                    MiniView.this.mKeyboardHeight = 0;
                }
            }
        };
        KeyboardHelper.watchKeyboardStatus((View)this, (KeyboardHelper.OnKeyboardShowListener)this.mOnKeyboardShowListener);
    }

    public void updateMultiVideoSeat(List<VideoPositionWrapper> list2) {
        if (this.mMultiVideoLayout.getVisibility() != 0 || null == list2) {
            return;
        }
        ArrayList<VideoPositionWrapper> audioList = new ArrayList<VideoPositionWrapper>();
        ArrayList<VideoPositionWrapper> videoList = new ArrayList<VideoPositionWrapper>();
        for (VideoPositionWrapper item : list2) {
            if (null == item) continue;
            if (item.getMState() == 1 || item.getMState() == 3) {
                videoList.add(item);
                continue;
            }
            audioList.add(item);
        }
        if (videoList.size() == 0) {
            this.mMultiVideoCover1.setVisibility(0);
            this.mMultiVideoCover2.setVisibility(0);
        } else if (videoList.size() == 1) {
            this.mMultiVideoCover1.setVisibility(8);
            this.mMultiVideoCover2.setVisibility(0);
        } else {
            this.mMultiVideoCover1.setVisibility(8);
            this.mMultiVideoCover2.setVisibility(8);
        }
        if (null == this.mMultiVideoAudioAdapter) {
            this.mMultiVideoAudioList = new ArrayList<VideoPositionWrapper>(audioList);
            this.mMultiVideoAudioAdapter = new MultiVideoAudioAdapter(this.getContext(), this.mMultiVideoAudioList);
            this.mMultiVideoAudioRv.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext(), 1, false));
            this.mMultiVideoAudioRv.setAdapter((RecyclerView.Adapter)this.mMultiVideoAudioAdapter);
        } else {
            this.mMultiVideoAudioList.clear();
            this.mMultiVideoAudioList.addAll(audioList);
            this.mMultiVideoAudioAdapter.notifyDataSetChanged();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (Build.VERSION.SDK_INT >= 16 && this.mOnKeyboardShowListener != null) {
            KeyboardHelper.unwatchKeyboardStatus((View)this, (KeyboardHelper.OnKeyboardShowListener)this.mOnKeyboardShowListener);
        }
    }

    public void setRoomId(String roomId) {
        this.mRoomId = roomId;
    }
}

