/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.module.main.exit;

import android.os.Message;
import androidx.annotation.Nullable;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.MsgDispatcher;
import com.yy.hiyo.channel.base.IChannelCenterService;
import com.yy.hiyo.channel.base.bean.ChannelDetailInfo;
import com.yy.hiyo.channel.base.bean.ChannelLeaveResp;
import com.yy.hiyo.channel.base.bean.plugins.ChannelPluginData;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.base.service.IRoleService;
import com.yy.hiyo.channel.cbase.utils.ChannelUtils;
import com.yy.hiyo.channel.module.endpage.data.ChannelPluginWrapper;
import com.yy.hiyo.channel.module.endpage.data.LocalEndPageData;

public class ExitResultHelper {
    private static final String TAG = " ExitResultHelper";
    private final String channelId;
    private final String tagName;
    private static ChannelLeaveResp sLastLeaveResp;

    public ExitResultHelper(String channelId, String tagName) {
        this.channelId = channelId;
        this.tagName = tagName;
    }

    public static void checkShowResult(IChannel channel, ChannelLeaveResp leaveResp, ChannelPluginData beforePluginData) {
        ChannelDetailInfo info = channel.getDataService().getChannelDetailInfo(null);
        IRoleService roleService = channel.getRoleService();
        if (sLastLeaveResp != null && sLastLeaveResp.isNetErrorLocalCloseData()) {
            return;
        }
        sLastLeaveResp = leaveResp;
        if (info != null && roleService != null && (!info.baseInfo.isLoopMicRoom() && !info.baseInfo.isGroupParty() && roleService.isMeOwner() || !info.baseInfo.isLoopMicRoom() && info.baseInfo.isGroupParty() && roleService.isMeAnchor() || info.baseInfo.isLoopMicRoom() && channel.getSeatService().lastAnchorIsOwner())) {
            channel.getSeatService().clearCacheAnchor();
            ((IChannelCenterService)ServiceManagerProxy.getServiceManager().getService(IChannelCenterService.class)).getControlConfig(controlConfig -> {
                ExitResultHelper resultHelper = new ExitResultHelper(channel.getChannelId(), StringUtils.notNull((String)info.baseInfo.tag.getFirstTag().getName()));
                resultHelper.onExited(controlConfig.resultConditionMin, true, leaveResp);
            });
            LocalEndPageData traceData = null;
            if (beforePluginData != null && beforePluginData.mode == 14) {
                Object data = channel.getDataService().getLocalEndPageData();
                if (data instanceof LocalEndPageData) {
                    traceData = (LocalEndPageData)data;
                    long curTime = ChannelUtils.getCurrentTime();
                    if (curTime > traceData.getLastTraceTime() && traceData.getLastTraceTime() > 0L) {
                        long interval = (curTime - traceData.getLastTraceTime()) / 1000L;
                        if (beforePluginData.isVideoMode()) {
                            traceData.setLocalVideoShowTime(traceData.getLocalVideoShowTime() + (int)interval);
                        } else {
                            traceData.setLocalAudioShowTime(traceData.getLocalAudioShowTime() + (int)interval);
                        }
                        traceData.setLastTraceTime(0L);
                        traceData.setLocalShowTime(traceData.getLocalAudioShowTime() + traceData.getLocalVideoShowTime());
                    }
                }
                channel.getDataService().setLocalEndPageData(null);
            }
            if (traceData != null) {
                traceData.setLeaveResp(leaveResp);
            }
            ExitResultHelper.showEndPage(traceData, channel.getChannelId(), channel.getVCid(), beforePluginData);
        }
    }

    static void showEndPage(@Nullable LocalEndPageData data, String channelId, String vCid, ChannelPluginData beforePluginData) {
        if (beforePluginData != null) {
            ChannelPluginWrapper wrapper = new ChannelPluginWrapper(beforePluginData, channelId, vCid, data);
            final Message msg1 = new Message();
            msg1.what = AppbaseMsgDef.SHOW_CHANNEL_END_PAGE;
            msg1.arg1 = 2;
            msg1.arg2 = -1;
            msg1.obj = wrapper;
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    MsgDispatcher.getInstance().sendMessage(msg1);
                }
            }, (long)200L);
        }
    }

    public void onExited(int conditionTime, boolean isActive, ChannelLeaveResp leaveRoomData) {
        if (leaveRoomData != null && leaveRoomData.isSuccess() && isActive) {
            int showTime = 0;
            showTime = leaveRoomData.getShowTime() / 60;
            if (conditionTime <= 0) {
                conditionTime = 10;
            }
        }
    }

    public static void resetLast() {
        sLastLeaveResp = null;
    }
}

