/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.module.main.enter.upgard;

import android.content.Context;
import android.view.View;
import android.widget.RelativeLayout;
import com.yy.appbase.SettingFlagKeys;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.data.UserInfoBean;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.callback.OnProfileListCallback;
import com.yy.appbase.ui.dialog.ProgressDialog;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.ToastUtils;
import com.yy.framework.core.ui.BasePanel;
import com.yy.framework.core.ui.PanelLayer;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.IChannelCenterService;
import com.yy.hiyo.channel.base.bean.ChannelDetailInfo;
import com.yy.hiyo.channel.base.bean.ChannelUser;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.base.service.IDataService;
import com.yy.hiyo.channel.base.service.IEnteredChannel;
import com.yy.hiyo.channel.base.service.IRoleService;
import com.yy.hiyo.channel.cbase.channelhiido.RoomTrack;
import com.yy.hiyo.channel.module.main.enter.upgard.IUpgardCallback;
import com.yy.hiyo.channel.module.main.enter.upgard.IUpgardDataCallback;
import com.yy.hiyo.channel.module.main.enter.upgard.IUpgardRetryCallback;
import com.yy.hiyo.channel.module.main.enter.upgard.IUpgardViewCallback;
import com.yy.hiyo.channel.module.main.enter.upgard.UpgardModel;
import com.yy.hiyo.channel.module.main.enter.upgard.bean.UpgardBean;
import com.yy.hiyo.channel.module.main.enter.upgard.ui.UpgardAdapter;
import com.yy.hiyo.channel.module.main.enter.upgard.ui.UpgardDialog;
import com.yy.hiyo.channel.module.main.enter.upgard.ui.UpgardFailDialog;
import com.yy.hiyo.channel.module.main.enter.upgard.ui.UpgardMemberDialog;
import com.yy.hiyo.channel.module.main.enter.upgard.ui.UpgardPanel;
import com.yy.hiyo.mvp.base.BasePresenter;
import com.yy.hiyo.mvp.base.IMvpContext;
import java.util.ArrayList;
import java.util.List;
import okhttp3.Call;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpgardPresenter
extends BasePresenter<IMvpContext> {
    private static final String TAG = "UpgardPresenter";
    public static final int FROM_SETTING = 1;
    public static final int FROM_ROOM = 2;
    private UpgardPanel mUpgardPanel;
    private BasePanel mBasePanel;
    private RelativeLayout.LayoutParams mParams;
    private UpgardModel mModel;
    private DialogLinkManager mDialogLinkManager;
    private Context mContext;
    private PanelLayer mPanelLayer;
    private UpgardMemberDialog mUpgardMemberDialog;
    private int mType;
    private String mChannelId;
    private IChannel mParentChannel;
    private ChannelDetailInfo mParentInfo;
    private List<UpgardBean> mDataList;
    private IUpgardResultCallback mUpgardResultCallback;
    private IUpgardViewCallback mCallback = new IUpgardViewCallback(){

        @Override
        public void onUpgard() {
            RoomTrack.INSTANCE.reportMoveClick();
            ProgressDialog progressDialog2 = new ProgressDialog();
            if (UpgardPresenter.this.mDialogLinkManager != null) {
                UpgardPresenter.this.mDialogLinkManager.showDialog((BaseDialog)progressDialog2);
            }
            if (UpgardPresenter.this.mModel != null && UpgardPresenter.this.mUpgardPanel != null && UpgardPresenter.this.mBasePanel != null && UpgardPresenter.this.mPanelLayer != null) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)UpgardPresenter.TAG, (String)"upgard:%s", (Object[])new Object[]{UpgardPresenter.this.mUpgardPanel.getSelectData()});
                }
                UpgardPresenter.this.mModel.upgard(UpgardPresenter.this.mChannelId, UpgardPresenter.this.mUpgardPanel.getSelectData(), UpgardPresenter.this.mUpgardCallback);
                UpgardPresenter.this.mPanelLayer.hidePanel(UpgardPresenter.this.mBasePanel, true);
            }
        }

        @Override
        public void onCloseClick() {
            RoomTrack.INSTANCE.reportCancelSelectClick();
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)UpgardPresenter.TAG, (String)"close", (Object[])new Object[0]);
            }
            if (UpgardPresenter.this.mBasePanel != null && UpgardPresenter.this.mPanelLayer != null) {
                UpgardPresenter.this.mPanelLayer.hidePanel(UpgardPresenter.this.mBasePanel, true);
            }
        }
    };
    private IUpgardCallback mUpgardCallback = new IUpgardCallback(){

        @Override
        public void onSuccess(String pid) {
            RoomTrack.INSTANCE.reportMoveSuccShow();
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)UpgardPresenter.TAG, (String)("upgard success pid: " + pid), (Object[])new Object[0]);
            }
            UpgardPresenter.this.hideProgressDialog();
            UpgardDialog upgardDialog = new UpgardDialog();
            if (UpgardPresenter.this.mDialogLinkManager != null) {
                UpgardPresenter.this.mDialogLinkManager.showDialog((BaseDialog)upgardDialog);
            }
            if (UpgardPresenter.this.mUpgardResultCallback != null) {
                UpgardPresenter.this.mUpgardResultCallback.onSuccess(pid);
            }
            ((IChannelCenterService)ServiceManagerProxy.getService(IChannelCenterService.class)).getChannel(pid).getRoleService().updateMemberCacheFromServer(pid);
            SettingFlags.setBoolean((String)SettingFlagKeys.hasManualMigrateMemberKey((String)pid), (boolean)true);
        }

        @Override
        public void onFail(long code, @Nullable String reason) {
            RoomTrack.INSTANCE.reportMoveFailShow();
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)UpgardPresenter.TAG, (String)"upgard fail, code:%s, reason\uff1a%s", (Object[])new Object[]{code, reason});
            }
            UpgardPresenter.this.hideProgressDialog();
            UpgardFailDialog upgardFailDialog = new UpgardFailDialog();
            if (UpgardPresenter.this.mDialogLinkManager != null) {
                UpgardPresenter.this.mDialogLinkManager.showDialog((BaseDialog)upgardFailDialog);
            }
            upgardFailDialog.setCallback(new IUpgardRetryCallback(){

                @Override
                public void onRetry() {
                    RoomTrack.INSTANCE.reportMoveFailPopRetryClick();
                    if (UpgardPresenter.this.mParentChannel != null && UpgardPresenter.this.mType == 2) {
                        ProgressDialog progressDialog2 = new ProgressDialog();
                        if (UpgardPresenter.this.mDialogLinkManager != null) {
                            UpgardPresenter.this.mDialogLinkManager.showDialog((BaseDialog)progressDialog2);
                        }
                        UpgardPresenter.this.mParentChannel.getDataService().getChannelDetailInfo(UpgardPresenter.this.mIGetDetailInfoCallBack);
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)UpgardPresenter.TAG, (String)"upgard retry, from_room", (Object[])new Object[0]);
                        }
                    } else if (UpgardPresenter.this.mParentInfo != null && UpgardPresenter.this.mType == 1 && UpgardPresenter.this.mDataList != null && UpgardPresenter.this.mDataList.size() > 0) {
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)UpgardPresenter.TAG, (String)"upgard retry, from_setting", (Object[])new Object[0]);
                        }
                        if (UpgardPresenter.this.mUpgardPanel == null) {
                            UpgardPresenter.this.mUpgardPanel = new UpgardPanel(UpgardPresenter.this.mContext);
                        }
                        UpgardPresenter.this.showContent();
                        UpgardPresenter.this.mUpgardPanel.setListener(UpgardPresenter.this.mListener);
                        UpgardPresenter.this.mUpgardPanel.updateInfo(UpgardPresenter.this.mParentInfo);
                        UpgardPresenter.this.mUpgardPanel.updateData(UpgardPresenter.this.mDataList);
                    }
                }
            });
        }
    };
    private IDataService.IGetDetailInfoCallBack mIGetDetailInfoCallBack = new IDataService.IGetDetailInfoCallBack(){

        public void onSuccess(final String channelId, final ChannelDetailInfo info) {
            MLog.debug((Object)UpgardPresenter.TAG, (String)"GetDetailInfo success channelId: %s, detail: %s", (Object[])new Object[]{channelId, info});
            if (info != null && info.baseInfo.ownerUid == AccountUtil.getUid() && info.baseInfo.version == 1) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)UpgardPresenter.TAG, (String)"GetDetailInfo success:%s", (Object[])new Object[]{info});
                }
                UpgardPresenter.this.mChannelId = info.baseInfo.gid;
                UpgardPresenter.this.mUpgardPanel.setListener(UpgardPresenter.this.mListener);
                UpgardPresenter.this.mModel.getUpgardChannel(info.baseInfo.gid, new IUpgardDataCallback(){

                    @Override
                    public void onSuccess(boolean firstToggleAutoMigrate, @NotNull List<UpgardBean> mutableList) {
                        UpgardPresenter.this.hideProgressDialog();
                        if (UpgardPresenter.this.mType == 2) {
                            SettingFlags.setBoolean((String)SettingFlagKeys.hasRequestNeedMigrateKey((String)channelId), (boolean)true);
                        }
                        if (mutableList != null && mutableList.size() > 0) {
                            if (UpgardPresenter.this.mType == 2) {
                                SettingFlags.setBoolean((String)("key_first_enter_channel" + AccountUtil.getUid()), (boolean)false);
                            }
                            UpgardPresenter.this.showContent();
                            if (UpgardPresenter.this.mUpgardPanel != null) {
                                UpgardPresenter.this.mUpgardPanel.updateInfo(info);
                                UpgardPresenter.this.mUpgardPanel.updateData(mutableList);
                            }
                        } else if (firstToggleAutoMigrate) {
                            SettingFlags.setBoolean((String)SettingFlagKeys.hasToggleAutoMigrateKey((String)info.baseInfo.gid), (boolean)true);
                        }
                    }

                    @Override
                    public void onFail(long code, @Nullable String reason) {
                        UpgardPresenter.this.hideProgressDialog();
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)UpgardPresenter.TAG, (String)"getUpgardChannel fail, code:%s, reason:%s", (Object[])new Object[]{code, reason});
                        }
                        ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)ResourceUtils.getString((int)R.string.check_network_and_retry), (int)0);
                    }
                });
            }
        }

        public void onError(String channelId, int errorCode, String errorTips, Exception e) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)UpgardPresenter.TAG, (String)"GetDetailInfo error, code:%s, reason:%s", (Object[])new Object[]{errorCode, errorTips});
            }
            UpgardPresenter.this.hideProgressDialog();
            ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)ResourceUtils.getString((int)R.string.check_network_and_retry), (int)0);
        }
    };
    private UpgardAdapter.IContentClickListener mListener = new UpgardAdapter.IContentClickListener(){

        @Override
        public void onNumberClick(@NotNull String cid) {
            if (UpgardPresenter.this.mUpgardMemberDialog == null) {
                UpgardPresenter.this.mUpgardMemberDialog = new UpgardMemberDialog();
            }
            if (UpgardPresenter.this.mDialogLinkManager != null) {
                UpgardPresenter.this.mDialogLinkManager.showDialog((BaseDialog)UpgardPresenter.this.mUpgardMemberDialog);
            }
            UpgardPresenter.this.mUpgardMemberDialog.showLoading();
            ((IChannelCenterService)ServiceManagerProxy.getService(IChannelCenterService.class)).getChannel(cid).getRoleService().getMemberAndMasterList(Integer.MAX_VALUE, 0, new IRoleService.IGetUserListCallBack(){

                public void onSuccess(IChannel channel, long total, List<ChannelUser> members) {
                    if (total == 0L) {
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)UpgardPresenter.TAG, (String)"onNumberClick total 0", (Object[])new Object[0]);
                        }
                        if (UpgardPresenter.this.mUpgardMemberDialog != null) {
                            UpgardPresenter.this.mUpgardMemberDialog.setData(null);
                            return;
                        }
                    }
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)UpgardPresenter.TAG, (String)"onNumberClick success:%s", (Object[])new Object[]{members});
                    }
                    ArrayList<Long> uidList = new ArrayList<Long>();
                    for (ChannelUser user : members) {
                        if (user.uid == AccountUtil.getUid()) continue;
                        uidList.add(user.uid);
                    }
                    ((IUserInfoService)ServiceManagerProxy.getService(IUserInfoService.class)).getUserInfo(uidList, new OnProfileListCallback(){

                        public void onUISuccess(List<UserInfoBean> userInfo) {
                            if (MLog.isLogLevelBlowInfo()) {
                                MLog.info((Object)UpgardPresenter.TAG, (String)"fetch userInfo success", (Object[])new Object[0]);
                            }
                            if (UpgardPresenter.this.mUpgardMemberDialog != null) {
                                UpgardPresenter.this.mUpgardMemberDialog.setData(userInfo);
                            }
                        }

                        public void onError(Call call, Exception e, int id2) {
                            if (MLog.isLogLevelBlowInfo()) {
                                MLog.info((Object)UpgardPresenter.TAG, (String)"fetch userInfo error:%s", (Object[])new Object[]{e});
                            }
                            ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)ResourceUtils.getString((int)R.string.check_network_and_retry), (int)0);
                        }

                        public void onResponseError(int id2, String message, String response) {
                            if (MLog.isLogLevelBlowInfo()) {
                                MLog.info((Object)UpgardPresenter.TAG, (String)"fetch userInfo error:%s", (Object[])new Object[]{response});
                            }
                            ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)ResourceUtils.getString((int)R.string.check_network_and_retry), (int)0);
                        }
                    });
                }

                public void onError(IChannel channel, int errorCode, String errorTips, Exception e) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)UpgardPresenter.TAG, (String)"onNumberClick error, code:%s, reason:%s", (Object[])new Object[]{errorCode, errorTips});
                    }
                    if (UpgardPresenter.this.mUpgardMemberDialog != null) {
                        UpgardPresenter.this.mUpgardMemberDialog.setData(null);
                    }
                    ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)ResourceUtils.getString((int)R.string.check_network_and_retry), (int)0);
                }
            });
        }
    };

    public void onDestroy() {
        super.onDestroy();
        if (this.mDialogLinkManager != null) {
            this.mDialogLinkManager.dismissDialog();
        }
    }

    private void hideProgressDialog() {
        if (this.mDialogLinkManager != null) {
            this.mDialogLinkManager.dismissDialog();
        }
    }

    private void showContent() {
        this.createBasePanel();
        this.mBasePanel.setContent((View)this.mUpgardPanel, this.mParams);
        this.mPanelLayer.showPanel(this.mBasePanel, true);
        RoomTrack.INSTANCE.reportMovePopShow();
    }

    private void createBasePanel() {
        this.mParams = new RelativeLayout.LayoutParams(-1, -2);
        this.mParams.addRule(12);
        this.mBasePanel = new BasePanel(this.mContext);
        this.mBasePanel.setShowAnim(this.mBasePanel.createBottomShowAnimation());
        this.mBasePanel.setHideAnim(this.mBasePanel.createBottomHideAnimation());
    }

    public void show(Context context, IEnteredChannel channel, PanelLayer panelLayer, int type) {
        this.mContext = context;
        this.mPanelLayer = panelLayer;
        this.mType = type;
        this.mModel = new UpgardModel();
        this.mParentChannel = channel.getTopChannel();
        if (this.mUpgardPanel == null) {
            this.mUpgardPanel = new UpgardPanel(context);
        }
        this.mUpgardPanel.reset();
        this.mUpgardPanel.setCallback(this.mCallback);
        if (this.mDialogLinkManager == null) {
            this.mDialogLinkManager = new DialogLinkManager(context);
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"show from_room topId %s", (Object[])new Object[]{this.mParentChannel.getChannelId()});
        }
        this.mParentChannel.getDataService().fetchChannelDetailInfo(this.mIGetDetailInfoCallBack);
    }

    public void show(Context context, List<UpgardBean> mutableList, PanelLayer panelLayer, ChannelDetailInfo info) {
        this.mContext = context;
        this.mPanelLayer = panelLayer;
        this.mType = 1;
        if (this.mUpgardPanel == null) {
            this.mUpgardPanel = new UpgardPanel(context);
        }
        this.mUpgardPanel.reset();
        this.mUpgardPanel.setCallback(this.mCallback);
        if (this.mDialogLinkManager == null) {
            this.mDialogLinkManager = new DialogLinkManager(context);
        }
        this.mModel = new UpgardModel();
        this.mParentInfo = info;
        this.mChannelId = info.baseInfo.gid;
        this.mDataList = mutableList;
        if (mutableList != null && mutableList.size() > 0) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"show from_setting", (Object[])new Object[0]);
            }
            this.showContent();
            this.mUpgardPanel.setListener(this.mListener);
            if (this.mUpgardPanel != null) {
                this.mUpgardPanel.updateInfo(info);
                this.mUpgardPanel.updateData(mutableList);
            }
        }
    }

    public void setResultCallback(IUpgardResultCallback callback2) {
        this.mUpgardResultCallback = callback2;
    }

    public static interface IUpgardResultCallback {
        public void onSuccess(String var1);
    }
}

