/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.module.main.enter.gameenter.roomgamematch.mvp;

import android.content.Context;
import android.os.Bundle;
import android.os.CountDownTimer;
import android.os.Message;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.core.MsgDispatcher;
import com.yy.hiyo.channel.module.main.enter.gameenter.roomgamematch.ChannelGameMatchMsgDef;
import com.yy.hiyo.channel.module.main.enter.gameenter.roomgamematch.mvp.RoomGameMatchMvp;
import com.yy.hiyo.game.base.bean.GameInfo;

public class RoomGameMatchModel
implements RoomGameMatchMvp.IRoomGameMatchModel {
    private static final String TAG = "RoomGameMatchModel";
    private CountDownTimer mTimer;
    private GameInfo mGameInfo;
    private Bundle mArgs;

    @Override
    public void startMatch(GameInfo gameInfo, Bundle args, RoomGameMatchMvp.CallBack<String, Integer, Integer> callBack) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"startMatch", (Object[])new Object[0]);
        }
        if (!NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
            callBack.onError("net error");
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"startMatch net error", (Object[])new Object[0]);
            }
            return;
        }
        this.mGameInfo = gameInfo;
        this.mArgs = args;
        if (this.mGameInfo == null) {
            return;
        }
    }

    @Override
    public void cancelMatch() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"cancelMatch", (Object[])new Object[0]);
        }
        this.resetTimer();
        if (this.mGameInfo == null) {
            return;
        }
    }

    @Override
    public void quickMatchHeartBeanReq(RoomGameMatchMvp.CallBack<String, Integer, Integer> callBack) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"quickMatchHeartBeanReq", (Object[])new Object[0]);
        }
        if (!NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
            callBack.onError("net error");
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"quickMatchHeartBeanReq net error", (Object[])new Object[0]);
            }
            return;
        }
        if (this.mGameInfo == null) {
            return;
        }
    }

    private void startMatchHeadBeanReq(long time) {
        if (this.mTimer == null) {
            this.initTimer(time);
        }
        this.mTimer.start();
    }

    private void initTimer(long time) {
        long millisecond = time * 1000L;
        this.mTimer = new CountDownTimer(Long.MAX_VALUE, millisecond){

            public void onTick(long l) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        RoomGameMatchModel.this.quickMatchHeartBeanReq(new RoomGameMatchMvp.CallBack<String, Integer, Integer>(){

                            @Override
                            public void onError(String data) {
                                RoomGameMatchModel.this.cancelMatch();
                                Message message = new Message();
                                message.what = ChannelGameMatchMsgDef.EXIT_ROOM_GAME_MATCH_WINDOW;
                                MsgDispatcher.getInstance().sendMessage(message);
                            }

                            @Override
                            public void onResponse(Integer result1, Integer result2) {
                            }
                        });
                    }
                });
            }

            public void onFinish() {
            }
        };
    }

    private void resetTimer() {
        if (this.mTimer != null) {
            this.mTimer.cancel();
            this.mTimer = null;
        }
    }
}

