/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.module.main.enter.gameenter.roomgamematch;

import android.content.Context;
import android.os.Message;
import android.view.View;
import com.yy.appbase.core.DefaultWindowController;
import com.yy.base.logger.MLog;
import com.yy.framework.core.Environment;
import com.yy.framework.core.Notification;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.hiyo.channel.base.IRoomService;
import com.yy.hiyo.channel.module.main.enter.gameenter.roomgamematch.ChannelGameMatchMsgDef;
import com.yy.hiyo.channel.module.main.enter.gameenter.roomgamematch.RoomGameMatchPage;
import com.yy.hiyo.channel.module.main.enter.gameenter.roomgamematch.RoomGameMatchWindow;
import com.yy.hiyo.channel.module.main.enter.gameenter.roomgamematch.mvp.RoomGameMatchPresenter;
import com.yy.hiyo.game.base.bean.GameInfo;

public class RoomGameMatchController
extends DefaultWindowController {
    private static final String TAG = "RoomGameMatchController";
    private RoomGameMatchWindow mRoomGameMatchWindow;
    private RoomGameMatchPresenter mRoomGameMatchPresenter;

    public RoomGameMatchController(Environment env) {
        super(env);
    }

    public void notify(Notification notification) {
        super.notify(notification);
    }

    public void handleMessage(Message msg) {
        super.handleMessage(msg);
        if (msg.what == ChannelGameMatchMsgDef.OPEN_ROOM_GAME_MATCH_WINDOW) {
            this.enterMatchGamePage(msg);
        } else if (msg.what == ChannelGameMatchMsgDef.EXIT_ROOM_GAME_MATCH_WINDOW) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"exitRoomGameMatch", (Object[])new Object[0]);
            }
            this.exitRoomGameMatch();
        } else if (msg.what == ChannelGameMatchMsgDef.EXIT_ROOM_GAME_MATCH_WINDOW_NO_ANIM) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"exitRoomGameMatchNOAnim", (Object[])new Object[0]);
            }
            this.exitRoomGameMatchNOAnim();
        } else if (msg.what == ChannelGameMatchMsgDef.CANCEL_MATCH) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"cancelMatch", (Object[])new Object[0]);
            }
            if (this.mRoomGameMatchPresenter != null) {
                this.mRoomGameMatchPresenter.cancelMatch();
            }
            this.exitRoomGameMatch();
        }
    }

    private void enterMatchGamePage(Message msg) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"enterMatchGamePage", (Object[])new Object[0]);
        }
        ((IRoomService)this.getServiceManager().getService(IRoomService.class)).exitRoom();
        this.mRoomGameMatchWindow = (RoomGameMatchWindow)this.getWindow();
        this.mRoomGameMatchWindow.getRoomGameMatchPage().setUICallBack(new RoomGameMatchPage.UICallBack(){

            @Override
            public void onExitRoomGame() {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)RoomGameMatchController.TAG, (String)"onExitRoomGame", (Object[])new Object[0]);
                }
                RoomGameMatchController.this.exitRoomGameMatch();
            }
        });
        if (msg.obj instanceof GameInfo) {
            GameInfo gameInfo = (GameInfo)msg.obj;
            this.mRoomGameMatchPresenter = this.getPresenter();
            this.mRoomGameMatchPresenter.setView((View)this.mRoomGameMatchWindow.getRoomGameMatchPage());
            this.mRoomGameMatchPresenter.setData(gameInfo);
            this.mRoomGameMatchPresenter.initUser();
            this.mRoomGameMatchPresenter.startMatch(gameInfo, msg.getData());
        }
        this.mWindowMgr.pushWindow((AbstractWindow)this.mRoomGameMatchWindow, true);
    }

    private void exitRoomGameMatch() {
        if (this.mRoomGameMatchWindow != null) {
            this.mWindowMgr.popWindow(true, (AbstractWindow)this.mRoomGameMatchWindow);
        }
    }

    private void exitRoomGameMatchNOAnim() {
        if (this.mRoomGameMatchWindow != null) {
            this.mWindowMgr.popWindow(false, (AbstractWindow)this.mRoomGameMatchWindow);
        }
    }

    private DefaultWindow getWindow() {
        if (this.mRoomGameMatchWindow == null) {
            return new RoomGameMatchWindow((Context)this.mContext, (UICallBacks)this, "RoomGameMatchWindow");
        }
        return this.mRoomGameMatchWindow;
    }

    private RoomGameMatchPresenter getPresenter() {
        if (this.mRoomGameMatchPresenter == null) {
            this.mRoomGameMatchPresenter = new RoomGameMatchPresenter(this.getServiceManager());
            return this.mRoomGameMatchPresenter;
        }
        return this.mRoomGameMatchPresenter;
    }

    public void onWindowDetach(AbstractWindow abstractWindow) {
        super.onWindowDetach(abstractWindow);
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"onWindowDetach", (Object[])new Object[0]);
        }
        this.mRoomGameMatchWindow = null;
        if (this.mRoomGameMatchPresenter != null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"presenter cancel", (Object[])new Object[0]);
            }
            this.mRoomGameMatchPresenter.cancelMatch();
            this.mRoomGameMatchPresenter.cleatData();
            this.mRoomGameMatchPresenter = null;
        }
    }
}

