/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.module.main.enter.agreement;

import android.content.Context;
import android.text.method.MovementMethod;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.appbase.service.IWebService;
import com.yy.appbase.span.ChainSpan;
import com.yy.appbase.ui.utils.CrashCatchLinkMovementMethod;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.framework.core.ui.dialog.frame.YYDialog.YYDialog;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.cbase.channelhiido.RoomTrack;
import com.yy.hiyo.channel.module.main.enter.agreement.AgreementAdapter;
import java.util.ArrayList;
import java.util.List;

public class AgreementDialog
extends YYDialog
implements View.OnClickListener {
    private View mView;
    private YYTextView moreTv;
    private Context mContext;
    private List<String> mList;
    private Callback mCallback;
    private IWebService mWebService;

    public AgreementDialog(@NonNull Context context) {
        super(context, R.style.normal_yydialog);
        this.mContext = context;
        this.init();
        RoomTrack.INSTANCE.reportAgreementShow();
    }

    private void init() {
        this.mList = new ArrayList<String>();
        this.mList.add(ResourceUtils.getString((int)R.string.tips_room_agreement_1));
        this.mList.add(ResourceUtils.getString((int)R.string.tips_room_agreement_2));
        this.mList.add(ResourceUtils.getString((int)R.string.tips_room_agreement_3));
        this.mList.add(ResourceUtils.getString((int)R.string.tips_room_agreement_4));
        this.mList.add(ResourceUtils.getString((int)R.string.tips_channel_agreement_5));
        this.mView = View.inflate((Context)this.mContext, (int)R.layout.dialog_agreement_channel, null);
        ViewGroup.LayoutParams contentLp = new ViewGroup.LayoutParams(ResolutionUtils.getScreenWidth((Context)this.mContext) * 5 / 6, -2);
        this.setContentView(this.mView, contentLp);
        this.moreTv = (YYTextView)this.mView.findViewById(R.id.tv_more);
        this.moreTv.setMovementMethod((MovementMethod)CrashCatchLinkMovementMethod.getInstance());
        ChainSpan chainSpan = ChainSpan.of();
        chainSpan.beginBlock().append((CharSequence)ResourceUtils.getString((int)R.string.short_tips_terms_of_service)).onBlockClick(() -> {
            this.moreTv.setHighlightColor(ResourceUtils.getColor((int)17170445));
            this.dismiss();
            if (this.mWebService != null) {
                this.mWebService.loadUrl("https://www.ihago.net/a/license/register-user-android.html", "");
            }
        }, true, ResourceUtils.getColor((int)R.color.color_333333)).endBlock().space().append((CharSequence)"&").space().beginBlock().append((CharSequence)ResourceUtils.getString((int)R.string.short_tips_privacy_policy)).onBlockClick(() -> {
            this.moreTv.setHighlightColor(ResourceUtils.getColor((int)17170445));
            this.dismiss();
            if (this.mWebService != null) {
                this.mWebService.loadUrl("https://www.ihago.net/a/license/register-policy-android.html", "");
            }
        }, true, ResourceUtils.getColor((int)R.color.color_333333)).endBlock().onFinish(text -> {
            if (this.moreTv != null) {
                this.moreTv.setText((CharSequence)text);
            }
        }).build();
        this.mView.findViewById(R.id.iv_close).setOnClickListener((View.OnClickListener)this);
        this.mView.findViewById(R.id.btn_agree).setOnClickListener((View.OnClickListener)this);
        RecyclerView rv = (RecyclerView)this.mView.findViewById(R.id.rv_agreement);
        DividerItemDecoration itemDecoration = new DividerItemDecoration(this.mContext, 1);
        itemDecoration.setDrawable(ResourceUtils.getDrawable((int)R.drawable.shape_agreement_divider));
        rv.addItemDecoration((RecyclerView.ItemDecoration)itemDecoration);
        rv.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.mContext));
        rv.setAdapter((RecyclerView.Adapter)new AgreementAdapter(this.mContext, this.mList));
    }

    public void onClick(View v) {
        if (v.getId() == R.id.iv_close) {
            if (null != this.mCallback) {
                this.mCallback.onCancel();
            }
            RoomTrack.INSTANCE.reportAgreementCancelClick();
            this.dismiss();
        } else if (v.getId() == R.id.btn_agree) {
            if (null != this.mCallback) {
                this.mCallback.onClickAgree();
            }
            RoomTrack.INSTANCE.reportAgreementOKClick();
            this.dismiss();
        }
    }

    public void dismissByCancel() {
        if (!this.isShowing()) {
            return;
        }
        if (null != this.mCallback) {
            this.mCallback.onCancel();
        }
        this.dismiss();
    }

    public void setOnCallback(Callback callback2) {
        this.mCallback = callback2;
    }

    public void setWebService(IWebService webService) {
        this.mWebService = webService;
    }

    public static interface Callback {
        public void onClickAgree();

        default public void onCancel() {
        }
    }
}

