/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.module.main.enter;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.text.TextUtils;
import com.bumptech.glide.load.DecodeFormat;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.transform.BlurTransformation;
import com.yy.base.imageloader.transform.YYBitmapTransformation;
import com.yy.base.imageloader.transform.YYCenterCrop;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ScreenUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.EnterParam;
import javax.annotation.Nullable;

public class LoadingBgHellper {
    public static final int BG_BLUR_RADIUS = 20;
    private static final String TAG = "LoadingBgHellper";
    private static String sCacheCoverUrl = "";

    private LoadingBgHellper() {
    }

    public static int getLoadingBgDefaultResId() {
        MLog.debug((Object)TAG, (String)"getLoadingBgDefaultResId", (Object[])new Object[0]);
        return R.drawable.icon_end_page_bg;
    }

    public static void preloadLoadingBgBy(Context context, EnterParam param2) {
        if (param2 == null) {
            return;
        }
        String url = (String)param2.getExtra("live_cover_url", (Object)"");
        if (StringUtils.isEmpty((String)url)) {
            return;
        }
        LoadingBgHellper.preloadLoadingBg(context, url);
    }

    public static void removedBgFromCacheBy(@Nullable String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return;
        }
        LoadingBgHellper.removeBgFromCache(url);
    }

    public static void preloadLoadingBg(Context context, String url) {
        BitmapDrawable bitmap = ImageLoader.getBitmapFromCache((String)url);
        if (bitmap != null && bitmap.getBitmap() != null && !bitmap.getBitmap().isRecycled()) {
            return;
        }
        LoadingBgHellper loadingIten = new LoadingBgHellper();
        loadingIten.preloadLoadingBgInner(context, url);
    }

    public static void removeBgFromCache(String url) {
        ImageLoader.removeBitmapFromCache((String)url);
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"remvoe:%s", (Object[])new Object[]{url});
        }
    }

    public static BitmapDrawable getBitmapDrawableFromCache(String url) {
        BitmapDrawable result;
        if (!TextUtils.isEmpty((CharSequence)sCacheCoverUrl) && !sCacheCoverUrl.equals(url)) {
            LoadingBgHellper.removedBgFromCacheBy(sCacheCoverUrl);
        }
        if ((result = ImageLoader.getBitmapFromCache((String)url)) != null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"getBitmapDrawableFromCache success:%s!", (Object[])new Object[]{url});
            }
            sCacheCoverUrl = url;
            return result;
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"getBitmapDrawableFromCache fail:%s!", (Object[])new Object[]{url});
        }
        return null;
    }

    private void preloadLoadingBgInner(Context context, final String url) {
        int bitmapWidth = ScreenUtils.getInstance().getWidthPixels() / 2;
        String snapUrl = url != null && url.contains("?x-oss-process=image") ? url : YYImageUtils.getSnapUrl((String)url, (int)bitmapWidth, (int)bitmapWidth);
        MLog.error((Object)TAG, (String)("load snap url: " + snapUrl), (Object[])new Object[0]);
        ImageLoader.loadBitmap((Context)context, (String)snapUrl, (ImageLoader.BitmapLoadListener)new ImageLoader.BitmapLoadListener(){

            public void onLoadFailed(Exception e) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)LoadingBgHellper.TAG, (String)"preload fail:%s, reason:%s!", (Object[])new Object[]{url, e != null ? e.toString() : ""});
                }
            }

            public void onResourceReady(Bitmap bitmap) {
                YYTaskExecutor.execute(() -> {
                    if (bitmap != null) {
                        ImageLoader.addBitmapToCache((String)url, (BitmapDrawable)new BitmapDrawable(bitmap));
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)LoadingBgHellper.TAG, (String)"preload success, and add bitamp to cache:%s!", (Object[])new Object[]{url});
                        }
                    } else if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)LoadingBgHellper.TAG, (String)"preload success, but blur failed:%s!", (Object[])new Object[]{url});
                    }
                });
            }
        }, (int)bitmapWidth, (int)bitmapWidth, (boolean)false, (DecodeFormat)DecodeFormat.PREFER_RGB_565, (YYBitmapTransformation[])new YYBitmapTransformation[]{new YYCenterCrop(), new BlurTransformation(20)});
    }
}

