/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.module.main.enter;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.IBinder;
import androidx.annotation.Nullable;
import androidx.core.app.NotificationCompat;
import com.yy.appbase.R;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.channel.R;

public class ChannelKeepAliveService
extends Service {
    private static final String TAG = "ChannelKeepAliveService";
    private static final int SERVICE_ID = 123456;
    public static final String CHANNEL_NAME = "channel_name";
    private static final String CHANNEL_DEFAULT = "default";
    private static Intent sIntentService;
    private static long sStartForegroundTime;
    private static boolean sNeedStop;
    private static String sChannelId;
    private static Runnable sStopTask;

    @Nullable
    public IBinder onBind(Intent intent) {
        return null;
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"onStartCommand intent is null: %s  channelNameL %s", (Object[])new Object[]{intent == null, intent == null ? "" : intent.getStringExtra(CHANNEL_NAME)});
        }
        if (intent != null) {
            this.startFgService(intent);
        }
        return 0;
    }

    private void startFgService(Intent intent) {
        String channelName;
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"startFgService", (Object[])new Object[0]);
        }
        if ((channelName = intent.getStringExtra(CHANNEL_NAME)) == null) {
            channelName = "";
        }
        String title = String.format(ResourceUtils.getString((int)R.string.channel_title_foreground_service), channelName);
        Notification notification = this.getDefaultNotification(title);
        this.startForeground(123456, notification);
        YYTaskExecutor.removeTask((Runnable)sStopTask);
        if (sNeedStop) {
            sStopTask.run();
        }
    }

    private Notification getDefaultNotification(String title) {
        Context context = RuntimeContext.sApplicationContext;
        NotificationManager notificationManager = (NotificationManager)RuntimeContext.sApplicationContext.getSystemService("notification");
        NotificationCompat.Builder builder = new NotificationCompat.Builder(context, CHANNEL_DEFAULT);
        builder.setContentTitle((CharSequence)title);
        builder.setContentText((CharSequence)ResourceUtils.getString((int)R.string.channel_tips_foreground_service));
        if (Build.VERSION.SDK_INT > 27) {
            builder.setSmallIcon(R.drawable.push_logo_white);
        } else {
            builder.setSmallIcon(R.drawable.push_logo);
        }
        Notification notification = builder.build();
        if (Build.VERSION.SDK_INT >= 26) {
            NotificationChannel channel = new NotificationChannel(CHANNEL_DEFAULT, (CharSequence)CHANNEL_DEFAULT, 4);
            notificationManager.createNotificationChannel(channel);
        }
        notification.when = System.currentTimeMillis();
        notification.flags |= 0x10;
        notification.contentIntent = this.getBackPendingIntent();
        return notification;
    }

    private PendingIntent getBackPendingIntent() {
        Intent intent = new Intent();
        intent.setClassName(RuntimeContext.sApplicationContext, "com.yy.hiyo.MainActivity");
        intent.addFlags(0x10000000);
        intent.putExtra("notification_intent_back_to_channel", true);
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)RuntimeContext.sApplicationContext, (int)0, (Intent)intent, (int)0x10000000);
        return pendingIntent;
    }

    public static void startForegroundService(String channelId, String channelName) {
        block7: {
            if (sIntentService == null) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)"startForegroundService", (Object[])new Object[0]);
                }
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)"start foreground Service channelName: %s", (Object[])new Object[]{channelName});
                }
                try {
                    sIntentService = new Intent(RuntimeContext.sApplicationContext, ChannelKeepAliveService.class);
                    sIntentService.putExtra(CHANNEL_NAME, channelName);
                    if (Build.VERSION.SDK_INT >= 26) {
                        RuntimeContext.sApplicationContext.startForegroundService(sIntentService);
                        sStartForegroundTime = System.currentTimeMillis();
                    } else {
                        RuntimeContext.sApplicationContext.startService(sIntentService);
                        sStartForegroundTime = -1L;
                    }
                }
                catch (Exception e) {
                    if (!MLog.isLogLevelBlowInfo()) break block7;
                    MLog.info((Object)TAG, (String)"startForegroundService e=%s", (Object[])new Object[]{e.toString()});
                }
            }
        }
        sNeedStop = false;
        sChannelId = channelId;
        YYTaskExecutor.removeTask((Runnable)sStopTask);
    }

    public static void stopForegroundService(String channelId) {
        if (sIntentService != null && (StringUtils.equal((String)channelId, (String)sChannelId) || StringUtils.isEmpty((String)sChannelId))) {
            long interval;
            sNeedStop = true;
            long l = interval = sStartForegroundTime == -1L ? -1L : 5000L - (System.currentTimeMillis() - sStartForegroundTime);
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"stop foreground Service interval: %d, sStartForegroundTime: %d", (Object[])new Object[]{interval, sStartForegroundTime});
            }
            if (interval > 0L) {
                YYTaskExecutor.postToMainThread((Runnable)sStopTask, (long)(interval + 500L));
            } else {
                sStopTask.run();
            }
            sChannelId = "";
        }
    }

    public void onDestroy() {
        super.onDestroy();
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"onDestroy", (Object[])new Object[0]);
        }
        this.stopForeground(true);
    }

    public void onTaskRemoved(Intent rootIntent) {
        super.onTaskRemoved(rootIntent);
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"onTaskRemoved", (Object[])new Object[0]);
        }
        this.stopForeground(true);
    }

    static {
        sStartForegroundTime = -1L;
        sNeedStop = false;
        sChannelId = "";
        sStopTask = new Runnable(){

            @Override
            public void run() {
                if (sIntentService != null) {
                    RuntimeContext.sApplicationContext.stopService(sIntentService);
                    sIntentService = null;
                    sStartForegroundTime = -1L;
                    sNeedStop = false;
                }
            }
        };
    }
}

