/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.module.main.enter;

import android.content.Context;
import android.content.DialogInterface;
import android.os.Message;
import com.yy.appbase.abtest.newab.NAB;
import com.yy.appbase.abtest.newab.NewABDefine;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.service.IWebService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.logger.MLog;
import com.yy.base.utils.SettingFlags;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.MsgDispatcher;
import com.yy.hiyo.channel.module.main.enter.agreement.AgreementDialog;

public class ChannelJoinGuideUtils {
    private static final String TAG = "ChannelJoinGuideUtils";
    private static AgreementDialog dialog;

    public static void excuteAfterPrivacyAgreementOrGuestLoginGuide(Context context, final Runnable continueCommand) {
        if (ChannelJoinGuideUtils.showGuestGuide()) {
            return;
        }
        boolean show = ChannelJoinGuideUtils.showPrivacyAgreementGuide(context, new IPrivacyAgreementGuideCallBack(){

            @Override
            public void onAgree() {
                continueCommand.run();
            }
        });
        if (!show) {
            continueCommand.run();
        }
    }

    public static boolean showPrivacyAgreementGuide(Context context, final IPrivacyAgreementGuideCallBack callBack) {
        if (AccountUtil.isLoginByGuest()) {
            Message message = new Message();
            message.what = BaseMsgDef.SHOW_GUIDE_DIALOG;
            MsgDispatcher.getInstance().sendMessage(message);
            return true;
        }
        if (NAB.B.equals((Object)NewABDefine.ENTER_CHANNEL_AGREEMENT.getTest())) {
            return false;
        }
        boolean agreementShowed = SettingFlags.getBoolean((String)"key_voice_room_agreement_showed", (boolean)false);
        if (!agreementShowed) {
            if (dialog != null) {
                dialog.dismissByCancel();
            }
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"\u5f39\u534f\u8bae\u5f39\u7a97", (Object[])new Object[0]);
            }
            dialog = new AgreementDialog(context);
            dialog.setWebService((IWebService)ServiceManagerProxy.getServiceManager().getService(IWebService.class));
            dialog.setOnCallback(new AgreementDialog.Callback(){

                @Override
                public void onClickAgree() {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)ChannelJoinGuideUtils.TAG, (String)"\u534f\u8bae\u5f39\u7a97\u70b9\u51fbagree", (Object[])new Object[0]);
                    }
                    SettingFlags.setBoolean((String)"key_voice_room_agreement_showed", (boolean)true);
                    if (callBack != null) {
                        callBack.onAgree();
                    }
                }

                @Override
                public void onCancel() {
                    if (callBack != null) {
                        callBack.onCancel();
                    }
                }
            });
            dialog.show();
            dialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

                public void onDismiss(DialogInterface dialogInterface) {
                    dialog = null;
                }
            });
            return true;
        }
        return false;
    }

    public static boolean showGuestGuide() {
        if (AccountUtil.isLoginByGuest()) {
            Message message = new Message();
            message.what = BaseMsgDef.SHOW_GUIDE_DIALOG;
            MsgDispatcher.getInstance().sendMessage(message);
            return true;
        }
        return false;
    }

    public static interface IPrivacyAgreementGuideCallBack {
        public void onAgree();

        default public void onCancel() {
        }
    }
}

