/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.module.main;

import android.content.DialogInterface;
import android.os.Message;
import com.yy.appbase.callback.IVoiceRoomExitCallback;
import com.yy.appbase.notify.NotificationIdDef;
import com.yy.appbase.ui.dialog.OkCancelDialog;
import com.yy.appbase.ui.dialog.OkCancelDialogListener;
import com.yy.base.event.fw.FWEvent;
import com.yy.base.event.fw.FWEventActionKey;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.Environment;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.BasePanel;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.hiyo.channel.ChannelBaseMsgDef;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.EnterParam;
import com.yy.hiyo.channel.base.IChannelCenterService;
import com.yy.hiyo.channel.base.bean.ChannelNotify;
import com.yy.hiyo.channel.base.bean.EnterChannelData;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.base.service.IMediaService;
import com.yy.hiyo.channel.base.service.intercepter.IMediaIntercepter;
import com.yy.hiyo.channel.cbase.AbsChannelController;
import com.yy.hiyo.channel.cbase.ChannelMsgDef;
import com.yy.hiyo.channel.module.main.ChannelWindowController;
import com.yy.hiyo.channel.module.main.IChannelWindowController;
import com.yy.hiyo.channel.module.main.plugins.general.PartyPanelViewModel;
import com.yy.hiyo.game.base.FilterRunnable;
import com.yy.hiyo.mvp.base.AbsNotifyDispatchService;
import com.yy.hiyo.mvp.base.IMvpContext;
import com.yy.hiyo.mvp.base.INotifyDispatchService;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Map;

public class ChannelComplexWindowController
extends AbsChannelController
implements IChannelWindowController {
    private static String TAG = "ChannelController_ComplexWindow";
    private MyWindowController curJoinedChannel;
    private ChannelWindowController.ICallback mCallback;
    private IChannelWindowController subJoinedChannel;
    private IChannelWindowController subJoinedChannelTemp;
    private boolean mNeedInterceptMedia = true;
    private IMediaIntercepter mMediaIntercepter;
    private ChannelWindowController.ICallback myCallBack = new ChannelWindowController.ICallback(){

        @Override
        public void preJoinSuccess(IChannelWindowController controller, Runnable callBack, String channelId) {
            IChannel channel = ((IChannelCenterService)ChannelComplexWindowController.this.getServiceManager().getService(IChannelCenterService.class)).getChannel(channelId);
            if (channel == null || channel.getPluginService().getCurPluginData() == null) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)"preJoinSuccess reset subJoinChannel to Null, by pluginDataNull!", (Object[])new Object[0]);
                }
                ChannelComplexWindowController.this.subJoinedChannelTemp = null;
                ChannelComplexWindowController.this.mNeedInterceptMedia = false;
            } else if (channel.getPluginService().getCurPluginData().mode != 1) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)"preJoinSuccess reset subJoinChannel to Null, by curChannel:%s not Base Mode!", (Object[])new Object[]{channel.getChannelId()});
                }
                ChannelComplexWindowController.this.subJoinedChannelTemp = null;
                ChannelComplexWindowController.this.mNeedInterceptMedia = false;
            } else if (ChannelComplexWindowController.this.subJoinedChannelTemp != null && !ChannelComplexWindowController.this.subJoinedChannelTemp.isDestroyed()) {
                ChannelComplexWindowController.this.subJoinedChannel = ChannelComplexWindowController.this.subJoinedChannelTemp;
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)"preJoinSuccess reset subJoinChannel to:%s", (Object[])new Object[]{ChannelComplexWindowController.this.subJoinedChannel.getChannelId()});
                }
                ChannelComplexWindowController.this.subJoinedChannelTemp = null;
                ChannelComplexWindowController.this.mNeedInterceptMedia = true;
            }
            if (ChannelComplexWindowController.this.subJoinedChannel != null) {
                ChannelComplexWindowController.this.subJoinedChannel.setIntercepter(new IChannelWindowController.IIntercepter(){

                    @Override
                    public boolean handleGameFilter(IChannelWindowController controller, FilterRunnable runnable2) {
                        boolean b = ChannelComplexWindowController.this.handleGameFilterInner(controller, runnable2);
                        return b;
                    }

                    @Override
                    public boolean shouldStartForegroundService() {
                        return true;
                    }
                });
            }
            if (ChannelComplexWindowController.this.mCallback != null) {
                ChannelComplexWindowController.this.mCallback.preJoinSuccess(ChannelComplexWindowController.this, callBack, channelId);
            }
        }

        @Override
        public void onJoinSuccess(EnterParam requestParams, EnterChannelData data, IChannelWindowController controller) {
            if (ChannelComplexWindowController.this.mCallback != null) {
                ChannelComplexWindowController.this.mCallback.onJoinSuccess(requestParams, data, ChannelComplexWindowController.this);
                if (!((ChannelComplexWindowController)ChannelComplexWindowController.this).curJoinedChannel.destroyed && ChannelComplexWindowController.this.subJoinedChannel != null && !ChannelComplexWindowController.this.subJoinedChannel.isDestroyed()) {
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (ChannelComplexWindowController.this.subJoinedChannel != null && !ChannelComplexWindowController.this.subJoinedChannel.isDestroyed()) {
                                ChannelComplexWindowController.this.sendMessage(ChannelMsgDef.MSG_MINI_UPDATE_CHANNEL_INFO, -1, -1, ChannelComplexWindowController.this.subJoinedChannel.getChannelId());
                            }
                        }
                    }, (long)500L);
                }
            }
        }

        @Override
        public void onJoinError(IChannelWindowController controller) {
            ChannelComplexWindowController.this.mNeedInterceptMedia = false;
            if (ChannelComplexWindowController.this.mCallback != null) {
                ChannelComplexWindowController.this.mCallback.onJoinError(ChannelComplexWindowController.this);
            }
        }

        @Override
        public IChannel.IJoinCallBack getJoinErrorHandler(EnterParam enterParam) {
            if (ChannelComplexWindowController.this.mCallback != null) {
                return ChannelComplexWindowController.this.mCallback.getJoinErrorHandler(enterParam);
            }
            return null;
        }

        @Override
        public void preDestroy(IChannelWindowController controller) {
            if (ChannelComplexWindowController.this.mCallback != null) {
                ChannelComplexWindowController.this.mCallback.preDestroy(ChannelComplexWindowController.this);
            }
        }

        @Override
        public void onChannelDestroyed(IChannelWindowController controller) {
            if (ChannelComplexWindowController.this.mCallback != null) {
                ChannelComplexWindowController.this.mCallback.onChannelDestroyed(ChannelComplexWindowController.this);
            }
        }
    };

    public ChannelComplexWindowController(Environment environment, ChannelWindowController.ICallback callback2, IChannelWindowController subJoinedChannel) {
        super(environment);
        this.mCallback = callback2;
        this.subJoinedChannelTemp = subJoinedChannel;
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"create with sub:%s", (Object[])new Object[]{subJoinedChannel.getChannelId()});
        }
    }

    @Override
    public String getChannelId() {
        return this.curJoinedChannel.getChannelId();
    }

    @Override
    public IChannel getChannel() {
        return this.curJoinedChannel.getChannel();
    }

    @Override
    public EnterParam getEnterParams() {
        return this.curJoinedChannel.getEnterParams();
    }

    @Override
    public String getJoinedSubChannelId() {
        if (this.subJoinedChannel != null) {
            return this.subJoinedChannel.getChannelId();
        }
        return "";
    }

    @Override
    public EnterParam getJoinedSubChannelEnterParam() {
        if (this.subJoinedChannel != null) {
            return this.subJoinedChannel.getEnterParams();
        }
        return null;
    }

    @Override
    public boolean isDestroyed() {
        if (this.curJoinedChannel != null) {
            return this.curJoinedChannel.destroyed;
        }
        return true;
    }

    @Override
    public void enterChannel(EnterParam enterParam, boolean showWindowAfterJoinSuccess, boolean callJoinRequest) {
        this.curJoinedChannel = new MyWindowController(this.getEnvironment(), this.myCallBack);
        this.curJoinedChannel.enterChannel(enterParam, showWindowAfterJoinSuccess, callJoinRequest, true);
    }

    @Override
    public void bringWindowToFront(EnterParam enterParam) {
        this.bringWindowToFront(enterParam, false, null);
    }

    @Override
    public void handleMessage(Message msg) {
        super.handleMessage(msg);
        if (this.curJoinedChannel != null) {
            this.curJoinedChannel.handleMessage(msg);
        }
    }

    @Override
    public Object handleMessageSync(Message msg) {
        if (msg == null) {
            return null;
        }
        Object result = null;
        if (msg.what == ChannelBaseMsgDef.MULTIVIDEO_MINI_SHOW_GET_VIDEO_VIEW) {
            if (this.subJoinedChannel != null) {
                result = this.subJoinedChannel.handleMessageSync(msg);
            } else if (this.subJoinedChannelTemp != null) {
                result = this.subJoinedChannelTemp.handleMessageSync(msg);
            }
            if (result == null && this.curJoinedChannel != null) {
                result = this.curJoinedChannel.handleMessageSync(msg);
            }
            return result;
        }
        if (this.curJoinedChannel != null) {
            return this.curJoinedChannel.handleMessageSync(msg);
        }
        if (this.subJoinedChannel != null) {
            return this.subJoinedChannel.handleMessageSync(msg);
        }
        if (this.subJoinedChannelTemp != null) {
            return this.subJoinedChannelTemp.handleMessageSync(msg);
        }
        return super.handleMessageSync(msg);
    }

    private void bringWindowToFront(final EnterParam enterParam, final boolean notPushSubJoinedChannelWindow, final Runnable callbackAfter) {
        if (StringUtils.equal((String)enterParam.roomId, (String)this.curJoinedChannel.getChannelId())) {
            this.curJoinedChannel.bringWindowToFront(enterParam);
        } else if (this.subJoinedChannel != null && StringUtils.equal((String)enterParam.roomId, (String)this.subJoinedChannel.getChannelId())) {
            this.mCallback.preJoinSuccess(this.subJoinedChannel, new Runnable(){

                @Override
                public void run() {
                    if (!notPushSubJoinedChannelWindow) {
                        ChannelComplexWindowController.this.subJoinedChannel.bringWindowToFront(enterParam);
                    } else {
                        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                if (ChannelComplexWindowController.this.subJoinedChannel != null && !ChannelComplexWindowController.this.subJoinedChannel.isDestroyed()) {
                                    ChannelComplexWindowController.this.sendMessage(ChannelMsgDef.MSG_MINI_UPDATE_CHANNEL_INFO, -1, -1, ChannelComplexWindowController.this.subJoinedChannel.getChannelId());
                                }
                            }
                        }, (long)300L);
                    }
                    if (ChannelComplexWindowController.this.mCallback != null) {
                        ChannelComplexWindowController.this.mCallback.onJoinSuccess(ChannelComplexWindowController.this.subJoinedChannel.getEnterParams(), ChannelComplexWindowController.this.subJoinedChannel.getChannel().getEnterChannelData(), ChannelComplexWindowController.this.subJoinedChannel, true);
                    }
                    if (callbackAfter != null) {
                        callbackAfter.run();
                    }
                }
            }, this.subJoinedChannel.getChannelId());
        }
    }

    @Override
    public void destroy(boolean popWinAni) {
        this.destroy(popWinAni, null, null, false, null, 0);
    }

    public void destroyWithoutSubChannel(boolean popWinAni, final IVoiceRoomExitCallback callbackWhenExited, Map<String, Object> extMap) {
        if (this.subJoinedChannel != null && !this.subJoinedChannel.isDestroyed()) {
            this.bringWindowToFront(this.subJoinedChannel.getEnterParams(), true, new Runnable(){

                @Override
                public void run() {
                    if (callbackWhenExited != null) {
                        callbackWhenExited.onExit(true);
                    }
                }
            });
        } else {
            this.destroy(popWinAni, callbackWhenExited, extMap, false, "", -1);
        }
    }

    @Override
    public void destroy(final boolean popWinAni, final IVoiceRoomExitCallback callbackWhenExited, final Map<String, Object> extMap, final boolean notLeaveRequest, final String nextJoinSuccessChannel, final int nextJoinSuccessEntry) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"destroy nextJoinSuccessChannel:%s,subJoinedChannel:%s,curToDestroyChannel:%s", (Object[])new Object[]{nextJoinSuccessChannel, this.subJoinedChannel != null ? this.subJoinedChannel.getChannelId() : "", this.getChannelId()});
        }
        Runnable destroyCurChannel = new Runnable(){

            @Override
            public void run() {
                IChannel channel = ChannelComplexWindowController.this.getChannel();
                if (channel != null && channel.getPluginService().getCurPluginData() != null && channel.getPluginService().getCurPluginData().mode == 1) {
                    ChannelComplexWindowController.this.curJoinedChannel.destroy(popWinAni, callbackWhenExited, extMap, notLeaveRequest, nextJoinSuccessChannel, nextJoinSuccessEntry, true);
                } else {
                    ChannelComplexWindowController.this.curJoinedChannel.destroy(popWinAni, callbackWhenExited, extMap, notLeaveRequest, nextJoinSuccessChannel, nextJoinSuccessEntry);
                }
            }
        };
        if (this.subJoinedChannel == null && this.subJoinedChannelTemp != null && !StringUtils.equal((String)nextJoinSuccessChannel, (String)this.subJoinedChannelTemp.getChannelId()) && !this.subJoinedChannelTemp.isDestroyed() && this.curJoinedChannel != null && this.curJoinedChannel.getEnterParams() != null && this.curJoinedChannel.getEnterParams().entry == 47) {
            this.subJoinedChannel = this.subJoinedChannelTemp;
            this.subJoinedChannelTemp = null;
            this.destroySubJoinedChannel(destroyCurChannel, nextJoinSuccessChannel, nextJoinSuccessEntry);
        } else if (this.subJoinedChannel != null && !StringUtils.equal((String)nextJoinSuccessChannel, (String)this.subJoinedChannel.getChannelId())) {
            this.destroySubJoinedChannel(destroyCurChannel, nextJoinSuccessChannel, nextJoinSuccessEntry);
        } else {
            destroyCurChannel.run();
        }
    }

    @Override
    public void setIntercepter(IChannelWindowController.IIntercepter intercepter) {
        if (this.curJoinedChannel != null) {
            this.curJoinedChannel.setIntercepter(intercepter);
        }
    }

    @Override
    public IChannelWindowController getSubJoinedChannel() {
        return this.subJoinedChannel;
    }

    @Override
    public void destroyJoinedSubChannel(boolean ani) {
        this.destroyJoinedSubChannel(ani, null);
    }

    private void destroyJoinedSubChannel(boolean ani, final Runnable callBack) {
        if (this.subJoinedChannel == null) {
            if (callBack != null) {
                callBack.run();
            }
            return;
        }
        this.mNeedInterceptMedia = false;
        this.destroySubJoinedChannel(new Runnable(){

            @Override
            public void run() {
                if (ChannelComplexWindowController.this.curJoinedChannel != null && !((ChannelComplexWindowController)ChannelComplexWindowController.this).curJoinedChannel.destroyed) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TAG, (String)"joinMultiRoom:%s", (Object[])new Object[]{ChannelComplexWindowController.this.curJoinedChannel.getChannelId()});
                    }
                    ChannelComplexWindowController.this.sendMessage(ChannelMsgDef.MSG_MINI_UPDATE_CHANNEL_INFO, -1, -1, ChannelComplexWindowController.this.curJoinedChannel.getChannelId());
                    if (ChannelComplexWindowController.this.curJoinedChannel.getChannel().getMediaService().getMediaIntercepter() == ChannelComplexWindowController.this.mMediaIntercepter) {
                        ChannelComplexWindowController.this.curJoinedChannel.getChannel().getMediaService().setMediaIntercepter(null);
                        ChannelComplexWindowController.this.mMediaIntercepter = null;
                    }
                    ChannelComplexWindowController.this.curJoinedChannel.getChannel().getMediaService().joinMultiRoom(ChannelComplexWindowController.this.curJoinedChannel.getChannel().getPluginService().getCurPluginData());
                    ChannelComplexWindowController.this.curJoinedChannel.notifyMediaInterceptStateChange();
                }
                if (callBack != null) {
                    callBack.run();
                }
            }
        }, "", 0);
    }

    private void destroySubJoinedChannel(final Runnable runnable2, String nextJoinSuccessChannel, int nextJoinSuccessEntry) {
        if (this.subJoinedChannel == null) {
            if (runnable2 != null) {
                runnable2.run();
            }
            return;
        }
        final String subJoinedChannelId = this.subJoinedChannel.getChannelId();
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"destroySubJoinedChannel:%s, nextJoinSuccessChannel:%s", (Object[])new Object[]{subJoinedChannelId, nextJoinSuccessChannel});
        }
        this.subJoinedChannel.destroy(false, new IVoiceRoomExitCallback(){

            public void onExit(boolean isExit) {
                NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationIdDef.CHANNEL_EXITED, (Object)subJoinedChannelId));
                FWEvent.sendEvent((Object)ChannelComplexWindowController.this, (FWEventActionKey)FWEventActionKey.FWAction_On_ChannelExit, (Object[])new Object[]{subJoinedChannelId});
                runnable2.run();
                if (!ChannelComplexWindowController.this.isDestroyed() && ChannelComplexWindowController.this.getChannel() != null) {
                    ChannelComplexWindowController.this.sendMessage(ChannelMsgDef.MSG_MINI_UPDATE_CHANNEL_INFO, -1, -1, ChannelComplexWindowController.this.getChannel().getChannelId());
                }
            }
        }, null, false, nextJoinSuccessChannel, nextJoinSuccessEntry);
        this.subJoinedChannel = null;
    }

    private void replaceCurController(String subJoinedChannelId) {
        if (this.mCallback != null && this.subJoinedChannel != null && StringUtils.equal((String)subJoinedChannelId, (String)this.subJoinedChannel.getChannelId())) {
            EnterParam enterChannelParams = this.subJoinedChannel.getChannel().getEnterParam();
            enterChannelParams.entry = 104;
            this.mCallback.preJoinSuccess(this.subJoinedChannel, new Runnable(){

                @Override
                public void run() {
                    if (ChannelComplexWindowController.this.mCallback != null) {
                        ChannelComplexWindowController.this.mCallback.onJoinSuccess(ChannelComplexWindowController.this.subJoinedChannel.getEnterParams(), ChannelComplexWindowController.this.subJoinedChannel.getChannel().getEnterChannelData(), ChannelComplexWindowController.this.subJoinedChannel, true);
                        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                if (ChannelComplexWindowController.this.subJoinedChannel != null && !ChannelComplexWindowController.this.subJoinedChannel.isDestroyed()) {
                                    ChannelComplexWindowController.this.sendMessage(ChannelMsgDef.MSG_MINI_UPDATE_CHANNEL_INFO, -1, -1, ChannelComplexWindowController.this.subJoinedChannel.getChannelId());
                                }
                            }
                        }, (long)500L);
                    }
                }
            }, this.subJoinedChannel.getChannelId());
        } else if (this.curJoinedChannel != null) {
            this.curJoinedChannel.exitChannel(this.curJoinedChannel.getChannelId());
        }
    }

    protected boolean handleGameFilterInner(IChannelWindowController controller, final FilterRunnable runnable2) {
        if (this.curJoinedChannel != null && this.curJoinedChannel.shouldHandle(runnable2)) {
            if (this.subJoinedChannel != null) {
                this.destroyJoinedSubChannel(false, new Runnable(){

                    @Override
                    public void run() {
                        ChannelComplexWindowController.this.curJoinedChannel.handleGameFilterInner(((ChannelComplexWindowController)ChannelComplexWindowController.this).curJoinedChannel.gameFilter, runnable2);
                    }
                });
                return true;
            }
            return this.curJoinedChannel.handleGameFilterInner(this.curJoinedChannel.gameFilter, runnable2);
        }
        if (this.curJoinedChannel != null) {
            return this.curJoinedChannel.handleGameFilterInner(this.curJoinedChannel.gameFilter, runnable2);
        }
        return false;
    }

    private class MyWindowController
    extends ChannelWindowController {
        private boolean mFirstShown;
        private INotifyDispatchService.INotifyHandler mNotifyHandler;
        private OkCancelDialog mDialog;
        private BasePanel.IPanelListener mPartyPanelListener;
        private Runnable mShowMediaTipsIfNeed;
        private ArrayList<WeakReference<IMediaIntercepter.IInterceptStateChange>> mInterceptStateChangeListeners;
        private boolean mHasShowHasVoiceChatDialog;
        private boolean mHasShowHasMusicDialog;

        public MyWindowController(Environment environment, ChannelWindowController.ICallback callback2) {
            super(environment, callback2);
            this.mFirstShown = true;
            this.mShowMediaTipsIfNeed = null;
            this.mHasShowHasVoiceChatDialog = false;
            this.mHasShowHasMusicDialog = false;
        }

        private INotifyDispatchService.INotifyHandler<ChannelNotify> getNotifyHandler() {
            if (this.mNotifyHandler == null) {
                this.mNotifyHandler = new INotifyDispatchService.INotifyHandler<ChannelNotify>(){

                    public void onHandleNotify(ChannelNotify notify2) {
                        if (notify2 != null && notify2.notify != null) {
                            if (notify2.notify.mBgmPlayNotify != null && notify2.notify.mBgmPlayNotify.playState) {
                                if (StringUtils.equal((String)notify2.notify.mBgmPlayNotify.ownerCid, (String)MyWindowController.this.getChannel().getChannelId())) {
                                    if (MLog.isLogLevelBlowInfo()) {
                                        MLog.info((Object)TAG, (String)"onHandleBgmPlayNotify:%s", (Object[])new Object[]{notify2.cid});
                                    }
                                    if (MyWindowController.this.mShowMediaTipsIfNeed == null || !MyWindowController.this.isPartyPanelShowing()) {
                                        MyWindowController.this.showOpenMediaDialogByHasMusic();
                                    } else {
                                        MyWindowController.this.showMediaTipsIfNeed(true);
                                    }
                                }
                            } else if (notify2.notify.openVoiceChatNotify != null && notify2.notify.openVoiceChatNotify.operUid > 0L) {
                                if (MLog.isLogLevelBlowInfo()) {
                                    MLog.info((Object)TAG, (String)"openVoiceChatNotify:%s", (Object[])new Object[]{notify2.cid});
                                }
                                if (MyWindowController.this.mShowMediaTipsIfNeed == null || !MyWindowController.this.isPartyPanelShowing()) {
                                    MyWindowController.this.showOpenMediaDialogByHasVoiceChat();
                                } else {
                                    MyWindowController.this.showMediaTipsIfNeed(true);
                                }
                            }
                        }
                    }
                };
            }
            return this.mNotifyHandler;
        }

        private boolean isPartyPanelShowing() {
            IMvpContext pageContext = this.getPageContext();
            if (pageContext == null || !pageContext.hasViewModel(PartyPanelViewModel.class)) {
                return false;
            }
            return ((PartyPanelViewModel)pageContext.getViewModel(PartyPanelViewModel.class)).isPageShowing();
        }

        private void showMediaTipsIfNeed(boolean hasVoiceOrMusicOpen) {
            IChannel channel = this.getChannel();
            if (channel == null || this.destroyed) {
                return;
            }
            if (this.mShowMediaTipsIfNeed != null) {
                return;
            }
            boolean needCheck = hasVoiceOrMusicOpen;
            if (!hasVoiceOrMusicOpen) {
                if (channel.getSeatService().hasUserInSeat()) {
                    needCheck = true;
                } else if (channel.getDataService().getCacheDetail() != null && channel.getDataService().getCacheDetail().dynamicInfo != null && channel.getDataService().getCacheDetail().dynamicInfo.mCurrentPlayBgUid > 0L) {
                    needCheck = true;
                }
            }
            if (!needCheck) {
                return;
            }
            Runnable commandShowMediaTips = new Runnable(){

                @Override
                public void run() {
                    IChannel channel = MyWindowController.this.getChannel();
                    if (channel == null || MyWindowController.this.destroyed) {
                        return;
                    }
                    if (!MyWindowController.this.mHasShowHasVoiceChatDialog) {
                        if (channel.getSeatService().hasUserInSeat()) {
                            MyWindowController.this.showOpenMediaDialogByHasVoiceChat();
                        } else if (channel.getDataService().getCacheDetail() != null && channel.getDataService().getCacheDetail().dynamicInfo != null && channel.getDataService().getCacheDetail().dynamicInfo.mCurrentPlayBgUid > 0L) {
                            MyWindowController.this.showOpenMediaDialogByHasMusic();
                        }
                    } else if (channel.getSeatService().hasUserInSeat()) {
                        MyWindowController.this.showOpenMediaDialogByHasVoiceChat();
                    }
                }
            };
            IMvpContext pageContext = this.getPageContext();
            if (!this.isPartyPanelShowing()) {
                commandShowMediaTips.run();
            } else {
                this.mShowMediaTipsIfNeed = commandShowMediaTips;
                if (this.mPartyPanelListener == null) {
                    this.mPartyPanelListener = new BasePanel.IPanelListener(){

                        public void onPanelShow(BasePanel panel, boolean animated) {
                        }

                        public void onPanelHide(BasePanel panel, boolean animated) {
                        }

                        public void onPanelShown(BasePanel panel) {
                        }

                        public void onPanelHidden(BasePanel panel) {
                            if (MyWindowController.this.mShowMediaTipsIfNeed != null && !MyWindowController.this.destroyed) {
                                MyWindowController.this.mShowMediaTipsIfNeed.run();
                                MyWindowController.this.mShowMediaTipsIfNeed = null;
                            }
                        }
                    };
                }
                if (pageContext.hasViewModel(PartyPanelViewModel.class)) {
                    ((PartyPanelViewModel)pageContext.getPresenter(PartyPanelViewModel.class)).addPanelListener(this.mPartyPanelListener);
                }
            }
        }

        private void showOpenMediaDialogByHasVoiceChat() {
            if (!ChannelComplexWindowController.this.mNeedInterceptMedia || this.destroyed) {
                return;
            }
            this.mHasShowHasVoiceChatDialog = true;
            this.showOpenMediaDialog(1, ResourceUtils.getString((int)R.string.tips_close_voiceroom_when_textroom_has_voice), null, null);
        }

        private void showOpenMediaDialogByHasMusic() {
            if (!ChannelComplexWindowController.this.mNeedInterceptMedia || this.destroyed) {
                return;
            }
            if (this.mHasShowHasMusicDialog || this.mHasShowHasVoiceChatDialog) {
                return;
            }
            this.mHasShowHasMusicDialog = true;
            this.showOpenMediaDialog(2, ResourceUtils.getString((int)R.string.tips_close_voiceroom_when_textroom_has_music), null, null);
        }

        private void showOpenMediaDialogByOpenMusic(Runnable callBack, Runnable noCallBack) {
            if (this.destroyed) {
                return;
            }
            if (SettingFlags.getBoolean((String)"showtipwhenopenmusicin", (boolean)false)) {
                ChannelComplexWindowController.this.destroyJoinedSubChannel(false, callBack);
                return;
            }
            SettingFlags.setBoolean((String)"showtipwhenopenmusicin", (boolean)true);
            this.showOpenMediaDialog(2, ResourceUtils.getString((int)R.string.tips_close_voiceroom_when_textroom_open_music), callBack, noCallBack);
        }

        private void showOpenMediaDialogByOpenVoice(Runnable callBack, Runnable noCallBack) {
            if (this.destroyed) {
                return;
            }
            if (SettingFlags.getBoolean((String)"showtipwhenopenvoicechatin", (boolean)false)) {
                ChannelComplexWindowController.this.destroyJoinedSubChannel(false, callBack);
                return;
            }
            SettingFlags.setBoolean((String)"showtipwhenopenvoicechatin", (boolean)true);
            this.showOpenMediaDialog(1, ResourceUtils.getString((int)R.string.tips_close_voiceroom_when_textroom_open_voice), callBack, noCallBack);
        }

        void notifyMediaInterceptStateChange() {
            if (this.mInterceptStateChangeListeners == null || this.mInterceptStateChangeListeners.size() == 0) {
                return;
            }
            IMediaIntercepter.IInterceptStateChange listener = null;
            for (WeakReference<IMediaIntercepter.IInterceptStateChange> item : this.mInterceptStateChangeListeners) {
                if (item == null || item.get() == null || (listener = (IMediaIntercepter.IInterceptStateChange)item.get()) == null) continue;
                listener.onInterceptStateChange();
            }
        }

        boolean showOpenMediaDialog(final int dialogType, String tips, final Runnable okCallBack, final Runnable noCallBack) {
            IChannel channel = ChannelComplexWindowController.this.curJoinedChannel.getChannel();
            if (channel == null) {
                return false;
            }
            OkCancelDialog dialog2 = new OkCancelDialog(new OkCancelDialog.Builder().message((CharSequence)tips).okLabel((CharSequence)ResourceUtils.getString((int)R.string.btn_ok)).setCancelLabel((CharSequence)ResourceUtils.getString((int)R.string.btn_no)).cancelable(true).outSideCancelable(false).withCloseBtn(true).listener(new OkCancelDialogListener(){

                public void onClose() {
                }

                public void onCancel() {
                    HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20045439").put("function_id", "no_click").put("type", String.valueOf(dialogType)));
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TAG, (String)"OpenMediaDialog canceled!", (Object[])new Object[0]);
                    }
                    if (MyWindowController.this.destroyed) {
                        return;
                    }
                    if (noCallBack != null) {
                        noCallBack.run();
                    }
                }

                public void onOk() {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TAG, (String)"OpenMediaDialog OK!", (Object[])new Object[0]);
                    }
                    HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20045439").put("function_id", "is_click").put("type", String.valueOf(dialogType)));
                    if (MyWindowController.this.destroyed) {
                        return;
                    }
                    ChannelComplexWindowController.this.destroyJoinedSubChannel(false, okCallBack);
                }
            }));
            dialog2.setCancelListener(new DialogInterface.OnCancelListener(){

                public void onCancel(DialogInterface dialog2) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TAG, (String)"OpenMediaDialog canceled2!", (Object[])new Object[0]);
                    }
                    HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20045439").put("function_id", "no_click").put("type", String.valueOf(dialogType)));
                    if (MyWindowController.this.destroyed) {
                        return;
                    }
                    if (noCallBack != null) {
                        noCallBack.run();
                    }
                }
            });
            this.mDialog = dialog2;
            this.mDialogLinkManager.showDialog((BaseDialog)dialog2);
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20045439").put("function_id", "coexistence_inquiry_popover_show").put("type", String.valueOf(dialogType)));
            return false;
        }

        @Override
        protected void startForegroundService() {
            if (ChannelComplexWindowController.this.subJoinedChannel != null && !ChannelComplexWindowController.this.subJoinedChannel.isDestroyed()) {
                return;
            }
            super.startForegroundService();
        }

        @Override
        public void enterChannel(EnterParam enterParam, boolean showWindowAfterJoinSuccess, boolean callJoinRequest, boolean callJoinBaseBroadcast) {
            super.enterChannel(enterParam, showWindowAfterJoinSuccess, callJoinRequest, callJoinBaseBroadcast);
            if (ChannelComplexWindowController.this.mMediaIntercepter == null) {
                ChannelComplexWindowController.this.mMediaIntercepter = new IMediaIntercepter(){

                    public boolean isMediaIntercepted(IChannel channel) {
                        return ChannelComplexWindowController.this.mNeedInterceptMedia && ChannelComplexWindowController.this.subJoinedChannel != null;
                    }

                    public void registerMediaInterceptStateChange(IMediaIntercepter.IInterceptStateChange listener) {
                        if (listener == null) {
                            return;
                        }
                        if (MyWindowController.this.mInterceptStateChangeListeners == null) {
                            MyWindowController.this.mInterceptStateChangeListeners = new ArrayList(2);
                        } else {
                            IMediaIntercepter.IInterceptStateChange listenerReal = null;
                            for (WeakReference item : MyWindowController.this.mInterceptStateChangeListeners) {
                                if (item == null || (listenerReal = (IMediaIntercepter.IInterceptStateChange)item.get()) != listener) continue;
                                return;
                            }
                        }
                        MyWindowController.this.mInterceptStateChangeListeners.add(new WeakReference<IMediaIntercepter.IInterceptStateChange>(listener));
                    }

                    public void unRegisterMediaInterceptStateChange(IMediaIntercepter.IInterceptStateChange listener) {
                        if (listener == null || MyWindowController.this.mInterceptStateChangeListeners == null || MyWindowController.this.mInterceptStateChangeListeners.size() <= 0) {
                            return;
                        }
                        for (WeakReference item : MyWindowController.this.mInterceptStateChangeListeners) {
                            IMediaIntercepter.IInterceptStateChange listenerReal;
                            if (item == null || (listenerReal = (IMediaIntercepter.IInterceptStateChange)item.get()) != listener) continue;
                            MyWindowController.this.mInterceptStateChangeListeners.remove(item);
                            return;
                        }
                    }

                    public void tryOpenVoiceChat(boolean forceOpen, IChannel channel, Runnable continueCallBacker, Runnable interceptCallBacker) {
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)TAG, (String)"tryOpenVoiceChat forceOpen:%d, channelId:%s!", (Object[])new Object[]{forceOpen ? 1 : 0, channel != null ? channel.getChannelId() : ""});
                        }
                        if (forceOpen || !ChannelComplexWindowController.this.mNeedInterceptMedia) {
                            ChannelComplexWindowController.this.destroyJoinedSubChannel(false, continueCallBacker);
                        } else {
                            MyWindowController.this.showOpenMediaDialogByOpenVoice(continueCallBacker, interceptCallBacker);
                        }
                    }

                    public void tryJoinVoiceChat(boolean forceJoin, IChannel channel, Runnable continueCallBacker, Runnable interceptCallBacker) {
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)TAG, (String)"tryJoinVoiceChat forceOpen:%d, channelId:%s!", (Object[])new Object[]{forceJoin ? 1 : 0, channel != null ? channel.getChannelId() : ""});
                        }
                        if (forceJoin || !ChannelComplexWindowController.this.mNeedInterceptMedia) {
                            ChannelComplexWindowController.this.destroyJoinedSubChannel(false, continueCallBacker);
                        }
                    }

                    public void tryPlayBgMusic(boolean forcePlay, IChannel channel, Runnable continueCallBacker, Runnable interceptCallBacker) {
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)TAG, (String)"tryPlayBgMusic forceOpen:%d, channelId:%s!", (Object[])new Object[]{forcePlay ? 1 : 0, channel != null ? channel.getChannelId() : ""});
                        }
                        if (forcePlay || !ChannelComplexWindowController.this.mNeedInterceptMedia) {
                            ChannelComplexWindowController.this.destroyJoinedSubChannel(false, continueCallBacker);
                        } else {
                            MyWindowController.this.showOpenMediaDialogByOpenMusic(continueCallBacker, interceptCallBacker);
                        }
                    }

                    public boolean preJoinMediaRoom(IChannel channel, Runnable interceptCallBacker) {
                        if (channel != null && channel.getPluginService().getCurPluginData() != null && channel.getPluginService().getCurPluginData().mode == 1) {
                            IChannelWindowController subJoinController;
                            IChannelWindowController iChannelWindowController = subJoinController = ChannelComplexWindowController.this.subJoinedChannel != null ? ChannelComplexWindowController.this.subJoinedChannel : ChannelComplexWindowController.this.subJoinedChannelTemp;
                            if (ChannelComplexWindowController.this.mNeedInterceptMedia && subJoinController != null && !subJoinController.isDestroyed()) {
                                if (interceptCallBacker != null) {
                                    interceptCallBacker.run();
                                }
                                return true;
                            }
                            return false;
                        }
                        return false;
                    }
                };
            }
            ((IChannelCenterService)this.getServiceManager().getService(IChannelCenterService.class)).getChannel(this.getEnterParams().roomId).getMediaService().setMediaIntercepter(ChannelComplexWindowController.this.mMediaIntercepter);
        }

        @Override
        protected boolean handleGameFilter(FilterRunnable runnable2) {
            return ChannelComplexWindowController.this.handleGameFilterInner(this, runnable2);
        }

        @Override
        public void destroy(boolean popWinAni, IVoiceRoomExitCallback callbackWhenExited, Map<String, Object> extMap, boolean notLeaveRequest, String nextJoinSuccessChannel, int nextJoinSuccessEntry, boolean callLeaveBaseGroupcast) {
            IChannel channel;
            if (this.mInterceptStateChangeListeners != null) {
                this.mInterceptStateChangeListeners.clear();
            }
            if (ChannelComplexWindowController.this.subJoinedChannel != null) {
                ChannelComplexWindowController.this.subJoinedChannel.setIntercepter(null);
            }
            if ((channel = this.getChannel()) != null) {
                if (this.mNotifyHandler != null) {
                    ((AbsNotifyDispatchService)channel.getNotifyDispatcher()).removeHandler(this.mNotifyHandler);
                }
                if (ChannelComplexWindowController.this.mMediaIntercepter != null && channel.getMediaService().getMediaIntercepter() == ChannelComplexWindowController.this.mMediaIntercepter) {
                    channel.getMediaService().setMediaIntercepter(null);
                    ChannelComplexWindowController.this.mMediaIntercepter = null;
                }
            } else if (ChannelComplexWindowController.this.mMediaIntercepter != null) {
                IMediaService mediaService = ((IChannelCenterService)this.getServiceManager().getService(IChannelCenterService.class)).getChannel(this.getEnterParams().roomId).getMediaService();
                if (mediaService.getMediaIntercepter() == ChannelComplexWindowController.this.mMediaIntercepter) {
                    mediaService.setMediaIntercepter(null);
                }
                ChannelComplexWindowController.this.mMediaIntercepter = null;
            }
            super.destroy(popWinAni, callbackWhenExited, extMap, notLeaveRequest, nextJoinSuccessChannel, nextJoinSuccessEntry, callLeaveBaseGroupcast);
            if (this.mDialog != null) {
                this.mDialogLinkManager.dismissDialog();
                this.mDialog = null;
            }
        }

        @Override
        public void onWindowShown(AbstractWindow abstractWindow) {
            if (this.destroyed) {
                return;
            }
            super.onWindowShown(abstractWindow);
            if (abstractWindow == this.window) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)"onWindowShown:%s, subJoinedChannel:%s", (Object[])new Object[]{abstractWindow, ChannelComplexWindowController.this.subJoinedChannel != null ? ChannelComplexWindowController.this.subJoinedChannel.getChannelId() : ""});
                }
                IChannel channel = this.getChannel();
                if (this.mFirstShown && channel != null) {
                    ((AbsNotifyDispatchService)this.getChannel().getNotifyDispatcher()).addHandler(this.getNotifyHandler());
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            MyWindowController.this.showMediaTipsIfNeed(false);
                        }
                    }, (long)200L);
                }
                this.mFirstShown = false;
                if (ChannelComplexWindowController.this.subJoinedChannel != null) {
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (ChannelComplexWindowController.this.subJoinedChannel != null) {
                                ChannelComplexWindowController.this.subJoinedChannel.bringWindowToBackGround(false);
                            }
                        }
                    });
                }
            } else if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"onWindowShown:%s, mWindow:", (Object[])new Object[]{abstractWindow, this.window});
            }
        }

        @Override
        public void minimize() {
            if (this.getChannel() == null && this.getChannel().getPluginService().getCurPluginData().mode != 1) {
                super.minimize();
                return;
            }
            ChannelComplexWindowController.this.curJoinedChannel.getChannel().getDataService().getCacheDetail();
            if (ChannelComplexWindowController.this.subJoinedChannel != null && StringUtils.isNotEmpty((String)ChannelComplexWindowController.this.subJoinedChannel.getChannelId())) {
                ChannelComplexWindowController.this.replaceCurController(ChannelComplexWindowController.this.subJoinedChannel.getChannelId());
            } else {
                super.minimize();
            }
        }

        @Override
        public String getCoexistenceVoiceChannel() {
            if (ChannelComplexWindowController.this.subJoinedChannel != null && StringUtils.isNotEmpty((String)ChannelComplexWindowController.this.subJoinedChannel.getChannelId())) {
                return ChannelComplexWindowController.this.subJoinedChannel.getChannelId();
            }
            return "";
        }
    }
}

