/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.module.history.mvp;

import android.content.Context;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.dialog.OkCancelDialog;
import com.yy.appbase.ui.dialog.OkCancelDialogListener;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.cbase.channelhiido.RoomTrack;
import com.yy.hiyo.channel.module.history.IVoiceRoomHistoryCallBack;
import com.yy.hiyo.channel.module.history.VoiceRoomHistoryPage;
import com.yy.hiyo.channel.module.history.mvp.IVoiceRoomHistoryService;
import com.yy.hiyo.channel.module.history.mvp.VoiceRoomHistoryModel;
import com.yy.hiyo.channel.module.history.mvp.VoiceRoomHistoryMvp;
import com.yy.hiyo.mvp.base.BasePresenter;
import com.yy.hiyo.mvp.base.IMvpContext;
import java.util.ArrayList;
import java.util.List;
import net.ihago.channel.srv.mgr.HistoryChannel;

public class VoiceRoomHistoryPresenter
extends BasePresenter
implements VoiceRoomHistoryMvp.IPresenter,
IVoiceRoomHistoryService {
    private MutableLiveData<List<Object>> mHistoryList;
    private MutableLiveData<Boolean> mRequestResult;
    private VoiceRoomHistoryModel mModel = new VoiceRoomHistoryModel(ServiceManagerProxy.getServiceManager());
    private IVoiceRoomHistoryCallBack mCallBack;
    protected DialogLinkManager mDialogLinkManager;
    private VoiceRoomHistoryPage mPage;
    private static final String TAG = "VoiceRoomHistoryPresenter";

    public VoiceRoomHistoryPresenter(IMvpContext mvpContext, IVoiceRoomHistoryCallBack iVoiceRoomHistoryCallBack) {
        super(mvpContext);
        this.mCallBack = iVoiceRoomHistoryCallBack;
    }

    @Override
    public LiveData<List<Object>> getVoiceRoomHistory() {
        if (this.mHistoryList == null) {
            this.mHistoryList = new MutableLiveData();
        }
        return this.mHistoryList;
    }

    @Override
    public LiveData<Boolean> getRequestResult() {
        if (this.mRequestResult == null) {
            this.mRequestResult = new MutableLiveData();
        }
        return this.mRequestResult;
    }

    @Override
    public void exitVoiceHistoryRoom() {
        this.mCallBack.exitRoomHistory();
    }

    @Override
    public void showDeleteDialog() {
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTVoiceRoom", (String)"VoiceRoomHistoryPresentershow delete dialog", (Object[])new Object[0]);
        }
        RoomTrack.INSTANCE.onVoiceRoomHistoryListDeleteClick();
        String strTitle = ResourceUtils.getString((int)R.string.title_voice_room_history_delete);
        String strCancel = ResourceUtils.getString((int)R.string.btn_voice_room_history_cancel);
        String strOK = ResourceUtils.getString((int)R.string.btn_voice_room_history_sure);
        OkCancelDialog dialog2 = new OkCancelDialog((CharSequence)strTitle, (CharSequence)strOK, (CharSequence)strCancel, true, true, new OkCancelDialogListener(){

            public void onCancel() {
                RoomTrack.INSTANCE.onVoiceRoomHistoryListDeleteCancel();
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTVoiceRoom", (String)"VoiceRoomHistoryPresenterdelete cancel", (Object[])new Object[0]);
                }
            }

            public void onOk() {
                RoomTrack.INSTANCE.onVoiceRoomHistoryListDeleteSure();
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTVoiceRoom", (String)"VoiceRoomHistoryPresenterdelete ok", (Object[])new Object[0]);
                }
                VoiceRoomHistoryPresenter.this.mModel.deleteLocalVoiceRoomHistory();
                VoiceRoomHistoryPresenter.this.mHistoryList.setValue(new ArrayList());
                VoiceRoomHistoryPresenter.this.mRequestResult.setValue((Object)true);
            }
        });
        if (this.mDialogLinkManager == null) {
            this.mDialogLinkManager = new DialogLinkManager((Context)this.getContext());
        }
        this.mDialogLinkManager.showDialog((BaseDialog)dialog2);
        RoomTrack.INSTANCE.onVoiceRoomHistoryListDeleteDialogShow();
    }

    @Override
    public void updateOrInsertVoiceRoomRecord(String roomId) {
        this.mModel.updateLocalVoiceRoomHistory(roomId);
    }

    @Override
    public void deleteVoiceRoomRecord(String roomId) {
        this.mModel.deleteLocalVoiceRoomHistory(roomId);
    }

    @Override
    public void requestVoiceHistoryRecrod() {
        this.mModel.getHistoryRoom(new VoiceRoomHistoryMvp.IModel.CallBack<List<Object>, Boolean>(){

            @Override
            public void onResponse(List<Object> data) {
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTVoiceRoom", (String)("VoiceRoomHistoryPresenter requestVoiceHistoryRecrod on Response " + data.size()), (Object[])new Object[0]);
                }
                if (VoiceRoomHistoryPresenter.this.mHistoryList != null) {
                    VoiceRoomHistoryPresenter.this.mHistoryList.setValue(data);
                } else if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTVoiceRoom", (String)("VoiceRoomHistoryPresenter requestVoiceHistoryRecrod mHistoryList null " + data.size()), (Object[])new Object[0]);
                }
            }

            @Override
            public void requestResult(Boolean data) {
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTVoiceRoom", (String)("VoiceRoomHistoryPresenter requestVoiceHistoryRecrod on result " + data), (Object[])new Object[0]);
                }
                if (VoiceRoomHistoryPresenter.this.mRequestResult != null) {
                    VoiceRoomHistoryPresenter.this.mRequestResult.setValue((Object)data);
                } else if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTVoiceRoom", (String)("VoiceRoomHistoryPresenter requestVoiceHistoryRecrod mRequestResult null " + data), (Object[])new Object[0]);
                }
            }
        });
    }

    @Override
    public void onItemClick(String roomId, @NonNull HistoryChannel channel) {
        if (channel != null && channel.plugin_info != null) {
            this.mCallBack.enterVoiceRoom(roomId, channel.plugin_info.type, StringUtils.isNotEmpty((String)channel.avatar) ? channel.url : channel.avatar);
        } else {
            this.mCallBack.enterVoiceRoom(roomId, -1, StringUtils.isNotEmpty((String)channel.avatar) ? channel.url : channel.avatar);
        }
    }

    @Override
    public void showLoadingDialog() {
        if (this.mPage != null) {
            this.mPage.showLoading();
        }
    }

    @Override
    public void setView(View view) {
        this.mPage = (VoiceRoomHistoryPage)view;
    }

    @Override
    public void clearData() {
        this.mHistoryList = null;
        this.mRequestResult = null;
        this.mModel.clearData();
        this.mPage = null;
    }

    private FragmentActivity getContext() {
        return this.getMvpContext().getContext();
    }
}

