/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.module.history;

import android.os.Message;
import android.text.TextUtils;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.notify.NotificationIdDef;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.logger.MLog;
import com.yy.framework.core.Environment;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationDef;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.hiyo.channel.base.EnterParam;
import com.yy.hiyo.channel.base.IChannelCenterService;
import com.yy.hiyo.channel.module.history.IVoiceRoomHistoryCallBack;
import com.yy.hiyo.channel.module.history.VoiceRoomHistoryWindow;
import com.yy.hiyo.channel.module.history.mvp.VoiceRoomHistoryPresenter;
import com.yy.hiyo.mvp.base.MvpController;

public class VoiceRoomHistoryController
extends MvpController
implements IVoiceRoomHistoryCallBack {
    private static final String TAG = "VoiceRoomHistoryController";
    private VoiceRoomHistoryPresenter mPresenter = new VoiceRoomHistoryPresenter(this.getMvpContext(), this);
    private VoiceRoomHistoryWindow mWindow;

    public VoiceRoomHistoryController(Environment env) {
        super(env);
    }

    public void handleMessage(Message msg) {
        super.handleMessage(msg);
        if (msg.what == AppbaseMsgDef.ChannelOrRoomHistoryMsgDef.OPEN_HISTORY) {
            this.enterRoomHistory(true);
        } else if (msg.what == AppbaseMsgDef.ChannelOrRoomHistoryMsgDef.EXIT_HISTORY) {
            this.exitRoomHistory();
        } else if (msg.what == AppbaseMsgDef.ChannelOrRoomHistoryMsgDef.HISTORY_UPDATE) {
            String roomId = (String)msg.obj;
            if (FeatureLog.isLogLevelBlowInfo()) {
                FeatureLog.i((String)"FTVoiceRoom", (String)("VoiceRoomHistoryController\u6536\u5230\u63d2\u5165\u5386\u53f2\u5217\u8868roomId\u7684\u6d88\u606f roomdId" + roomId), (Object[])new Object[0]);
            }
            if (this.mPresenter == null) {
                this.mPresenter = new VoiceRoomHistoryPresenter(this.getMvpContext(), this);
            }
            if (!TextUtils.isEmpty((CharSequence)roomId)) {
                this.mPresenter.updateOrInsertVoiceRoomRecord(roomId);
            }
            if (this.mWindow != null) {
                this.mPresenter.requestVoiceHistoryRecrod();
            }
        } else if (msg.what == AppbaseMsgDef.ChannelOrRoomHistoryMsgDef.HISTORY_DELETE) {
            String roomId = (String)msg.obj;
            if (FeatureLog.isLogLevelBlowInfo()) {
                FeatureLog.i((String)"FTVoiceRoom", (String)("VoiceRoomHistoryController\u6536\u5230\u5220\u9664\u5386\u53f2\u5217\u8868roomId\u7684\u6d88\u606f roomdId" + roomId), (Object[])new Object[0]);
            }
            if (this.mPresenter == null) {
                this.mPresenter = new VoiceRoomHistoryPresenter(this.getMvpContext(), this);
            }
            if (!TextUtils.isEmpty((CharSequence)roomId)) {
                this.mPresenter.deleteVoiceRoomRecord(roomId);
            }
        }
    }

    public void notify(Notification notification) {
        super.notify(notification);
        if (notification.id == NotificationDef.N_LOGIN_ACCOUNT_CHANGED) {
            if (this.mPresenter != null) {
                this.mPresenter.clearData();
            }
            this.mWindow = null;
        } else if (notification.id == NotificationIdDef.CHANNEL_ENTERED && notification.extObj instanceof String) {
            String channelId = (String)notification.extObj;
            IChannelCenterService service = (IChannelCenterService)this.getServiceManager().getService(IChannelCenterService.class);
            if (service.getChannel(channelId) != null && service.getChannel(channelId).getDataService() != null && service.getChannel(channelId).getDataService().getChannelDetailInfo(null) != null && service.getChannel((String)channelId).getDataService().getChannelDetailInfo(null).baseInfo != null) {
                long ownerId = service.getChannel((String)channelId).getDataService().getChannelDetailInfo(null).baseInfo.ownerUid;
                if ("hago.amongus".equals(service.getChannel((String)channelId).getDataService().getChannelDetailInfo(null).baseInfo.source)) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TAG, (String)"enter among us room ,not record", (Object[])new Object[0]);
                    }
                    return;
                }
                if (ownerId != AccountUtil.getUid() || "hago.amongus-user".equals(service.getChannel((String)channelId).getDataService().getChannelDetailInfo(null).baseInfo.source)) {
                    this.sendMessage(AppbaseMsgDef.ChannelOrRoomHistoryMsgDef.HISTORY_UPDATE, -1, -1, notification.extObj);
                }
            }
        }
    }

    @Override
    public VoiceRoomHistoryPresenter getVoiceRoomHistoryPresenter() {
        if (this.mPresenter == null) {
            this.mPresenter = new VoiceRoomHistoryPresenter(this.getMvpContext(), this);
        }
        return this.mPresenter;
    }

    @Override
    public void enterRoomHistory(boolean animated) {
        this.mWindow = this.getRoomHistoryWindow(animated);
        this.mWindowMgr.pushWindow((AbstractWindow)this.mWindow, animated);
    }

    @Override
    public void exitRoomHistory() {
        if (this.mWindow != null) {
            this.mWindowMgr.popWindow(true, (AbstractWindow)this.mWindow);
        }
    }

    public void onWindowAttach(AbstractWindow abstractWindow) {
        super.onWindowAttach(abstractWindow);
        if (this.mPresenter != null) {
            this.mPresenter.showLoadingDialog();
            this.mPresenter.requestVoiceHistoryRecrod();
        }
    }

    @Override
    public VoiceRoomHistoryWindow getRoomHistoryWindow(boolean animated) {
        if (this.mWindow == null) {
            this.mWindow = new VoiceRoomHistoryWindow(this.getMvpContext(), this, (UICallBacks)this, animated);
        }
        return this.mWindow;
    }

    @Override
    public void enterVoiceRoom(String roomId, int pluginType, String avatarUrl) {
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTVoiceRoom", (String)("VoiceRoomHistoryController\u4ece\u5386\u53f2\u5217\u8868\u8fdb\u5165\u8bed\u97f3\u623f roomdId" + roomId), (Object[])new Object[0]);
        }
        EnterParam enterParam = EnterParam.obtain((String)roomId, (int)9, (String)"");
        Message message = Message.obtain();
        message.what = AppbaseMsgDef.ChannelMsgDef.ENTRY_CHANNEL;
        message.obj = enterParam;
        enterParam.setExtra("pluginType", (Object)pluginType);
        this.sendMessage(message);
    }

    public void onWindowDetach(AbstractWindow abstractWindow) {
        super.onWindowDetach(abstractWindow);
        this.mWindow = null;
        this.mPresenter = null;
    }
}

