/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.module.follow.protocol;

import com.yy.appbase.callback.ICommonCallback;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.channel.follow.IFollowProtoCallback;
import net.ihago.room.srv.follow.ECode;
import net.ihago.room.srv.follow.Error;

public class ProtoHelper {
    public static final int CODE_COMMON_ERR = 5000;
    public static final int CODE_TIMEOUT = 5001;
    public static final String MSG_TIMEOUT = "request timeout";
    public static final int CODE_NULL_RESULT = 5002;
    public static final String MSG_NULL_RESULT = "result is null";

    public static boolean isOK(Error error) {
        return error == null || error.code == (long)ECode.EOK.getValue();
    }

    public static boolean isFail(Error error) {
        return !ProtoHelper.isOK(error);
    }

    public static String error2String(Error error) {
        if (error == null) {
            return "error == null";
        }
        return StringUtils.formatWitUSLocal((String)"error: code = %d, msg = %s", (Object[])new Object[]{error.code, error.tips});
    }

    public static <T> void handleOnSuccess(IFollowProtoCallback<T> callback2, T data) {
        if (callback2 == null) {
            return;
        }
        callback2.onSuccess(data);
    }

    public static void handleOnFail(IFollowProtoCallback callback2, int code, String msg) {
        if (callback2 == null) {
            return;
        }
        callback2.onFail(code, msg);
    }

    public static void handleOnFailInMain(final IFollowProtoCallback callback2, final int code, final String msg) {
        if (callback2 == null) {
            return;
        }
        if (YYTaskExecutor.isMainThread()) {
            callback2.onFail(code, msg);
        } else {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    callback2.onFail(code, msg);
                }
            });
        }
    }

    public static void handleOnFailInMain(ICommonCallback callback2, int code, String msg) {
        if (callback2 == null) {
            return;
        }
        if (YYTaskExecutor.isMainThread()) {
            callback2.onFail(code, msg, new Object[0]);
        } else {
            YYTaskExecutor.postToMainThread(() -> callback2.onFail(code, msg, new Object[0]));
        }
    }

    public static <T> void handleOnSuccessInMain(final IFollowProtoCallback<T> callback2, final T data) {
        if (callback2 == null) {
            return;
        }
        if (YYTaskExecutor.isMainThread()) {
            callback2.onSuccess(data);
        } else {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    callback2.onSuccess(data);
                }
            });
        }
    }

    public static <T> void handleOnSuccessInMain(ICommonCallback<T> callback2, T data, Object ... ext) {
        if (callback2 == null) {
            return;
        }
        if (YYTaskExecutor.isMainThread()) {
            callback2.onSuccess(data, ext);
        } else {
            YYTaskExecutor.postToMainThread(() -> callback2.onSuccess(data, ext));
        }
    }
}

