/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.module.follow.list.reminderlist.ui;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.ui.adapter.BaseItemBinder;
import com.yy.appbase.ui.utils.AvatarUtils;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.YYImageUtils;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.bean.ReminderDetails;
import net.ihago.room.srv.follow.NoticeChannelInfo;

public class ReminderViewHolder
extends BaseItemBinder.ViewHolder<ReminderDetails> {
    private RecycleImageView mIvAvatar;
    private YYTextView mTvNick;
    private YYTextView mTvSitting;
    private YYTextView mTvRoomName;
    private YYTextView mTvPeopleCount;
    private YYFrameLayout mFlFriendTag;
    private OnItemClickListener mItemClickListener;

    public ReminderViewHolder(View itemView) {
        super(itemView);
        this.mIvAvatar = (RecycleImageView)itemView.findViewById(R.id.iv_avatar);
        this.mTvNick = (YYTextView)itemView.findViewById(R.id.tv_nick);
        this.mTvSitting = (YYTextView)itemView.findViewById(R.id.tv_sitting);
        this.mTvRoomName = (YYTextView)itemView.findViewById(R.id.tv_room_name);
        this.mTvPeopleCount = (YYTextView)itemView.findViewById(R.id.tv_people_count);
        this.mFlFriendTag = (YYFrameLayout)itemView.findViewById(R.id.fl_friend_tag);
        itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ReminderViewHolder.this.mItemClickListener != null) {
                    ReminderViewHolder.this.mItemClickListener.onItemClicked((ReminderDetails)ReminderViewHolder.this.getData());
                }
            }
        });
    }

    public void setData(ReminderDetails data) {
        UserInfoKS userInfoKS;
        super.setData((Object)data);
        NoticeChannelInfo noticeUserInfo = data.getNoticeUserInfo();
        if (noticeUserInfo != null) {
            this.mTvRoomName.setText((CharSequence)noticeUserInfo.channel_name);
            this.mTvPeopleCount.setText((CharSequence)("" + noticeUserInfo.player_num));
            if (noticeUserInfo.on_seat.booleanValue()) {
                this.mTvSitting.setVisibility(0);
            } else {
                this.mTvSitting.setVisibility(8);
            }
            if (noticeUserInfo.is_friends.booleanValue()) {
                this.mFlFriendTag.setVisibility(0);
            } else {
                this.mFlFriendTag.setVisibility(8);
            }
        }
        if ((userInfoKS = data.getUserInfoKS()) != null) {
            this.mTvNick.setText((CharSequence)userInfoKS.nick);
            String avatarUrl = userInfoKS.avatar + YYImageUtils.getThumbnailPostfix((int)75);
            ImageLoader.loadImage((RecycleImageView)this.mIvAvatar, (String)avatarUrl, (int)0, (int)AvatarUtils.getDefaultAvatar((int)userInfoKS.getSex()));
        }
    }

    public void setItemClickListener(OnItemClickListener itemClickListener) {
        this.mItemClickListener = itemClickListener;
    }

    public static BaseItemBinder getItemBinder(final OnItemClickListener itemClickListener) {
        return new BaseItemBinder<ReminderDetails, ReminderViewHolder>(){

            @NonNull
            protected ReminderViewHolder onCreateViewHolder(@NonNull LayoutInflater inflater, @NonNull ViewGroup parent) {
                View itemView = inflater.inflate(R.layout.reminder_list_item_channel, parent, false);
                ReminderViewHolder reminderViewHolder = new ReminderViewHolder(itemView);
                reminderViewHolder.setItemClickListener(itemClickListener);
                return reminderViewHolder;
            }
        };
    }

    public static interface OnItemClickListener {
        public void onItemClicked(ReminderDetails var1);
    }
}

