/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.module.follow.list.reminderlist;

import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import com.yy.appbase.data.PageData;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.utils.FP;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.channel.base.bean.ReminderDetails;
import com.yy.hiyo.channel.follow.IFollowProtoCallback;
import com.yy.hiyo.channel.module.follow.list.reminderlist.ReminderListModel;
import com.yy.hiyo.channel.module.follow.list.reminderlist.ReminderListMvp;
import com.yy.hiyo.mvp.base.BasePresenter;
import com.yy.hiyo.mvp.base.IMvpContext;
import com.yy.hiyo.voice.base.mediav1.service.IMediaRoomService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.ihago.room.srv.follow.NoticeChannelInfo;
import org.jetbrains.annotations.NotNull;

public class ReminderListPresenter
extends BasePresenter<IMvpContext>
implements ReminderListMvp.IPresenter {
    private MutableLiveData<PageData<ReminderDetails>> mReminderNextPageData = new MutableLiveData();
    private MutableLiveData<Integer> mListTotalData = new MutableLiveData();
    private ReminderListMvp.IModel mReminderListModel = new ReminderListModel();
    private ReminderListMvp.IView mRemindrListView;

    public ReminderListPresenter(IMvpContext mvpContext, @NotNull ReminderListMvp.IView view) {
        super(mvpContext);
        this.mRemindrListView = view;
    }

    @Override
    public void onReminderListRefresh() {
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTVoiceRoomFollow", (String)"\u5173\u6ce8\u63d0\u9192\u5217\u8868\u5237\u65b0", (Object[])new Object[0]);
        }
        this.mReminderListModel.reminderListRefresh(new IFollowProtoCallback<PageData<ReminderDetails>>(){

            public void onSuccess(@NotNull PageData<ReminderDetails> data) {
                List infos;
                ReminderListPresenter.this.mRemindrListView.clearStatus();
                ReminderListPresenter.this.mReminderNextPageData.setValue(data);
                ReminderListPresenter.this.mListTotalData.setValue((Object)data.getTotal());
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTVoiceRoomFollow", (String)"\u5173\u6ce8\u63d0\u9192\u5217\u8868\u5237\u65b0\u6210\u529f, %s", (Object[])new Object[]{data});
                }
                if (!FP.empty((Collection)(infos = data.getData()))) {
                    ArrayList<String> cids = new ArrayList<String>();
                    for (ReminderDetails next : infos) {
                        NoticeChannelInfo noticeUserInfo = next.getNoticeUserInfo();
                        if (noticeUserInfo == null || !StringUtils.isNotEmpty((String)noticeUserInfo.channel_id)) continue;
                        cids.add(noticeUserInfo.channel_id);
                    }
                    ((IMediaRoomService)ServiceManagerProxy.getService(IMediaRoomService.class)).preloadRoomMiddleInfos(cids);
                }
            }

            public void onFail(int code, String msg) {
                ReminderListPresenter.this.mRemindrListView.clearStatus();
                FeatureLog.e((String)"FTVoiceRoomFollow", (String)"\u5173\u6ce8\u63d0\u9192\u5217\u8868\u5237\u65b0\u5931\u8d25, code = %d, msg = %s", (Object[])new Object[]{code, msg});
            }
        });
    }

    @Override
    public void onReminderListLoadmore() {
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTVoiceRoomFollow", (String)"\u5173\u6ce8\u63d0\u9192\u5217\u8868\u52a0\u8f7d\u4e0b\u4e00\u9875", (Object[])new Object[0]);
        }
        this.mReminderListModel.reminderListNextPage(new IFollowProtoCallback<PageData<ReminderDetails>>(){

            public void onSuccess(@NotNull PageData<ReminderDetails> data) {
                ReminderListPresenter.this.mRemindrListView.clearStatus();
                ReminderListPresenter.this.mReminderNextPageData.setValue(data);
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTVoiceRoomFollow", (String)"\u5173\u6ce8\u63d0\u9192\u5217\u8868\u52a0\u8f7d\u4e0b\u4e00\u9875\u6210\u529f, %s", (Object[])new Object[]{data});
                }
            }

            public void onFail(int code, String msg) {
                ReminderListPresenter.this.mRemindrListView.clearStatus();
                FeatureLog.e((String)"FTVoiceRoomFollow", (String)"\u5173\u6ce8\u63d0\u9192\u5217\u8868\u52a0\u8f7d\u4e0b\u4e00\u9875\u5931\u8d25, code = %d, msg = %s", (Object[])new Object[]{code, msg});
            }
        });
    }

    @Override
    public LiveData<Integer> listTotal() {
        return this.mListTotalData;
    }

    @Override
    public LiveData<PageData<ReminderDetails>> nextPage() {
        return this.mReminderNextPageData;
    }
}

