/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.module.follow.list.reminderlist;

import com.yy.appbase.data.PageData;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.UserInfoModule;
import com.yy.appbase.service.callback.OnProfileCallback;
import com.yy.base.utils.FP;
import com.yy.hiyo.channel.base.bean.ReminderDetails;
import com.yy.hiyo.channel.follow.IFollowProtoCallback;
import com.yy.hiyo.channel.module.follow.list.reminderlist.ReminderListMvp;
import com.yy.hiyo.channel.module.follow.protocol.FollowProtoService;
import com.yy.hiyo.channel.module.follow.protocol.ProtoHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.ihago.room.srv.follow.GetNoticeUserChannelInfoRes;
import net.ihago.room.srv.follow.NoticeChannelInfo;
import net.ihago.room.srv.follow.PullNoticeChannelListRes;
import org.jetbrains.annotations.NotNull;

public class ReminderListModel
implements ReminderListMvp.IModel {
    private List<Long> noticeUidList;
    private int pageSize = 50;
    private int pageIndex = 0;

    @Override
    public void reminderListRefresh(final IFollowProtoCallback<PageData<ReminderDetails>> callback2) {
        FollowProtoService.getInstance().requestNoticeList(new IFollowProtoCallback<PullNoticeChannelListRes>(){

            public void onSuccess(@NotNull PullNoticeChannelListRes data) {
                ReminderListModel.this.noticeUidList = data.uids;
                ReminderListModel.this.pageSize = FP.orInt((Long)data.page_size);
                List noticeUserList = data.list;
                PageData pageData = new PageData();
                pageData.setPageIndex(0);
                if (ReminderListModel.this.noticeUidList != null && ReminderListModel.this.noticeUidList.size() > 0) {
                    if (ReminderListModel.this.noticeUidList.size() < ReminderListModel.this.pageSize) {
                        pageData.setHasNextPage(false);
                    } else {
                        pageData.setHasNextPage(true);
                    }
                    pageData.setTotal(ReminderListModel.this.noticeUidList.size());
                    ReminderListModel.this.requestPageUserDetails(noticeUserList, (PageData<ReminderDetails>)pageData, (IFollowProtoCallback<PageData<ReminderDetails>>)callback2);
                } else {
                    pageData.setHasNextPage(false);
                    pageData.setTotal(0);
                    ReminderListModel.this.pageIndex = 0;
                    ProtoHelper.handleOnSuccessInMain(callback2, pageData);
                }
            }

            public void onFail(int code, String msg) {
                ProtoHelper.handleOnFailInMain(callback2, code, msg);
            }
        }, true);
    }

    @Override
    public void reminderListNextPage(final IFollowProtoCallback<PageData<ReminderDetails>> callback2) {
        int reqPageIndex = this.pageIndex + 1;
        ArrayList<Long> reqUidList = new ArrayList<Long>();
        final PageData pageData = new PageData();
        pageData.setPageIndex(reqPageIndex);
        if (this.noticeUidList != null) {
            int index;
            pageData.setTotal(this.noticeUidList.size());
            int startIndex = reqPageIndex * this.pageSize;
            int endIndex = startIndex + this.pageSize;
            for (index = startIndex; index < this.noticeUidList.size() && index <= endIndex; ++index) {
                reqUidList.add(this.noticeUidList.get(index));
            }
            if (index < this.noticeUidList.size()) {
                pageData.setHasNextPage(true);
            } else {
                pageData.setHasNextPage(false);
            }
        } else {
            pageData.setTotal(0);
            pageData.setHasNextPage(false);
        }
        if (reqUidList.size() > 0) {
            FollowProtoService.getInstance().requestNoticeUserList(reqUidList, new IFollowProtoCallback<GetNoticeUserChannelInfoRes>(){

                public void onSuccess(@NotNull GetNoticeUserChannelInfoRes data) {
                    ReminderListModel.this.requestPageUserDetails(data.list, (PageData<ReminderDetails>)pageData, (IFollowProtoCallback<PageData<ReminderDetails>>)callback2);
                }

                public void onFail(int code, String msg) {
                    ProtoHelper.handleOnFailInMain(callback2, code, msg);
                }
            });
        } else {
            this.pageIndex = pageData.getPageIndex();
            ProtoHelper.handleOnSuccessInMain(callback2, pageData);
        }
    }

    private void requestPageUserDetails(final List<NoticeChannelInfo> noticeUserList, final PageData<ReminderDetails> pageData, final IFollowProtoCallback<PageData<ReminderDetails>> callback2) {
        if (noticeUserList != null && noticeUserList.size() > 0) {
            ArrayList<Long> uidList = new ArrayList<Long>();
            for (NoticeChannelInfo noticeUserInfo : noticeUserList) {
                uidList.add(noticeUserInfo.uid);
            }
            ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getUserInfos(uidList, new OnProfileCallback(){

                public void onSuccess(int id2, List<UserInfoKS> userInfoKSList) {
                    HashMap<Long, UserInfoKS> userInfoKSMap = new HashMap<Long, UserInfoKS>();
                    if (userInfoKSList != null) {
                        for (UserInfoKS userInfoKS : userInfoKSList) {
                            if (userInfoKS == null) continue;
                            userInfoKSMap.put(userInfoKS.getUid(), userInfoKS);
                        }
                    }
                    ArrayList<ReminderDetails> reminderDetailsList = new ArrayList<ReminderDetails>();
                    for (NoticeChannelInfo noticeUserInfo : noticeUserList) {
                        ReminderDetails reminderDetails = new ReminderDetails();
                        reminderDetails.setUserInfoKS((UserInfoKS)userInfoKSMap.get(noticeUserInfo.uid));
                        reminderDetails.setNoticeUserInfo(noticeUserInfo);
                        reminderDetailsList.add(reminderDetails);
                    }
                    ReminderListModel.this.pageIndex = pageData.getPageIndex();
                    pageData.setData(reminderDetailsList);
                    ProtoHelper.handleOnSuccessInMain(callback2, pageData);
                }

                public void onFail(int id2, String msg, String response) {
                    ProtoHelper.handleOnFail(callback2, 5000, msg);
                }

                public int id() {
                    return 0;
                }
            });
        } else {
            this.pageIndex = pageData.getPageIndex();
            ProtoHelper.handleOnSuccessInMain(callback2, pageData);
        }
    }
}

