/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.module.follow;

import com.yy.appbase.abtest.IAB;
import com.yy.appbase.abtest.newab.NAB;
import com.yy.appbase.abtest.newab.NewABDefine;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.UserInfoModule;
import com.yy.appbase.roomfloat.FloatMsgInfo;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.callback.OnProfileCallback;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.VoiceRoomFollowConfig;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.DateUtils;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.TimeUtils;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.ChannelDefine;
import com.yy.hiyo.channel.base.IChannelCenterService;
import com.yy.hiyo.channel.cbase.AbsPage;
import com.yy.hiyo.channel.cbase.channelhiido.RoomTrack;
import com.yy.hiyo.channel.cbase.context.BaseChannelPresenter;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.cbase.publicscreen.IPublicScreenService;
import com.yy.hiyo.channel.cbase.publicscreen.callback.IPublicScreenModulePresenter;
import com.yy.hiyo.channel.cbase.tools.IRevenueToolsModulePresenter;
import com.yy.hiyo.channel.module.follow.bean.FloatMsgFollowInfo;
import com.yy.hiyo.channel.publicscreen.BaseImMsg;
import com.yy.hiyo.relation.base.IRelationService;
import com.yy.hiyo.relation.base.data.RelationInfo;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class FollowPresenter
extends BaseChannelPresenter<AbsPage, IChannelPageContext<AbsPage>> {
    private static final String TAG = "FollowPresenter";
    private static final int ThREE_MiNIS = 180000;
    protected static final String SHOWED_FOLLOW_TIMES = "showed_follow_times";
    private static final String LAST_COMMON_FOLLOW_MILLS = "last_common_follow_mills";
    private int mFollowTime = 180000;
    private int mFollowFloatSecond = 120;
    private int floatingTime = 10;
    private int mFollowCount = 3;
    protected long mRoomOwnerId = 0L;
    protected int followGuideTimes = 3;
    protected long times = 0L;
    private List<Integer> mFollowPluginModes;
    private IAB mUITest;
    Runnable followGuideRunnable = () -> {
        if (this.isFollowing() || this.mRoomOwnerId <= 0L || this.mRoomOwnerId == AccountUtil.getUid()) {
            return;
        }
        ArrayList<Long> uids = new ArrayList<Long>();
        uids.add(this.mRoomOwnerId);
        uids.add(AccountUtil.getUid());
        if (this.getChannel().getPluginService().getCurPluginData().isVideoMode() || NAB.B.equals((Object)this.mUITest) && this.isSupportFollowGuide()) {
            ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getUserInfos(uids, new OnProfileCallback(){

                public void onSuccess(int id2, List<UserInfoKS> userInfoKSList) {
                    if (FP.empty(userInfoKSList) || FollowPresenter.this.isDestroyed()) {
                        return;
                    }
                    FollowPresenter.this.addFloatMsg(userInfoKSList, FollowPresenter.this.times);
                }

                public void onFail(int id2, String msg, String response) {
                }

                public int id() {
                    return 0;
                }
            });
        }
    };
    Runnable mFollowRunnable = new Runnable(){

        @Override
        public void run() {
            if (!FollowPresenter.this.isFollowing()) {
                int followCount = SettingFlags.getIntValue((String)(AccountUtil.getUid() + "key_voice_room_follow_count"), (int)0);
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTVoiceRoomFollow", (String)"followRunnable unFollowed:%s", (Object[])new Object[]{followCount});
                }
                long appearTime = SettingFlags.getLongValue((String)(AccountUtil.getUid() + "key_voice_room_follow_date"));
                if (followCount > FollowPresenter.this.mFollowCount && TimeUtils.isSameDay((long)appearTime, (long)System.currentTimeMillis())) {
                    if (FeatureLog.isLogLevelBlowInfo()) {
                        FeatureLog.i((String)"FTVoiceRoomFollow", (String)"followRunnable followCount max:%s\uff0c appearCount:%s", (Object[])new Object[]{followCount, FollowPresenter.this.mFollowCount});
                    }
                    return;
                }
                if (FollowPresenter.this.mRoomOwnerId == FollowPresenter.this.getChannelDetailInfo().baseInfo.ownerUid) {
                    if (FeatureLog.isLogLevelBlowInfo()) {
                        FeatureLog.i((String)"FTVoiceRoomFollow", (String)"request roomOwnerInfo success", (Object[])new Object[0]);
                    }
                    if (FollowPresenter.this.isDestroyed()) {
                        return;
                    }
                    FollowPresenter.this.pushFollowMessage(ResourceUtils.getString((int)R.string.channel_radio_video_un_follow_tips), false);
                    RoomTrack.INSTANCE.reportFollowGuideShow(FollowPresenter.this.getChannel().getChannelId(), FollowPresenter.this.mRoomOwnerId + "");
                    int finalFollowCount = followCount + 1;
                    SettingFlags.setIntValue((String)(AccountUtil.getUid() + "key_voice_room_follow_count"), (int)finalFollowCount);
                    SettingFlags.setLongValue((String)(AccountUtil.getUid() + "key_voice_room_follow_date"), (long)System.currentTimeMillis());
                }
            }
        }
    };

    public void onPageAttach(AbsPage page, boolean isReAttach) {
        super.onPageAttach(page, isReAttach);
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTVoiceRoomFollow", (String)"onPageAttach", (Object[])new Object[0]);
        }
        if (this.isBan()) {
            if (FeatureLog.isLogLevelBlowInfo()) {
                FeatureLog.i((String)"FTVoiceRoomFollow", (String)"onPageAttach roomOwner or anchor", (Object[])new Object[0]);
            }
            return;
        }
        this.mRoomOwnerId = this.getAnchorUid();
        this.mUITest = NewABDefine.HAGO_CHATROOM_FOLLOW_UI.getTest();
        AConfigData config = UnifyConfig.INSTANCE.getConfigData(BssCode.VOICE_ROOM_FOLLOW);
        if (config instanceof VoiceRoomFollowConfig) {
            this.mFollowTime = ChannelDefine.isRadioMode((int)this.getChannel().getPluginService().getCurPluginData().mode) ? (this.getChannel().getPluginService().getCurPluginData().isVideoMode() ? ((VoiceRoomFollowConfig)config).getRadioVideoFollowTime() * 1000 : ((VoiceRoomFollowConfig)config).getRadioFollowTime() * 1000) : ((VoiceRoomFollowConfig)config).getFollowTime() * 1000;
            this.mFollowCount = ((VoiceRoomFollowConfig)config).getFollowCount();
            this.followGuideTimes = ((VoiceRoomFollowConfig)config).getFollowGuideTime();
            this.mFollowFloatSecond = ((VoiceRoomFollowConfig)config).getFollowFloatGuideSecond();
            this.floatingTime = ((VoiceRoomFollowConfig)config).getFloatingSecond();
            this.mFollowPluginModes = ((VoiceRoomFollowConfig)config).getFollowPluginModes();
        }
        this.onFloatFollowGuide();
        this.onPublicScreenFollowGuide();
    }

    protected boolean isBan() {
        return false;
    }

    private void onPublicScreenFollowGuide() {
        if (this.isFollowing() || this.getChannel().getRoleService().isMeOwner() || this.getChannel().getRoleService().isMeAnchor()) {
            return;
        }
        if (this.getChannel().getPluginService().getCurPluginData().isVideoMode()) {
            return;
        }
        if (this.mUITest == null || NAB.A.equals((Object)this.mUITest) || !this.isSupportFollowGuide()) {
            long appearTime = SettingFlags.getLongValue((String)(AccountUtil.getUid() + "key_voice_room_follow_date"));
            int followCount = SettingFlags.getIntValue((String)(AccountUtil.getUid() + "key_voice_room_follow_count"));
            if (followCount >= this.mFollowCount && TimeUtils.isSameDay((long)appearTime, (long)System.currentTimeMillis())) {
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTVoiceRoomFollow", (String)"onPageAttach, followCount max:%s\uff0c appearCount:%s", (Object[])new Object[]{followCount, this.mFollowCount});
                }
                return;
            }
            SettingFlags.setLongValue((String)(AccountUtil.getUid() + "key_voice_room_follow_date"), (long)System.currentTimeMillis());
            if (!TimeUtils.isSameDay((long)appearTime, (long)System.currentTimeMillis())) {
                SettingFlags.setIntValue((String)(AccountUtil.getUid() + "key_voice_room_follow_count"), (int)0);
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTVoiceRoomFollow", (String)"onPageAttach, followCount reset", (Object[])new Object[0]);
                }
            }
            if (FeatureLog.isLogLevelBlowInfo()) {
                FeatureLog.i((String)"FTVoiceRoomFollow", (String)"onPageAttach not cacheFollowStatus", (Object[])new Object[0]);
            }
            YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mFollowRunnable);
            YYTaskExecutor.postToMainThread((Runnable)this.mFollowRunnable, (long)this.mFollowTime);
        }
    }

    private void onFloatFollowGuide() {
        if (this.getChannel().getPluginService().getCurPluginData().isVideoMode() || NAB.B.equals((Object)this.mUITest) && this.isSupportFollowGuide()) {
            long value = this.getTheDayShowTimes();
            if (value >= (long)this.followGuideTimes) {
                return;
            }
            this.times = ++value;
            YYTaskExecutor.postToMainThread((Runnable)this.followGuideRunnable, (long)(this.mFollowFloatSecond * 1000));
        }
    }

    private boolean isSupportFollowGuide() {
        boolean result;
        int mode = this.getChannel().getPluginService().getCurPluginData().getMode();
        if (FP.empty(this.mFollowPluginModes)) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"isSupportFollowGuide config mode is empty ", (Object[])new Object[0]);
            }
            result = ChannelDefine.SUPPORT_FOLLOW_GUIDE.contains(mode);
        } else {
            result = this.mFollowPluginModes.contains(mode);
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)("isSupportFollowGuide mode = " + mode + ", result = " + result), (Object[])new Object[0]);
        }
        return result;
    }

    protected long getTheDayShowTimes() {
        long lastUpdateTime = SettingFlags.getLongValue((String)(LAST_COMMON_FOLLOW_MILLS + AccountUtil.getUid()), (long)0L);
        if (!DateUtils.isToday((Calendar)Calendar.getInstance(), (long)lastUpdateTime)) {
            SettingFlags.setLongValue((String)(LAST_COMMON_FOLLOW_MILLS + AccountUtil.getUid()), (long)System.currentTimeMillis());
            SettingFlags.setLongValue((String)(SHOWED_FOLLOW_TIMES + AccountUtil.getUid()), (long)0L);
        }
        long value = SettingFlags.getLongValue((String)(SHOWED_FOLLOW_TIMES + AccountUtil.getUid()), (long)0L);
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTVoiceRoomFollow", (String)"onFollowGuide  value:%s, followGuideTimes:%s", (Object[])new Object[]{value, this.followGuideTimes});
        }
        return value;
    }

    private void addFloatMsg(List<UserInfoKS> userInfoKSList, long times) {
        UserInfoKS userInfo = null;
        String myNick = "";
        for (UserInfoKS userInfoKS : userInfoKSList) {
            if (userInfoKS.uid == AccountUtil.getUid()) {
                myNick = userInfoKS.nick;
                continue;
            }
            if (userInfoKS.uid != this.mRoomOwnerId) continue;
            userInfo = userInfoKS;
        }
        FloatMsgFollowInfo floatMsgInfo = new FloatMsgFollowInfo(100, ResourceUtils.getString((int)R.string.tips_float_msg_follow_tittle, (Object[])new Object[]{myNick}), ResourceUtils.getString((int)R.string.tips_float_msg_follow_content_2), userInfo, this.floatingTime * 1000);
        if (!this.isDestroyed()) {
            ((IRevenueToolsModulePresenter)this.getPresenter(IRevenueToolsModulePresenter.class)).addFloatMsgItem((FloatMsgInfo)floatMsgInfo);
        }
        this.markShowedFloatFollowTimes(times);
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTVoiceRoomFollow", (String)"addFloatMsg", (Object[])new Object[0]);
        }
    }

    protected void markShowedFloatFollowTimes(long times) {
        SettingFlags.setLongValue((String)(SHOWED_FOLLOW_TIMES + AccountUtil.getUid()), (long)times);
    }

    private boolean isFollowing() {
        this.mRoomOwnerId = this.getAnchorUid();
        RelationInfo relationInfo = ((IRelationService)ServiceManagerProxy.getServiceManager().getService(IRelationService.class)).getRelationLocal(this.mRoomOwnerId);
        return relationInfo.isFollow();
    }

    private Long getAnchorUid() {
        if (this.getChannel().getDataService().getCacheDetail().baseInfo.isLoopMicRoom()) {
            return ((IChannelCenterService)ServiceManagerProxy.getService(IChannelCenterService.class)).getCurrentChannel().getRoleService().getAnchorUid();
        }
        return this.getChannelDetailInfo().baseInfo.ownerUid;
    }

    public void onPageDetach(AbsPage page) {
        super.onPageDetach(page);
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTVoiceRoomFollow", (String)"onPageDetach", (Object[])new Object[0]);
        }
        YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mFollowRunnable);
        YYTaskExecutor.removeTask((Runnable)this.followGuideRunnable);
    }

    public void onDestroy() {
        super.onDestroy();
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTVoiceRoomFollow", (String)"onDestroy", (Object[])new Object[0]);
        }
        YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mFollowRunnable);
        YYTaskExecutor.removeTask((Runnable)this.followGuideRunnable);
    }

    protected void pushFollowMessage(String text, boolean isGift) {
        IPublicScreenModulePresenter publicScreenPresenter = (IPublicScreenModulePresenter)this.getPresenter(IPublicScreenModulePresenter.class);
        if (publicScreenPresenter == null || publicScreenPresenter.getPublicScreenPresenter() == null) {
            if (FeatureLog.isLogLevelBlowInfo()) {
                FeatureLog.i((String)"FTVoiceRoomFollow", (String)"chatPresenter null", (Object[])new Object[0]);
            }
            return;
        }
        BaseImMsg followMsg = ((IPublicScreenService)ServiceManagerProxy.getService(IPublicScreenService.class)).getMsgItemFactory().generateFollowMsg(this.getChannel().getChannelId(), (CharSequence)text, this.mRoomOwnerId, this.getChannel().getRoleService().getRoleCache(this.mRoomOwnerId), isGift);
        publicScreenPresenter.getPublicScreenPresenter().appendLocalMsg(followMsg);
    }
}

