/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.module.follow;

import androidx.annotation.NonNull;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.UserInfoModule;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.dialog.OkCancelDialogListener;
import com.yy.base.logger.MLog;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiyo.relation.base.IRelationService;
import com.yy.hiyo.relation.base.data.RelationInfo;

public final class FollowHandler {
    private static final String TAG = "FollowHandler";
    private DialogLinkManager mDialogLinkManager;

    public void setDialogLinkManager(DialogLinkManager dialogLinkManager) {
        this.mDialogLinkManager = dialogLinkManager;
    }

    public void handleClick(long uid, int followPath) {
        RelationInfo relationInfo = ((IRelationService)ServiceManagerProxy.getServiceManager().getService(IRelationService.class)).getRelationLocal(uid);
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"follow uid: %s ,follow status: %s", (Object[])new Object[]{uid, relationInfo.getRelation().getValue()});
        }
        if (relationInfo.isFollow()) {
            this.showUnFollowTipDialog(uid, relationInfo, followPath);
        } else {
            this.handleFollow(uid, relationInfo, followPath);
        }
    }

    public void handleFollow(long uid, @NonNull RelationInfo info, int followPath) {
        ((IRelationService)ServiceManagerProxy.getServiceManager().getService(IRelationService.class)).requestCancelFollow(info);
    }

    public void handleUnFollow(long uid, @NonNull RelationInfo info, int followPath) {
        ((IRelationService)ServiceManagerProxy.getServiceManager().getService(IRelationService.class)).requestFollow(info, followPath);
    }

    private void showUnFollowTipDialog(final long uid, final @NonNull RelationInfo relationInfo, final int followPath) {
        if (this.mDialogLinkManager == null) {
            return;
        }
        UserInfoKS cacheUserInfo = ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getCacheUserInfo(uid);
        if (cacheUserInfo == null) {
            return;
        }
        ((IRelationService)ServiceManagerProxy.getService(IRelationService.class)).cancelFollowVerify(cacheUserInfo.uid, new OkCancelDialogListener(){

            public void onCancel() {
            }

            public void onOk() {
                FollowHandler.this.handleUnFollow(uid, relationInfo, followPath);
            }
        });
    }
}

