/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.module.creator.partypage;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.cbase.channelhiido.ChannelTrack;
import com.yy.hiyo.channel.component.play.game.OnRoomGameItemClick;
import com.yy.hiyo.channel.module.creator.partypage.item.PartyGameViewHolder;
import com.yy.hiyo.game.base.bean.GameInfo;
import java.util.ArrayList;
import java.util.List;

public class PartyGameAdapter
extends RecyclerView.Adapter<PartyGameViewHolder> {
    private final List<GameInfo> mDatas = new ArrayList<GameInfo>();
    private OnRoomGameItemClick mClick;
    private String mRoomId;
    private int selectedPos = 0;

    public void setRoomId(String roomId) {
        this.mRoomId = roomId;
    }

    public void setData(final List<GameInfo> data) {
        if (FP.empty(data)) {
            return;
        }
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                PartyGameAdapter.this.setDataIdle(data);
            }
        });
    }

    private void setDataIdle(List<GameInfo> data) {
        this.mDatas.clear();
        this.mDatas.addAll(data);
        String lastGid = SettingFlags.getStringValue((String)"key_last_play_game_gid", (String)"");
        for (int i = 0; i < this.mDatas.size(); ++i) {
            if (!StringUtils.equal((String)this.mDatas.get((int)i).gid, (String)lastGid)) continue;
            this.selectedPos = i;
        }
        this.mClick.onClick(this.mDatas.get(this.selectedPos));
        this.notifyDataSetChanged();
    }

    public void setOnItemSelect(OnRoomGameItemClick click) {
        this.mClick = click;
    }

    @NonNull
    public PartyGameViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.item_create_room_game_choose, parent, false);
        PartyGameViewHolder holder = new PartyGameViewHolder(itemView);
        return holder;
    }

    public void onBindViewHolder(@NonNull PartyGameViewHolder holder, int position) {
        if (position < this.mDatas.size()) {
            holder.bindView(this.mDatas.get(position), this.selectedPos == position);
            holder.itemView.setOnClickListener(v -> {
                int oldPos = this.selectedPos;
                this.selectedPos = position;
                this.notifyItemChanged(oldPos);
                this.notifyItemChanged(position);
                this.mClick.onClick(this.mDatas.get(position));
                ChannelTrack.INSTANCE.createGameItemClick(this.mDatas.get((int)position).gid);
            });
        }
    }

    public int getItemCount() {
        return this.mDatas.size();
    }

    public int getSelectedPos() {
        return this.selectedPos;
    }
}

